/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template;

import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.Variable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LiveTemplateBuilder {
    @NonNls
    private static final String END_PREFIX = "____END";
    private static final Logger LOGGER = Logger.getInstance(LiveTemplateBuilder.class);
    private final StringBuilder myText = new StringBuilder();
    private final List<Variable> myVariables = new ArrayList<Variable>();
    private final Set<String> myVarNames = new HashSet<String>();
    private final List<VarOccurence> myVariableOccurrences = new ArrayList<VarOccurence>();
    private final List<Marker> myMarkers = new ArrayList<Marker>();
    private final int mySegmentLimit;
    private final boolean myAddEndVariableAtTheEndOfTemplate;
    private String myLastEndVarName;
    private boolean myIsToReformat;

    public LiveTemplateBuilder() {
        this(false, Registry.intValue("emmet.segments.limit"));
    }

    public LiveTemplateBuilder(boolean addEndVariableAtTheEndOfTemplate, int segmentLimit) {
        this.mySegmentLimit = segmentLimit;
        this.myAddEndVariableAtTheEndOfTemplate = addEndVariableAtTheEndOfTemplate;
    }

    public void setIsToReformat(boolean isToReformat) {
        this.myIsToReformat = isToReformat;
    }

    public CharSequence getText() {
        return this.myText;
    }

    public static boolean isEndVariable(@NotNull String name) {
        if (name == null) {
            LiveTemplateBuilder.$$$reportNull$$$0(0);
        }
        return name.startsWith(END_PREFIX);
    }

    public boolean findVarOccurence(String name) {
        for (VarOccurence occurence : this.myVariableOccurrences) {
            if (!occurence.myName.equals(name)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public TemplateImpl buildTemplate() {
        List<Variable> variables = this.getListWithLimit(this.myVariables);
        if (!this.findVarOccurence("END")) {
            if (this.myLastEndVarName == null) {
                for (Variable variable : variables) {
                    if (!LiveTemplateBuilder.isEndVariable(variable.getName())) continue;
                    this.myLastEndVarName = variable.getName();
                    break;
                }
            }
            if (this.myLastEndVarName != null) {
                int endOffset = -1;
                if (this.myAddEndVariableAtTheEndOfTemplate) {
                    endOffset = this.myText.length();
                } else {
                    Iterator<Object> it = this.myVariableOccurrences.iterator();
                    while (it.hasNext()) {
                        VarOccurence occurence = (VarOccurence)it.next();
                        if (!occurence.myName.equals(this.myLastEndVarName)) continue;
                        endOffset = occurence.myOffset;
                        break;
                    }
                    if (endOffset >= 0) {
                        Iterator<Variable> it1 = variables.iterator();
                        while (it1.hasNext()) {
                            Variable variable = it1.next();
                            if (!this.myLastEndVarName.equals(variable.getName()) || !variable.isAlwaysStopAt()) continue;
                            it.remove();
                            it1.remove();
                        }
                    }
                }
                if (endOffset >= 0) {
                    this.myVariableOccurrences.add(new VarOccurence("END", endOffset));
                }
            }
        }
        TemplateImpl template = new TemplateImpl("", "");
        for (Variable variable : variables) {
            template.addVariable(variable.getName(), variable.getExpressionString(), variable.getDefaultValueString(), variable.isAlwaysStopAt());
        }
        List<VarOccurence> variableOccurrences = this.getListWithLimit(this.myVariableOccurrences);
        variableOccurrences.sort(Comparator.comparingInt(o -> o.myOffset));
        int last2 = 0;
        for (VarOccurence occurence : variableOccurrences) {
            template.addTextSegment(this.myText.substring(last2, occurence.myOffset));
            template.addVariableSegment(occurence.myName);
            last2 = occurence.myOffset;
        }
        template.addTextSegment(this.myText.substring(last2));
        template.setToReformat(this.myIsToReformat);
        TemplateImpl templateImpl = template;
        if (templateImpl == null) {
            LiveTemplateBuilder.$$$reportNull$$$0(1);
        }
        return templateImpl;
    }

    private <T> List<T> getListWithLimit(List<T> list2) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return list2;
        }
        if (this.mySegmentLimit == 0) {
            return Collections.emptyList();
        }
        if (this.mySegmentLimit > 0 && list2.size() > this.mySegmentLimit) {
            this.warnTooManySegments(list2.size());
            return ContainerUtil.getFirstItems(list2, this.mySegmentLimit);
        }
        return list2;
    }

    public void insertText(int offset2, String text2, boolean disableEndVariable) {
        if (disableEndVariable) {
            String varName = null;
            for (VarOccurence occurence : this.myVariableOccurrences) {
                if (!LiveTemplateBuilder.isEndVariable(occurence.myName) || occurence.myOffset != offset2) continue;
                varName = occurence.myName;
                break;
            }
            if (varName != null) {
                for (Variable variable : this.myVariables) {
                    if (!varName.equals(variable.getName())) continue;
                    variable.setAlwaysStopAt(false);
                    variable.setDefaultValueString("\"\"");
                    break;
                }
            }
        }
        int delta = text2.length();
        for (VarOccurence occurence : this.myVariableOccurrences) {
            if (occurence.myOffset <= offset2 && (disableEndVariable || occurence.myOffset != offset2)) continue;
            occurence.myOffset += delta;
        }
        this.myText.insert(offset2, text2);
        this.updateMarkers(offset2, text2);
    }

    public int length() {
        return this.myText.length();
    }

    private void updateMarkers(int offset2, String text2) {
        for (Marker marker : this.myMarkers) {
            if (offset2 < marker.getStartOffset()) {
                marker.myStartOffset += text2.length();
                continue;
            }
            if (offset2 > marker.getEndOffset()) continue;
            marker.myEndOffset += text2.length();
        }
    }

    private String generateUniqueVarName(Set<String> existingNames, boolean end) {
        String prefix = end ? END_PREFIX : "VAR";
        int i2 = 0;
        while (this.myVarNames.contains(prefix + i2) || existingNames.contains(prefix + i2)) {
            ++i2;
        }
        return prefix + i2;
    }

    public int insertTemplate(int offset2, TemplateImpl template, Map<String, String> predefinedVarValues) {
        int endOffset;
        this.myIsToReformat = this.myText.length() > 0 || template.isToReformat();
        this.removeEndVarAtOffset(offset2);
        String text2 = template.getTemplateText();
        this.insertText(offset2, text2, false);
        HashSet<String> oldVarNames = new HashSet<String>();
        for (int i2 = 0; i2 < template.getVariableCount(); ++i2) {
            String varName = template.getVariableNameAt(i2);
            oldVarNames.add(varName);
        }
        HashMap<String, String> newVarNames = new HashMap<String, String>();
        for (int i3 = 0; i3 < template.getVariableCount(); ++i3) {
            String newVarName;
            String varName = template.getVariableNameAt(i3);
            if (TemplateImpl.INTERNAL_VARS_SET.contains(varName) || predefinedVarValues != null && predefinedVarValues.containsKey(varName)) continue;
            if (this.myVarNames.contains(varName)) {
                oldVarNames.remove(varName);
                newVarName = this.generateUniqueVarName(oldVarNames, LiveTemplateBuilder.isEndVariable(varName));
                newVarNames.put(varName, newVarName);
                if (varName.equals(this.myLastEndVarName)) {
                    this.myLastEndVarName = newVarName;
                }
            } else {
                newVarName = varName;
            }
            Variable var = new Variable(newVarName, template.getExpressionStringAt(i3), template.getDefaultValueStringAt(i3), template.isAlwaysStopAt(i3));
            if (this.mySegmentLimit >= 0 && this.myVariables.size() >= this.mySegmentLimit) {
                if (this.mySegmentLimit <= 0) break;
                this.warnTooManySegments(this.myVariables.size());
                break;
            }
            this.myVariables.add(var);
            this.myVarNames.add(newVarName);
        }
        int end = -1;
        for (int i4 = 0; i4 < template.getSegmentsCount(); ++i4) {
            String segmentName = template.getSegmentName(i4);
            int localOffset = template.getSegmentOffset(i4);
            if ("END".equals(segmentName)) {
                end = offset2 + localOffset;
                continue;
            }
            if (predefinedVarValues != null && predefinedVarValues.containsKey(segmentName)) {
                String value = predefinedVarValues.get(segmentName);
                this.insertText(offset2 + localOffset, value, false);
                offset2 += value.length();
                continue;
            }
            if (newVarNames.containsKey(segmentName)) {
                segmentName = (String)newVarNames.get(segmentName);
            }
            this.myVariableOccurrences.add(new VarOccurence(segmentName, offset2 + localOffset));
        }
        int n = endOffset = end >= 0 ? end : offset2 + text2.length();
        if (endOffset > 0 && endOffset != offset2 + text2.length() && endOffset < this.myText.length() && !this.hasVarAtOffset(endOffset)) {
            this.myLastEndVarName = this.generateUniqueVarName(this.myVarNames, true);
            this.myVariables.add(new Variable(this.myLastEndVarName, "", "", true));
            this.myVarNames.add(this.myLastEndVarName);
            this.myVariableOccurrences.add(new VarOccurence(this.myLastEndVarName, endOffset));
        }
        return endOffset;
    }

    private void warnTooManySegments(int size) {
        LOGGER.warn("Too many (" + size + " with the limit of " + this.mySegmentLimit + ") segments were requested for the template with the text: " + this.myText);
    }

    private void removeEndVarAtOffset(int offset2) {
        Iterator<VarOccurence> it = this.myVariableOccurrences.iterator();
        while (it.hasNext()) {
            VarOccurence occurence = it.next();
            if (!LiveTemplateBuilder.isEndVariable(occurence.myName) || occurence.myOffset != offset2) continue;
            it.remove();
            this.myVariables.removeIf(variable -> occurence.myName.equals(variable.getName()));
        }
    }

    private boolean hasVarAtOffset(int offset2) {
        boolean flag2 = false;
        for (VarOccurence occurence : this.myVariableOccurrences) {
            if (occurence.myOffset != offset2) continue;
            flag2 = true;
            break;
        }
        return flag2;
    }

    public Marker createMarker(int offset2) {
        Marker marker = new Marker(offset2, offset2);
        this.myMarkers.add(marker);
        return marker;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/LiveTemplateBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/LiveTemplateBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTemplate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEndVariable";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }

    private static final class VarOccurence {
        String myName;
        int myOffset;

        private VarOccurence(String name, int offset2) {
            this.myName = name;
            this.myOffset = offset2;
        }
    }

    public static final class Marker {
        int myStartOffset;
        int myEndOffset;

        private Marker(int startOffset, int endOffset) {
            this.myStartOffset = startOffset;
            this.myEndOffset = endOffset;
        }

        public int getStartOffset() {
            return this.myStartOffset;
        }

        public int getEndOffset() {
            return this.myEndOffset;
        }
    }
}

