/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template;

import com.intellij.codeInsight.template.LiveTemplateContext;
import com.intellij.codeInsight.template.LiveTemplateContextBean;
import com.intellij.codeInsight.template.LiveTemplateContextNotFoundException;
import com.intellij.codeInsight.template.LiveTemplateContextProvider;
import com.intellij.codeInsight.template.LiveTemplateContextsSnapshot;
import com.intellij.codeInsight.template.LiveTemplateContextsState;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@ApiStatus.Internal
public final class LiveTemplateContextService
implements Disposable {
    private volatile LiveTemplateContextsState myState = LiveTemplateContextService.loadLiveTemplateContextsNoLock();

    public LiveTemplateContextService() {
        LiveTemplateContextBean.EP_NAME.addChangeListener(this::reloadLiveTemplateContexts, this);
        LiveTemplateContextProvider.EP_NAME.addChangeListener(this::reloadLiveTemplateContexts, this);
    }

    public static LiveTemplateContextService getInstance() {
        return ApplicationManager.getApplication().getService(LiveTemplateContextService.class);
    }

    @NotNull
    public @NotNull Collection<@NotNull LiveTemplateContext> getLiveTemplateContexts() {
        Collection<LiveTemplateContext> collection = this.myState.myLiveTemplateIds.values();
        if (collection == null) {
            LiveTemplateContextService.$$$reportNull$$$0(0);
        }
        return collection;
    }

    @Nullable
    public LiveTemplateContext getLiveTemplateContext(@Nullable String id) {
        if (id == null) {
            return null;
        }
        return this.myState.myLiveTemplateIds.get(id);
    }

    @NotNull
    public @NotNull Map<@NotNull String, @NotNull String> getInternalIds() {
        Map<String, String> map2 = this.myState.myInternalIds;
        if (map2 == null) {
            LiveTemplateContextService.$$$reportNull$$$0(1);
        }
        return map2;
    }

    @Nullable
    public LiveTemplateContext getLiveTemplateContext(@NotNull Class<?> clazz) {
        if (clazz == null) {
            LiveTemplateContextService.$$$reportNull$$$0(2);
        }
        LiveTemplateContextsState currentState = this.myState;
        LiveTemplateContext existingBean = currentState.myLiveTemplateClasses.get(clazz);
        if (existingBean != null) {
            return existingBean;
        }
        for (LiveTemplateContext bean : currentState.myLiveTemplateIds.values()) {
            TemplateContextType instance2 = bean.getTemplateContextType();
            if (!clazz.isInstance(instance2)) continue;
            currentState.myLiveTemplateClasses.put(clazz, bean);
            return bean;
        }
        return null;
    }

    @NotNull
    public TemplateContextType getTemplateContextType(@NotNull String id) {
        LiveTemplateContext context2;
        if (id == null) {
            LiveTemplateContextService.$$$reportNull$$$0(3);
        }
        if ((context2 = this.getLiveTemplateContext(id)) == null) {
            throw new LiveTemplateContextNotFoundException("Unable to find LiveTemplateContext with contextId " + id);
        }
        TemplateContextType templateContextType = context2.getTemplateContextType();
        if (templateContextType == null) {
            LiveTemplateContextService.$$$reportNull$$$0(4);
        }
        return templateContextType;
    }

    @NotNull
    public TemplateContextType getTemplateContextType(@NotNull Class<?> clazz) {
        LiveTemplateContext context2;
        if (clazz == null) {
            LiveTemplateContextService.$$$reportNull$$$0(5);
        }
        if ((context2 = this.getLiveTemplateContext(clazz)) == null) {
            throw new LiveTemplateContextNotFoundException("Unable to find LiveTemplateContext with class " + clazz);
        }
        TemplateContextType templateContextType = context2.getTemplateContextType();
        if (templateContextType == null) {
            LiveTemplateContextService.$$$reportNull$$$0(6);
        }
        return templateContextType;
    }

    private void reloadLiveTemplateContexts() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        for (LiveTemplateContext liveTemplateContext : this.myState.myLiveTemplateIds.values()) {
            liveTemplateContext.getTemplateContextType().clearCachedBaseContextType();
        }
        this.myState = LiveTemplateContextService.loadLiveTemplateContextsNoLock();
    }

    private static LiveTemplateContextsState loadLiveTemplateContextsNoLock() {
        List<LiveTemplateContextBean> allBeans = LiveTemplateContextBean.EP_NAME.getExtensionList();
        LinkedHashMap<String, LiveTemplateContext> allIdsMap = new LinkedHashMap<String, LiveTemplateContext>();
        for (LiveTemplateContextBean bean : allBeans) {
            allIdsMap.put(bean.getContextId(), bean);
        }
        for (LiveTemplateContextProvider provider2 : LiveTemplateContextProvider.EP_NAME.getExtensionList()) {
            for (LiveTemplateContext contextType : provider2.createContexts()) {
                allIdsMap.put(contextType.getContextId(), contextType);
            }
        }
        Map<String, String> internalIds = allIdsMap.values().stream().map(LiveTemplateContext::getContextId).distinct().collect(Collectors.toMap(Function.identity(), Function.identity()));
        return new LiveTemplateContextsState(allIdsMap, internalIds);
    }

    @NotNull
    public LiveTemplateContextsSnapshot getSnapshot() {
        return new LiveTemplateContextsSnapshot(this.myState.myLiveTemplateIds);
    }

    @Override
    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/LiveTemplateContextService";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiveTemplateContexts";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalIds";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/LiveTemplateContextService";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateContextType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLiveTemplateContext";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateContextType";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 2, 3, 5 -> new IllegalArgumentException(string2);
        };
    }
}

