/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TemplateActionContext {
    @NotNull
    private final PsiFile myFile;
    @Nullable
    private final Editor myEditor;
    private final int myStartOffset;
    private final int myEndOffset;
    private final boolean myIsSurrounding;

    private TemplateActionContext(@NotNull PsiFile file2, @Nullable Editor editor2, int startOffset, int endOffset, boolean isSurrounding) {
        if (file2 == null) {
            TemplateActionContext.$$$reportNull$$$0(0);
        }
        this.myFile = file2;
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        this.myIsSurrounding = isSurrounding;
        this.myEditor = editor2;
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile = this.myFile;
        if (psiFile == null) {
            TemplateActionContext.$$$reportNull$$$0(1);
        }
        return psiFile;
    }

    @ApiStatus.Internal
    @Nullable
    public Editor getEditor() {
        return this.myEditor;
    }

    public boolean isSurrounding() {
        return this.myIsSurrounding;
    }

    @NotNull
    public TemplateActionContext withFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            TemplateActionContext.$$$reportNull$$$0(2);
        }
        return new TemplateActionContext(file2, this.myEditor, this.myStartOffset, this.myEndOffset, this.myIsSurrounding);
    }

    public int getStartOffset() {
        return this.myStartOffset;
    }

    public int getEndOffset() {
        return this.myEndOffset;
    }

    @NotNull
    public static TemplateActionContext expanding(@NotNull PsiFile psiFile, @NotNull Editor editor2) {
        if (psiFile == null) {
            TemplateActionContext.$$$reportNull$$$0(3);
        }
        if (editor2 == null) {
            TemplateActionContext.$$$reportNull$$$0(4);
        }
        int editorOffset = editor2.getCaretModel().getOffset();
        return TemplateActionContext.create(psiFile, editor2, editorOffset, editorOffset, false);
    }

    @NotNull
    public static TemplateActionContext expanding(@NotNull PsiFile psiFile, int offset2) {
        if (psiFile == null) {
            TemplateActionContext.$$$reportNull$$$0(5);
        }
        return TemplateActionContext.create(psiFile, null, offset2, offset2, false);
    }

    @NotNull
    public static TemplateActionContext surrounding(@NotNull PsiFile psiFile, @NotNull Editor editor2) {
        PsiElement endElement;
        if (psiFile == null) {
            TemplateActionContext.$$$reportNull$$$0(6);
        }
        if (editor2 == null) {
            TemplateActionContext.$$$reportNull$$$0(7);
        }
        SelectionModel selectionModel = editor2.getSelectionModel();
        int start = selectionModel.getSelectionStart();
        int end = selectionModel.getSelectionEnd();
        PsiElement startElement = psiFile.findElementAt(start);
        if (startElement instanceof PsiWhiteSpace) {
            start = Math.min(startElement.getTextRange().getEndOffset(), end);
        }
        if ((endElement = psiFile.findElementAt(end)) != startElement && endElement instanceof PsiWhiteSpace) {
            end = Math.max(start, endElement.getTextRange().getStartOffset());
        }
        return TemplateActionContext.create(psiFile, editor2, start, end, true);
    }

    @NotNull
    public static TemplateActionContext create(@NotNull PsiFile psiFile, @Nullable Editor editor2, int startOffset, int endOffset, boolean isSurrounding) {
        if (psiFile == null) {
            TemplateActionContext.$$$reportNull$$$0(8);
        }
        return new TemplateActionContext(psiFile, editor2, startOffset, endOffset, isSurrounding);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/TemplateActionContext";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/TemplateActionContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "withFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "expanding";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "surrounding";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }
}

