/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template;

import com.intellij.codeInsight.template.EverywhereContextType;
import com.intellij.codeInsight.template.LiveTemplateContextNotFoundException;
import com.intellij.codeInsight.template.LiveTemplateContextService;
import com.intellij.codeInsight.template.TemplateActionContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TemplateContextType {
    String myContextId;
    ClearableLazyValue<@Nullable TemplateContextType> myBaseContextType;
    @NotNull
    private final @NlsContexts.Label String myPresentableName;

    protected TemplateContextType(@NlsContexts.Label @NotNull String presentableName) {
        if (presentableName == null) {
            TemplateContextType.$$$reportNull$$$0(0);
        }
        this.myPresentableName = presentableName;
    }

    @Deprecated
    protected TemplateContextType(@NotNull String id, @NlsContexts.Label @NotNull String presentableName) {
        if (id == null) {
            TemplateContextType.$$$reportNull$$$0(1);
        }
        if (presentableName == null) {
            TemplateContextType.$$$reportNull$$$0(2);
        }
        this(id, presentableName, EverywhereContextType.class);
    }

    @Deprecated
    protected TemplateContextType(@NotNull String id, @NlsContexts.Label @NotNull String presentableName, @Nullable Class<? extends TemplateContextType> baseContextType) {
        if (id == null) {
            TemplateContextType.$$$reportNull$$$0(3);
        }
        if (presentableName == null) {
            TemplateContextType.$$$reportNull$$$0(4);
        }
        this.myContextId = id;
        this.myPresentableName = presentableName;
        Class<? extends TemplateContextType> actualBaseClass = baseContextType != null ? baseContextType : EverywhereContextType.class;
        this.myBaseContextType = ClearableLazyValue.createAtomic(() -> LiveTemplateContextService.getInstance().getTemplateContextType(actualBaseClass));
    }

    @NotNull
    @NlsContexts.Label
    public String getPresentableName() {
        String string2 = this.myPresentableName;
        if (string2 == null) {
            TemplateContextType.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @NotNull
    public final String getContextId() {
        if (this.myContextId == null) {
            throw new AssertionError((Object)("contextId must be set for liveTemplateContext " + this));
        }
        String string2 = this.myContextId;
        if (string2 == null) {
            TemplateContextType.$$$reportNull$$$0(6);
        }
        return string2;
    }

    @Deprecated
    public boolean isInContext(@NotNull PsiFile file2, int offset2) {
        if (file2 == null) {
            TemplateContextType.$$$reportNull$$$0(7);
        }
        throw new RuntimeException("Please, implement isInContext(TemplateActionContext) method and don't invoke this method directly");
    }

    public boolean isInContext(@NotNull TemplateActionContext templateActionContext) {
        if (templateActionContext == null) {
            TemplateContextType.$$$reportNull$$$0(8);
        }
        return this.isInContext(templateActionContext.getFile(), templateActionContext.getStartOffset());
    }

    public boolean isExpandableFromEditor() {
        return true;
    }

    @Nullable
    public SyntaxHighlighter createHighlighter() {
        return null;
    }

    @Nullable
    public TemplateContextType getBaseContextType() {
        if (this.myBaseContextType != null) {
            try {
                return this.myBaseContextType.getValue();
            }
            catch (LiveTemplateContextNotFoundException e) {
                Logger.getInstance(TemplateContextType.class).error("Error in liveTemplateContext with ID '" + this.myContextId + "', base liveTemplateContext is not registered plugin.xml", e);
                return LiveTemplateContextService.getInstance().getTemplateContextType(EverywhereContextType.class);
            }
        }
        return null;
    }

    @ApiStatus.Internal
    void clearCachedBaseContextType() {
        if (this.myBaseContextType != null) {
            this.myBaseContextType.drop();
        }
    }

    public Document createDocument(CharSequence text2, Project project2) {
        return EditorFactory.getInstance().createDocument(text2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/TemplateContextType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateActionContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/TemplateContextType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isInContext";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5, 6 -> new IllegalStateException(string2);
        };
    }
}

