/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.LiveTemplatesConfigurable;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformIcons;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InvokeTemplateAction
extends DefaultActionGroup {
    private final TemplateImpl myTemplate;
    private final Editor myEditor;
    private final Project myProject;
    @Nullable
    private final Runnable myCallback;

    public InvokeTemplateAction(TemplateImpl template, Editor editor2, Project project2, Set<? super Character> usedMnemonicsSet) {
        this(template, editor2, project2, usedMnemonicsSet, null);
    }

    public InvokeTemplateAction(TemplateImpl template, Editor editor2, Project project2, Set<? super Character> usedMnemonicsSet, @Nullable Runnable afterInvocationCallback) {
        super(InvokeTemplateAction.extractMnemonic(template.getKey(), usedMnemonicsSet) + (String)(StringUtil.isEmptyOrSpaces(template.getDescription()) ? "" : ". " + template.getDescription()), List.of(new EditTemplateSettingsAction(project2, template), new DisableTemplateSettingsAction(template)));
        this.myTemplate = template;
        this.myProject = project2;
        this.myEditor = editor2;
        this.myCallback = afterInvocationCallback;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            InvokeTemplateAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setPopupGroup(true);
        e.getPresentation().setPerformGroup(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            InvokeTemplateAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    @NlsActions.ActionText
    public static String extractMnemonic(@NlsActions.ActionText String caption, Set<? super Character> usedMnemonics) {
        if (StringUtil.isEmpty(caption)) {
            return "";
        }
        for (int i2 = 0; i2 < caption.length(); ++i2) {
            char c2 = caption.charAt(i2);
            if (!usedMnemonics.add(Character.valueOf(Character.toUpperCase(c2)))) continue;
            return caption.substring(0, i2) + "\u001b" + caption.substring(i2);
        }
        return caption + " ";
    }

    public TemplateImpl getTemplate() {
        return this.myTemplate;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            InvokeTemplateAction.$$$reportNull$$$0(2);
        }
        this.perform();
    }

    public void perform() {
        Document document = this.myEditor.getDocument();
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 != null && !IntentionPreviewUtils.isIntentionPreviewActive() && ReadonlyStatusHandler.getInstance(this.myProject).ensureFilesWritable(Collections.singletonList(file2)).hasReadonlyFiles()) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, this::performInCommand, CodeInsightBundle.message("command.wrap.with.template", new Object[0]), "Wrap with template " + this.myTemplate.getKey());
    }

    public void performInCommand() {
        Document document = this.myEditor.getDocument();
        this.myEditor.getCaretModel().runForEachCaret(__ -> {
            if (this.myEditor.getSelectionModel().hasSelection() && this.myTemplate.isToReformat()) {
                int offset2;
                int selectionEnd = this.myEditor.getSelectionModel().getSelectionEnd();
                int lineEnd = document.getLineEndOffset(document.getLineNumber(offset2));
                for (offset2 = this.myEditor.getSelectionModel().getSelectionStart(); offset2 < lineEnd && offset2 < selectionEnd && (document.getCharsSequence().charAt(offset2) == ' ' || document.getCharsSequence().charAt(offset2) == '\t'); ++offset2) {
                }
                if (selectionEnd == document.getLineStartOffset(document.getLineNumber(selectionEnd))) {
                    --selectionEnd;
                }
                if (offset2 < lineEnd && offset2 < selectionEnd) {
                    this.myEditor.getSelectionModel().setSelection(offset2, selectionEnd);
                }
            }
            String selectionString = this.myEditor.getSelectionModel().getSelectedText();
            TemplateManager.getInstance(this.myProject).startTemplate(this.myEditor, selectionString, this.myTemplate);
        });
        if (this.myCallback != null) {
            this.myCallback.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/impl/InvokeTemplateAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/impl/InvokeTemplateAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }

    private static class EditTemplateSettingsAction
    extends AnAction {
        private final Project myProject;
        private final TemplateImpl myTemplate;

        private EditTemplateSettingsAction(Project project2, TemplateImpl template) {
            super(CodeInsightBundle.message("action.text.edit.live.template.settings", new Object[0]), null, PlatformIcons.EDIT);
            this.myProject = project2;
            this.myTemplate = template;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                EditTemplateSettingsAction.$$$reportNull$$$0(0);
            }
            LiveTemplatesConfigurable configurable2 = new LiveTemplatesConfigurable();
            ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)configurable2, () -> configurable2.getTemplateListPanel().editTemplate(this.myTemplate));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/impl/InvokeTemplateAction$EditTemplateSettingsAction", "actionPerformed"));
        }
    }

    private static class DisableTemplateSettingsAction
    extends AnAction {
        private final TemplateImpl myTemplate;

        private DisableTemplateSettingsAction(TemplateImpl template) {
            super(CodeInsightBundle.message("action.text.disable.live.template", template.getKey()), null, AllIcons.Actions.Cancel);
            this.myTemplate = template;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                DisableTemplateSettingsAction.$$$reportNull$$$0(0);
            }
            this.myTemplate.setDeactivated(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/impl/InvokeTemplateAction$DisableTemplateSettingsAction", "actionPerformed"));
        }
    }
}

