/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.template.CustomLiveTemplate;
import com.intellij.codeInsight.template.CustomLiveTemplateBase;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.TemplateActionContext;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.CustomLiveTemplateLookupElement;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElement;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElementImpl;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateListPanel;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeWithMe.ClientId;
import com.intellij.diagnostic.CoreAttachmentFactory;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListTemplatesHandler
implements CodeInsightActionHandler {
    private static final Logger LOG = Logger.getInstance(ListTemplatesHandler.class);

    @Override
    public void invoke(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        if (project2 == null) {
            ListTemplatesHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            ListTemplatesHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            ListTemplatesHandler.$$$reportNull$$$0(2);
        }
        EditorUtil.fillVirtualSpaceUntilCaret((Editor)editor2);
        PsiDocumentManager.getInstance(project2).commitDocument(editor2.getDocument());
        int offset2 = editor2.getCaretModel().getOffset();
        List<TemplateImpl> applicableTemplates = TemplateManagerImpl.listApplicableTemplateWithInsertingDummyIdentifier(TemplateActionContext.expanding(file2, editor2));
        Map<TemplateImpl, String> matchingTemplates = ListTemplatesHandler.filterTemplatesByPrefix(applicableTemplates, editor2, offset2, false, true);
        MultiMap<String, CustomLiveTemplateLookupElement> customTemplatesLookupElements = ListTemplatesHandler.getCustomTemplatesLookupItems(editor2, file2, offset2);
        if (matchingTemplates.isEmpty()) {
            for (TemplateImpl template : applicableTemplates) {
                matchingTemplates.put(template, null);
            }
        }
        if (matchingTemplates.isEmpty() && customTemplatesLookupElements.isEmpty()) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                HintManager.getInstance().showErrorHint(editor2, CodeInsightBundle.message("templates.no.defined", new Object[0]));
            }
            return;
        }
        ListTemplatesHandler.showTemplatesLookup(project2, editor2, file2, matchingTemplates, customTemplatesLookupElements);
    }

    public static Map<TemplateImpl, String> filterTemplatesByPrefix(@NotNull Collection<? extends TemplateImpl> templates, @NotNull Editor editor2, int offset2, boolean fullMatch, boolean searchInDescription) {
        if (templates == null) {
            ListTemplatesHandler.$$$reportNull$$$0(3);
        }
        if (editor2 == null) {
            ListTemplatesHandler.$$$reportNull$$$0(4);
        }
        if (offset2 > editor2.getDocument().getTextLength()) {
            LOG.error("Cannot filter templates, index out of bounds. Offset: " + offset2, CoreAttachmentFactory.createAttachment(editor2.getDocument()));
        }
        CharSequence documentText = editor2.getDocument().getCharsSequence().subSequence(0, offset2);
        String prefixWithoutDots = ListTemplatesHandler.computeDescriptionMatchingPrefix(editor2.getDocument(), offset2);
        Pattern prefixSearchPattern = Pattern.compile(".*\\b" + prefixWithoutDots + ".*");
        TreeMap<TemplateImpl, String> matchingTemplates = new TreeMap<TemplateImpl, String>(TemplateListPanel.TEMPLATE_COMPARATOR);
        for (TemplateImpl templateImpl : templates) {
            block7: {
                String templateKey;
                block6: {
                    ProgressManager.checkCanceled();
                    templateKey = templateImpl.getKey();
                    if (!fullMatch) break block6;
                    int startOffset = documentText.length() - templateKey.length();
                    if (startOffset > 0 && Character.isJavaIdentifierPart(documentText.charAt(startOffset - 1)) || !StringUtil.endsWith(documentText, templateKey)) break block7;
                    matchingTemplates.put(templateImpl, templateKey);
                    break block7;
                }
                if (!ClientId.isCurrentlyUnderLocalId() && prefixWithoutDots.isEmpty()) {
                    matchingTemplates.put(templateImpl, prefixWithoutDots);
                    continue;
                }
                for (int i2 = templateKey.length(); i2 > 0; --i2) {
                    ProgressManager.checkCanceled();
                    String prefix = templateKey.substring(0, i2);
                    int startOffset = documentText.length() - i2;
                    if (startOffset > 0 && Character.isJavaIdentifierPart(documentText.charAt(startOffset - 1)) || !StringUtil.endsWith(documentText, prefix)) continue;
                    matchingTemplates.put(templateImpl, prefix);
                    break;
                }
            }
            if (!searchInDescription || matchingTemplates.containsKey(templateImpl)) continue;
            String templateDescription = templateImpl.getDescription();
            if (prefixWithoutDots.isEmpty() || templateDescription == null || !prefixSearchPattern.matcher(templateDescription).matches()) continue;
            matchingTemplates.put(templateImpl, prefixWithoutDots);
        }
        return matchingTemplates;
    }

    private static void showTemplatesLookup(Project project2, Editor editor2, PsiFile file2, @NotNull Map<TemplateImpl, String> matchingTemplates, @NotNull MultiMap<String, CustomLiveTemplateLookupElement> customTemplatesLookupElements) {
        if (matchingTemplates == null) {
            ListTemplatesHandler.$$$reportNull$$$0(5);
        }
        if (customTemplatesLookupElements == null) {
            ListTemplatesHandler.$$$reportNull$$$0(6);
        }
        LookupImpl lookup2 = (LookupImpl)LookupManager.getInstance(project2).createLookup(editor2, LookupElement.EMPTY_ARRAY, "", new TemplatesArranger());
        for (Map.Entry<TemplateImpl, String> entry : matchingTemplates.entrySet()) {
            TemplateImpl template = entry.getKey();
            lookup2.addItem(ListTemplatesHandler.createTemplateElement(template), new PlainPrefixMatcher(StringUtil.notNullize(entry.getValue())));
        }
        for (Map.Entry<Object, Object> entry : customTemplatesLookupElements.entrySet()) {
            for (CustomLiveTemplateLookupElement lookupElement : (Collection)entry.getValue()) {
                lookup2.addItem(lookupElement, new PlainPrefixMatcher((String)entry.getKey()));
            }
        }
        ListTemplatesHandler.showLookup(lookup2, file2);
    }

    public static MultiMap<String, CustomLiveTemplateLookupElement> getCustomTemplatesLookupItems(@NotNull Editor editor2, @NotNull PsiFile file2, int offset2) {
        if (editor2 == null) {
            ListTemplatesHandler.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            ListTemplatesHandler.$$$reportNull$$$0(8);
        }
        MultiMap<String, CustomLiveTemplateLookupElement> result2 = MultiMap.create();
        CustomTemplateCallback customTemplateCallback = new CustomTemplateCallback(editor2, file2);
        TemplateActionContext templateActionContext = TemplateActionContext.expanding(file2, editor2);
        for (CustomLiveTemplate customLiveTemplate : TemplateManagerImpl.listApplicableCustomTemplates(templateActionContext)) {
            String customTemplatePrefix;
            if (!(customLiveTemplate instanceof CustomLiveTemplateBase) || (customTemplatePrefix = ((CustomLiveTemplateBase)customLiveTemplate).computeTemplateKeyWithoutContextChecking(customTemplateCallback)) == null) continue;
            result2.putValues(customTemplatePrefix, ((CustomLiveTemplateBase)customLiveTemplate).getLookupElements(file2, editor2, offset2));
        }
        return result2;
    }

    private static LiveTemplateLookupElement createTemplateElement(final TemplateImpl template) {
        return new LiveTemplateLookupElementImpl(template, false){

            @Override
            public Set<String> getAllLookupStrings() {
                String description = template.getDescription();
                if (description == null) {
                    return super.getAllLookupStrings();
                }
                return ContainerUtil.newHashSet(this.getLookupString(), description);
            }
        };
    }

    private static String computePrefix(TemplateImpl template, String argument) {
        String key = template.getKey();
        if (argument == null) {
            return key;
        }
        if (key.length() > 0 && Character.isJavaIdentifierPart(key.charAt(key.length() - 1))) {
            return key + " " + argument;
        }
        return key + argument;
    }

    public static void showTemplatesLookup(Project project2, Editor editor2, Map<TemplateImpl, String> template2Argument) {
        LookupImpl lookup2 = (LookupImpl)LookupManager.getInstance(project2).createLookup(editor2, LookupElement.EMPTY_ARRAY, "", new LookupArranger.DefaultArranger());
        for (TemplateImpl template : template2Argument.keySet()) {
            String prefix = ListTemplatesHandler.computePrefix(template, template2Argument.get(template));
            lookup2.addItem(ListTemplatesHandler.createTemplateElement(template), new PlainPrefixMatcher(prefix));
        }
        ListTemplatesHandler.showLookup(lookup2, template2Argument);
    }

    private static void showLookup(LookupImpl lookup2, @Nullable Map<TemplateImpl, String> template2Argument) {
        lookup2.addLookupListener(new MyLookupAdapter(template2Argument));
        lookup2.refreshUi(false, true);
        lookup2.showLookup();
    }

    private static void showLookup(LookupImpl lookup2, @NotNull PsiFile file2) {
        if (file2 == null) {
            ListTemplatesHandler.$$$reportNull$$$0(9);
        }
        lookup2.addLookupListener(new MyLookupAdapter(file2));
        lookup2.refreshUi(false, true);
        lookup2.showLookup();
    }

    private static String computeDescriptionMatchingPrefix(Document document, int offset2) {
        CharSequence chars = document.getCharsSequence();
        int start = offset2;
        while (true) {
            char c2;
            ProgressManager.checkCanceled();
            if (start == 0 || !Character.isJavaIdentifierPart(c2 = chars.charAt(start - 1))) break;
            --start;
        }
        return chars.subSequence(start, offset2).toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templates";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchingTemplates";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customTemplatesLookupElements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/template/impl/ListTemplatesHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "filterTemplatesByPrefix";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "showTemplatesLookup";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getCustomTemplatesLookupItems";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "showLookup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class TemplatesArranger
    extends LookupArranger {
        private TemplatesArranger() {
        }

        @Override
        public Pair<List<LookupElement>, Integer> arrangeItems(@NotNull Lookup lookup2, boolean onExplicitAction) {
            if (lookup2 == null) {
                TemplatesArranger.$$$reportNull$$$0(0);
            }
            LinkedHashSet<LookupElement> result2 = new LinkedHashSet<LookupElement>();
            List<LookupElement> items2 = this.getMatchingItems();
            for (LookupElement item : items2) {
                if (!item.getLookupString().startsWith(lookup2.itemPattern(item))) continue;
                result2.add(item);
            }
            result2.addAll(items2);
            ArrayList list2 = new ArrayList(result2);
            int selected = lookup2.isSelectionTouched() ? list2.indexOf(lookup2.getCurrentItem()) : 0;
            return new Pair<List<LookupElement>, Integer>(list2, Math.max(selected, 0));
        }

        @Override
        public LookupArranger createEmptyCopy() {
            return new TemplatesArranger();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookup", "com/intellij/codeInsight/template/impl/ListTemplatesHandler$TemplatesArranger", "arrangeItems"));
        }
    }

    private static class MyLookupAdapter
    implements LookupListener {
        private final Map<TemplateImpl, String> myTemplate2Argument;
        private final PsiFile myFile;

        MyLookupAdapter(@Nullable Map<TemplateImpl, String> template2Argument) {
            this.myTemplate2Argument = template2Argument;
            this.myFile = null;
        }

        MyLookupAdapter(@Nullable PsiFile file2) {
            this.myTemplate2Argument = null;
            this.myFile = file2;
        }

        @Override
        public void itemSelected(@NotNull LookupEvent event) {
            if (event == null) {
                MyLookupAdapter.$$$reportNull$$$0(0);
            }
            FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.liveTemplates");
            LookupElement item = event.getItem();
            Lookup lookup2 = event.getLookup();
            Project project2 = lookup2.getProject();
            if (item instanceof LiveTemplateLookupElementImpl) {
                TemplateImpl template = ((LiveTemplateLookupElementImpl)item).getTemplate();
                String argument = this.myTemplate2Argument != null ? this.myTemplate2Argument.get(template) : null;
                WriteCommandAction.writeCommandAction(project2).run(() -> {
                    Editor editor2 = lookup2.getEditor();
                    if (!editor2.isDisposed()) {
                        editor2.getCaretModel().runForEachCaret(caret -> ((TemplateManagerImpl)TemplateManager.getInstance(project2)).startTemplateWithPrefix(caret.getEditor(), template, null, argument));
                    }
                });
            } else if (item instanceof CustomLiveTemplateLookupElement && this.myFile != null) {
                WriteCommandAction.writeCommandAction(project2).run(() -> {
                    Editor editor2 = lookup2.getEditor();
                    if (!editor2.isDisposed()) {
                        editor2.getCaretModel().runForEachCaret(caret -> ((CustomLiveTemplateLookupElement)item).expandTemplate(lookup2.getEditor(), this.myFile));
                    }
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/template/impl/ListTemplatesHandler$MyLookupAdapter", "itemSelected"));
        }
    }
}

