/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.template.CustomLiveTemplate;
import com.intellij.codeInsight.template.CustomLiveTemplateBase;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.TemplateActionContext;
import com.intellij.codeInsight.template.impl.ListTemplatesHandler;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElementImpl;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class LiveTemplateCompletionContributor
extends CompletionContributor
implements DumbAware {
    private static final Key<Boolean> ourShowTemplatesInTests = Key.create("ShowTemplatesInTests");

    @TestOnly
    public static void setShowTemplatesInTests(boolean show2, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            LiveTemplateCompletionContributor.$$$reportNull$$$0(0);
        }
        TestModeFlags.set(ourShowTemplatesInTests, show2, parentDisposable);
    }

    public static boolean shouldShowAllTemplates() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return TestModeFlags.is(ourShowTemplatesInTests);
        }
        return Registry.is("show.live.templates.in.completion");
    }

    public LiveTemplateCompletionContributor() {
        this.extend(CompletionType.BASIC, PlatformPatterns.psiElement(), new CompletionProvider<CompletionParameters>(){

            @Override
            protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context2, @NotNull CompletionResultSet result2) {
                TemplateImpl template;
                boolean isAutopopup;
                if (parameters2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                ProgressManager.checkCanceled();
                PsiFile file2 = parameters2.getPosition().getContainingFile();
                if (file2 instanceof PsiPlainTextFile && EditorTextField.managesEditor((Editor)parameters2.getEditor())) {
                    return;
                }
                PrefixMatcher matcher = result2.getPrefixMatcher();
                if (matcher instanceof CamelHumpMatcher && ((CamelHumpMatcher)matcher).isTypoTolerant()) {
                    return;
                }
                Editor editor2 = parameters2.getEditor();
                int offset2 = editor2.getCaretModel().getOffset();
                List<TemplateImpl> availableTemplates = TemplateManagerImpl.listApplicableTemplates(TemplateActionContext.expanding(file2, editor2));
                Map<TemplateImpl, String> templates = ListTemplatesHandler.filterTemplatesByPrefix(availableTemplates, editor2, offset2, false, false);
                boolean bl = isAutopopup = parameters2.getInvocationCount() == 0;
                if (LiveTemplateCompletionContributor.this.showAllTemplates()) {
                    AtomicBoolean templatesShown = new AtomicBoolean(false);
                    CompletionResultSet finalResult = result2;
                    boolean showLiveTemplatesOnTop = Registry.is("ide.completion.show.live.templates.on.top");
                    if (showLiveTemplatesOnTop) {
                        LiveTemplateCompletionContributor.ensureTemplatesShown(templatesShown, templates, availableTemplates, finalResult, isAutopopup);
                        LiveTemplateCompletionContributor.showCustomLiveTemplates(parameters2, result2);
                    }
                    result2.runRemainingContributors(parameters2, completionResult -> {
                        finalResult.passResult((CompletionResult)completionResult);
                        if (completionResult.isStartMatch()) {
                            LiveTemplateCompletionContributor.ensureTemplatesShown(templatesShown, templates, availableTemplates, finalResult, isAutopopup);
                        }
                    });
                    LiveTemplateCompletionContributor.ensureTemplatesShown(templatesShown, templates, availableTemplates, result2, isAutopopup);
                    if (!showLiveTemplatesOnTop) {
                        LiveTemplateCompletionContributor.showCustomLiveTemplates(parameters2, result2);
                    }
                    return;
                }
                if (!isAutopopup) {
                    return;
                }
                if (!LiveTemplateCompletionContributor.customTemplateAvailableAndHasCompletionItem(null, editor2, file2, offset2) && (template = LiveTemplateCompletionContributor.findFullMatchedApplicableTemplate(editor2, offset2, availableTemplates)) != null) {
                    result2.withPrefixMatcher(template.getKey()).addElement(new LiveTemplateLookupElementImpl(template, true));
                }
                for (Map.Entry<TemplateImpl, String> possible : templates.entrySet()) {
                    ProgressManager.checkCanceled();
                    String templateKey = possible.getKey().getKey();
                    String currentPrefix = possible.getValue();
                    result2.withPrefixMatcher(currentPrefix).restartCompletionOnPrefixChange(templateKey);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/template/impl/LiveTemplateCompletionContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static boolean customTemplateAvailableAndHasCompletionItem(@Nullable Character shortcutChar, @NotNull Editor editor2, @NotNull PsiFile file2, int offset2) {
        if (editor2 == null) {
            LiveTemplateCompletionContributor.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            LiveTemplateCompletionContributor.$$$reportNull$$$0(2);
        }
        CustomTemplateCallback callback = new CustomTemplateCallback(editor2, file2);
        TemplateActionContext templateActionContext = TemplateActionContext.expanding(file2, editor2);
        for (CustomLiveTemplate customLiveTemplate : TemplateManagerImpl.listApplicableCustomTemplates(templateActionContext)) {
            ProgressManager.checkCanceled();
            if (!(customLiveTemplate instanceof CustomLiveTemplateBase) || shortcutChar != null && customLiveTemplate.getShortcut() != shortcutChar.charValue() || !((CustomLiveTemplateBase)customLiveTemplate).hasCompletionItem(callback, offset2)) continue;
            return customLiveTemplate.computeTemplateKey(callback) != null;
        }
        return false;
    }

    protected boolean showAllTemplates() {
        return LiveTemplateCompletionContributor.shouldShowAllTemplates();
    }

    private static void ensureTemplatesShown(AtomicBoolean templatesShown, Map<TemplateImpl, String> templates, List<? extends TemplateImpl> availableTemplates, CompletionResultSet result2, boolean isAutopopup) {
        if (!templatesShown.getAndSet(true)) {
            final List<String> templateKeys = ContainerUtil.map(availableTemplates, template -> template.getKey());
            result2.restartCompletionOnPrefixChange((ElementPattern<String>)StandardPatterns.string().with(new PatternCondition<String>("type after non-identifier"){

                @Override
                public boolean accepts(@NotNull String s, ProcessingContext context2) {
                    if (s == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return s.length() > 1 && !Character.isJavaIdentifierPart(s.charAt(s.length() - 2)) && templateKeys.stream().anyMatch(template -> s.endsWith((String)template));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/codeInsight/template/impl/LiveTemplateCompletionContributor$2", "accepts"));
                }
            }));
            for (Map.Entry<TemplateImpl, String> entry : templates.entrySet()) {
                ProgressManager.checkCanceled();
                if (isAutopopup && entry.getKey().getShortcutChar() == 'N') continue;
                result2.withPrefixMatcher(result2.getPrefixMatcher().cloneWithPrefix(StringUtil.notNullize(entry.getValue()))).addElement(new LiveTemplateLookupElementImpl(entry.getKey(), false));
            }
        }
    }

    private static void showCustomLiveTemplates(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result2) {
        if (parameters2 == null) {
            LiveTemplateCompletionContributor.$$$reportNull$$$0(3);
        }
        if (result2 == null) {
            LiveTemplateCompletionContributor.$$$reportNull$$$0(4);
        }
        TemplateActionContext templateActionContext = TemplateActionContext.expanding(parameters2.getPosition().getContainingFile(), parameters2.getEditor());
        for (CustomLiveTemplate customLiveTemplate : TemplateManagerImpl.listApplicableCustomTemplates(templateActionContext)) {
            ProgressManager.checkCanceled();
            if (!(customLiveTemplate instanceof CustomLiveTemplateBase)) continue;
            ((CustomLiveTemplateBase)customLiveTemplate).addCompletions(parameters2, result2);
        }
    }

    @Nullable
    public static TemplateImpl findFullMatchedApplicableTemplate(@NotNull Editor editor2, int offset2, @NotNull Collection<? extends TemplateImpl> availableTemplates) {
        TemplateImpl template;
        Map<TemplateImpl, String> templates;
        if (editor2 == null) {
            LiveTemplateCompletionContributor.$$$reportNull$$$0(5);
        }
        if (availableTemplates == null) {
            LiveTemplateCompletionContributor.$$$reportNull$$$0(6);
        }
        if ((templates = ListTemplatesHandler.filterTemplatesByPrefix(availableTemplates, editor2, offset2, true, false)).size() == 1 && (template = ContainerUtil.getFirstItem(templates.keySet())) != null) {
            return template;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "availableTemplates";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/template/impl/LiveTemplateCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setShowTemplatesInTests";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "customTemplateAvailableAndHasCompletionItem";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "showCustomLiveTemplates";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findFullMatchedApplicableTemplate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

