/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupActionProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementAction;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElementImpl;
import com.intellij.codeInsight.template.impl.LiveTemplatesConfigurable;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.PlatformIcons;
import org.jetbrains.annotations.NotNull;

public class LiveTemplateLookupActionProvider
implements LookupActionProvider {
    @Override
    public void fillActions(@NotNull LookupElement element, final @NotNull Lookup lookup2, @NotNull @NotNull Consumer<? super @NotNull LookupElementAction> consumer2) {
        if (element == null) {
            LiveTemplateLookupActionProvider.$$$reportNull$$$0(0);
        }
        if (lookup2 == null) {
            LiveTemplateLookupActionProvider.$$$reportNull$$$0(1);
        }
        if (consumer2 == null) {
            LiveTemplateLookupActionProvider.$$$reportNull$$$0(2);
        }
        if (element instanceof LiveTemplateLookupElementImpl) {
            final TemplateImpl template = ((LiveTemplateLookupElementImpl)element).getTemplate();
            final TemplateImpl templateFromSettings = TemplateSettings.getInstance().getTemplate(template.getKey(), template.getGroupName());
            if (templateFromSettings != null) {
                consumer2.consume(new LookupElementAction(PlatformIcons.EDIT, CodeInsightBundle.message("action.text.edit.live.template.settings", new Object[0])){

                    @Override
                    public LookupElementAction.Result performLookupAction() {
                        Project project2 = lookup2.getProject();
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (project2.isDisposed()) {
                                return;
                            }
                            LiveTemplatesConfigurable configurable2 = new LiveTemplatesConfigurable();
                            ShowSettingsUtil.getInstance().editConfigurable(project2, (Configurable)configurable2, () -> configurable2.getTemplateListPanel().editTemplate(template));
                        });
                        return LookupElementAction.Result.HIDE_LOOKUP;
                    }
                });
                consumer2.consume(new LookupElementAction(AllIcons.Actions.Cancel, CodeInsightBundle.message("action.text.disable.live.template", template.getKey())){

                    @Override
                    public LookupElementAction.Result performLookupAction() {
                        ApplicationManager.getApplication().invokeLater(() -> templateFromSettings.setDeactivated(true));
                        return LookupElementAction.Result.HIDE_LOOKUP;
                    }
                });
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "lookup";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/template/impl/LiveTemplateLookupActionProvider";
        objectArray[2] = "fillActions";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

