/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.LiveTemplateContext;
import com.intellij.codeInsight.template.LiveTemplateContextService;
import com.intellij.codeInsight.template.LiveTemplateContextsSnapshot;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.util.JdomKt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.jvm.functions.Function0;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public final class TemplateContext {
    private final Map<String, Boolean> myContextStates = new HashMap<String, Boolean>();

    public TemplateContext createCopy() {
        TemplateContext cloneResult = new TemplateContext();
        cloneResult.myContextStates.putAll(this.myContextStates);
        return cloneResult;
    }

    static boolean contextsEqual(@NotNull LiveTemplateContextsSnapshot allContexts, @NotNull TemplateImpl thisTemplate, @NotNull TemplateImpl defaultTemplate) {
        if (allContexts == null) {
            TemplateContext.$$$reportNull$$$0(0);
        }
        if (thisTemplate == null) {
            TemplateContext.$$$reportNull$$$0(1);
        }
        if (defaultTemplate == null) {
            TemplateContext.$$$reportNull$$$0(2);
        }
        return TemplateContext.getDifference(allContexts, thisTemplate.getTemplateContext(), defaultTemplate.getTemplateContext()) == null;
    }

    @Nullable
    static LiveTemplateContext getDifference(@NotNull LiveTemplateContextsSnapshot allContexts, @NotNull TemplateContext thisContext, @NotNull TemplateContext defaultContext) {
        if (allContexts == null) {
            TemplateContext.$$$reportNull$$$0(3);
        }
        if (thisContext == null) {
            TemplateContext.$$$reportNull$$$0(4);
        }
        if (defaultContext == null) {
            TemplateContext.$$$reportNull$$$0(5);
        }
        return (LiveTemplateContext)((Object)ContainerUtil.find(allContexts.getLiveTemplateContexts(), type -> TemplateContext.isEnabled(allContexts, thisContext, type) != TemplateContext.isEnabled(allContexts, defaultContext, type)));
    }

    @Nullable
    static TemplateContextType getDifferenceType(@NotNull LiveTemplateContextsSnapshot allContexts, @NotNull TemplateContext thisContext, @NotNull TemplateContext defaultContext) {
        LiveTemplateContext differenceExtension;
        if (allContexts == null) {
            TemplateContext.$$$reportNull$$$0(6);
        }
        if (thisContext == null) {
            TemplateContext.$$$reportNull$$$0(7);
        }
        if (defaultContext == null) {
            TemplateContext.$$$reportNull$$$0(8);
        }
        if ((differenceExtension = TemplateContext.getDifference(allContexts, thisContext, defaultContext)) != null) {
            return differenceExtension.getTemplateContextType();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnabled(@NotNull TemplateContextType contextType) {
        if (contextType == null) {
            TemplateContext.$$$reportNull$$$0(9);
        }
        LiveTemplateContextsSnapshot allContexts = LiveTemplateContextService.getInstance().getSnapshot();
        Map<String, Boolean> map2 = this.myContextStates;
        synchronized (map2) {
            return TemplateContext.isEnabledNoSync(this, allContexts, contextType.getContextId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isEnabled(@NotNull LiveTemplateContextsSnapshot allContexts, @NotNull TemplateContext thisContext, @NotNull LiveTemplateContext contextType) {
        if (allContexts == null) {
            TemplateContext.$$$reportNull$$$0(10);
        }
        if (thisContext == null) {
            TemplateContext.$$$reportNull$$$0(11);
        }
        if (contextType == null) {
            TemplateContext.$$$reportNull$$$0(12);
        }
        Map<String, Boolean> map2 = thisContext.myContextStates;
        synchronized (map2) {
            return TemplateContext.isEnabledNoSync(thisContext, allContexts, contextType.getContextId());
        }
    }

    private static boolean isEnabledNoSync(@NotNull TemplateContext thisContext, @NotNull LiveTemplateContextsSnapshot allContexts, @NotNull String contextTypeId) {
        Boolean storedValue;
        if (thisContext == null) {
            TemplateContext.$$$reportNull$$$0(13);
        }
        if (allContexts == null) {
            TemplateContext.$$$reportNull$$$0(14);
        }
        if (contextTypeId == null) {
            TemplateContext.$$$reportNull$$$0(15);
        }
        if ((storedValue = thisContext.getOwnValueNoSync(contextTypeId)) == null) {
            LiveTemplateContext liveTemplateContext = allContexts.getLiveTemplateContext(contextTypeId);
            String baseContextTypeId = liveTemplateContext != null ? liveTemplateContext.getBaseContextId() : null;
            return baseContextTypeId != null && TemplateContext.isEnabledNoSync(thisContext, allContexts, baseContextTypeId);
        }
        return storedValue;
    }

    @Nullable
    public Boolean getOwnValue(@NotNull TemplateContextType contextType) {
        if (contextType == null) {
            TemplateContext.$$$reportNull$$$0(16);
        }
        return this.getOwnValue(contextType.getContextId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Boolean getOwnValue(String contextTypeId) {
        Map<String, Boolean> map2 = this.myContextStates;
        synchronized (map2) {
            return this.getOwnValueNoSync(contextTypeId);
        }
    }

    @Nullable
    private Boolean getOwnValueNoSync(String contextTypeId) {
        return this.myContextStates.get(contextTypeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(TemplateContextType contextType, boolean value) {
        Map<String, Boolean> map2 = this.myContextStates;
        synchronized (map2) {
            this.myContextStates.put(contextType.getContextId(), value);
        }
    }

    @VisibleForTesting
    public void setDefaultContext(@NotNull TemplateContext defContext) {
        if (defContext == null) {
            TemplateContext.$$$reportNull$$$0(17);
        }
        HashMap<String, Boolean> copy2 = new HashMap<String, Boolean>(this.myContextStates);
        this.myContextStates.clear();
        this.myContextStates.putAll(defContext.myContextStates);
        this.myContextStates.putAll(copy2);
    }

    @ApiStatus.Internal
    public void readTemplateContext(@NotNull Element element, @NotNull LiveTemplateContextService ltContextService) {
        if (element == null) {
            TemplateContext.$$$reportNull$$$0(18);
        }
        if (ltContextService == null) {
            TemplateContext.$$$reportNull$$$0(19);
        }
        Map<String, String> internMap = ltContextService.getInternalIds();
        for (Element option : element.getChildren("option")) {
            String name = option.getAttributeValue("name");
            String value = option.getAttributeValue("value");
            if (name == null || value == null) continue;
            this.myContextStates.put(ContainerUtil.getOrElse(internMap, name, name), Boolean.parseBoolean(value));
        }
        this.myContextStates.putAll(this.makeInheritanceExplicit(this, ltContextService.getSnapshot()));
    }

    @VisibleForTesting
    public void readTemplateContext(@NotNull Element element) {
        if (element == null) {
            TemplateContext.$$$reportNull$$$0(20);
        }
        this.readTemplateContext(element, LiveTemplateContextService.getInstance());
    }

    @NotNull
    private Map<String, Boolean> makeInheritanceExplicit(TemplateContext context2, LiveTemplateContextsSnapshot allContexts) {
        HashMap<String, Boolean> explicitStates = new HashMap<String, Boolean>();
        for (LiveTemplateContext type : allContexts.getLiveTemplateContexts()) {
            if (!this.isDisabledByInheritance(context2, allContexts, type)) continue;
            explicitStates.put(type.getContextId(), false);
        }
        HashMap<String, Boolean> hashMap = explicitStates;
        if (hashMap == null) {
            TemplateContext.$$$reportNull$$$0(21);
        }
        return hashMap;
    }

    private boolean isDisabledByInheritance(TemplateContext thisContext, LiveTemplateContextsSnapshot allContexts, LiveTemplateContext type) {
        return !thisContext.hasOwnValue(type) && !TemplateContext.isEnabled(allContexts, thisContext, type) && JBIterable.generate(type, context2 -> allContexts.getLiveTemplateContext(context2.getBaseContextId())).filter(this::hasOwnValue).first() != null;
    }

    private boolean hasOwnValue(LiveTemplateContext t) {
        return this.getOwnValue(t.getContextId()) != null;
    }

    @TestOnly
    public Element writeTemplateContext(@Nullable TemplateContext defaultContext) {
        return this.writeTemplateContext(defaultContext, TemplateContext.getIdToType());
    }

    @VisibleForTesting
    @Nullable
    public Element writeTemplateContext(@Nullable TemplateContext defaultContext, @NotNull Lazy<? extends Map<String, TemplateContextType>> idToType) {
        if (idToType == null) {
            TemplateContext.$$$reportNull$$$0(22);
        }
        if (this.myContextStates.isEmpty()) {
            return null;
        }
        Element element = new Element("context");
        ArrayList<Map.Entry<String, Boolean>> entries2 = new ArrayList<Map.Entry<String, Boolean>>(this.myContextStates.entrySet());
        entries2.sort(Map.Entry.comparingByKey());
        for (Map.Entry entry : entries2) {
            Boolean ownValue = (Boolean)entry.getValue();
            if (ownValue == null) continue;
            TemplateContextType type = (TemplateContextType)((Map)idToType.getValue()).get(entry.getKey());
            if (type == null) {
                JdomKt.addOptionTag(element, (String)entry.getKey(), ownValue.toString());
                continue;
            }
            if (!this.isValueChanged(ownValue, type, defaultContext)) continue;
            JdomKt.addOptionTag(element, type.getContextId(), ownValue.toString());
        }
        return element;
    }

    @NotNull
    public static Lazy<Map<String, TemplateContextType>> getIdToType() {
        Lazy lazy = LazyKt.lazy((Function0)new Function0<Map<String, TemplateContextType>>(){

            public Map<String, TemplateContextType> invoke() {
                HashMap<String, TemplateContextType> idToType = new HashMap<String, TemplateContextType>();
                for (LiveTemplateContext type : LiveTemplateContextService.getInstance().getLiveTemplateContexts()) {
                    idToType.put(type.getContextId(), type.getTemplateContextType());
                }
                return idToType;
            }
        });
        if (lazy == null) {
            TemplateContext.$$$reportNull$$$0(23);
        }
        return lazy;
    }

    private boolean isValueChanged(@NotNull Boolean ownValue, @NotNull TemplateContextType type, @Nullable TemplateContext defaultContext) {
        Boolean defaultValue;
        if (ownValue == null) {
            TemplateContext.$$$reportNull$$$0(24);
        }
        if (type == null) {
            TemplateContext.$$$reportNull$$$0(25);
        }
        Boolean bl = defaultValue = defaultContext == null ? null : defaultContext.getOwnValue(type.getContextId());
        if (defaultValue == null) {
            TemplateContextType base = type.getBaseContextType();
            boolean baseEnabled = base != null && this.isEnabled(base);
            return ownValue != baseEnabled;
        }
        return !ownValue.equals(defaultValue);
    }

    public String toString() {
        return this.myContextStates.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 21, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allContexts";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisTemplate";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultTemplate";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisContext";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultContext";
                break;
            }
            case 9: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextType";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextTypeId";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defContext";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ltContextService";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/impl/TemplateContext";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idToType";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownValue";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/impl/TemplateContext";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "makeInheritanceExplicit";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdToType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "contextsEqual";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDifference";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDifferenceType";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledNoSync";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getOwnValue";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultContext";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "readTemplateContext";
                break;
            }
            case 21: 
            case 23: {
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "writeTemplateContext";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isValueChanged";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 21, 23 -> new IllegalStateException(string2);
        };
    }
}

