/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.completion.OffsetsInFile;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewEditor;
import com.intellij.codeInsight.template.CustomLiveTemplate;
import com.intellij.codeInsight.template.CustomLiveTemplateBase;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateActionContext;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TemplateSubstitutor;
import com.intellij.codeInsight.template.impl.InteractiveTemplateStateProcessor;
import com.intellij.codeInsight.template.impl.ListTemplatesHandler;
import com.intellij.codeInsight.template.impl.NonInteractiveTemplateStateProcessor;
import com.intellij.codeInsight.template.impl.TemplateContextTypes;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerUtilBase;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInsight.template.impl.TemplateStateProcessor;
import com.intellij.codeInsight.template.impl.TemplateSubstitutionContext;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageEditorUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class TemplateManagerImpl
extends TemplateManager
implements Disposable {
    @NotNull
    private final Project myProject;
    private static final Key<Boolean> ourTemplateTesting = Key.create("TemplateTesting");
    private static final OffsetKey START_OFFSET = OffsetKey.create("start", false);
    private static final OffsetKey END_OFFSET = OffsetKey.create("end", true);

    public TemplateManagerImpl(@NotNull Project project2) {
        if (project2 == null) {
            TemplateManagerImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
        EditorFactoryListener myEditorFactoryListener = new EditorFactoryListener(){

            public void editorReleased(@NotNull EditorFactoryEvent event) {
                TemplateState prevState;
                Editor editor2;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((editor2 = event.getEditor()).getProject() != null && editor2.getProject() != TemplateManagerImpl.this.myProject) {
                    return;
                }
                if (TemplateManagerImpl.this.myProject.isDisposed() || !TemplateManagerImpl.this.myProject.isOpen()) {
                    return;
                }
                TemplateState state = TemplateManagerImpl.getTemplateState(editor2);
                if (state != null) {
                    state.gotoEnd();
                }
                if ((prevState = TemplateManagerImpl.clearTemplateState(editor2)) != null) {
                    Disposer.dispose(prevState);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/template/impl/TemplateManagerImpl$1", "editorReleased"));
            }
        };
        EditorFactory.getInstance().addEditorFactoryListener(myEditorFactoryListener, (Disposable)this.myProject);
    }

    @Override
    public void dispose() {
    }

    @TestOnly
    public static void setTemplateTesting(Disposable parentDisposable) {
        TestModeFlags.set(ourTemplateTesting, true, parentDisposable);
    }

    @Override
    public Template createTemplate(@NotNull String key, @NotNull String group2) {
        if (key == null) {
            TemplateManagerImpl.$$$reportNull$$$0(1);
        }
        if (group2 == null) {
            TemplateManagerImpl.$$$reportNull$$$0(2);
        }
        return new TemplateImpl(key, group2);
    }

    @Override
    public Template createTemplate(@NotNull String key, @NotNull String group2, String text2) {
        if (key == null) {
            TemplateManagerImpl.$$$reportNull$$$0(3);
        }
        if (group2 == null) {
            TemplateManagerImpl.$$$reportNull$$$0(4);
        }
        return new TemplateImpl(key, text2, group2);
    }

    @Nullable
    public static TemplateState getTemplateState(@NotNull Editor editor2) {
        if (editor2 == null) {
            TemplateManagerImpl.$$$reportNull$$$0(5);
        }
        return (TemplateState)TemplateManagerUtilBase.getTemplateState(editor2);
    }

    @Nullable
    static TemplateState clearTemplateState(@NotNull Editor editor2) {
        if (editor2 == null) {
            TemplateManagerImpl.$$$reportNull$$$0(6);
        }
        return (TemplateState)TemplateManagerUtilBase.clearTemplateState(editor2);
    }

    @NotNull
    private TemplateState initTemplateState(@NotNull Editor editor2) {
        Editor topLevelEditor;
        TemplateState prevState;
        if (editor2 == null) {
            TemplateManagerImpl.$$$reportNull$$$0(7);
        }
        if ((prevState = TemplateManagerImpl.clearTemplateState(topLevelEditor = InjectedLanguageEditorUtil.getTopLevelEditor(editor2))) != null) {
            Disposer.dispose(prevState);
        }
        TemplateStateProcessor processor = editor2 instanceof IntentionPreviewEditor ? new NonInteractiveTemplateStateProcessor() : new InteractiveTemplateStateProcessor();
        TemplateState state = new TemplateState(this.myProject, topLevelEditor, topLevelEditor.getDocument(), processor);
        Disposer.register(this, state);
        TemplateManagerUtilBase.setTemplateState((UserDataHolder)topLevelEditor, state);
        TemplateState templateState2 = state;
        if (templateState2 == null) {
            TemplateManagerImpl.$$$reportNull$$$0(8);
        }
        return templateState2;
    }

    @Override
    @NotNull
    public TemplateState runTemplate(@NotNull Editor editor2, @NotNull Template template) {
        if (editor2 == null) {
            TemplateManagerImpl.$$$reportNull$$$0(9);
        }
        if (template == null) {
            TemplateManagerImpl.$$$reportNull$$$0(10);
        }
        return this.startTemplate(editor2, null, template, true, null, null, null);
    }

    @Override
    public boolean startTemplate(@NotNull Editor editor2, char shortcutChar) {
        Runnable runnable;
        if (editor2 == null) {
            TemplateManagerImpl.$$$reportNull$$$0(11);
        }
        if ((runnable = this.prepareTemplate(editor2, shortcutChar, null)) != null) {
            PsiDocumentManager.getInstance(this.myProject).commitDocument(editor2.getDocument());
            runnable.run();
        }
        return runnable != null;
    }

    @Override
    public void startTemplate(@NotNull Editor editor2, @NotNull Template template) {
        if (editor2 == null) {
            TemplateManagerImpl.$$$reportNull$$$0(12);
        }
        if (template == null) {
            TemplateManagerImpl.$$$reportNull$$$0(13);
        }
        this.startTemplate(editor2, template, null);
    }

    @Override
    public void startTemplate(@NotNull Editor editor2, String selectionString, @NotNull Template template) {
        if (editor2 == null) {
            TemplateManagerImpl.$$$reportNull$$$0(14);
        }
        if (template == null) {
            TemplateManagerImpl.$$$reportNull$$$0(15);
        }
        this.startTemplate(editor2, selectionString, template, true, null, null, null);
    }

    @Override
    public void startTemplate(@NotNull Editor editor2, @NotNull Template template, TemplateEditingListener listener2, PairProcessor<? super String, ? super String> processor) {
        if (editor2 == null) {
            TemplateManagerImpl.$$$reportNull$$$0(16);
        }
        if (template == null) {
            TemplateManagerImpl.$$$reportNull$$$0(17);
        }
        this.startTemplate(editor2, null, template, true, listener2, processor, null);
    }

    @NotNull
    private TemplateState startTemplate(Editor editor2, String selectionString, Template template, boolean inSeparateCommand, TemplateEditingListener listener2, PairProcessor<? super String, ? super String> processor, Map<String, String> predefinedVarValues) {
        TemplateState templateState2 = this.initTemplateState(editor2);
        templateState2.getProperties().put(ExpressionContext.SELECTION, selectionString);
        if (listener2 != null) {
            templateState2.addTemplateStateListener(listener2);
        }
        Runnable r = () -> {
            if (selectionString != null) {
                templateState2.performWrite(() -> EditorModificationUtilEx.deleteSelectedText((Editor)editor2));
            } else {
                editor2.getSelectionModel().removeSelection();
            }
            TemplateImpl substitutedTemplate = this.substituteTemplate((TemplateImpl)template, editor2);
            templateState2.start(substitutedTemplate, processor, predefinedVarValues);
        };
        if (inSeparateCommand && templateState2.requiresWriteAction()) {
            CommandProcessor.getInstance().executeCommand(this.myProject, r, AnalysisBundle.message("insert.code.template.command", new Object[0]), null);
        } else {
            r.run();
        }
        if (this.shouldSkipInTests() && !templateState2.isFinished()) {
            templateState2.gotoEnd(false);
        }
        TemplateState templateState3 = templateState2;
        if (templateState3 == null) {
            TemplateManagerImpl.$$$reportNull$$$0(18);
        }
        return templateState3;
    }

    public boolean shouldSkipInTests() {
        return ApplicationManager.getApplication().isUnitTestMode() && !TestModeFlags.is(ourTemplateTesting);
    }

    @Override
    public void startTemplate(@NotNull Editor editor2, @NotNull Template template, TemplateEditingListener listener2) {
        if (editor2 == null) {
            TemplateManagerImpl.$$$reportNull$$$0(19);
        }
        if (template == null) {
            TemplateManagerImpl.$$$reportNull$$$0(20);
        }
        this.startTemplate(editor2, null, template, true, listener2, null, null);
    }

    @Override
    public void startTemplate(@NotNull Editor editor2, @NotNull Template template, boolean inSeparateCommand, Map<String, String> predefinedVarValues, TemplateEditingListener listener2) {
        if (editor2 == null) {
            TemplateManagerImpl.$$$reportNull$$$0(21);
        }
        if (template == null) {
            TemplateManagerImpl.$$$reportNull$$$0(22);
        }
        this.startTemplate(editor2, null, template, inSeparateCommand, listener2, null, predefinedVarValues);
    }

    private static int passArgumentBack(CharSequence text2, int caretOffset) {
        char c2;
        int i2;
        for (i2 = caretOffset - 1; i2 >= 0 && !TemplateManagerImpl.isDelimiter(c2 = text2.charAt(i2)); --i2) {
        }
        return i2 + 1;
    }

    private static boolean isDelimiter(char c2) {
        return !Character.isJavaIdentifierPart(c2);
    }

    private static <T, U> void addToMap(@NotNull Map<T, U> map2, @NotNull Collection<? extends T> keys2, U value) {
        if (map2 == null) {
            TemplateManagerImpl.$$$reportNull$$$0(23);
        }
        if (keys2 == null) {
            TemplateManagerImpl.$$$reportNull$$$0(24);
        }
        for (T key : keys2) {
            map2.put(key, value);
        }
    }

    private static boolean containsTemplateStartingBefore(Map<TemplateImpl, String> template2argument, int offset2, int caretOffset, CharSequence text2) {
        for (TemplateImpl template : template2argument.keySet()) {
            String argument;
            int templateStart = TemplateManagerImpl.getTemplateStart(template, argument = template2argument.get(template), caretOffset, text2);
            if (templateStart >= offset2) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Runnable prepareTemplate(Editor editor2, char shortcutChar, @Nullable PairProcessor<? super String, ? super String> processor) {
        if (editor2.getSelectionModel().hasSelection()) {
            return null;
        }
        PsiFile file2 = PsiUtilBase.getPsiFileInEditor(editor2, this.myProject);
        if (file2 == null || file2 instanceof PsiCompiledElement) {
            return null;
        }
        Map<TemplateImpl, String> template2argument = this.findMatchingTemplates(file2, editor2, Character.valueOf(shortcutChar), TemplateSettings.getInstance());
        TemplateActionContext templateActionContext = TemplateActionContext.expanding(file2, editor2);
        boolean multiCaretMode = editor2.getCaretModel().getCaretCount() > 1;
        List<CustomLiveTemplate> customCandidates = ContainerUtil.findAll(CustomLiveTemplate.EP_NAME.getExtensions(), customLiveTemplate -> shortcutChar == customLiveTemplate.getShortcut() && (!multiCaretMode || TemplateManagerImpl.supportsMultiCaretMode(customLiveTemplate)) && TemplateManagerImpl.isApplicable(customLiveTemplate, templateActionContext));
        if (!customCandidates.isEmpty()) {
            int caretOffset = editor2.getCaretModel().getOffset();
            CustomTemplateCallback templateCallback = new CustomTemplateCallback(editor2, file2);
            for (CustomLiveTemplate customLiveTemplate2 : customCandidates) {
                String key = customLiveTemplate2.computeTemplateKey(templateCallback);
                if (key == null) continue;
                int offsetBeforeKey = caretOffset - key.length();
                CharSequence text2 = editor2.getDocument().getImmutableCharSequence();
                if (template2argument != null && TemplateManagerImpl.containsTemplateStartingBefore(template2argument, offsetBeforeKey, caretOffset, text2)) continue;
                return () -> {
                    customLiveTemplate2.expand(key, templateCallback);
                    if (multiCaretMode) {
                        PsiDocumentManager.getInstance(templateCallback.getProject()).commitDocument(editor2.getDocument());
                    }
                };
            }
        }
        return this.startNonCustomTemplates(template2argument, editor2, processor);
    }

    private static boolean supportsMultiCaretMode(CustomLiveTemplate customLiveTemplate) {
        return !(customLiveTemplate instanceof CustomLiveTemplateBase) || ((CustomLiveTemplateBase)customLiveTemplate).supportsMultiCaret();
    }

    public static boolean isApplicable(@NotNull CustomLiveTemplate customLiveTemplate, @NotNull TemplateActionContext templateActionContext) {
        if (customLiveTemplate == null) {
            TemplateManagerImpl.$$$reportNull$$$0(25);
        }
        if (templateActionContext == null) {
            TemplateManagerImpl.$$$reportNull$$$0(26);
        }
        CustomTemplateCallback callback = new CustomTemplateCallback(Objects.requireNonNull(templateActionContext.getEditor()), templateActionContext.getFile());
        return customLiveTemplate.isApplicable(callback, callback.getOffset(), templateActionContext.isSurrounding());
    }

    private static int getArgumentOffset(int caretOffset, String argument, CharSequence text2) {
        int argumentOffset = caretOffset - argument.length();
        if (argumentOffset > 0 && text2.charAt(argumentOffset - 1) == ' ' && argumentOffset - 2 >= 0 && Character.isJavaIdentifierPart(text2.charAt(argumentOffset - 2))) {
            --argumentOffset;
        }
        return argumentOffset;
    }

    private static int getTemplateStart(TemplateImpl template, String argument, int caretOffset, CharSequence text2) {
        int templateStart;
        if (argument == null) {
            templateStart = caretOffset - template.getKey().length();
        } else {
            int argOffset = TemplateManagerImpl.getArgumentOffset(caretOffset, argument, text2);
            templateStart = argOffset - template.getKey().length();
        }
        return templateStart;
    }

    public Map<TemplateImpl, String> findMatchingTemplates(PsiFile file2, Editor editor2, @Nullable Character shortcutChar, TemplateSettings templateSettings) {
        List<TemplateImpl> candidatesWithArgument;
        Document document = editor2.getDocument();
        CharSequence text2 = document.getCharsSequence();
        int caretOffset = editor2.getCaretModel().getOffset();
        List<TemplateImpl> candidatesWithoutArgument = TemplateManagerImpl.findMatchingTemplates(text2, caretOffset, shortcutChar, templateSettings, false);
        int argumentOffset = TemplateManagerImpl.passArgumentBack(text2, caretOffset);
        String argument = null;
        if (argumentOffset >= 0) {
            argument = text2.subSequence(argumentOffset, caretOffset).toString();
            if (argumentOffset > 0 && text2.charAt(argumentOffset - 1) == ' ' && argumentOffset - 2 >= 0 && Character.isJavaIdentifierPart(text2.charAt(argumentOffset - 2))) {
                --argumentOffset;
            }
        }
        if ((candidatesWithArgument = TemplateManagerImpl.findMatchingTemplates(text2, argumentOffset, shortcutChar, templateSettings, true)).isEmpty() && candidatesWithoutArgument.isEmpty()) {
            return null;
        }
        candidatesWithoutArgument = TemplateManagerImpl.filterApplicableCandidates(TemplateActionContext.expanding(file2, caretOffset), candidatesWithoutArgument);
        candidatesWithArgument = TemplateManagerImpl.filterApplicableCandidates(TemplateActionContext.expanding(file2, argumentOffset), candidatesWithArgument);
        HashMap<TemplateImpl, String> candidate2Argument = new HashMap<TemplateImpl, String>();
        TemplateManagerImpl.addToMap(candidate2Argument, candidatesWithoutArgument, null);
        TemplateManagerImpl.addToMap(candidate2Argument, candidatesWithArgument, argument);
        return candidate2Argument;
    }

    @Nullable
    public Runnable startNonCustomTemplates(Map<TemplateImpl, String> template2argument, Editor editor2, @Nullable PairProcessor<? super String, ? super String> processor) {
        int caretOffset = editor2.getCaretModel().getOffset();
        Document document = editor2.getDocument();
        CharSequence text2 = document.getCharsSequence();
        if (template2argument == null || template2argument.isEmpty()) {
            return null;
        }
        return () -> {
            if (template2argument.size() == 1) {
                TemplateImpl template = (TemplateImpl)template2argument.keySet().iterator().next();
                String argument = (String)template2argument.get(template);
                int templateStart = TemplateManagerImpl.getTemplateStart(template, argument, caretOffset, text2);
                this.startTemplateWithPrefix(editor2, template, templateStart, processor, argument);
            } else {
                ListTemplatesHandler.showTemplatesLookup(this.myProject, editor2, template2argument);
            }
        };
    }

    private static List<TemplateImpl> findMatchingTemplates(CharSequence text2, int caretOffset, @Nullable Character shortcutChar, TemplateSettings settings, boolean hasArgument) {
        String key;
        int wordStart;
        List<TemplateImpl> candidates = Collections.emptyList();
        for (int i2 = settings.getMaxKeyLength(); i2 >= 1 && ((wordStart = caretOffset - i2) < 0 || Character.isJavaIdentifierStart((key = text2.subSequence(wordStart, caretOffset).toString()).charAt(0)) && wordStart > 0 && Character.isJavaIdentifierPart(text2.charAt(wordStart - 1)) || (candidates = settings.collectMatchingCandidates(key, shortcutChar, hasArgument)).isEmpty()); --i2) {
        }
        return candidates;
    }

    public void startTemplateWithPrefix(Editor editor2, TemplateImpl template, @Nullable PairProcessor<? super String, ? super String> processor, @Nullable String argument) {
        int caretOffset = editor2.getCaretModel().getOffset();
        String key = template.getKey();
        int startOffset = caretOffset - key.length();
        if (argument != null) {
            if (!TemplateManagerImpl.isDelimiter(key.charAt(key.length() - 1))) {
                --startOffset;
            }
            startOffset -= argument.length();
        }
        this.startTemplateWithPrefix(editor2, template, startOffset, processor, argument);
    }

    @NotNull
    private TemplateImpl substituteTemplate(@NotNull TemplateImpl template, @NotNull Editor editor2) {
        PsiFile psiFile;
        if (template == null) {
            TemplateManagerImpl.$$$reportNull$$$0(27);
        }
        if (editor2 == null) {
            TemplateManagerImpl.$$$reportNull$$$0(28);
        }
        if ((psiFile = PsiDocumentManager.getInstance(this.myProject).getPsiFile(editor2.getDocument())) == null) {
            TemplateImpl templateImpl = template;
            if (templateImpl == null) {
                TemplateManagerImpl.$$$reportNull$$$0(29);
            }
            return templateImpl;
        }
        for (TemplateSubstitutor substitutor : TemplateSubstitutor.EP_NAME.getExtensionList()) {
            TemplateImpl substituted = substitutor.substituteTemplate(new TemplateSubstitutionContext(this.myProject, editor2), template);
            if (substituted == null) continue;
            template = substituted;
        }
        TemplateImpl templateImpl = template;
        if (templateImpl == null) {
            TemplateManagerImpl.$$$reportNull$$$0(30);
        }
        return templateImpl;
    }

    public void startTemplateWithPrefix(Editor editor2, TemplateImpl template, int templateStart, @Nullable PairProcessor<? super String, ? super String> processor, @Nullable String argument) {
        int caretOffset = editor2.getCaretModel().getOffset();
        TemplateState templateState2 = this.initTemplateState(editor2);
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(this.myProject, () -> {
            editor2.getDocument().deleteString(templateStart, caretOffset);
            editor2.getCaretModel().moveToOffset(templateStart);
            editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            editor2.getSelectionModel().removeSelection();
            HashMap<String, String> predefinedVarValues = null;
            if (argument != null) {
                predefinedVarValues = new HashMap<String, String>();
                predefinedVarValues.put("ARG", argument);
            }
            templateState2.start(this.substituteTemplate(template, editor2), processor, predefinedVarValues);
        }, AnalysisBundle.message("insert.code.template.command", new Object[0]), null);
    }

    private static List<TemplateImpl> filterApplicableCandidates(@NotNull TemplateActionContext templateActionContext, @NotNull List<TemplateImpl> candidates) {
        if (templateActionContext == null) {
            TemplateManagerImpl.$$$reportNull$$$0(31);
        }
        if (candidates == null) {
            TemplateManagerImpl.$$$reportNull$$$0(32);
        }
        if (candidates.isEmpty()) {
            return candidates;
        }
        PsiFile copy2 = TemplateManagerImpl.insertDummyIdentifierWithCache(templateActionContext).getFile();
        ArrayList<TemplateImpl> result2 = new ArrayList<TemplateImpl>();
        for (TemplateImpl candidate : candidates) {
            if (!TemplateManagerImpl.isApplicable(candidate, TemplateActionContext.expanding(copy2, templateActionContext.getStartOffset() - candidate.getKey().length()))) continue;
            result2.add(candidate);
        }
        return result2;
    }

    private static List<TemplateContextType> getBases(TemplateContextType type) {
        ArrayList<TemplateContextType> list2 = new ArrayList<TemplateContextType>();
        while ((type = type.getBaseContextType()) != null) {
            list2.add(type);
        }
        return list2;
    }

    private static Set<TemplateContextType> getDirectlyApplicableContextTypes(@NotNull TemplateActionContext templateActionContext) {
        if (templateActionContext == null) {
            TemplateManagerImpl.$$$reportNull$$$0(33);
        }
        LinkedHashSet<TemplateContextType> set2 = new LinkedHashSet<TemplateContextType>();
        for (TemplateContextType contextType : TemplateManagerImpl.getAllContextTypes()) {
            if (!contextType.isInContext(templateActionContext)) continue;
            set2.add(contextType);
        }
        block1: while (true) {
            for (TemplateContextType type : set2) {
                if (!set2.removeAll(TemplateManagerImpl.getBases(type))) continue;
                continue block1;
            }
            break;
        }
        return set2;
    }

    @NotNull
    public static List<TemplateContextType> getAllContextTypes() {
        List<TemplateContextType> list2 = TemplateContextTypes.getAllContextTypes();
        if (list2 == null) {
            TemplateManagerImpl.$$$reportNull$$$0(34);
        }
        return list2;
    }

    @Override
    @Nullable
    public Template getActiveTemplate(@NotNull Editor editor2) {
        TemplateState templateState2;
        if (editor2 == null) {
            TemplateManagerImpl.$$$reportNull$$$0(35);
        }
        return (templateState2 = TemplateManagerImpl.getTemplateState(editor2)) != null ? templateState2.getTemplate() : null;
    }

    @Override
    public boolean finishTemplate(@NotNull Editor editor2) {
        TemplateState state;
        if (editor2 == null) {
            TemplateManagerImpl.$$$reportNull$$$0(36);
        }
        if ((state = TemplateManagerImpl.getTemplateState(editor2)) != null) {
            state.gotoEnd();
            return true;
        }
        return false;
    }

    @Deprecated(forRemoval=true)
    public static boolean isApplicable(PsiFile file2, int offset2, TemplateImpl template) {
        return TemplateManagerImpl.isApplicable(template, TemplateActionContext.expanding(file2, offset2));
    }

    public static boolean isApplicable(TemplateImpl template, @NotNull TemplateActionContext templateActionContext) {
        if (templateActionContext == null) {
            TemplateManagerImpl.$$$reportNull$$$0(37);
        }
        return TemplateManagerImpl.isApplicable(template, TemplateManagerImpl.getApplicableContextTypes(templateActionContext));
    }

    public static boolean isApplicable(TemplateImpl template, Set<? extends TemplateContextType> contextTypes) {
        for (TemplateContextType templateContextType : contextTypes) {
            if (!template.getTemplateContext().isEnabled(templateContextType)) continue;
            return true;
        }
        return false;
    }

    public static List<TemplateImpl> listApplicableTemplates(@NotNull TemplateActionContext templateActionContext) {
        if (templateActionContext == null) {
            TemplateManagerImpl.$$$reportNull$$$0(38);
        }
        Set<TemplateContextType> contextTypes = TemplateManagerImpl.getApplicableContextTypes(templateActionContext);
        ArrayList<TemplateImpl> result2 = new ArrayList<TemplateImpl>();
        for (TemplateImpl template : TemplateSettings.getInstance().getTemplates()) {
            if (template.isDeactivated() || templateActionContext.isSurrounding() && !template.isSelectionTemplate() || !TemplateManagerImpl.isApplicable(template, contextTypes)) continue;
            result2.add(template);
        }
        return result2;
    }

    public static List<TemplateImpl> listApplicableTemplateWithInsertingDummyIdentifier(@NotNull TemplateActionContext templateActionContext) {
        if (templateActionContext == null) {
            TemplateManagerImpl.$$$reportNull$$$0(39);
        }
        OffsetsInFile offsets2 = TemplateManagerImpl.insertDummyIdentifierWithCache(templateActionContext);
        return TemplateManagerImpl.listApplicableTemplates(TemplateActionContext.create(offsets2.getFile(), null, TemplateManagerImpl.getStartOffset(offsets2), TemplateManagerImpl.getEndOffset(offsets2), templateActionContext.isSurrounding()));
    }

    public static List<CustomLiveTemplate> listApplicableCustomTemplates(@NotNull TemplateActionContext templateActionContext) {
        if (templateActionContext == null) {
            TemplateManagerImpl.$$$reportNull$$$0(40);
        }
        ArrayList<CustomLiveTemplate> result2 = new ArrayList<CustomLiveTemplate>();
        for (CustomLiveTemplate template : CustomLiveTemplate.EP_NAME.getExtensions()) {
            if (templateActionContext.isSurrounding() && !template.supportsWrapping() || !TemplateManagerImpl.isApplicable(template, templateActionContext)) continue;
            result2.add(template);
        }
        return result2;
    }

    public static Set<TemplateContextType> getApplicableContextTypes(@NotNull TemplateActionContext templateActionContext) {
        PsiFile basePsi;
        Language languageAtOffset;
        PsiFile basePsi2;
        if (templateActionContext == null) {
            TemplateManagerImpl.$$$reportNull$$$0(41);
        }
        Set<TemplateContextType> result2 = TemplateManagerImpl.getDirectlyApplicableContextTypes(templateActionContext);
        PsiFile file2 = templateActionContext.getFile();
        Language baseLanguage = file2.getViewProvider().getBaseLanguage();
        if (baseLanguage != file2.getLanguage() && (basePsi2 = file2.getViewProvider().getPsi(baseLanguage)) != null) {
            result2.addAll(TemplateManagerImpl.getDirectlyApplicableContextTypes(templateActionContext.withFile(basePsi2)));
        }
        if ((languageAtOffset = PsiUtilCore.getLanguageAtOffset(file2, templateActionContext.getStartOffset())) != file2.getLanguage() && languageAtOffset != baseLanguage && (basePsi = file2.getViewProvider().getPsi(languageAtOffset)) != null) {
            result2.addAll(TemplateManagerImpl.getDirectlyApplicableContextTypes(templateActionContext.withFile(basePsi)));
        }
        return result2;
    }

    private static int getStartOffset(OffsetsInFile offsets2) {
        return offsets2.getOffsets().getOffset(START_OFFSET);
    }

    private static int getEndOffset(OffsetsInFile offsets2) {
        return offsets2.getOffsets().getOffset(END_OFFSET);
    }

    private static OffsetsInFile insertDummyIdentifierWithCache(@NotNull TemplateActionContext templateActionContext) {
        if (templateActionContext == null) {
            TemplateManagerImpl.$$$reportNull$$$0(42);
        }
        ProperTextRange editRange = ProperTextRange.create(templateActionContext.getStartOffset(), templateActionContext.getEndOffset());
        PsiFile file2 = templateActionContext.getFile();
        TemplateManagerImpl.assertRangeWithinDocument(editRange, Objects.requireNonNull(file2.getViewProvider().getDocument()));
        ConcurrentMap map2 = (ConcurrentMap)CachedValuesManager.getCachedValue(file2, () -> CachedValueProvider.Result.create(ConcurrentFactoryMap.createMap(key -> TemplateManagerImpl.copyWithDummyIdentifier(new OffsetsInFile(file2), ((ProperTextRange)key.first).getStartOffset(), ((ProperTextRange)key.first).getEndOffset(), (String)key.second)), file2, file2.getViewProvider().getDocument()));
        return (OffsetsInFile)map2.get(Pair.create(editRange, CompletionUtil.DUMMY_IDENTIFIER_TRIMMED));
    }

    private static void assertRangeWithinDocument(ProperTextRange editRange, Document document) {
        TextRange docRange = TextRange.from(0, document.getTextLength());
        assert (docRange.contains(editRange)) : docRange + " doesn't contain " + editRange;
    }

    @NotNull
    public static OffsetsInFile copyWithDummyIdentifier(OffsetsInFile offsetMap, int startOffset, int endOffset, String replacement) {
        offsetMap.getOffsets().addOffset(START_OFFSET, startOffset);
        offsetMap.getOffsets().addOffset(END_OFFSET, endOffset);
        Document document = offsetMap.getFile().getViewProvider().getDocument();
        assert (document != null);
        if (replacement.isEmpty() && startOffset == endOffset && PsiDocumentManager.getInstance(offsetMap.getFile().getProject()).isCommitted(document)) {
            OffsetsInFile offsetsInFile = offsetMap;
            if (offsetsInFile == null) {
                TemplateManagerImpl.$$$reportNull$$$0(43);
            }
            return offsetsInFile;
        }
        OffsetsInFile hostOffsets = offsetMap.toTopLevelFile();
        OffsetsInFile hostCopy = hostOffsets.copyWithReplacement(TemplateManagerImpl.getStartOffset(hostOffsets), TemplateManagerImpl.getEndOffset(hostOffsets), replacement);
        OffsetsInFile offsetsInFile = hostCopy.toInjectedIfAny(TemplateManagerImpl.getStartOffset(hostCopy));
        if (offsetsInFile == null) {
            TemplateManagerImpl.$$$reportNull$$$0(44);
        }
        return offsetsInFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 18, 29, 30, 34, 43, 44 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 28: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: 
            case 18: 
            case 29: 
            case 30: 
            case 34: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/impl/TemplateManagerImpl";
                break;
            }
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customLiveTemplate";
                break;
            }
            case 26: 
            case 31: 
            case 33: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateActionContext";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/impl/TemplateManagerImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "initTemplateState";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "startTemplate";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteTemplate";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllContextTypes";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithDummyIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTemplate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "clearTemplateState";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "initTemplateState";
                break;
            }
            case 8: 
            case 18: 
            case 29: 
            case 30: 
            case 34: 
            case 43: 
            case 44: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "runTemplate";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "startTemplate";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addToMap";
                break;
            }
            case 25: 
            case 26: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "substituteTemplate";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "filterApplicableCandidates";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getDirectlyApplicableContextTypes";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getActiveTemplate";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "finishTemplate";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "listApplicableTemplates";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "listApplicableTemplateWithInsertingDummyIdentifier";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "listApplicableCustomTemplates";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getApplicableContextTypes";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "insertDummyIdentifierWithCache";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 8, 18, 29, 30, 34, 43, 44 -> new IllegalStateException(string2);
        };
    }
}

