/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.DynamicBundle;
import com.intellij.codeInsight.template.LiveTemplateContextService;
import com.intellij.codeInsight.template.LiveTemplateContextsSnapshot;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.DefaultLiveTemplateEP;
import com.intellij.codeInsight.template.impl.DefaultLiveTemplatesProvider;
import com.intellij.codeInsight.template.impl.TemplateContext;
import com.intellij.codeInsight.template.impl.TemplateGroup;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.diagnostic.PluginException;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.options.BaseSchemeProcessor;
import com.intellij.openapi.options.CompoundScheme;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.Strings;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.ResourceUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xmlb.Converter;
import com.intellij.util.xmlb.annotations.OptionTag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import kotlin.Lazy;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="TemplateSettings", storages={@Storage(value="templates.xml")}, additionalExportDirectory="templates", category=SettingsCategory.CODE)
public final class TemplateSettings
implements PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance(TemplateSettings.class);
    private static final ExtensionPointName<DefaultLiveTemplateEP> EP_NAME = new ExtensionPointName("com.intellij.defaultLiveTemplates");
    @NonNls
    public static final String USER_GROUP_NAME = "user";
    @NonNls
    private static final String TEMPLATE_SET = "templateSet";
    @NonNls
    private static final String GROUP = "group";
    @NonNls
    public static final String TEMPLATE = "template";
    public static final char SPACE_CHAR = ' ';
    public static final char TAB_CHAR = '\t';
    public static final char ENTER_CHAR = '\n';
    public static final char DEFAULT_CHAR = 'D';
    public static final char CUSTOM_CHAR = 'C';
    public static final char NONE_CHAR = 'N';
    @NonNls
    private static final String SPACE = "SPACE";
    @NonNls
    private static final String TAB = "TAB";
    @NonNls
    private static final String ENTER = "ENTER";
    @NonNls
    private static final String CUSTOM = "CUSTOM";
    @NonNls
    private static final String NONE = "NONE";
    @NonNls
    private static final String NAME = "name";
    @NonNls
    private static final String VALUE = "value";
    @NonNls
    private static final String DESCRIPTION = "description";
    @NonNls
    private static final String SHORTCUT = "shortcut";
    @NonNls
    private static final String VARIABLE = "variable";
    @NonNls
    private static final String EXPRESSION = "expression";
    @NonNls
    private static final String DEFAULT_VALUE = "defaultValue";
    @NonNls
    private static final String ALWAYS_STOP_AT = "alwaysStopAt";
    @NonNls
    static final String CONTEXT = "context";
    @NonNls
    private static final String TO_REFORMAT = "toReformat";
    @NonNls
    private static final String TO_SHORTEN_FQ_NAMES = "toShortenFQNames";
    @NonNls
    private static final String USE_STATIC_IMPORT = "useStaticImport";
    @NonNls
    private static final String DEACTIVATED = "deactivated";
    @NonNls
    private static final String RESOURCE_BUNDLE = "resource-bundle";
    @NonNls
    private static final String KEY = "key";
    @NonNls
    private static final String ID = "id";
    @NonNls
    static final String TEMPLATES_DIR_PATH = "templates";
    private final MultiMap<String, TemplateImpl> myTemplates;
    private final Map<String, Template> myTemplatesById;
    private final Map<TemplateKey, TemplateImpl> myDefaultTemplates;
    private int myMaxKeyLength;
    private final SchemeManager<TemplateGroup> mySchemeManager;
    private State myState;
    private final Map<Pair<String, String>, PluginInfo> myPredefinedTemplates;
    private TemplateKey myLastSelectedTemplate;

    public TemplateSettings() {
        this(SchemeManagerFactory.getInstance());
    }

    @NonInjectable
    public TemplateSettings(@NotNull SchemeManagerFactory factory2) {
        if (factory2 == null) {
            TemplateSettings.$$$reportNull$$$0(0);
        }
        this.myTemplates = MultiMap.createLinked();
        this.myTemplatesById = new LinkedHashMap<String, Template>();
        this.myDefaultTemplates = new LinkedHashMap<TemplateKey, TemplateImpl>();
        this.myMaxKeyLength = 0;
        this.myState = new State();
        this.myPredefinedTemplates = new HashMap<Pair<String, String>, PluginInfo>();
        this.mySchemeManager = factory2.create(TEMPLATES_DIR_PATH, new BaseSchemeProcessor<TemplateGroup, TemplateGroup>(){

            @Override
            @Nullable
            public TemplateGroup readScheme(@NotNull Element element, boolean duringLoad) {
                TemplateGroup readGroup;
                TemplateGroup group2;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                TemplateGroup templateGroup = group2 = (readGroup = TemplateSettings.parseTemplateGroup(element, element.getAttributeValue(TemplateSettings.GROUP), this.getClass().getClassLoader())) == null ? null : TemplateSettings.this.mergeParsedGroup(element, false, false, readGroup);
                if (group2 != null) {
                    group2.setModified(false);
                }
                return group2;
            }

            @Override
            public void beforeReloaded(@NotNull SchemeManager<TemplateGroup> schemeManager2) {
                if (schemeManager2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                for (TemplateGroup group2 : schemeManager2.getAllSchemes()) {
                    schemeManager2.removeScheme(group2);
                }
                TemplateSettings.this.myTemplates.clear();
                TemplateSettings.this.myDefaultTemplates.clear();
            }

            @Override
            public void reloaded(@NotNull SchemeManager<TemplateGroup> schemeManager2, @NotNull Collection<? extends TemplateGroup> groups2) {
                if (schemeManager2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (groups2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                TemplateSettings.this.doLoadTemplates(groups2);
            }

            @Override
            @NotNull
            public SchemeState getState(@NotNull TemplateGroup template) {
                if (template == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (template.isModified()) {
                    SchemeState schemeState = SchemeState.POSSIBLY_CHANGED;
                    if (schemeState == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    return schemeState;
                }
                LiveTemplateContextsSnapshot allContexts = LiveTemplateContextService.getInstance().getSnapshot();
                for (TemplateImpl t : template.getElements()) {
                    if (!TemplateSettings.this.differsFromDefault(allContexts, t)) continue;
                    SchemeState schemeState = SchemeState.POSSIBLY_CHANGED;
                    if (schemeState == null) {
                        1.$$$reportNull$$$0(6);
                    }
                    return schemeState;
                }
                SchemeState schemeState = SchemeState.NON_PERSISTENT;
                if (schemeState == null) {
                    1.$$$reportNull$$$0(7);
                }
                return schemeState;
            }

            @NotNull
            public Element writeScheme(@NotNull TemplateGroup template) {
                if (template == null) {
                    1.$$$reportNull$$$0(8);
                }
                Element templateSetElement = new Element(TemplateSettings.TEMPLATE_SET);
                List elements = template.getElements();
                if (!elements.isEmpty()) {
                    boolean isGroupAttributeAdded = false;
                    Lazy<Map<String, TemplateContextType>> idToType = TemplateContext.getIdToType();
                    LiveTemplateContextsSnapshot allContexts = LiveTemplateContextService.getInstance().getSnapshot();
                    for (TemplateImpl t : elements) {
                        TemplateImpl defaultTemplate = TemplateSettings.this.getDefaultTemplate(t);
                        if (defaultTemplate != null && t.equals(defaultTemplate) && TemplateContext.contextsEqual(allContexts, t, defaultTemplate)) continue;
                        if (!isGroupAttributeAdded) {
                            isGroupAttributeAdded = true;
                            templateSetElement.setAttribute(TemplateSettings.GROUP, template.getName());
                        }
                        templateSetElement.addContent(TemplateSettings.serializeTemplate(t, defaultTemplate, idToType));
                    }
                }
                template.setModified(false);
                Element element = templateSetElement;
                if (element == null) {
                    1.$$$reportNull$$$0(9);
                }
                return element;
            }

            @Override
            public void onSchemeAdded(@NotNull TemplateGroup scheme) {
                if (scheme == null) {
                    1.$$$reportNull$$$0(10);
                }
                for (TemplateImpl template : scheme.getElements()) {
                    TemplateSettings.this.addTemplateImpl(template);
                }
            }

            @Override
            public void onSchemeDeleted(@NotNull TemplateGroup scheme) {
                if (scheme == null) {
                    1.$$$reportNull$$$0(11);
                }
                for (TemplateImpl template : scheme.getElements()) {
                    TemplateSettings.this.removeTemplate(template);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 5, 6, 7, 9 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "schemeManager";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "groups";
                        break;
                    }
                    case 4: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = TemplateSettings.TEMPLATE;
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInsight/template/impl/TemplateSettings$1";
                        break;
                    }
                    case 10: 
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scheme";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInsight/template/impl/TemplateSettings$1";
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getState";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[1] = "writeScheme";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "readScheme";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "beforeReloaded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "reloaded";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "getState";
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 9: {
                        break;
                    }
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "writeScheme";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray;
                        objectArray[2] = "onSchemeAdded";
                        break;
                    }
                    case 11: {
                        objectArray = objectArray;
                        objectArray[2] = "onSchemeDeleted";
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 5, 6, 7, 9 -> new IllegalStateException(string2);
                };
            }
        }, null, null, SettingsCategory.CODE);
        this.doLoadTemplates(this.mySchemeManager.loadSchemes());
        Macro.EP_NAME.addChangeListener(() -> {
            for (TemplateImpl template : this.myTemplates.values()) {
                template.dropParsedData();
            }
            for (TemplateImpl template : this.myDefaultTemplates.values()) {
                template.dropParsedData();
            }
        }, ApplicationManager.getApplication());
        EP_NAME.addChangeListener(this.mySchemeManager::reload, ApplicationManager.getApplication());
    }

    private void doLoadTemplates(@NotNull Collection<? extends TemplateGroup> groups2) {
        if (groups2 == null) {
            TemplateSettings.$$$reportNull$$$0(1);
        }
        for (TemplateGroup templateGroup : groups2) {
            for (TemplateImpl template : templateGroup.getElements()) {
                this.addTemplateImpl(template);
            }
        }
        this.loadDefaultLiveTemplates();
    }

    public static TemplateSettings getInstance() {
        return ApplicationManager.getApplication().getService(TemplateSettings.class);
    }

    private boolean differsFromDefault(@NotNull LiveTemplateContextsSnapshot allContexts, @NotNull TemplateImpl t) {
        TemplateImpl def;
        if (allContexts == null) {
            TemplateSettings.$$$reportNull$$$0(2);
        }
        if (t == null) {
            TemplateSettings.$$$reportNull$$$0(3);
        }
        return (def = this.getDefaultTemplate(t)) == null || !t.equals(def) || !TemplateContext.contextsEqual(allContexts, t, def);
    }

    boolean differsFromDefault(@NotNull TemplateImpl t) {
        if (t == null) {
            TemplateSettings.$$$reportNull$$$0(4);
        }
        return this.differsFromDefault(LiveTemplateContextService.getInstance().getSnapshot(), t);
    }

    @Nullable
    public TemplateImpl getDefaultTemplate(@NotNull TemplateImpl t) {
        if (t == null) {
            TemplateSettings.$$$reportNull$$$0(5);
        }
        return this.myDefaultTemplates.get(TemplateKey.keyOf(t));
    }

    @Override
    public State getState() {
        return this.myState;
    }

    @Override
    public void loadState(@NotNull State state) {
        if (state == null) {
            TemplateSettings.$$$reportNull$$$0(6);
        }
        this.myState = state;
        this.applyNewDeletedTemplates();
    }

    void applyNewDeletedTemplates() {
        for (TemplateKey templateKey : this.myState.deletedKeys) {
            if (templateKey.groupName == null) {
                for (TemplateImpl template : new ArrayList<TemplateImpl>(this.myTemplates.get(templateKey.key))) {
                    this.removeTemplate(template);
                }
                continue;
            }
            TemplateImpl toDelete = this.getTemplate(templateKey.key, templateKey.groupName);
            if (toDelete == null) continue;
            this.removeTemplate(toDelete);
        }
    }

    @Nullable
    public String getLastSelectedTemplateKey() {
        return this.myLastSelectedTemplate != null ? this.myLastSelectedTemplate.key : null;
    }

    @Nullable
    public String getLastSelectedTemplateGroup() {
        return this.myLastSelectedTemplate != null ? this.myLastSelectedTemplate.groupName : null;
    }

    public void setLastSelectedTemplate(@Nullable String group2, @Nullable String key) {
        this.myLastSelectedTemplate = group2 == null ? null : new TemplateKey(group2, key);
    }

    public Collection<? extends TemplateImpl> getTemplatesAsList() {
        return this.myTemplates.values();
    }

    public TemplateImpl[] getTemplates() {
        Collection<TemplateImpl> all = this.myTemplates.values();
        return all.toArray(new TemplateImpl[0]);
    }

    public char getDefaultShortcutChar() {
        return this.myState.defaultShortcut;
    }

    public void setDefaultShortcutChar(char defaultShortcutChar) {
        this.myState.defaultShortcut = defaultShortcutChar;
    }

    @NotNull
    public Collection<TemplateImpl> getTemplates(@NotNull String key) {
        if (key == null) {
            TemplateSettings.$$$reportNull$$$0(7);
        }
        Collection<TemplateImpl> collection = this.myTemplates.get(key);
        if (collection == null) {
            TemplateSettings.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @Nullable
    public TemplateImpl getTemplate(@NonNls String key, String group2) {
        Collection<TemplateImpl> templates = this.myTemplates.get(key);
        for (TemplateImpl template : templates) {
            if (!template.getGroupName().equals(group2)) continue;
            return template;
        }
        return null;
    }

    public Template getTemplateById(@NonNls String id) {
        return this.myTemplatesById.get(id);
    }

    public int getMaxKeyLength() {
        return this.myMaxKeyLength;
    }

    public void addTemplate(Template template) {
        this.clearPreviouslyRegistered(template);
        this.addTemplateImpl(template);
        TemplateImpl templateImpl = (TemplateImpl)template;
        String groupName = templateImpl.getGroupName();
        TemplateGroup group2 = this.mySchemeManager.findSchemeByName(groupName);
        if (group2 == null) {
            group2 = new TemplateGroup(groupName);
            this.mySchemeManager.addScheme(group2);
        }
        group2.addElement(templateImpl);
    }

    private void clearPreviouslyRegistered(Template template) {
        TemplateImpl existing = this.getTemplate(template.getKey(), ((TemplateImpl)template).getGroupName());
        if (existing != null) {
            LOG.info("Template with key " + template.getKey() + " and id " + template.getId() + " already registered");
            TemplateGroup group2 = this.mySchemeManager.findSchemeByName(existing.getGroupName());
            if (group2 != null) {
                group2.removeElement(existing);
                if (group2.isEmpty()) {
                    this.mySchemeManager.removeScheme(group2);
                }
            }
            this.myTemplates.remove(template.getKey(), existing);
        }
    }

    private void addTemplateImpl(@NotNull Template template) {
        TemplateImpl templateImpl;
        if (template == null) {
            TemplateSettings.$$$reportNull$$$0(9);
        }
        if (this.getTemplate((templateImpl = (TemplateImpl)template).getKey(), templateImpl.getGroupName()) == null) {
            this.myTemplates.putValue(template.getKey(), templateImpl);
        }
        this.myMaxKeyLength = Math.max(this.myMaxKeyLength, template.getKey().length());
        this.myState.deletedKeys.remove(TemplateKey.keyOf((TemplateImpl)template));
    }

    private void addTemplateById(Template template) {
        String id;
        if (!this.myTemplatesById.containsKey(template.getId()) && (id = template.getId()) != null) {
            this.myTemplatesById.put(id, template);
        }
    }

    public void removeTemplate(@NotNull Template template) {
        if (template == null) {
            TemplateSettings.$$$reportNull$$$0(10);
        }
        this.myTemplates.remove(template.getKey(), (TemplateImpl)template);
        TemplateGroup group2 = this.mySchemeManager.findSchemeByName(((TemplateImpl)template).getGroupName());
        if (group2 != null) {
            group2.removeElement((TemplateImpl)template);
            if (group2.isEmpty()) {
                this.mySchemeManager.removeScheme(group2);
            }
        }
    }

    @NotNull
    private static TemplateImpl createTemplate(@NotNull @NlsSafe String key, @NlsSafe String string2, @NotNull @NonNls String group2, @NlsContexts.DetailedDescription String description, @Nullable @NlsSafe String shortcut, @NonNls String id) {
        if (key == null) {
            TemplateSettings.$$$reportNull$$$0(11);
        }
        if (group2 == null) {
            TemplateSettings.$$$reportNull$$$0(12);
        }
        TemplateImpl template = new TemplateImpl(key, string2, group2, false);
        template.setId(id);
        template.setDescription(description);
        if (TAB.equals(shortcut)) {
            template.setShortcutChar('\t');
        } else if (ENTER.equals(shortcut)) {
            template.setShortcutChar('\n');
        } else if (SPACE.equals(shortcut)) {
            template.setShortcutChar(' ');
        } else if (NONE.equals(shortcut)) {
            template.setShortcutChar('N');
        } else {
            template.setShortcutChar('D');
        }
        TemplateImpl templateImpl = template;
        if (templateImpl == null) {
            TemplateSettings.$$$reportNull$$$0(13);
        }
        return templateImpl;
    }

    private void loadDefaultLiveTemplates() {
        try {
            this.myPredefinedTemplates.clear();
            for (DefaultLiveTemplatesProvider provider2 : DefaultLiveTemplatesProvider.EP_NAME.getExtensionList()) {
                this.loadDefaultLiveTemplatesFromProvider(provider2);
            }
            EP_NAME.processWithPluginDescriptor((ep, pluginDescriptor) -> {
                String file2 = ep.file;
                if (file2 == null) {
                    return;
                }
                try {
                    ClassLoader pluginClassLoader = pluginDescriptor.getClassLoader();
                    this.readDefTemplate(file2, !ep.hidden, pluginClassLoader, PluginInfoDetectorKt.getPluginInfoByDescriptor((PluginDescriptor)pluginDescriptor));
                }
                catch (Exception e) {
                    LOG.error(new PluginException(e, pluginDescriptor.getPluginId()));
                }
            });
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error(e);
        }
    }

    private void loadDefaultLiveTemplatesFromProvider(DefaultLiveTemplatesProvider provider2) throws JDOMException {
        for (String defTemplate : provider2.getDefaultLiveTemplateFiles()) {
            this.readDefTemplate(defTemplate, true, provider2.getClass().getClassLoader(), PluginInfoDetectorKt.getPluginInfo(provider2.getClass()));
        }
        try {
            String[] hidden = provider2.getHiddenLiveTemplateFiles();
            if (hidden != null) {
                for (String s : hidden) {
                    this.readDefTemplate(s, false, provider2.getClass().getClassLoader(), PluginInfoDetectorKt.getPluginInfo(provider2.getClass()));
                }
            }
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
    }

    private void readDefTemplate(@NotNull String defTemplate, boolean registerTemplate, @NotNull ClassLoader loader, PluginInfo info2) throws JDOMException {
        Element element;
        if (defTemplate == null) {
            TemplateSettings.$$$reportNull$$$0(14);
        }
        if (loader == null) {
            TemplateSettings.$$$reportNull$$$0(15);
        }
        String pluginId = info2.getId();
        try {
            byte[] data2 = defTemplate.startsWith("/") ? ResourceUtil.getResourceAsBytes(TemplateSettings.appendExt(defTemplate.substring(1)), loader) : ResourceUtil.getResourceAsBytes(TemplateSettings.appendExt(defTemplate), loader);
            if (data2 == null) {
                LOG.error(new PluginException("Unable to find template resource: " + defTemplate + "; classLoader: " + loader + "; plugin: " + info2, pluginId == null ? null : PluginId.getId(pluginId)));
                return;
            }
            element = JDOMUtil.load(data2);
        }
        catch (IOException e) {
            LOG.error(new PluginException("Unable to read template resource: " + defTemplate + "; classLoader: " + loader + "; plugin: " + info2, e, pluginId == null ? null : PluginId.getId(pluginId)));
            return;
        }
        TemplateGroup defGroup = TemplateSettings.parseTemplateGroup(element, TemplateSettings.getDefaultTemplateName(defTemplate), loader);
        if (defGroup != null) {
            for (TemplateImpl template : defGroup.getElements()) {
                String key = template.getKey();
                String groupName = template.getGroupName();
                if (!Strings.isNotEmpty(key) || !Strings.isNotEmpty(groupName)) continue;
                this.myPredefinedTemplates.put(new Pair<String, String>(key, groupName), info2);
            }
            TemplateGroup group2 = this.mergeParsedGroup(element, true, registerTemplate, defGroup);
            if (group2 != null && group2.getReplace() != null) {
                for (TemplateImpl template : this.myTemplates.get(group2.getReplace())) {
                    this.removeTemplate(template);
                }
            }
        }
    }

    private static String appendExt(@NotNull String head) {
        if (head == null) {
            TemplateSettings.$$$reportNull$$$0(16);
        }
        return head.endsWith(".xml") ? head : head + ".xml";
    }

    @Nullable
    public PluginInfo findPluginForPredefinedTemplate(TemplateImpl template) {
        return this.myPredefinedTemplates.get(Pair.create(template.getKey(), template.getGroupName()));
    }

    private static String getDefaultTemplateName(String defTemplate) {
        return defTemplate.substring(defTemplate.lastIndexOf(47) + 1);
    }

    @Nullable
    private static TemplateGroup parseTemplateGroup(@NotNull Element element, @NonNls String defGroupName, @NotNull ClassLoader classLoader) {
        if (element == null) {
            TemplateSettings.$$$reportNull$$$0(17);
        }
        if (classLoader == null) {
            TemplateSettings.$$$reportNull$$$0(18);
        }
        if (!TEMPLATE_SET.equals(element.getName())) {
            LOG.error("Ignore invalid template scheme: " + JDOMUtil.writeElement(element));
            return null;
        }
        String groupName = element.getAttributeValue(GROUP);
        if (Strings.isEmpty(groupName)) {
            groupName = defGroupName;
        }
        LiveTemplateContextService ltContextService = LiveTemplateContextService.getInstance();
        TemplateGroup result2 = new TemplateGroup(groupName, element.getAttributeValue("REPLACE"));
        for (Element child : element.getChildren(TEMPLATE)) {
            try {
                result2.addElement(TemplateSettings.readTemplateFromElement(groupName, child, classLoader, ltContextService));
            }
            catch (Exception e) {
                LOG.warn("failed to load template " + element.getAttributeValue(NAME), e);
            }
        }
        return result2;
    }

    @Nullable
    private TemplateGroup mergeParsedGroup(@NotNull Element element, boolean isDefault, boolean registerTemplate, TemplateGroup parsedGroup) {
        Object existingScheme;
        if (element == null) {
            TemplateSettings.$$$reportNull$$$0(19);
        }
        Object result2 = new TemplateGroup(parsedGroup.getName(), element.getAttributeValue("REPLACE"));
        LinkedHashMap<String, TemplateImpl> created = new LinkedHashMap<String, TemplateImpl>();
        for (TemplateImpl template : parsedGroup.getElements()) {
            boolean defaultTemplateModified;
            if (isDefault) {
                this.myDefaultTemplates.put(TemplateKey.keyOf(template), template);
            }
            TemplateImpl existing = this.getTemplate(template.getKey(), template.getGroupName());
            boolean bl = defaultTemplateModified = isDefault && (this.myState.deletedKeys.contains(TemplateKey.keyOf(template)) || this.myTemplatesById.containsKey(template.getId()) || existing != null);
            if (!defaultTemplateModified) {
                created.put(template.getKey(), template);
            }
            if (!isDefault || existing == null) continue;
            existing.getTemplateContext().setDefaultContext(template.getTemplateContext());
        }
        if (registerTemplate && (existingScheme = this.mySchemeManager.findSchemeByName(((CompoundScheme)result2).getName())) != null) {
            result2 = existingScheme;
        }
        existingScheme = created.values().iterator();
        while (existingScheme.hasNext()) {
            TemplateImpl template;
            template = (TemplateImpl)existingScheme.next();
            if (registerTemplate) {
                this.clearPreviouslyRegistered(template);
                this.addTemplateImpl(template);
            }
            this.addTemplateById(template);
            ((CompoundScheme)result2).addElement(template);
        }
        if (registerTemplate && (existingScheme = this.mySchemeManager.findSchemeByName(((CompoundScheme)result2).getName())) == null && !((CompoundScheme)result2).isEmpty()) {
            this.mySchemeManager.addScheme((TemplateGroup)result2, false);
        }
        return ((CompoundScheme)result2).isEmpty() ? null : result2;
    }

    @Deprecated
    public static TemplateImpl readTemplateFromElement(String groupName, @NotNull Element element, @NotNull ClassLoader classLoader) {
        if (element == null) {
            TemplateSettings.$$$reportNull$$$0(20);
        }
        if (classLoader == null) {
            TemplateSettings.$$$reportNull$$$0(21);
        }
        return TemplateSettings.readTemplateFromElement(groupName, element, classLoader, LiveTemplateContextService.getInstance());
    }

    public static TemplateImpl readTemplateFromElement(String groupName, @NotNull Element element, @NotNull ClassLoader classLoader, @NotNull LiveTemplateContextService ltContextService) {
        String description;
        if (element == null) {
            TemplateSettings.$$$reportNull$$$0(22);
        }
        if (classLoader == null) {
            TemplateSettings.$$$reportNull$$$0(23);
        }
        if (ltContextService == null) {
            TemplateSettings.$$$reportNull$$$0(24);
        }
        String name = element.getAttributeValue(NAME);
        String value = element.getAttributeValue(VALUE);
        String resourceBundle = element.getAttributeValue(RESOURCE_BUNDLE);
        String key = element.getAttributeValue(KEY);
        String id = element.getAttributeValue(ID);
        if (resourceBundle != null && key != null) {
            ResourceBundle bundle = DynamicBundle.getResourceBundle(classLoader, resourceBundle);
            description = bundle.getString(key);
        } else {
            description = element.getAttributeValue(DESCRIPTION);
        }
        String shortcut = element.getAttributeValue(SHORTCUT);
        TemplateImpl template = TemplateSettings.createTemplate(name, value, groupName, description, shortcut, id);
        template.setToReformat(Boolean.parseBoolean(element.getAttributeValue(TO_REFORMAT)));
        template.setToShortenLongNames(Boolean.parseBoolean(element.getAttributeValue(TO_SHORTEN_FQ_NAMES)));
        template.setDeactivated(Boolean.parseBoolean(element.getAttributeValue(DEACTIVATED)));
        String useStaticImport = element.getAttributeValue(USE_STATIC_IMPORT);
        if (useStaticImport != null) {
            template.setValue(Template.Property.USE_STATIC_IMPORT_IF_POSSIBLE, Boolean.parseBoolean(useStaticImport));
        }
        for (Element e : element.getChildren(VARIABLE)) {
            String variableName = e.getAttributeValue(NAME);
            String expression = e.getAttributeValue(EXPRESSION);
            String defaultValue = e.getAttributeValue(DEFAULT_VALUE);
            boolean isAlwaysStopAt = Boolean.parseBoolean(e.getAttributeValue(ALWAYS_STOP_AT));
            template.addVariable(variableName, expression, defaultValue, isAlwaysStopAt);
        }
        Element context2 = element.getChild(CONTEXT);
        if (context2 != null) {
            template.getTemplateContext().readTemplateContext(context2, ltContextService);
        }
        return template;
    }

    @NotNull
    public static Element serializeTemplate(@NotNull TemplateImpl template, @Nullable TemplateImpl defaultTemplate, @NotNull Lazy<Map<String, TemplateContextType>> idToType) {
        if (template == null) {
            TemplateSettings.$$$reportNull$$$0(25);
        }
        if (idToType == null) {
            TemplateSettings.$$$reportNull$$$0(26);
        }
        Element element = new Element(TEMPLATE);
        String id = template.getId();
        if (id != null) {
            element.setAttribute(ID, id);
        }
        element.setAttribute(NAME, template.getKey());
        element.setAttribute(VALUE, template.getString());
        if (template.getShortcutChar() == '\t') {
            element.setAttribute(SHORTCUT, TAB);
        } else if (template.getShortcutChar() == '\n') {
            element.setAttribute(SHORTCUT, ENTER);
        } else if (template.getShortcutChar() == ' ') {
            element.setAttribute(SHORTCUT, SPACE);
        } else if (template.getShortcutChar() == 'N') {
            element.setAttribute(SHORTCUT, NONE);
        }
        if (template.getDescription() != null) {
            element.setAttribute(DESCRIPTION, template.getDescription());
        }
        element.setAttribute(TO_REFORMAT, Boolean.toString(template.isToReformat()));
        element.setAttribute(TO_SHORTEN_FQ_NAMES, Boolean.toString(template.isToShortenLongNames()));
        if (template.getValue(Template.Property.USE_STATIC_IMPORT_IF_POSSIBLE) != Template.getDefaultValue(Template.Property.USE_STATIC_IMPORT_IF_POSSIBLE)) {
            element.setAttribute(USE_STATIC_IMPORT, Boolean.toString(template.getValue(Template.Property.USE_STATIC_IMPORT_IF_POSSIBLE)));
        }
        if (template.isDeactivated()) {
            element.setAttribute(DEACTIVATED, Boolean.toString(true));
        }
        for (int i2 = 0; i2 < template.getVariableCount(); ++i2) {
            Element variableElement = new Element(VARIABLE);
            variableElement.setAttribute(NAME, template.getVariableNameAt(i2));
            variableElement.setAttribute(EXPRESSION, template.getExpressionStringAt(i2));
            variableElement.setAttribute(DEFAULT_VALUE, template.getDefaultValueStringAt(i2));
            variableElement.setAttribute(ALWAYS_STOP_AT, Boolean.toString(template.isAlwaysStopAt(i2)));
            element.addContent(variableElement);
        }
        Element contextElement = template.getTemplateContext().writeTemplateContext(defaultTemplate == null ? null : defaultTemplate.getTemplateContext(), idToType);
        if (contextElement != null) {
            element.addContent(contextElement);
        }
        Element element2 = element;
        if (element2 == null) {
            TemplateSettings.$$$reportNull$$$0(27);
        }
        return element2;
    }

    public void setTemplates(@NotNull List<? extends TemplateGroup> newGroups) {
        if (newGroups == null) {
            TemplateSettings.$$$reportNull$$$0(28);
        }
        this.myTemplates.clear();
        this.myState.deletedKeys.clear();
        for (TemplateImpl template : this.myDefaultTemplates.values()) {
            this.myState.deletedKeys.add(TemplateKey.keyOf(template));
        }
        this.myMaxKeyLength = 0;
        SmartList<TemplateGroup> schemes = new SmartList<TemplateGroup>();
        for (TemplateGroup templateGroup : newGroups) {
            if (templateGroup.isEmpty()) continue;
            schemes.add(templateGroup);
            for (TemplateImpl template : templateGroup.getElements()) {
                this.clearPreviouslyRegistered(template);
                this.addTemplateImpl(template);
            }
        }
        this.mySchemeManager.setSchemes(schemes);
    }

    public List<TemplateGroup> getTemplateGroups() {
        return this.mySchemeManager.getAllSchemes();
    }

    @NotNull
    public List<TemplateImpl> collectMatchingCandidates(@NotNull String key, @Nullable Character shortcutChar, boolean hasArgument) {
        Collection<TemplateImpl> templates;
        if (key == null) {
            TemplateSettings.$$$reportNull$$$0(29);
        }
        if ((templates = this.getTemplates(key)).isEmpty()) {
            List<TemplateImpl> list2 = Collections.emptyList();
            if (list2 == null) {
                TemplateSettings.$$$reportNull$$$0(30);
            }
            return list2;
        }
        ArrayList<TemplateImpl> candidates = new ArrayList<TemplateImpl>();
        for (TemplateImpl template : templates) {
            if (template.isDeactivated() || shortcutChar != null && this.getShortcutChar(template) != shortcutChar.charValue() || hasArgument && !template.hasArgument()) continue;
            candidates.add(template);
        }
        ArrayList<TemplateImpl> arrayList = candidates;
        if (arrayList == null) {
            TemplateSettings.$$$reportNull$$$0(31);
        }
        return arrayList;
    }

    public char getShortcutChar(TemplateImpl template) {
        char c2 = template.getShortcutChar();
        return c2 == 'D' ? this.getDefaultShortcutChar() : c2;
    }

    public List<TemplateKey> getDeletedTemplates() {
        return this.myState.deletedKeys;
    }

    public void reset() {
        this.myState.deletedKeys.clear();
        this.loadDefaultLiveTemplates();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 13, 27, 30, 31 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allContexts";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: 
            case 11: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = KEY;
                break;
            }
            case 8: 
            case 13: 
            case 27: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/impl/TemplateSettings";
                break;
            }
            case 9: 
            case 10: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = TEMPLATE;
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = GROUP;
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defTemplate";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "head";
                break;
            }
            case 17: 
            case 19: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ltContextService";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idToType";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newGroups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/impl/TemplateSettings";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplates";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemplate";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "serializeTemplate";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "collectMatchingCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doLoadTemplates";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "differsFromDefault";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTemplate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTemplates";
                break;
            }
            case 8: 
            case 13: 
            case 27: 
            case 30: 
            case 31: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addTemplateImpl";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeTemplate";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createTemplate";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "readDefTemplate";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "appendExt";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "parseTemplateGroup";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "mergeParsedGroup";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "readTemplateFromElement";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "serializeTemplate";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setTemplates";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "collectMatchingCandidates";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 8, 13, 27, 30, 31 -> new IllegalStateException(string2);
        };
    }

    static final class State {
        @OptionTag(nameAttribute="", valueAttribute="shortcut", converter=ShortcutConverter.class)
        public char defaultShortcut = (char)9;
        public List<TemplateKey> deletedKeys = new SmartList<TemplateKey>();

        State() {
        }
    }

    public static final class TemplateKey {
        private String groupName;
        private String key;

        public TemplateKey() {
        }

        private TemplateKey(String groupName, String key) {
            this.groupName = groupName;
            this.key = key;
        }

        public static TemplateKey keyOf(TemplateImpl template) {
            return new TemplateKey(template.getGroupName(), template.getKey());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TemplateKey that = (TemplateKey)o;
            return Objects.equals(this.groupName, that.groupName) && Objects.equals(this.key, that.key);
        }

        public int hashCode() {
            int result2 = this.groupName != null ? this.groupName.hashCode() : 0;
            result2 = 31 * result2 + (this.key != null ? this.key.hashCode() : 0);
            return result2;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String toString() {
            return this.getKey() + "@" + this.getGroupName();
        }
    }

    static final class ShortcutConverter
    extends Converter<Character> {
        ShortcutConverter() {
        }

        @Override
        @NotNull
        public Character fromString(@NotNull String shortcut) {
            if (shortcut == null) {
                ShortcutConverter.$$$reportNull$$$0(0);
            }
            Character c2 = Character.valueOf((char)(TemplateSettings.TAB.equals(shortcut) ? 9 : (TemplateSettings.ENTER.equals(shortcut) ? 10 : (TemplateSettings.CUSTOM.equals(shortcut) ? 67 : (TemplateSettings.NONE.equals(shortcut) ? 78 : 32)))));
            if (c2 == null) {
                ShortcutConverter.$$$reportNull$$$0(1);
            }
            return c2;
        }

        @Override
        @NotNull
        public String toString(@NotNull Character shortcut) {
            if (shortcut == null) {
                ShortcutConverter.$$$reportNull$$$0(2);
            }
            return shortcut.charValue() == '\t' ? TemplateSettings.TAB : (shortcut.charValue() == '\n' ? TemplateSettings.ENTER : (shortcut.charValue() == 'C' ? TemplateSettings.CUSTOM : (shortcut.charValue() == 'N' ? TemplateSettings.NONE : TemplateSettings.SPACE)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = TemplateSettings.SHORTCUT;
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/template/impl/TemplateSettings$ShortcutConverter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/template/impl/TemplateSettings$ShortcutConverter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "fromString";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "toString";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }
}

