/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.TemplateBase;
import com.intellij.codeInsight.template.impl.TemplateSegments;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.DocumentUtil;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateStateBase {
    private final Map myProperties;
    private Editor myEditor;
    private Document myDocument;
    private Map<String, String> myPredefinedVariableValues;
    private TemplateBase myTemplate;
    private TemplateSegments mySegments;

    public TemplateStateBase(Editor editor2, @NotNull Document document) {
        if (document == null) {
            TemplateStateBase.$$$reportNull$$$0(0);
        }
        this.myProperties = new HashMap();
        this.myEditor = editor2;
        this.myDocument = document;
    }

    protected void setEditor(Editor editor2) {
        this.myEditor = editor2;
    }

    public Editor getEditor() {
        return this.myEditor;
    }

    protected Document getDocument() {
        return this.myDocument;
    }

    protected void setDocument(Document document) {
        this.myDocument = document;
    }

    protected Map<String, String> getPredefinedVariableValues() {
        return this.myPredefinedVariableValues;
    }

    protected void setPredefinedVariableValues(Map<String, String> predefinedVariableValues) {
        this.myPredefinedVariableValues = predefinedVariableValues;
    }

    protected void setTemplate(TemplateBase template) {
        this.myTemplate = template;
    }

    @Nullable
    protected String getSelectionBeforeTemplate() {
        return (String)this.myProperties.get(ExpressionContext.SELECTION);
    }

    @Nullable
    public TextResult getVariableValue(@NotNull String variableName) {
        String text2;
        if (variableName == null) {
            TemplateStateBase.$$$reportNull$$$0(1);
        }
        if (variableName.equals("SELECTION")) {
            return new TextResult(StringUtil.notNullize(this.getSelectionBeforeTemplate()));
        }
        if (variableName.equals("END")) {
            return new TextResult("");
        }
        if (this.myPredefinedVariableValues != null && (text2 = this.myPredefinedVariableValues.get(variableName)) != null) {
            return new TextResult(text2);
        }
        int segmentNumber = this.myTemplate.getVariableSegmentNumber(variableName);
        if (segmentNumber < 0 || this.mySegments.getSegmentsCount() <= segmentNumber) {
            return null;
        }
        CharSequence text3 = this.myDocument.getImmutableCharSequence();
        int start = this.mySegments.getSegmentStart(segmentNumber);
        int end = this.mySegments.getSegmentEnd(segmentNumber);
        int length = text3.length();
        if (start > length || end > length) {
            return null;
        }
        return new TextResult(text3.subSequence(start, end).toString());
    }

    boolean isDisposed() {
        return this.myDocument == null;
    }

    protected void restoreEmptyVariables(IntList indices) {
        ArrayList<TextRange> rangesToRemove = new ArrayList<TextRange>();
        for (int i2 = 0; i2 < indices.size(); ++i2) {
            int index2 = indices.getInt(i2);
            rangesToRemove.add(TextRange.create(this.mySegments.getSegmentStart(index2), this.mySegments.getSegmentEnd(index2)));
        }
        rangesToRemove.sort((o1, o2) -> {
            int startDiff = o2.getStartOffset() - o1.getStartOffset();
            return startDiff != 0 ? startDiff : o2.getEndOffset() - o1.getEndOffset();
        });
        DocumentUtil.executeInBulk(this.myDocument, () -> {
            if (this.isDisposed()) {
                return;
            }
            for (TextRange range : rangesToRemove) {
                this.myDocument.deleteString(range.getStartOffset(), range.getEndOffset());
            }
        });
    }

    protected TemplateBase getTemplate() {
        return this.myTemplate;
    }

    protected TemplateSegments getSegments() {
        return this.mySegments;
    }

    protected void setSegments(TemplateSegments segments) {
        this.mySegments = segments;
    }

    public Map getProperties() {
        return this.myProperties;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/template/impl/TemplateStateBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getVariableValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

