/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.impl.MacroParser;
import com.intellij.codeInsight.template.impl.SelectionNode;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Variable
implements Cloneable {
    private final String myName;
    private boolean myAlwaysStopAt;
    @Nullable
    private String myExpressionString;
    private Expression myExpression;
    private String myDefaultValueString;
    private Expression myDefaultValueExpression;
    private final boolean mySkipOnStart;

    public Variable(@NotNull Variable from) {
        if (from == null) {
            Variable.$$$reportNull$$$0(0);
        }
        this.myExpression = null;
        this.myName = from.myName;
        this.myExpression = from.myExpression;
        this.myDefaultValueExpression = from.myDefaultValueExpression;
        this.myExpressionString = from.myExpressionString;
        this.myDefaultValueString = from.myDefaultValueString;
        this.myAlwaysStopAt = from.myAlwaysStopAt;
        this.mySkipOnStart = from.mySkipOnStart;
    }

    public Variable(@NotNull @NlsSafe String name, @Nullable Expression expression, @Nullable Expression defaultValueExpression, boolean alwaysStopAt, boolean skipOnStart) {
        if (name == null) {
            Variable.$$$reportNull$$$0(1);
        }
        this.myExpression = null;
        this.myName = name;
        this.myExpression = expression;
        this.myDefaultValueExpression = defaultValueExpression;
        this.myAlwaysStopAt = alwaysStopAt;
        this.mySkipOnStart = skipOnStart;
    }

    public Variable(@NotNull @NlsSafe String name, @Nullable @NlsSafe String expression, @Nullable @NlsSafe String defaultValueString, boolean alwaysStopAt) {
        if (name == null) {
            Variable.$$$reportNull$$$0(2);
        }
        this.myExpression = null;
        this.myName = name;
        this.myExpressionString = StringUtil.notNullize(expression);
        this.myDefaultValueString = StringUtil.notNullize(defaultValueString);
        this.myAlwaysStopAt = alwaysStopAt;
        this.mySkipOnStart = false;
    }

    @NotNull
    public String getExpressionString() {
        String string2 = StringUtil.notNullize(this.myExpressionString);
        if (string2 == null) {
            Variable.$$$reportNull$$$0(3);
        }
        return string2;
    }

    public void setExpressionString(@Nullable String expressionString) {
        this.myExpressionString = expressionString;
        this.myExpression = null;
    }

    @NotNull
    public Expression getExpression() {
        if (this.myExpression == null) {
            this.myExpression = this.myName.equals("SELECTION") ? new SelectionNode() : MacroParser.parse(this.myExpressionString);
        }
        Expression expression = this.myExpression;
        if (expression == null) {
            Variable.$$$reportNull$$$0(4);
        }
        return expression;
    }

    @NotNull
    public String getDefaultValueString() {
        String string2 = StringUtil.notNullize(this.myDefaultValueString);
        if (string2 == null) {
            Variable.$$$reportNull$$$0(5);
        }
        return string2;
    }

    public void setDefaultValueString(@Nullable String defaultValueString) {
        this.myDefaultValueString = defaultValueString;
        this.myDefaultValueExpression = null;
    }

    @NotNull
    public Expression getDefaultValueExpression() {
        if (this.myDefaultValueExpression == null) {
            this.myDefaultValueExpression = MacroParser.parse(this.myDefaultValueString);
        }
        Expression expression = this.myDefaultValueExpression;
        if (expression == null) {
            Variable.$$$reportNull$$$0(6);
        }
        return expression;
    }

    void dropParsedData() {
        if (this.myExpressionString != null) {
            this.myExpression = null;
        }
        if (this.myDefaultValueString != null) {
            this.myDefaultValueExpression = null;
        }
    }

    @NotNull
    public String getName() {
        String string2 = this.myName;
        if (string2 == null) {
            Variable.$$$reportNull$$$0(7);
        }
        return string2;
    }

    public boolean isAlwaysStopAt() {
        if (this.myName.equals("SELECTION")) {
            return false;
        }
        return this.myAlwaysStopAt;
    }

    public void setAlwaysStopAt(boolean alwaysStopAt) {
        this.myAlwaysStopAt = alwaysStopAt;
    }

    public Object clone() {
        return new Variable(this.myName, this.myExpressionString, this.myDefaultValueString, this.myAlwaysStopAt);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Variable)) {
            return false;
        }
        Variable variable = (Variable)o;
        if (this.myAlwaysStopAt != variable.myAlwaysStopAt) {
            return false;
        }
        if (this.mySkipOnStart != variable.mySkipOnStart) {
            return false;
        }
        if (this.myDefaultValueString != null ? !this.myDefaultValueString.equals(variable.myDefaultValueString) : variable.myDefaultValueString != null) {
            return false;
        }
        if (this.myExpressionString != null ? !this.myExpressionString.equals(variable.myExpressionString) : variable.myExpressionString != null) {
            return false;
        }
        return this.myName.equals(variable.myName);
    }

    public int hashCode() {
        int result2 = this.myName.hashCode();
        result2 = 29 * result2 + (this.myAlwaysStopAt ? 1 : 0);
        result2 = 29 * result2 + (this.mySkipOnStart ? 1 : 0);
        result2 = 29 * result2 + (this.myExpressionString != null ? this.myExpressionString.hashCode() : 0);
        result2 = 29 * result2 + (this.myDefaultValueString != null ? this.myDefaultValueString.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return "Variable{myName='" + this.myName + "', myAlwaysStopAt=" + this.myAlwaysStopAt + ", myExpressionString='" + this.myExpressionString + "', myDefaultValueString='" + this.myDefaultValueString + "', mySkipOnStart=" + this.mySkipOnStart + "}";
    }

    public boolean skipOnStart() {
        return this.mySkipOnStart;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/impl/Variable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/impl/Variable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionString";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValueString";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValueExpression";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 4, 5, 6, 7 -> new IllegalStateException(string2);
        };
    }
}

