/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import org.jetbrains.annotations.Nullable;

public class VariableNode
extends Expression {
    private final String myName;
    private final Expression myInitialValue;

    public VariableNode(String name, @Nullable Expression initialValue) {
        this.myName = name;
        this.myInitialValue = initialValue;
    }

    @Override
    public Result calculateResult(ExpressionContext context2) {
        if (this.myInitialValue != null) {
            return this.myInitialValue.calculateQuickResult(context2);
        }
        return context2.getVariableValue(this.getName());
    }

    @Override
    public boolean requiresCommittedPSI() {
        return this.myInitialValue != null && this.myInitialValue.requiresCommittedPSI();
    }

    @Override
    public LookupElement[] calculateLookupItems(ExpressionContext context2) {
        if (this.myInitialValue == null) {
            return null;
        }
        return this.myInitialValue.calculateLookupItems(context2);
    }

    public String getName() {
        return this.myName;
    }

    @Nullable
    public Expression getInitialValue() {
        return this.myInitialValue;
    }
}

