/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.macro.MacroBase;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.util.PsiUtilBase;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CommentMacro
extends MacroBase {
    private final Function<? super Commenter, String> myCommenterFunction;

    protected CommentMacro(String name, Function<? super Commenter, String> commenterFunction) {
        super(name, name + "()");
        this.myCommenterFunction = commenterFunction;
    }

    @Override
    @Nullable
    protected Result calculateResult(Expression @NotNull [] params, ExpressionContext context2, boolean quick) {
        Editor editor2;
        if (params == null) {
            CommentMacro.$$$reportNull$$$0(0);
        }
        Language language = (editor2 = context2.getEditor()) == null ? null : PsiUtilBase.getLanguageInEditor(editor2, context2.getProject());
        Commenter commenter = language == null ? null : (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
        String lineCommentPrefix = commenter == null ? null : this.myCommenterFunction.apply(commenter);
        return lineCommentPrefix == null ? null : new TextResult(lineCommentPrefix.trim());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/codeInsight/template/macro/CommentMacro", "calculateResult"));
    }

    public static class AnyCommentEnd
    extends CommentMacro {
        public AnyCommentEnd() {
            super("commentEnd", (? super Commenter commenter) -> {
                String line = commenter.getLineCommentPrefix();
                return StringUtil.isNotEmpty(line) ? "" : commenter.getBlockCommentSuffix();
            });
        }
    }

    public static class AnyCommentStart
    extends CommentMacro {
        public AnyCommentStart() {
            super("commentStart", (? super Commenter commenter) -> {
                String line = commenter.getLineCommentPrefix();
                return StringUtil.isNotEmpty(line) ? line : commenter.getBlockCommentPrefix();
            });
        }
    }

    public static class BlockCommentEnd
    extends CommentMacro {
        public BlockCommentEnd() {
            super("blockCommentEnd", Commenter::getBlockCommentSuffix);
        }
    }

    public static class BlockCommentStart
    extends CommentMacro {
        public BlockCommentStart() {
            super("blockCommentStart", Commenter::getBlockCommentPrefix);
        }
    }

    public static class LineCommentStart
    extends CommentMacro {
        public LineCommentStart() {
            super("lineCommentStart", Commenter::getLineCommentPrefix);
        }
    }
}

