/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.ListResult;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.containers.ContainerUtil;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GroovyScriptMacro
extends Macro {
    private static final Logger LOG = Logger.getInstance(GroovyScriptMacro.class);

    @Override
    public String getName() {
        return "groovyScript";
    }

    @Override
    public String getPresentableName() {
        return CodeInsightBundle.message("macro.groovy.script", new Object[0]);
    }

    @Override
    public Result calculateResult(Expression @NotNull [] params, ExpressionContext context2) {
        if (params == null) {
            GroovyScriptMacro.$$$reportNull$$$0(0);
        }
        if (params.length == 0) {
            return null;
        }
        Object o = GroovyScriptMacro.runIt(params, context2);
        if (o instanceof Collection && !((Collection)o).isEmpty()) {
            return new TextResult(GroovyScriptMacro.toNormalizedString(((Collection)o).iterator().next()));
        }
        if (o instanceof Object[] && ((Object[])o).length > 0) {
            return new TextResult(GroovyScriptMacro.toNormalizedString(((Object[])o)[0]));
        }
        if (o != null) {
            return new TextResult(GroovyScriptMacro.toNormalizedString(o));
        }
        return null;
    }

    private static Object runIt(Expression[] params, ExpressionContext context2) {
        Editor editor2 = context2.getEditor();
        Language language = editor2 == null ? null : PsiUtilBase.getLanguageInEditor(editor2, context2.getProject());
        try {
            Result result2 = params[0].calculateResult(context2);
            if (result2 == null) {
                return null;
            }
            String text2 = result2.toString();
            GroovyShell shell = new GroovyShell(language == null ? null : language.getClass().getClassLoader());
            File possibleFile = new File(text2);
            Script script = possibleFile.exists() ? shell.parse(possibleFile) : shell.parse(text2);
            Binding binding = new Binding();
            for (int i2 = 1; i2 < params.length; ++i2) {
                Result paramResult = params[i2].calculateResult(context2);
                Object value = null;
                if (paramResult instanceof ListResult) {
                    value = ContainerUtil.map2List(((ListResult)paramResult).getComponents(), result1 -> result1.toString());
                } else if (paramResult != null) {
                    value = paramResult.toString();
                }
                binding.setVariable("_" + i2, value);
            }
            binding.setVariable("_editor", (Object)editor2);
            script.setBinding(binding);
            return script.run();
        }
        catch (Error | Exception e) {
            LOG.info(e);
            return StringUtil.convertLineSeparators(e.getLocalizedMessage());
        }
    }

    @Override
    public Result calculateQuickResult(Expression @NotNull [] params, ExpressionContext context2) {
        if (params == null) {
            GroovyScriptMacro.$$$reportNull$$$0(1);
        }
        return this.calculateResult(params, context2);
    }

    @Override
    public LookupElement[] calculateLookupItems(Expression @NotNull [] params, ExpressionContext context2) {
        Object o;
        if (params == null) {
            GroovyScriptMacro.$$$reportNull$$$0(2);
        }
        List<Object> collection = (o = GroovyScriptMacro.runIt(params, context2)) instanceof Collection ? (List<Object>)o : (o instanceof Object[] ? Arrays.asList((Object[])o) : ContainerUtil.createMaybeSingletonList(o));
        return ContainerUtil.map2Array(collection, LookupElement.class, item -> LookupElementBuilder.create(GroovyScriptMacro.toNormalizedString(item)));
    }

    private static String toNormalizedString(Object o) {
        return StringUtil.convertLineSeparators(o.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "params";
        objectArray2[1] = "com/intellij/codeInsight/template/macro/GroovyScriptMacro";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateResult";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateQuickResult";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateLookupItems";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

