/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.settings;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.editable.PostfixTemplateEditor;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.FormBuilder;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostfixEditTemplateDialog
extends DialogWrapper {
    private final JBTextField myTemplateNameTextField;
    private final PostfixTemplateEditor myEditor;

    public PostfixEditTemplateDialog(@NotNull Component parentComponent, @NotNull PostfixTemplateEditor editor2, @NotNull String templateType, @Nullable PostfixTemplate template) {
        if (parentComponent == null) {
            PostfixEditTemplateDialog.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            PostfixEditTemplateDialog.$$$reportNull$$$0(1);
        }
        if (templateType == null) {
            PostfixEditTemplateDialog.$$$reportNull$$$0(2);
        }
        super(null, parentComponent, true, DialogWrapper.IdeModalityType.IDE);
        this.myEditor = editor2;
        Disposer.register(this.getDisposable(), editor2);
        String initialName = template != null ? StringUtil.trimStart(template.getKey(), ".") : "";
        this.myTemplateNameTextField = new JBTextField(initialName);
        this.setTitle(template != null ? CodeInsightBundle.message("dialog.title.edit.template", initialName) : CodeInsightBundle.message("dialog.title.create.new.template", templateType));
        this.init();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myTemplateNameTextField;
    }

    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        String templateName = this.myTemplateNameTextField.getText();
        if (!StringUtil.isJavaIdentifier(templateName)) {
            List<ValidationInfo> list2 = Collections.singletonList(new ValidationInfo(CodeInsightBundle.message("message.template.key.must.be.an.identifier", new Object[0]), (JComponent)this.myTemplateNameTextField));
            if (list2 == null) {
                PostfixEditTemplateDialog.$$$reportNull$$$0(3);
            }
            return list2;
        }
        List list3 = super.doValidateAll();
        if (list3 == null) {
            PostfixEditTemplateDialog.$$$reportNull$$$0(4);
        }
        return list3;
    }

    @NotNull
    public String getTemplateName() {
        String string2 = this.myTemplateNameTextField.getText();
        if (string2 == null) {
            PostfixEditTemplateDialog.$$$reportNull$$$0(5);
        }
        return string2;
    }

    protected JComponent createCenterPanel() {
        return FormBuilder.createFormBuilder().addLabeledComponent(CodeInsightBundle.message("label.template.key", new Object[0]), (JComponent)this.myTemplateNameTextField).addComponentFillVertically(this.myEditor.getComponent(), 4).getPanel();
    }

    @Nullable
    protected String getHelpId() {
        return this.myEditor.getHelpId();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateType";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/postfix/settings/PostfixEditTemplateDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/postfix/settings/PostfixEditTemplateDialog";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "doValidateAll";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 4, 5 -> new IllegalStateException(string2);
        };
    }
}

