/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.settings;

import com.intellij.codeInsight.template.postfix.templates.LanguagePostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.codeInsight.template.postfix.templates.editable.PostfixChangedBuiltinTemplate;
import com.intellij.codeInsight.template.postfix.templates.editable.PostfixTemplateWrapper;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="PostfixTemplates", storages={@Storage(value="postfixTemplates.xml")}, category=SettingsCategory.CODE)
public final class PostfixTemplateStorage
extends SimpleModificationTracker
implements PersistentStateComponent<Element> {
    @NonNls
    private static final String TEMPLATE_TAG = "template";
    @NonNls
    private static final String PROVIDER_ATTR_NAME = "provider";
    @NonNls
    private static final String ID_ATTR_NAME = "id";
    @NonNls
    private static final String KEY_ATTR_NAME = "key";
    @NonNls
    private static final String BUILTIN_ATTR_NAME = "builtin";
    private final Map<String, PostfixTemplateProvider> myTemplateProviders;
    private final MultiMap<String, PostfixTemplate> myTemplates = new MultiMap();
    private final List<Element> myUnloadedTemplates = new SmartList<Element>();

    public PostfixTemplateStorage() {
        this.myTemplateProviders = new HashMap<String, PostfixTemplateProvider>();
        for (LanguageExtensionPoint extension2 : LanguagePostfixTemplate.EP_NAME.getExtensionList()) {
            Object provider2 = extension2.getInstance();
            if (!(provider2 instanceof PostfixTemplateProvider)) continue;
            this.myTemplateProviders.put(((PostfixTemplateProvider)provider2).getId(), (PostfixTemplateProvider)provider2);
        }
    }

    @NotNull
    public static PostfixTemplateStorage getInstance() {
        PostfixTemplateStorage postfixTemplateStorage = ApplicationManager.getApplication().getService(PostfixTemplateStorage.class);
        if (postfixTemplateStorage == null) {
            PostfixTemplateStorage.$$$reportNull$$$0(0);
        }
        return postfixTemplateStorage;
    }

    @NotNull
    public Set<PostfixTemplate> getTemplates(@NotNull PostfixTemplateProvider provider2) {
        if (provider2 == null) {
            PostfixTemplateStorage.$$$reportNull$$$0(1);
        }
        return new HashSet<PostfixTemplate>(this.myTemplates.get(provider2.getId()));
    }

    public void setTemplates(@NotNull PostfixTemplateProvider provider2, @NotNull Collection<PostfixTemplate> templates) {
        Collection<PostfixTemplate> oldTemplates;
        if (provider2 == null) {
            PostfixTemplateStorage.$$$reportNull$$$0(2);
        }
        if (templates == null) {
            PostfixTemplateStorage.$$$reportNull$$$0(3);
        }
        if (!templates.equals(oldTemplates = this.myTemplates.get(provider2.getId()))) {
            this.myTemplates.put(provider2.getId(), templates);
            this.incModificationCount();
        }
    }

    @Override
    public void loadState(@NotNull Element state) {
        if (state == null) {
            PostfixTemplateStorage.$$$reportNull$$$0(4);
        }
        this.myTemplates.clear();
        for (Element templateElement2 : state.getChildren(TEMPLATE_TAG)) {
            PostfixTemplateProvider provider2 = this.myTemplateProviders.get(templateElement2.getAttributeValue(PROVIDER_ATTR_NAME, ""));
            if (provider2 != null) {
                String templateId = templateElement2.getAttributeValue(ID_ATTR_NAME, "");
                String templateName = StringUtil.trimStart(StringUtil.notNullize(templateElement2.getAttributeValue(KEY_ATTR_NAME)), ".");
                if (StringUtil.isEmpty(templateId) || StringUtil.isEmpty(templateName)) continue;
                PostfixTemplate externalTemplate = provider2.readExternalTemplate(templateId, templateName, templateElement2);
                String builtinId = templateElement2.getAttributeValue(BUILTIN_ATTR_NAME);
                PostfixTemplate builtinTemplate = PostfixTemplateStorage.findBuiltinTemplate(builtinId, provider2);
                if (builtinTemplate != null) {
                    PostfixTemplate delegate2 = externalTemplate != null ? externalTemplate : new PostfixTemplateWrapper(templateId, templateName, "." + templateName, builtinTemplate, provider2);
                    this.myTemplates.putValue(provider2.getId(), new PostfixChangedBuiltinTemplate(delegate2, builtinTemplate));
                    continue;
                }
                if (externalTemplate != null) {
                    this.myTemplates.putValue(provider2.getId(), externalTemplate);
                    continue;
                }
                this.myUnloadedTemplates.add(templateElement2);
                continue;
            }
            this.myUnloadedTemplates.add(templateElement2);
        }
    }

    @Nullable
    private static PostfixTemplate findBuiltinTemplate(@Nullable @NonNls String id, @NotNull PostfixTemplateProvider provider2) {
        if (provider2 == null) {
            PostfixTemplateStorage.$$$reportNull$$$0(5);
        }
        return (PostfixTemplate)((Object)ContainerUtil.find(provider2.getTemplates(), p -> p.getId().equals(id)));
    }

    @Override
    public Element getState() {
        Element element = new Element("state");
        for (Element element2 : this.myUnloadedTemplates) {
            element.addContent(element2.clone());
        }
        for (Map.Entry entry : this.myTemplates.entrySet()) {
            for (PostfixTemplate template : (Collection)entry.getValue()) {
                PostfixTemplateProvider provider2 = template.getProvider();
                if (provider2 == null) continue;
                if (template instanceof PostfixChangedBuiltinTemplate) {
                    PostfixChangedBuiltinTemplate changedBuiltinTemplate = (PostfixChangedBuiltinTemplate)template;
                    String builtin = changedBuiltinTemplate.getBuiltinTemplate().getId();
                    element.addContent(PostfixTemplateStorage.writeTemplate(changedBuiltinTemplate.getDelegate(), provider2, builtin));
                    continue;
                }
                element.addContent(PostfixTemplateStorage.writeTemplate(template, provider2, null));
            }
        }
        return element;
    }

    private static Element writeTemplate(@NotNull PostfixTemplate template, @NotNull PostfixTemplateProvider provider2, @Nullable String builtinId) {
        if (template == null) {
            PostfixTemplateStorage.$$$reportNull$$$0(6);
        }
        if (provider2 == null) {
            PostfixTemplateStorage.$$$reportNull$$$0(7);
        }
        Element templateElement2 = new Element(TEMPLATE_TAG);
        templateElement2.setAttribute(ID_ATTR_NAME, template.getId());
        templateElement2.setAttribute(KEY_ATTR_NAME, template.getKey());
        templateElement2.setAttribute(PROVIDER_ATTR_NAME, provider2.getId());
        if (builtinId != null) {
            templateElement2.setAttribute(BUILTIN_ATTR_NAME, builtinId);
        }
        provider2.writeExternalTemplate(template, templateElement2);
        return templateElement2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/postfix/settings/PostfixTemplateStorage";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = PROVIDER_ATTR_NAME;
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templates";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = TEMPLATE_TAG;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/postfix/settings/PostfixTemplateStorage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTemplates";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setTemplates";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findBuiltinTemplate";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "writeTemplate";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string2);
        };
    }
}

