/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.settings;

import com.intellij.codeInsight.template.postfix.templates.LanguagePostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.Factory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="PostfixTemplatesSettings", storages={@Storage(value="postfixTemplates.xml")}, category=SettingsCategory.CODE)
public class PostfixTemplatesSettings
implements PersistentStateComponent<Element> {
    public static final Factory<Set<String>> SET_FACTORY = () -> new HashSet();
    private Map<String, Set<String>> myProviderToDisabledTemplates = new HashMap<String, Set<String>>();
    @Deprecated
    private Map<String, Set<String>> myLangToDisabledTemplates = new HashMap<String, Set<String>>();
    private boolean postfixTemplatesEnabled = true;
    private boolean templatesCompletionEnabled = true;
    private int myShortcut = 9;

    public boolean isTemplateEnabled(@NotNull PostfixTemplate template, @NotNull PostfixTemplateProvider provider2) {
        Set<String> result2;
        if (template == null) {
            PostfixTemplatesSettings.$$$reportNull$$$0(0);
        }
        if (provider2 == null) {
            PostfixTemplatesSettings.$$$reportNull$$$0(1);
        }
        return (result2 = this.myProviderToDisabledTemplates.get(provider2.getId())) == null || !result2.contains(template.getId());
    }

    public void disableTemplate(@NotNull PostfixTemplate template, @NotNull PostfixTemplateProvider provider2) {
        if (template == null) {
            PostfixTemplatesSettings.$$$reportNull$$$0(2);
        }
        if (provider2 == null) {
            PostfixTemplatesSettings.$$$reportNull$$$0(3);
        }
        this.disableTemplate(template, provider2.getId());
    }

    public void disableTemplate(@NotNull PostfixTemplate template, @NotNull String providerId) {
        if (template == null) {
            PostfixTemplatesSettings.$$$reportNull$$$0(4);
        }
        if (providerId == null) {
            PostfixTemplatesSettings.$$$reportNull$$$0(5);
        }
        Set<String> state = ContainerUtil.getOrCreate(this.myProviderToDisabledTemplates, providerId, SET_FACTORY);
        state.add(template.getId());
    }

    public boolean isPostfixTemplatesEnabled() {
        return this.postfixTemplatesEnabled;
    }

    public void setPostfixTemplatesEnabled(boolean postfixTemplatesEnabled) {
        this.postfixTemplatesEnabled = postfixTemplatesEnabled;
    }

    public boolean isTemplatesCompletionEnabled() {
        return this.templatesCompletionEnabled;
    }

    public void setTemplatesCompletionEnabled(boolean templatesCompletionEnabled) {
        this.templatesCompletionEnabled = templatesCompletionEnabled;
    }

    @Deprecated(forRemoval=true)
    @MapAnnotation(entryTagName="disabled-postfix-templates", keyAttributeName="lang", surroundWithTag=false)
    @NotNull
    public Map<String, Set<String>> getLangDisabledTemplates() {
        Map<String, Set<String>> map2 = this.myLangToDisabledTemplates;
        if (map2 == null) {
            PostfixTemplatesSettings.$$$reportNull$$$0(6);
        }
        return map2;
    }

    @Deprecated(forRemoval=true)
    public void setLangDisabledTemplates(@NotNull Map<String, Set<String>> templatesState) {
        if (templatesState == null) {
            PostfixTemplatesSettings.$$$reportNull$$$0(7);
        }
        this.myLangToDisabledTemplates = templatesState;
    }

    @MapAnnotation(entryTagName="disabled-templates", keyAttributeName="provider", surroundWithTag=false)
    @NotNull
    public Map<String, Set<String>> getProviderToDisabledTemplates() {
        Map<String, Set<String>> map2 = this.myProviderToDisabledTemplates;
        if (map2 == null) {
            PostfixTemplatesSettings.$$$reportNull$$$0(8);
        }
        return map2;
    }

    public void setProviderToDisabledTemplates(@NotNull Map<String, Set<String>> templatesState) {
        if (templatesState == null) {
            PostfixTemplatesSettings.$$$reportNull$$$0(9);
        }
        this.myProviderToDisabledTemplates = templatesState;
    }

    public int getShortcut() {
        return this.myShortcut;
    }

    public void setShortcut(int shortcut) {
        this.myShortcut = shortcut;
    }

    @NotNull
    public static PostfixTemplatesSettings getInstance() {
        PostfixTemplatesSettings postfixTemplatesSettings = ApplicationManager.getApplication().getService(PostfixTemplatesSettings.class);
        if (postfixTemplatesSettings == null) {
            PostfixTemplatesSettings.$$$reportNull$$$0(10);
        }
        return postfixTemplatesSettings;
    }

    @Override
    @Nullable
    public Element getState() {
        Element result2 = new Element("state");
        XmlSerializer.serializeObjectInto(this, result2);
        return result2;
    }

    @Override
    public void loadState(@NotNull Element settings) {
        if (settings == null) {
            PostfixTemplatesSettings.$$$reportNull$$$0(11);
        }
        this.myLangToDisabledTemplates.clear();
        XmlSerializer.deserializeInto(settings, this);
        if (!this.myLangToDisabledTemplates.isEmpty()) {
            MultiMap<String, Language> importedLanguages = PostfixTemplatesSettings.getLanguagesToImport();
            for (Map.Entry<String, Set<String>> entry : this.myLangToDisabledTemplates.entrySet()) {
                for (Language language : importedLanguages.get(entry.getKey())) {
                    for (PostfixTemplateProvider provider2 : LanguagePostfixTemplate.LANG_EP.allForLanguage(language)) {
                        for (PostfixTemplate template : provider2.getTemplates()) {
                            if (!entry.getValue().contains(template.getKey())) continue;
                            this.disableTemplate(template, provider2);
                        }
                    }
                }
            }
            for (String language : importedLanguages.keySet()) {
                this.myLangToDisabledTemplates.remove(language);
            }
        }
    }

    @NotNull
    private static MultiMap<String, Language> getLanguagesToImport() {
        MultiMap<String, Language> importedLanguages = MultiMap.create();
        for (LanguageExtensionPoint extension2 : LanguagePostfixTemplate.EP_NAME.getExtensionList()) {
            Language language = Language.findLanguageByID(extension2.getKey());
            if (language == null) continue;
            importedLanguages.putValue(language.getDisplayName(), language);
        }
        MultiMap<String, Language> multiMap = importedLanguages;
        if (multiMap == null) {
            PostfixTemplatesSettings.$$$reportNull$$$0(12);
        }
        return multiMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8, 10, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerId";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesSettings";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templatesState";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesSettings";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLangDisabledTemplates";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviderToDisabledTemplates";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguagesToImport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isTemplateEnabled";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "disableTemplate";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setLangDisabledTemplates";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setProviderToDisabledTemplates";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 6, 8, 10, 12 -> new IllegalStateException(string2);
        };
    }
}

