/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.completion.OffsetTranslator;
import com.intellij.codeInsight.template.CustomLiveTemplateBase;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.impl.CustomLiveTemplateLookupElement;
import com.intellij.codeInsight.template.postfix.completion.PostfixTemplateLookupElement;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplatesSettings;
import com.intellij.codeInsight.template.postfix.templates.LanguagePostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateLogger;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplatesUtils;
import com.intellij.diagnostic.CoreAttachmentFactory;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.TemplateLanguageUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostfixLiveTemplate
extends CustomLiveTemplateBase {
    @NonNls
    public static final String POSTFIX_TEMPLATE_ID = "POSTFIX_TEMPLATE_ID";
    private static final Logger LOG = Logger.getInstance(PostfixLiveTemplate.class);

    public @NotNull Set<@NlsSafe String> getAllTemplateKeys(PsiFile file2, int offset2) {
        HashSet<String> keys2 = new HashSet<String>();
        Language language = PsiUtilCore.getLanguageAtOffset(file2, offset2);
        for (PostfixTemplateProvider provider2 : LanguagePostfixTemplate.LANG_EP.allForLanguage(language)) {
            ProgressManager.checkCanceled();
            keys2.addAll(PostfixLiveTemplate.getKeys(provider2));
        }
        HashSet<String> hashSet = keys2;
        if (hashSet == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    @Nullable
    @NlsSafe
    private static String computeTemplateKeyWithoutContextChecking(@NotNull PostfixTemplateProvider provider2, @NotNull CharSequence documentContent, int currentOffset) {
        int startOffset;
        if (provider2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(1);
        }
        if (documentContent == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(2);
        }
        if (documentContent.length() < startOffset) {
            return null;
        }
        for (startOffset = currentOffset; startOffset > 0; --startOffset) {
            ProgressManager.checkCanceled();
            char currentChar = documentContent.charAt(startOffset - 1);
            if (Character.isJavaIdentifierPart(currentChar)) continue;
            if (!provider2.isTerminalSymbol(currentChar)) {
                return null;
            }
            --startOffset;
            break;
        }
        return String.valueOf(documentContent.subSequence(startOffset, currentOffset));
    }

    @Override
    @Nullable
    @NlsSafe
    public String computeTemplateKey(@NotNull CustomTemplateCallback callback) {
        if (callback == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(3);
        }
        Editor editor2 = callback.getEditor();
        CharSequence charsSequence = editor2.getDocument().getCharsSequence();
        int offset2 = editor2.getCaretModel().getOffset();
        for (PostfixTemplateProvider provider2 : LanguagePostfixTemplate.LANG_EP.allForLanguage(PostfixLiveTemplate.getLanguage(callback))) {
            String key = PostfixLiveTemplate.computeTemplateKeyWithoutContextChecking(provider2, charsSequence, offset2);
            if (key == null || !PostfixLiveTemplate.isApplicableTemplate(provider2, key, callback.getFile(), editor2)) continue;
            return key;
        }
        return null;
    }

    @Override
    @Nullable
    @NlsSafe
    public String computeTemplateKeyWithoutContextChecking(@NotNull CustomTemplateCallback callback) {
        if (callback == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(4);
        }
        Editor editor2 = callback.getEditor();
        int currentOffset = editor2.getCaretModel().getOffset();
        for (PostfixTemplateProvider provider2 : LanguagePostfixTemplate.LANG_EP.allForLanguage(PostfixLiveTemplate.getLanguage(callback))) {
            ProgressManager.checkCanceled();
            String key = PostfixLiveTemplate.computeTemplateKeyWithoutContextChecking(provider2, editor2.getDocument().getCharsSequence(), currentOffset);
            if (key == null) continue;
            return key;
        }
        return null;
    }

    @Override
    public boolean supportsMultiCaret() {
        return false;
    }

    @Override
    public void expand(@NotNull String key, @NotNull CustomTemplateCallback callback) {
        if (key == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(5);
        }
        if (callback == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Editor editor2 = callback.getEditor();
        PsiFile file2 = callback.getContext().getContainingFile();
        for (PostfixTemplateProvider provider2 : LanguagePostfixTemplate.LANG_EP.allForLanguage(PostfixLiveTemplate.getLanguage(callback))) {
            PostfixTemplate postfixTemplate = PostfixLiveTemplate.findApplicableTemplate(provider2, key, editor2, file2);
            if (postfixTemplate == null) continue;
            PostfixLiveTemplate.expandTemplate(key, callback, editor2, provider2, postfixTemplate);
            return;
        }
        if (editor2.getCaretModel().getAllCarets().size() == 1) {
            LOG.error("Template not found by key: " + key + "; offset = " + callback.getOffset(), CoreAttachmentFactory.createAttachment(callback.getFile().getVirtualFile()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void expandTemplate(@NotNull String key, @NotNull CustomTemplateCallback callback, @NotNull Editor editor2, @NotNull PostfixTemplateProvider provider2, @NotNull PostfixTemplate postfixTemplate) {
        if (key == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(7);
        }
        if (callback == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(8);
        }
        if (editor2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(9);
        }
        if (provider2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(10);
        }
        if (postfixTemplate == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(11);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.postfix");
        PsiFile file2 = callback.getContext().getContainingFile();
        if (PostfixLiveTemplate.isApplicableTemplate(provider2, key, file2, editor2, postfixTemplate)) {
            int offset2 = PostfixLiveTemplate.deleteTemplateKey(file2, editor2, key);
            try {
                provider2.preExpand(file2, editor2);
                PsiElement context2 = CustomTemplateCallback.getContext(file2, PostfixLiveTemplate.positiveOffset(offset2));
                PostfixLiveTemplate.expandTemplate(postfixTemplate, editor2, context2);
            }
            finally {
                provider2.afterExpand(file2, editor2);
            }
        } else if (editor2.getCaretModel().getAllCarets().size() == 1) {
            LOG.error("Template not found by key: " + key + "; offset = " + callback.getOffset(), CoreAttachmentFactory.createAttachment(callback.getFile().getVirtualFile()));
        }
    }

    @Override
    public boolean isApplicable(@NotNull CustomTemplateCallback callback, int offset2, boolean wrapping) {
        if (callback == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(12);
        }
        PostfixTemplatesSettings settings = PostfixTemplatesSettings.getInstance();
        if (wrapping || !settings.isPostfixTemplatesEnabled()) {
            return false;
        }
        PsiFile contextFile = callback.getFile();
        Language language = PsiUtilCore.getLanguageAtOffset(contextFile, offset2);
        CharSequence fileText = callback.getEditor().getDocument().getImmutableCharSequence();
        for (PostfixTemplateProvider provider2 : LanguagePostfixTemplate.LANG_EP.allForLanguage(language)) {
            if (!StringUtil.isNotEmpty(PostfixLiveTemplate.computeTemplateKeyWithoutContextChecking(provider2, fileText, offset2 + 1))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supportsWrapping() {
        return false;
    }

    @Override
    public void wrap(@NotNull String selection, @NotNull CustomTemplateCallback callback) {
        if (selection == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(13);
        }
        if (callback == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(14);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    @NlsActions.ActionText
    public String getTitle() {
        String string2 = CodeInsightBundle.message("postfix.live.template.title", new Object[0]);
        if (string2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(15);
        }
        return string2;
    }

    @Override
    public char getShortcut() {
        return (char)PostfixTemplatesSettings.getInstance().getShortcut();
    }

    @Override
    public boolean hasCompletionItem(@NotNull CustomTemplateCallback callback, int offset2) {
        if (callback == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(16);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Collection<? extends CustomLiveTemplateLookupElement> getLookupElements(@NotNull PsiFile file2, @NotNull Editor editor2, int offset2) {
        if (file2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(17);
        }
        if (editor2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(18);
        }
        HashSet<PostfixTemplateLookupElement> result2 = new HashSet<PostfixTemplateLookupElement>();
        CustomTemplateCallback callback = new CustomTemplateCallback(editor2, file2);
        Disposable parentDisposable = Disposer.newDisposable();
        try {
            for (PostfixTemplateProvider provider2 : LanguagePostfixTemplate.LANG_EP.allForLanguage(PostfixLiveTemplate.getLanguage(callback))) {
                ProgressManager.checkCanceled();
                String key = this.computeTemplateKeyWithoutContextChecking(callback);
                if (key == null || editor2.getCaretModel().getCaretCount() != 1) continue;
                Condition<PostfixTemplate> isApplicationTemplateFunction = PostfixLiveTemplate.createIsApplicationTemplateFunction(provider2, key, file2, editor2, parentDisposable);
                for (PostfixTemplate postfixTemplate : PostfixTemplatesUtils.getAvailableTemplates(provider2)) {
                    ProgressManager.checkCanceled();
                    if (!isApplicationTemplateFunction.value(postfixTemplate)) continue;
                    result2.add(new PostfixTemplateLookupElement(this, postfixTemplate, postfixTemplate.getKey(), provider2, false));
                }
            }
        }
        finally {
            Disposer.dispose(parentDisposable);
        }
        HashSet<PostfixTemplateLookupElement> hashSet = result2;
        if (hashSet == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(19);
        }
        return hashSet;
    }

    private static void expandTemplate(@NotNull PostfixTemplate template, @NotNull Editor editor2, @NotNull PsiElement context2) {
        if (template == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(20);
        }
        if (editor2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(21);
        }
        if (context2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(22);
        }
        PostfixTemplateLogger.log(template, context2);
        if (template.startInWriteAction()) {
            ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().executeCommand(context2.getProject(), () -> template.expand(context2, editor2), CodeInsightBundle.message("command.expand.postfix.template", new Object[0]), POSTFIX_TEMPLATE_ID));
        } else {
            template.expand(context2, editor2);
        }
    }

    private static int deleteTemplateKey(@NotNull PsiFile file2, @NotNull Editor editor2, @NotNull String key) {
        if (file2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(23);
        }
        if (editor2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(24);
        }
        if (key == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(25);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        int currentOffset = editor2.getCaretModel().getOffset();
        int newOffset = currentOffset - key.length();
        ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().runUndoTransparentAction(() -> {
            Document document = editor2.getDocument();
            document.deleteString(newOffset, currentOffset);
            editor2.getCaretModel().moveToOffset(newOffset);
            PsiDocumentManager.getInstance(file2.getProject()).commitDocument(document);
        }));
        return newOffset;
    }

    private static Condition<PostfixTemplate> createIsApplicationTemplateFunction(@NotNull PostfixTemplateProvider provider2, @NotNull String key, @NotNull PsiFile file2, @NotNull Editor editor2, @NotNull Disposable parentDisposable) {
        if (provider2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(26);
        }
        if (key == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(27);
        }
        if (file2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(28);
        }
        if (editor2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(29);
        }
        if (parentDisposable == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(30);
        }
        if (file2.getFileType().isBinary()) {
            return Conditions.alwaysFalse();
        }
        int currentOffset = editor2.getCaretModel().getOffset();
        int newOffset = currentOffset - key.length();
        CharSequence fileContent = editor2.getDocument().getCharsSequence();
        StringBuilder fileContentWithoutKey = new StringBuilder();
        fileContentWithoutKey.append(fileContent.subSequence(0, newOffset));
        fileContentWithoutKey.append(fileContent.subSequence(currentOffset, fileContent.length()));
        PsiFile copyFile = PostfixLiveTemplate.copyFile(file2, fileContentWithoutKey);
        Document copyDocument = copyFile.getViewProvider().getDocument();
        if (copyDocument == null) {
            return Conditions.alwaysFalse();
        }
        copyDocument = (copyFile = provider2.preCheck(copyFile, editor2, newOffset)).getViewProvider().getDocument();
        if (copyDocument == null) {
            return Conditions.alwaysFalse();
        }
        Document fileDocument = file2.getViewProvider().getDocument();
        if (fileDocument != null && fileDocument.getTextLength() < currentOffset) {
            LOG.error("File document length (" + fileDocument.getTextLength() + ") is less than offset (" + currentOffset + ")", CoreAttachmentFactory.createAttachment(fileDocument), CoreAttachmentFactory.createAttachment(editor2.getDocument()));
        }
        Document originalDocument = editor2.getDocument();
        OffsetTranslator translator = new OffsetTranslator(originalDocument, file2, copyDocument, newOffset, currentOffset, "");
        Disposer.register(parentDisposable, translator);
        PsiElement context2 = CustomTemplateCallback.getContext(copyFile, PostfixLiveTemplate.positiveOffset(newOffset));
        Document finalCopyDocument = copyDocument;
        return template -> template != null && PostfixLiveTemplate.isDumbEnough(template, context2) && template.isEnabled(provider2) && template.isApplicable(context2, finalCopyDocument, newOffset);
    }

    private static boolean isDumbEnough(@NotNull PostfixTemplate template, @NotNull PsiElement context2) {
        DumbService dumbService;
        if (template == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(31);
        }
        if (context2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(32);
        }
        return !(dumbService = DumbService.getInstance(context2.getProject())).isDumb() || DumbService.isDumbAware(template);
    }

    @NotNull
    public static PsiFile copyFile(@NotNull PsiFile file2, @NotNull StringBuilder fileContentWithoutKey) {
        VirtualFile vFile;
        PsiFile copy2;
        if (file2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(33);
        }
        if (fileContentWithoutKey == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(34);
        }
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance(file2.getProject());
        FileType fileType = file2.getFileType();
        Language language = LanguageUtil.getLanguageForPsi(file2.getProject(), file2.getVirtualFile(), fileType);
        PsiFile psiFile = copy2 = language != null ? psiFileFactory.createFileFromText(file2.getName(), language, (CharSequence)fileContentWithoutKey, false, true) : psiFileFactory.createFileFromText(file2.getName(), fileType, (CharSequence)fileContentWithoutKey);
        if (copy2 instanceof PsiFileImpl) {
            ((PsiFileImpl)copy2).setOriginalFile(TemplateLanguageUtil.getBaseFile(file2));
        }
        if ((vFile = copy2.getVirtualFile()) != null) {
            UndoUtil.disableUndoFor(vFile);
        }
        PsiFile psiFile2 = copy2;
        if (psiFile2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(35);
        }
        return psiFile2;
    }

    public static boolean isApplicableTemplate(@NotNull PostfixTemplateProvider provider2, @NotNull String key, @NotNull PsiFile file2, @NotNull Editor editor2) {
        if (provider2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(36);
        }
        if (key == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(37);
        }
        if (file2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(38);
        }
        if (editor2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(39);
        }
        return PostfixLiveTemplate.findApplicableTemplate(provider2, key, editor2, file2) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isApplicableTemplate(@NotNull PostfixTemplateProvider provider2, @NotNull String key, @NotNull PsiFile file2, @NotNull Editor editor2, @Nullable PostfixTemplate template) {
        if (provider2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(40);
        }
        if (key == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(41);
        }
        if (file2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(42);
        }
        if (editor2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(43);
        }
        Disposable parentDisposable = Disposer.newDisposable();
        try {
            boolean bl = PostfixLiveTemplate.createIsApplicationTemplateFunction(provider2, key, file2, editor2, parentDisposable).value(template);
            return bl;
        }
        finally {
            Disposer.dispose(parentDisposable);
        }
    }

    @NotNull
    private static Set<String> getKeys(@NotNull PostfixTemplateProvider provider2) {
        if (provider2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(44);
        }
        HashSet<String> result2 = new HashSet<String>();
        for (PostfixTemplate template : PostfixTemplatesUtils.getAvailableTemplates(provider2)) {
            result2.add(template.getKey());
        }
        HashSet<String> hashSet = result2;
        if (hashSet == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(45);
        }
        return hashSet;
    }

    @Nullable
    private static PostfixTemplate findApplicableTemplate(@NotNull PostfixTemplateProvider provider2, @Nullable String key, @NotNull Editor editor2, @NotNull PsiFile file2) {
        if (provider2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(46);
        }
        if (editor2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(47);
        }
        if (file2 == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(48);
        }
        for (PostfixTemplate template : PostfixTemplatesUtils.getAvailableTemplates(provider2)) {
            if (!template.getKey().equals(key) || !PostfixLiveTemplate.isApplicableTemplate(provider2, key, file2, editor2, template)) continue;
            return template;
        }
        return null;
    }

    private static Language getLanguage(@NotNull CustomTemplateCallback callback) {
        if (callback == null) {
            PostfixLiveTemplate.$$$reportNull$$$0(49);
        }
        return PsiUtilCore.getLanguageAtOffset(callback.getFile(), callback.getOffset());
    }

    private static int positiveOffset(int offset2) {
        return offset2 > 0 ? offset2 - 1 : offset2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 17, 18, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 36, 37, 38, 39, 40, 41, 42, 43, 44, 46, 47, 48, 49 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate";
                break;
            }
            case 1: 
            case 10: 
            case 26: 
            case 36: 
            case 40: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentContent";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 14: 
            case 16: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 5: 
            case 7: 
            case 25: 
            case 27: 
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 9: 
            case 18: 
            case 21: 
            case 24: 
            case 29: 
            case 39: 
            case 43: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postfixTemplate";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 17: 
            case 23: 
            case 28: 
            case 33: 
            case 38: 
            case 42: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 20: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 22: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContentWithoutKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTemplateKeys";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/postfix/templates/PostfixLiveTemplate";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupElements";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFile";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeTemplateKeyWithoutContextChecking";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeTemplateKey";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "expandTemplate";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "hasCompletionItem";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getLookupElements";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "deleteTemplateKey";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createIsApplicationTemplateFunction";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isDumbEnough";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "copyFile";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableTemplate";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getKeys";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "findApplicableTemplate";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getLanguage";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 17, 18, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 36, 37, 38, 39, 40, 41, 42, 43, 44, 46, 47, 48, 49 -> new IllegalArgumentException(string2);
        };
    }
}

