/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplateMetaData;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplatesSettings;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PostfixTemplate {
    @NotNull
    @NonNls
    private final String myId;
    @NotNull
    @NlsSafe
    private final String myPresentableName;
    @NotNull
    @NlsSafe
    private final String myKey;
    private final @NotNull NotNullLazyValue<@NlsContexts.DetailedDescription String> myLazyDescription;
    @NotNull
    @NlsSafe
    private final String myExample;
    @Nullable
    private final PostfixTemplateProvider myProvider;

    @Deprecated(forRemoval=true)
    protected PostfixTemplate(@NotNull @NlsSafe String name, @NotNull @NlsSafe String example) {
        if (name == null) {
            PostfixTemplate.$$$reportNull$$$0(0);
        }
        if (example == null) {
            PostfixTemplate.$$$reportNull$$$0(1);
        }
        this(null, name, "." + name, example, null);
    }

    protected PostfixTemplate(@Nullable @NonNls String id, @NotNull @NlsSafe String name, @NotNull @NlsSafe String example, @Nullable PostfixTemplateProvider provider2) {
        if (name == null) {
            PostfixTemplate.$$$reportNull$$$0(2);
        }
        if (example == null) {
            PostfixTemplate.$$$reportNull$$$0(3);
        }
        this(id, name, "." + name, example, provider2);
    }

    protected PostfixTemplate(@Nullable String id, @NotNull String name, @NotNull String key, @NotNull String example, @Nullable PostfixTemplateProvider provider2) {
        if (name == null) {
            PostfixTemplate.$$$reportNull$$$0(4);
        }
        if (key == null) {
            PostfixTemplate.$$$reportNull$$$0(5);
        }
        if (example == null) {
            PostfixTemplate.$$$reportNull$$$0(6);
        }
        this.myLazyDescription = NotNullLazyValue.createValue(() -> this.calcDescription());
        this.myId = id != null ? id : this.getClass().getName() + "#" + key;
        this.myPresentableName = name;
        this.myKey = key;
        this.myExample = example;
        this.myProvider = provider2;
    }

    @NotNull
    @NlsContexts.DetailedDescription
    protected String calcDescription() {
        String string2;
        String defaultDescription = CodeInsightBundle.message("postfix.template.description.under.construction", new Object[0]);
        try {
            string2 = PostfixTemplateMetaData.createMetaData(this).getDescription().getText();
        }
        catch (IOException iOException) {
            String string3 = defaultDescription;
            if (string3 == null) {
                PostfixTemplate.$$$reportNull$$$0(8);
            }
            return string3;
        }
        if (string2 == null) {
            PostfixTemplate.$$$reportNull$$$0(7);
        }
        return string2;
    }

    @NotNull
    @NonNls
    public String getId() {
        String string2 = this.myId;
        if (string2 == null) {
            PostfixTemplate.$$$reportNull$$$0(9);
        }
        return string2;
    }

    @NotNull
    @NlsSafe
    public final String getKey() {
        String string2 = this.myKey;
        if (string2 == null) {
            PostfixTemplate.$$$reportNull$$$0(10);
        }
        return string2;
    }

    @NotNull
    @NlsSafe
    public String getPresentableName() {
        String string2 = this.myPresentableName;
        if (string2 == null) {
            PostfixTemplate.$$$reportNull$$$0(11);
        }
        return string2;
    }

    @NotNull
    @NlsContexts.DetailedDescription
    public String getDescription() {
        String string2 = this.myLazyDescription.getValue();
        if (string2 == null) {
            PostfixTemplate.$$$reportNull$$$0(12);
        }
        return string2;
    }

    @NotNull
    @NlsSafe
    public String getExample() {
        String string2 = this.myExample;
        if (string2 == null) {
            PostfixTemplate.$$$reportNull$$$0(13);
        }
        return string2;
    }

    public boolean startInWriteAction() {
        return true;
    }

    public boolean isEnabled(PostfixTemplateProvider provider2) {
        PostfixTemplatesSettings settings = PostfixTemplatesSettings.getInstance();
        return settings.isPostfixTemplatesEnabled() && settings.isTemplateEnabled(this, provider2);
    }

    public abstract boolean isApplicable(@NotNull PsiElement var1, @NotNull Document var2, int var3);

    public abstract void expand(@NotNull PsiElement var1, @NotNull Editor var2);

    @Nullable
    public PostfixTemplateProvider getProvider() {
        return this.myProvider;
    }

    public boolean isBuiltin() {
        return true;
    }

    public boolean isEditable() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PostfixTemplate)) {
            return false;
        }
        PostfixTemplate template = (PostfixTemplate)o;
        return Objects.equals(this.myId, template.myId) && Objects.equals(this.myPresentableName, template.myPresentableName) && Objects.equals(this.myKey, template.myKey) && Objects.equals(this.getDescription(), template.getDescription()) && Objects.equals(this.myExample, template.myExample) && Objects.equals(this.myProvider, template.myProvider);
    }

    public int hashCode() {
        return Objects.hash(this.myId, this.myPresentableName, this.myKey, this.getDescription(), this.myExample, this.myProvider);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 10, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "example";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/postfix/templates/PostfixTemplate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/postfix/templates/PostfixTemplate";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "calcDescription";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getExample";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 7, 8, 9, 10, 11, 12, 13 -> new IllegalStateException(string2);
        };
    }
}

