/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.postfix.templates.LanguagePostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PostfixTemplateLogger
extends CounterUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("completion.postfix", 59);
    @NonNls
    private static final String CUSTOM = "custom";
    @NonNls
    private static final String NO_PROVIDER = "no.provider";
    private static final EventField<Language> LANGUAGE = EventFields.Language;
    private static final EventField<String> TEMPLATE = EventFields.StringValidatedByCustomRule((String)"template", PostfixTemplateValidator.class);
    private static final EventField<String> PROVIDER = EventFields.StringValidatedByCustomRule((String)"provider", PostfixTemplateValidator.class);
    private static final EventField<PluginInfo> PLUGIN_INFO = EventFields.PluginInfo;
    private static final VarargEventId EXPANDED = GROUP.registerVarargEvent("expanded", new EventField[]{LANGUAGE, TEMPLATE, PROVIDER, PLUGIN_INFO});

    public EventLogGroup getGroup() {
        return GROUP;
    }

    static void log(@NotNull PostfixTemplate template, @NotNull PsiElement context2) {
        if (template == null) {
            PostfixTemplateLogger.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            PostfixTemplateLogger.$$$reportNull$$$0(1);
        }
        ArrayList<EventPair> events = new ArrayList<EventPair>(4);
        events.add(LANGUAGE.with((Object)context2.getLanguage()));
        if (template.isBuiltin()) {
            PostfixTemplateProvider provider2 = template.getProvider();
            String providerId = provider2 != null ? provider2.getId() : NO_PROVIDER;
            events.add(TEMPLATE.with((Object)template.getId()));
            events.add(PROVIDER.with((Object)providerId));
        } else {
            events.add(TEMPLATE.with((Object)CUSTOM));
            events.add(PROVIDER.with((Object)CUSTOM));
        }
        events.add(PLUGIN_INFO.with((Object)PluginInfoDetectorKt.getPluginInfo(template.getClass())));
        EXPANDED.log(context2.getProject(), events);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "template";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/template/postfix/templates/PostfixTemplateLogger";
        objectArray[2] = "log";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class PostfixTemplateValidator
    extends CustomValidationRule {
        @NotNull
        public String getRuleId() {
            return "completion_template";
        }

        public boolean acceptRuleId(@Nullable String ruleId) {
            return this.getRuleId().equals(ruleId) || "completion_provider_template".equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context2) {
            if (data2 == null) {
                PostfixTemplateValidator.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                PostfixTemplateValidator.$$$reportNull$$$0(1);
            }
            if (StringUtil.equals(data2, PostfixTemplateLogger.CUSTOM) || StringUtil.equals(data2, PostfixTemplateLogger.NO_PROVIDER)) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    PostfixTemplateValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            Language lang = this.getLanguage(context2);
            if (lang == null) {
                ValidationResultType validationResultType = ValidationResultType.REJECTED;
                if (validationResultType == null) {
                    PostfixTemplateValidator.$$$reportNull$$$0(3);
                }
                return validationResultType;
            }
            String provider2 = this.getEventDataField(context2, PROVIDER.getName());
            String template = this.getEventDataField(context2, TEMPLATE.getName());
            if (provider2 == null || template == null || !PostfixTemplateValidator.isProviderOrTemplate(data2, provider2, template)) {
                ValidationResultType validationResultType = ValidationResultType.REJECTED;
                if (validationResultType == null) {
                    PostfixTemplateValidator.$$$reportNull$$$0(4);
                }
                return validationResultType;
            }
            Pair<PostfixTemplate, PostfixTemplateProvider> result2 = PostfixTemplateValidator.findPostfixTemplate(lang, provider2, template);
            if (result2.getFirst() != null && result2.getSecond() != null) {
                PluginInfo templateInfo = PluginInfoDetectorKt.getPluginInfo(result2.getFirst().getClass());
                PluginInfo providerInfo = PluginInfoDetectorKt.getPluginInfo(result2.getSecond().getClass());
                ValidationResultType validationResultType = templateInfo.isDevelopedByJetBrains() && providerInfo.isDevelopedByJetBrains() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
                if (validationResultType == null) {
                    PostfixTemplateValidator.$$$reportNull$$$0(5);
                }
                return validationResultType;
            }
            ValidationResultType validationResultType = ValidationResultType.REJECTED;
            if (validationResultType == null) {
                PostfixTemplateValidator.$$$reportNull$$$0(6);
            }
            return validationResultType;
        }

        private static boolean isProviderOrTemplate(@NotNull String data2, @NotNull String provider2, @NotNull String template) {
            if (data2 == null) {
                PostfixTemplateValidator.$$$reportNull$$$0(7);
            }
            if (provider2 == null) {
                PostfixTemplateValidator.$$$reportNull$$$0(8);
            }
            if (template == null) {
                PostfixTemplateValidator.$$$reportNull$$$0(9);
            }
            return StringUtil.equals(data2, provider2) || StringUtil.equals(data2, template);
        }

        @NotNull
        private static Pair<PostfixTemplate, PostfixTemplateProvider> findPostfixTemplate(@NotNull Language lang, @NotNull String providerId, @NotNull String templateId) {
            if (lang == null) {
                PostfixTemplateValidator.$$$reportNull$$$0(10);
            }
            if (providerId == null) {
                PostfixTemplateValidator.$$$reportNull$$$0(11);
            }
            if (templateId == null) {
                PostfixTemplateValidator.$$$reportNull$$$0(12);
            }
            if (!StringUtil.equals(providerId, PostfixTemplateLogger.NO_PROVIDER)) {
                PostfixTemplateProvider provider2 = PostfixTemplateValidator.findProviderById(providerId, lang);
                PostfixTemplate template = provider2 != null ? PostfixTemplateValidator.findTemplateById(provider2, templateId) : null;
                Pair<PostfixTemplate, PostfixTemplateProvider> pair = provider2 != null && template != null ? Pair.create(template, provider2) : Pair.empty();
                if (pair == null) {
                    PostfixTemplateValidator.$$$reportNull$$$0(13);
                }
                return pair;
            }
            for (PostfixTemplateProvider provider3 : LanguagePostfixTemplate.LANG_EP.allForLanguage(lang)) {
                PostfixTemplate template = PostfixTemplateValidator.findTemplateById(provider3, templateId);
                if (template == null) continue;
                Pair<PostfixTemplate, PostfixTemplateProvider> pair = Pair.create(template, provider3);
                if (pair == null) {
                    PostfixTemplateValidator.$$$reportNull$$$0(14);
                }
                return pair;
            }
            Pair<PostfixTemplate, PostfixTemplateProvider> pair = Pair.empty();
            if (pair == null) {
                PostfixTemplateValidator.$$$reportNull$$$0(15);
            }
            return pair;
        }

        @Nullable
        private static PostfixTemplateProvider findProviderById(@NotNull String id, @NotNull Language lang) {
            if (id == null) {
                PostfixTemplateValidator.$$$reportNull$$$0(16);
            }
            if (lang == null) {
                PostfixTemplateValidator.$$$reportNull$$$0(17);
            }
            for (PostfixTemplateProvider provider2 : LanguagePostfixTemplate.LANG_EP.allForLanguage(lang)) {
                if (!StringUtil.equals(provider2.getId(), id)) continue;
                return provider2;
            }
            return null;
        }

        @Nullable
        private static PostfixTemplate findTemplateById(@NotNull PostfixTemplateProvider provider2, @NotNull String id) {
            if (provider2 == null) {
                PostfixTemplateValidator.$$$reportNull$$$0(18);
            }
            if (id == null) {
                PostfixTemplateValidator.$$$reportNull$$$0(19);
            }
            for (PostfixTemplate template : provider2.getTemplates()) {
                if (!StringUtil.equals(template.getId(), id)) continue;
                return template;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5, 6, 13, 14, 15 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/template/postfix/templates/PostfixTemplateLogger$PostfixTemplateValidator";
                    break;
                }
                case 8: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "template";
                    break;
                }
                case 10: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lang";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "providerId";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "templateId";
                    break;
                }
                case 16: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/template/postfix/templates/PostfixTemplateLogger$PostfixTemplateValidator";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findPostfixTemplate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "isProviderOrTemplate";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "findPostfixTemplate";
                    break;
                }
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "findProviderById";
                    break;
                }
                case 18: 
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "findTemplateById";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2, 3, 4, 5, 6, 13, 14, 15 -> new IllegalStateException(string2);
            };
        }
    }
}

