/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.unwrap;

import com.intellij.codeInsight.unwrap.UnwrapDescriptor;
import com.intellij.codeInsight.unwrap.Unwrapper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UnwrapDescriptorBase
implements UnwrapDescriptor {
    private Unwrapper[] myUnwrappers;

    public final Unwrapper @NotNull [] getUnwrappers() {
        if (this.myUnwrappers == null) {
            this.myUnwrappers = this.createUnwrappers();
        }
        if (this.myUnwrappers == null) {
            UnwrapDescriptorBase.$$$reportNull$$$0(0);
        }
        return this.myUnwrappers;
    }

    @Override
    @NotNull
    public List<Pair<PsiElement, Unwrapper>> collectUnwrappers(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        if (project2 == null) {
            UnwrapDescriptorBase.$$$reportNull$$$0(1);
        }
        if (editor2 == null) {
            UnwrapDescriptorBase.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            UnwrapDescriptorBase.$$$reportNull$$$0(3);
        }
        ArrayList<Pair<PsiElement, Unwrapper>> result2 = new ArrayList<Pair<PsiElement, Unwrapper>>();
        HashSet<PsiElement> ignored = new HashSet<PsiElement>();
        for (PsiElement e = this.findTargetElement(editor2, file2); e != null; e = e.getParent()) {
            for (Unwrapper u : this.getUnwrappers()) {
                if (!u.isApplicableTo(e) || ignored.contains(e)) continue;
                result2.add(Pair.create(e, u));
                u.collectElementsToIgnore(e, ignored);
            }
        }
        ArrayList<Pair<PsiElement, Unwrapper>> arrayList = result2;
        if (arrayList == null) {
            UnwrapDescriptorBase.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    protected abstract Unwrapper[] createUnwrappers();

    @Nullable
    protected PsiElement findTargetElement(Editor editor2, PsiFile file2) {
        PsiElement startElement;
        int offset2 = editor2.getCaretModel().getOffset();
        PsiElement endElement = file2.findElementAt(offset2);
        SelectionModel selectionModel = editor2.getSelectionModel();
        if (selectionModel.hasSelection() && selectionModel.getSelectionStart() < offset2 && (startElement = file2.findElementAt(selectionModel.getSelectionStart())) != null && startElement != endElement && startElement.getTextRange().getEndOffset() == offset2) {
            return startElement;
        }
        return endElement;
    }

    @Override
    public boolean showOptionsDialog() {
        return true;
    }

    @Override
    public boolean shouldTryToRestoreCaretPosition() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/unwrap/UnwrapDescriptorBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnwrappers";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/unwrap/UnwrapDescriptorBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "collectUnwrappers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectUnwrappers";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3 -> new IllegalArgumentException(string2);
        };
    }
}

