/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmptyDirectoryInspection
extends GlobalInspectionTool {
    public boolean onlyReportDirectoriesUnderSourceRoots = false;

    @Override
    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane(OptPane.checkbox("onlyReportDirectoriesUnderSourceRoots", LangBundle.message("empty.directories.only.under.source.roots.option", new Object[0]), new OptRegularComponent[0]));
        if (optPane == null) {
            EmptyDirectoryInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @Override
    public boolean isGraphNeeded() {
        return false;
    }

    @Override
    public boolean isReadActionNeeded() {
        return false;
    }

    @Override
    public void runInspection(@NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext context2, @NotNull ProblemDescriptionsProcessor processor) {
        if (scope == null) {
            EmptyDirectoryInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            EmptyDirectoryInspection.$$$reportNull$$$0(2);
        }
        if (context2 == null) {
            EmptyDirectoryInspection.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            EmptyDirectoryInspection.$$$reportNull$$$0(4);
        }
        Project project2 = context2.getProject();
        ProjectFileIndex index2 = ProjectRootManager.getInstance(project2).getFileIndex();
        SearchScope searchScope2 = ReadAction.compute(() -> scope.toSearchScope());
        if (!(searchScope2 instanceof GlobalSearchScope)) {
            return;
        }
        GlobalSearchScope globalSearchScope = (GlobalSearchScope)searchScope2;
        index2.iterateContent(file2 -> {
            if (this.onlyReportDirectoriesUnderSourceRoots && ReadAction.compute(() -> !index2.isInSourceContent(file2)).booleanValue()) {
                return true;
            }
            if (!file2.isDirectory() || file2.getChildren().length != 0) {
                return true;
            }
            PsiDirectory directory = ReadAction.compute(() -> PsiManager.getInstance(project2).findDirectory(file2));
            RefElement refDirectory = context2.getRefManager().getReference(directory);
            if (refDirectory == null || context2.shouldCheck(refDirectory, this)) {
                return true;
            }
            String relativePath = EmptyDirectoryInspection.getPathRelativeToModule(file2, project2);
            if (relativePath == null) {
                return true;
            }
            processor.addProblemElement(refDirectory, manager.createProblemDescriptor(LangBundle.message("empty.directories.problem.descriptor", relativePath), new EmptyPackageFix(file2.getUrl(), file2.getName())));
            return true;
        }, globalSearchScope);
    }

    @Nullable
    private static String getPathRelativeToModule(VirtualFile file2, Project project2) {
        VirtualFile[] contentRoots;
        ProjectRootManager rootManager = ProjectRootManager.getInstance(project2);
        for (VirtualFile otherRoot : contentRoots = rootManager.getContentRootsFromAllModules()) {
            if (!VfsUtilCore.isAncestor(otherRoot, file2, false)) continue;
            return VfsUtilCore.getRelativePath(file2, otherRoot, '/');
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/EmptyDirectoryInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/EmptyDirectoryInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runInspection";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string2);
        };
    }

    private static class EmptyPackageFix
    implements QuickFix<CommonProblemDescriptor> {
        private final String url;
        private final String name;

        EmptyPackageFix(String url, String name) {
            this.url = url;
            this.name = name;
        }

        @Override
        @NotNull
        public String getName() {
            String string2 = LangBundle.message("empty.directories.delete.quickfix", this.name);
            if (string2 == null) {
                EmptyPackageFix.$$$reportNull$$$0(0);
            }
            return string2;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string2 = LangBundle.message("empty.directories.delete.quickfix", "");
            if (string2 == null) {
                EmptyPackageFix.$$$reportNull$$$0(1);
            }
            return string2;
        }

        @Override
        public void applyFix(@NotNull Project project2, @NotNull CommonProblemDescriptor descriptor2) {
            VirtualFile file2;
            if (project2 == null) {
                EmptyPackageFix.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                EmptyPackageFix.$$$reportNull$$$0(3);
            }
            if ((file2 = VirtualFileManager.getInstance().findFileByUrl(this.url)) == null) {
                return;
            }
            PsiManager psiManager = PsiManager.getInstance(project2);
            PsiDirectory directory = psiManager.findDirectory(file2);
            if (directory == null) {
                return;
            }
            directory.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/EmptyDirectoryInspection$EmptyPackageFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/EmptyDirectoryInspection$EmptyPackageFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 2, 3 -> new IllegalArgumentException(string2);
            };
        }
    }
}

