/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.ide.DataManager;
import com.intellij.lang.LangBundle;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.properties.charset.Native2AsciiCharset;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.ChangeFileEncodingAction;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.encoding.EncodingUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LossyEncodingInspection
extends LocalInspectionTool {
    @Override
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string2 = InspectionsBundle.message("group.names.internationalization.issues", new Object[0]);
        if (string2 == null) {
            LossyEncodingInspection.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @Override
    @NonNls
    @NotNull
    public String getShortName() {
        return "LossyEncoding";
    }

    @Override
    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file2 == null) {
            LossyEncodingInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            LossyEncodingInspection.$$$reportNull$$$0(2);
        }
        if (InjectedLanguageManager.getInstance(file2.getProject()).isInjectedFragment(file2)) {
            return null;
        }
        if (!file2.isPhysical()) {
            return null;
        }
        FileViewProvider viewProvider = file2.getViewProvider();
        if (viewProvider.getBaseLanguage() != file2.getLanguage()) {
            return null;
        }
        VirtualFile virtualFile2 = file2.getVirtualFile();
        if (virtualFile2 == null) {
            return null;
        }
        if (!virtualFile2.isInLocalFileSystem()) {
            return null;
        }
        CharSequence text2 = viewProvider.getContents();
        Charset charset = LoadTextUtil.extractCharsetFromFileContent(file2.getProject(), virtualFile2, text2);
        if (charset instanceof Native2AsciiCharset) {
            return null;
        }
        SmartList<ProblemDescriptor> descriptors = new SmartList<ProblemDescriptor>();
        boolean ok2 = LossyEncodingInspection.checkFileLoadedInWrongEncoding(file2, manager, isOnTheFly, virtualFile2, charset, descriptors);
        if (ok2) {
            LossyEncodingInspection.checkIfCharactersWillBeLostAfterSave(file2, manager, isOnTheFly, text2, charset, descriptors);
        }
        return descriptors.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static boolean checkFileLoadedInWrongEncoding(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly, @NotNull VirtualFile virtualFile2, @NotNull Charset charset, @NotNull List<? super ProblemDescriptor> descriptors) {
        if (file2 == null) {
            LossyEncodingInspection.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            LossyEncodingInspection.$$$reportNull$$$0(4);
        }
        if (virtualFile2 == null) {
            LossyEncodingInspection.$$$reportNull$$$0(5);
        }
        if (charset == null) {
            LossyEncodingInspection.$$$reportNull$$$0(6);
        }
        if (descriptors == null) {
            LossyEncodingInspection.$$$reportNull$$$0(7);
        }
        if (FileDocumentManager.getInstance().isFileModified(virtualFile2) || !EncodingUtil.canReload((VirtualFile)virtualFile2)) {
            return true;
        }
        if (!LossyEncodingInspection.isGoodCharset(virtualFile2, charset)) {
            LocalQuickFix[] fixes = LossyEncodingInspection.getFixes(file2, virtualFile2, charset);
            descriptors.add(manager.createProblemDescriptor((PsiElement)file2, LangBundle.message("inspection.lossy.encoding.description", charset), true, ProblemHighlightType.GENERIC_ERROR, isOnTheFly, fixes));
            return false;
        }
        return true;
    }

    private static LocalQuickFix @NotNull [] getFixes(final @NotNull PsiFile file2, final @NotNull VirtualFile virtualFile2, @NotNull Charset wrongCharset) {
        if (file2 == null) {
            LossyEncodingInspection.$$$reportNull$$$0(8);
        }
        if (virtualFile2 == null) {
            LossyEncodingInspection.$$$reportNull$$$0(9);
        }
        if (wrongCharset == null) {
            LossyEncodingInspection.$$$reportNull$$$0(10);
        }
        HashSet<Charset> suspects = ContainerUtil.newHashSet(CharsetToolkit.getDefaultSystemCharset(), CharsetToolkit.getPlatformCharset());
        suspects.remove(wrongCharset);
        List<Charset> goodCharsets = ContainerUtil.filter(suspects, c2 -> LossyEncodingInspection.isGoodCharset(virtualFile2, c2));
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        if (!goodCharsets.isEmpty()) {
            final Charset goodCharset = goodCharsets.get(0);
            fixes.add(new LocalQuickFix(){

                @Override
                @Nls
                @NotNull
                public String getFamilyName() {
                    String string2 = InspectionsBundle.message("reload.file.encoding.family.name", goodCharset.displayName());
                    if (string2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string2;
                }

                @Override
                public boolean startInWriteAction() {
                    return false;
                }

                @Override
                public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
                    Document document;
                    if (project2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (descriptor2 == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if ((document = PsiDocumentManager.getInstance(project2).getDocument(file2)) == null) {
                        return;
                    }
                    ChangeFileEncodingAction.changeTo((Project)project2, (Document)document, null, (VirtualFile)virtualFile2, (Charset)goodCharset, (EncodingUtil.Magic8)EncodingUtil.Magic8.ABSOLUTELY, (EncodingUtil.Magic8)EncodingUtil.Magic8.ABSOLUTELY);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 2;
                        case 1, 2 -> 3;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/codeInspection/LossyEncodingInspection$1";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "descriptor";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getFamilyName";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/codeInspection/LossyEncodingInspection$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "applyFix";
                            break;
                        }
                    }
                    String string2 = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalStateException(string2);
                        case 1, 2 -> new IllegalArgumentException(string2);
                    };
                }
            });
            fixes.add(new LocalQuickFix(){

                @Override
                @Nls
                @NotNull
                public String getFamilyName() {
                    String string2 = InspectionsBundle.message("set.project.encoding.family.name", goodCharset.displayName());
                    if (string2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return string2;
                }

                @Override
                public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
                    if (project2 == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (descriptor2 == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    EncodingProjectManager.getInstance(project2).setDefaultCharsetName(goodCharset.name());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 2;
                        case 1, 2 -> 3;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/codeInspection/LossyEncodingInspection$2";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "descriptor";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getFamilyName";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/codeInspection/LossyEncodingInspection$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "applyFix";
                            break;
                        }
                    }
                    String string2 = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalStateException(string2);
                        case 1, 2 -> new IllegalArgumentException(string2);
                    };
                }
            });
        }
        fixes.add(new ReloadInAnotherEncodingFix(file2));
        LocalQuickFix[] localQuickFixArray = fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
        if (localQuickFixArray == null) {
            LossyEncodingInspection.$$$reportNull$$$0(11);
        }
        return localQuickFixArray;
    }

    private static boolean isGoodCharset(@NotNull VirtualFile virtualFile2, @NotNull Charset charset) {
        byte[] bytesToSave;
        byte[] loadedBytes;
        FileDocumentManager documentManager;
        Document document;
        if (virtualFile2 == null) {
            LossyEncodingInspection.$$$reportNull$$$0(12);
        }
        if (charset == null) {
            LossyEncodingInspection.$$$reportNull$$$0(13);
        }
        if ((document = (documentManager = FileDocumentManager.getInstance()).getDocument(virtualFile2)) == null) {
            return true;
        }
        try {
            loadedBytes = virtualFile2.contentsToByteArray();
            bytesToSave = new String(loadedBytes, charset).getBytes(charset);
        }
        catch (Exception e) {
            return true;
        }
        if (loadedBytes.length == 0 && bytesToSave.length == 0) {
            return true;
        }
        byte[] bom = virtualFile2.getBOM();
        if (bom != null && !ArrayUtil.startsWith(bytesToSave, bom)) {
            bytesToSave = ArrayUtil.mergeArrays(bom, bytesToSave);
        }
        return Arrays.equals(bytesToSave, loadedBytes);
    }

    private static void checkIfCharactersWillBeLostAfterSave(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly, @NotNull CharSequence text2, @NotNull Charset charset, @NotNull List<ProblemDescriptor> descriptors) {
        TextRange errRange;
        if (file2 == null) {
            LossyEncodingInspection.$$$reportNull$$$0(14);
        }
        if (manager == null) {
            LossyEncodingInspection.$$$reportNull$$$0(15);
        }
        if (text2 == null) {
            LossyEncodingInspection.$$$reportNull$$$0(16);
        }
        if (charset == null) {
            LossyEncodingInspection.$$$reportNull$$$0(17);
        }
        if (descriptors == null) {
            LossyEncodingInspection.$$$reportNull$$$0(18);
        }
        CharBuffer buffer = CharBuffer.wrap(text2);
        int textLength = text2.length();
        CharBuffer back = CharBuffer.allocate(textLength);
        Ref<ByteBuffer> outRef = Ref.create();
        int pos = 0;
        for (int errorCount = 0; pos < text2.length() && errorCount < 200 && (errRange = LossyEncodingInspection.nextUnmappable(buffer, pos, outRef, back, charset)) != null; ++errorCount) {
            ProblemDescriptor lastDescriptor = ContainerUtil.getLastItem(descriptors);
            if (lastDescriptor != null && lastDescriptor.getTextRangeInElement().getEndOffset() == errRange.getStartOffset()) {
                errRange = lastDescriptor.getTextRangeInElement().union(errRange);
                descriptors.remove(descriptors.size() - 1);
            }
            String message = InspectionsBundle.message("unsupported.character.for.the.charset", charset);
            ProblemDescriptor descriptor2 = manager.createProblemDescriptor((PsiElement)file2, errRange, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new ChangeEncodingFix(file2));
            descriptors.add(descriptor2);
            pos = errRange.getEndOffset();
        }
    }

    private static TextRange nextUnmappable(@NotNull CharBuffer in, int position, @NotNull Ref<ByteBuffer> outRef, @NotNull CharBuffer back, @NotNull Charset charset) {
        CoderResult cr;
        if (in == null) {
            LossyEncodingInspection.$$$reportNull$$$0(19);
        }
        if (outRef == null) {
            LossyEncodingInspection.$$$reportNull$$$0(20);
        }
        if (back == null) {
            LossyEncodingInspection.$$$reportNull$$$0(21);
        }
        if (charset == null) {
            LossyEncodingInspection.$$$reportNull$$$0(22);
        }
        CharsetEncoder encoder = charset.newEncoder().onUnmappableCharacter(CodingErrorAction.REPORT).onMalformedInput(CodingErrorAction.REPORT);
        int textLength = in.limit() - position;
        ByteBuffer out = outRef.get();
        if (out == null) {
            out = ByteBuffer.allocate((int)(encoder.averageBytesPerChar() * (float)textLength));
            outRef.set(out);
        }
        out.rewind();
        out.limit(out.capacity());
        in.rewind();
        in.position(position);
        while (true) {
            CoderResult coderResult = cr = in.hasRemaining() ? encoder.encode(in, out, true) : CoderResult.UNDERFLOW;
            if (cr.isUnderflow()) {
                cr = encoder.flush(out);
            }
            if (!cr.isOverflow()) break;
            int n = 3 * out.capacity() / 2 + 1;
            ByteBuffer tmp = ByteBuffer.allocate(n);
            out.flip();
            tmp.put(out);
            out = tmp;
            outRef.set(out);
        }
        if (cr.isError()) {
            return TextRange.from(in.position(), cr.length());
        }
        int outLength = out.position();
        CharsetDecoder decoder = charset.newDecoder().onUnmappableCharacter(CodingErrorAction.REPORT).onMalformedInput(CodingErrorAction.REPORT);
        out.rewind();
        out.limit(outLength);
        back.rewind();
        CoderResult dr = decoder.decode(out, back, true);
        if (dr.isError()) {
            return TextRange.from(back.position(), dr.length());
        }
        if (back.position() != textLength) {
            return TextRange.from(Math.min(textLength, back.position()), 1);
        }
        in.rewind();
        in.position(position);
        back.rewind();
        int len = StringUtil.commonPrefixLength(in, back);
        if (len == textLength) {
            return null;
        }
        return TextRange.from(len, 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/LossyEncodingInspection";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 5: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 6: 
            case 13: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrongCharset";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outRef";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "back";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/LossyEncodingInspection";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkFileLoadedInWrongEncoding";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFixes";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isGoodCharset";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "checkIfCharactersWillBeLostAfterSave";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "nextUnmappable";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22 -> new IllegalArgumentException(string2);
        };
    }

    private static class ReloadInAnotherEncodingFix
    extends ChangeEncodingFix {
        ReloadInAnotherEncodingFix(@NotNull PsiFile file2) {
            if (file2 == null) {
                ReloadInAnotherEncodingFix.$$$reportNull$$$0(0);
            }
            super(file2);
        }

        @Override
        @NotNull
        public String getText() {
            String string2 = InspectionsBundle.message("reload.in.another.encoding.text", new Object[0]);
            if (string2 == null) {
                ReloadInAnotherEncodingFix.$$$reportNull$$$0(1);
            }
            return string2;
        }

        @Override
        public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @Nullable Editor editor2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project2 == null) {
                ReloadInAnotherEncodingFix.$$$reportNull$$$0(2);
            }
            if (file2 == null) {
                ReloadInAnotherEncodingFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                ReloadInAnotherEncodingFix.$$$reportNull$$$0(4);
            }
            if (endElement == null) {
                ReloadInAnotherEncodingFix.$$$reportNull$$$0(5);
            }
            if (FileDocumentManager.getInstance().isFileModified(file2.getVirtualFile())) {
                return;
            }
            super.invoke(project2, file2, editor2, startElement, endElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/LossyEncodingInspection$ReloadInAnotherEncodingFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/LossyEncodingInspection$ReloadInAnotherEncodingFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }

    private static class ChangeEncodingFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        ChangeEncodingFix(@NotNull PsiFile file2) {
            if (file2 == null) {
                ChangeEncodingFix.$$$reportNull$$$0(0);
            }
            super(file2);
        }

        @Override
        public boolean startInWriteAction() {
            return false;
        }

        @Override
        @NotNull
        public String getText() {
            String string2 = this.getFamilyName();
            if (string2 == null) {
                ChangeEncodingFix.$$$reportNull$$$0(1);
            }
            return string2;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string2 = InspectionsBundle.message("change.encoding.fix.family.name", new Object[0]);
            if (string2 == null) {
                ChangeEncodingFix.$$$reportNull$$$0(2);
            }
            return string2;
        }

        @Override
        public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @Nullable Editor editor2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            VirtualFile virtualFile2;
            DataContext dataContext2;
            ListPopup popup2;
            if (project2 == null) {
                ChangeEncodingFix.$$$reportNull$$$0(3);
            }
            if (file2 == null) {
                ChangeEncodingFix.$$$reportNull$$$0(4);
            }
            if (startElement == null) {
                ChangeEncodingFix.$$$reportNull$$$0(5);
            }
            if (endElement == null) {
                ChangeEncodingFix.$$$reportNull$$$0(6);
            }
            if ((popup2 = new ChangeFileEncodingAction().createPopup(dataContext2 = ChangeEncodingFix.createDataContext(editor2, editor2 == null ? null : editor2.getComponent(), virtualFile2 = file2.getVirtualFile(), project2), null)) != null) {
                popup2.showInBestPositionFor(dataContext2);
            }
        }

        @NotNull
        static DataContext createDataContext(@Nullable Editor editor2, Component component2, VirtualFile selectedFile, @NotNull Project project2) {
            if (project2 == null) {
                ChangeEncodingFix.$$$reportNull$$$0(7);
            }
            DataContext dataContext2 = SimpleDataContext.builder().setParent(DataManager.getInstance().getDataContext(component2)).add(PlatformCoreDataKeys.CONTEXT_COMPONENT, (Object)(editor2 == null ? null : editor2.getComponent())).add(CommonDataKeys.PROJECT, (Object)project2).add(CommonDataKeys.VIRTUAL_FILE, (Object)selectedFile).build();
            if (dataContext2 == null) {
                ChangeEncodingFix.$$$reportNull$$$0(8);
            }
            return dataContext2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 2: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/LossyEncodingInspection$ChangeEncodingFix";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/LossyEncodingInspection$ChangeEncodingFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDataContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 8: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createDataContext";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1, 2, 8 -> new IllegalStateException(string2);
            };
        }
    }
}

