/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ExternalAnnotatorInspectionVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAsIntentionAdapter;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Verifier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProblemDescriptorUtil {
    public static final int NONE = 0;
    static final int APPEND_LINE_NUMBER = 1;
    public static final int TRIM_AT_TREE_END = 4;
    @NonNls
    private static final String LOC_REFERENCE = "#loc";
    @NonNls
    private static final String REF_REFERENCE = "#ref";
    public static final Couple<String> XML_CODE_MARKER = Couple.of("<xml-code>", "</xml-code>");

    @NotNull
    public static String extractHighlightedText(@NotNull CommonProblemDescriptor descriptor2, @Nullable PsiElement psiElement) {
        if (descriptor2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(0);
        }
        TextRange range = descriptor2 instanceof ProblemDescriptorBase ? ((ProblemDescriptorBase)descriptor2).getTextRange() : null;
        return ProblemDescriptorUtil.extractHighlightedText(range, psiElement);
    }

    @NotNull
    public static String sanitizeIllegalXmlChars(@NotNull String text2) {
        if (text2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(1);
        }
        if (Verifier.checkCharacterData(text2) == null) {
            String string2 = text2;
            if (string2 == null) {
                ProblemDescriptorUtil.$$$reportNull$$$0(2);
            }
            return string2;
        }
        String string3 = text2.codePoints().map(cp -> Verifier.isXMLCharacter(cp) ? cp : 63).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
        if (string3 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(3);
        }
        return string3;
    }

    @NotNull
    public static String extractHighlightedText(@Nullable TextRange range, @Nullable PsiElement psiElement) {
        TextRange elementRange;
        if (psiElement == null || !psiElement.isValid()) {
            return "";
        }
        String ref = psiElement.getText();
        if (range != null && (elementRange = psiElement.getTextRange()) != null && (range = range.shiftRight(-elementRange.getStartOffset())).getStartOffset() >= 0 && ref.length() > range.getLength()) {
            ref = range.substring(ref);
        }
        ref = ref.replace('\n', ' ').trim();
        ref = StringUtil.first(ref, 100, true);
        String string2 = ref.trim().replaceAll("\\s+", " ");
        if (string2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @NotNull
    public static String renderDescriptionMessage(@NotNull CommonProblemDescriptor descriptor2, @Nullable PsiElement element, boolean appendLineNumber) {
        if (descriptor2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(5);
        }
        return ProblemDescriptorUtil.renderDescriptionMessage(descriptor2, element, appendLineNumber ? 1 : 0);
    }

    @NotNull
    @InspectionMessage
    public static String renderDescriptionMessage(@NotNull CommonProblemDescriptor descriptor2, @Nullable PsiElement element, @FlagConstant int flags) {
        String message;
        if (descriptor2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(6);
        }
        if ((message = descriptor2.getDescriptionTemplate()) == null) {
            return "";
        }
        return ProblemDescriptorUtil.renderDescriptionMessage(descriptor2, element, flags, message);
    }

    public static ProblemPresentation renderDescriptor(@NotNull CommonProblemDescriptor descriptor2, @Nullable PsiElement element, @FlagConstant int flags) {
        if (descriptor2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(7);
        }
        NotNullLazyValue<@InspectionMessage String> descTemplate = NotNullLazyValue.volatileLazy(() -> StringUtil.notNullize(descriptor2.getDescriptionTemplate()));
        NotNullLazyValue<@InspectionMessage String> tooltipTemplate = NotNullLazyValue.volatileLazy(() -> descriptor2 instanceof ProblemDescriptor ? StringUtil.notNullize(((ProblemDescriptor)descriptor2).getTooltipTemplate()) : (String)descTemplate.getValue());
        final NotNullLazyValue<@InspectionMessage String> description = NotNullLazyValue.volatileLazy(() -> ProblemDescriptorUtil.renderDescriptionMessage(descriptor2, element, flags, (String)descTemplate.getValue()));
        final NotNullLazyValue<@NlsContexts.Tooltip String> tooltip = NotNullLazyValue.volatileLazy(() -> {
            String template = (String)tooltipTemplate.getValue();
            return template.equals(descTemplate.getValue()) ? (String)description.getValue() : ProblemDescriptorUtil.renderDescriptionMessage(descriptor2, element, flags, template);
        });
        return new ProblemPresentation(){

            @Override
            @NotNull
            public String getDescription() {
                String string2 = (String)description.getValue();
                if (string2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string2;
            }

            @Override
            @NotNull
            public String getTooltip() {
                String string2 = (String)tooltip.getValue();
                if (string2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/codeInspection/ProblemDescriptorUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDescription";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTooltip";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @NotNull
    @InspectionMessage
    @NlsContexts.Tooltip
    private static String renderDescriptionMessage(@NotNull CommonProblemDescriptor descriptor2, @Nullable PsiElement element, @FlagConstant int flags, @InspectionMessage String template) {
        int lineNumber;
        if (descriptor2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(8);
        }
        String message = template;
        if ((flags & 1) != 0 && descriptor2 instanceof ProblemDescriptor && !message.contains(REF_REFERENCE) && message.contains(LOC_REFERENCE) && (lineNumber = ((ProblemDescriptor)descriptor2).getLineNumber()) >= 0) {
            message = StringUtil.replace(message, LOC_REFERENCE, "(" + AnalysisBundle.message("inspection.export.results.at.line", new Object[0]) + " " + (lineNumber + 1) + ")");
        }
        message = ProblemDescriptorUtil.unescapeTags(message);
        message = ProblemDescriptorUtil.removeLocReference(message);
        if ((flags & 4) != 0) {
            int endIndex;
            if (XmlStringUtil.isWrappedInHtml(message)) {
                message = StringUtil.removeHtmlTags(message, true);
            }
            if ((endIndex = message.indexOf("#treeend")) > 0) {
                message = message.substring(0, endIndex);
            }
        }
        if (message.contains(REF_REFERENCE)) {
            String ref = ProblemDescriptorUtil.extractHighlightedText(descriptor2, element);
            message = StringUtil.replace(message, REF_REFERENCE, ref);
        }
        message = StringUtil.replace(message, "#end", "");
        message = StringUtil.replace(message, "#treeend", "");
        String string2 = message.trim();
        if (string2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(9);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String removeLocReference(@NotNull String message) {
        if (message == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(10);
        }
        message = StringUtil.replace(message, "#loc ", "");
        message = StringUtil.replace(message, " #loc", "");
        String string2 = message = StringUtil.replace(message, LOC_REFERENCE, "");
        if (string2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(11);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static String unescapeTags(@NotNull String message) {
        if (message == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(12);
        }
        message = StringUtil.replace(message, "<code>", "'");
        String string2 = message = (message = StringUtil.replace(message, "</code>", "'")).contains((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.first) ? ProblemDescriptorUtil.unescapeXmlCode(message) : (!XmlStringUtil.isWrappedInHtml(message) ? StringUtil.unescapeXmlEntities(message) : message);
        if (string2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(13);
        }
        return string2;
    }

    @NotNull
    private static String unescapeXmlCode(@NotNull String message) {
        if (message == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(14);
        }
        ArrayList<String> strings2 = new ArrayList<String>();
        for (String string2 : StringUtil.split(message, (String)ProblemDescriptorUtil.XML_CODE_MARKER.first)) {
            if (string2.contains((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.second)) {
                strings2.addAll(StringUtil.split(string2, (String)ProblemDescriptorUtil.XML_CODE_MARKER.second, false));
                continue;
            }
            strings2.add(string2);
        }
        StringBuilder builder2 = new StringBuilder();
        for (String string3 : strings2) {
            if (string3.contains((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.second)) {
                builder2.append(string3.replace((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.second, ""));
                continue;
            }
            builder2.append(StringUtil.unescapeXmlEntities(string3));
        }
        String string4 = builder2.toString();
        if (string4 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(15);
        }
        return string4;
    }

    @NotNull
    public static String renderDescriptionMessage(@NotNull CommonProblemDescriptor descriptor2, @Nullable PsiElement element) {
        if (descriptor2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(16);
        }
        return ProblemDescriptorUtil.renderDescriptionMessage(descriptor2, element, false);
    }

    @NotNull
    public static HighlightInfoType highlightTypeFromDescriptor(@NotNull ProblemDescriptor problemDescriptor, @NotNull HighlightSeverity severity, @NotNull SeverityRegistrar severityRegistrar) {
        if (problemDescriptor == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(17);
        }
        if (severity == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(18);
        }
        if (severityRegistrar == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(19);
        }
        return ProblemDescriptorUtil.getHighlightInfoType(problemDescriptor.getHighlightType(), severity, severityRegistrar);
    }

    @NotNull
    public static HighlightInfoType getHighlightInfoType(@NotNull ProblemHighlightType highlightType, @NotNull HighlightSeverity severity, @NotNull SeverityRegistrar severityRegistrar) {
        if (highlightType == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(20);
        }
        if (severity == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(21);
        }
        if (severityRegistrar == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(22);
        }
        HighlightInfoType highlightInfoType = switch (highlightType) {
            default -> throw new IncompatibleClassChangeError();
            case ProblemHighlightType.GENERIC_ERROR_OR_WARNING -> severityRegistrar.getHighlightInfoTypeBySeverity(severity);
            case ProblemHighlightType.LIKE_DEPRECATED -> new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.DEPRECATED.getAttributesKey());
            case ProblemHighlightType.LIKE_MARKED_FOR_REMOVAL -> new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.MARKED_FOR_REMOVAL.getAttributesKey());
            case ProblemHighlightType.LIKE_UNKNOWN_SYMBOL -> {
                if (severity == HighlightSeverity.ERROR) {
                    yield new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.WRONG_REF.getAttributesKey());
                }
                if (severity == HighlightSeverity.WARNING) {
                    yield new HighlightInfoType.HighlightInfoTypeImpl(severity, CodeInsightColors.WEAK_WARNING_ATTRIBUTES);
                }
                yield severityRegistrar.getHighlightInfoTypeBySeverity(severity);
            }
            case ProblemHighlightType.LIKE_UNUSED_SYMBOL -> new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.UNUSED_SYMBOL.getAttributesKey());
            case ProblemHighlightType.INFO -> HighlightInfoType.INFO;
            case ProblemHighlightType.WEAK_WARNING -> HighlightInfoType.WEAK_WARNING;
            case ProblemHighlightType.WARNING -> HighlightInfoType.WARNING;
            case ProblemHighlightType.ERROR -> HighlightInfoType.WRONG_REF;
            case ProblemHighlightType.GENERIC_ERROR -> HighlightInfoType.ERROR;
            case ProblemHighlightType.INFORMATION -> HighlightInfoType.INFORMATION;
            case ProblemHighlightType.POSSIBLE_PROBLEM -> HighlightInfoType.POSSIBLE_PROBLEM;
        };
        if (highlightInfoType == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(23);
        }
        return highlightInfoType;
    }

    public static ProblemDescriptor @NotNull [] convertToProblemDescriptors(@NotNull List<? extends Annotation> annotations, @NotNull PsiFile file2) {
        if (annotations == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(24);
        }
        if (file2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(25);
        }
        if (annotations.isEmpty()) {
            if (ProblemDescriptor.EMPTY_ARRAY == null) {
                ProblemDescriptorUtil.$$$reportNull$$$0(26);
            }
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>(annotations.size());
        IdentityHashMap<IntentionAction, LocalQuickFix> quickFixMappingCache = new IdentityHashMap<IntentionAction, LocalQuickFix>();
        for (Annotation annotation : annotations) {
            LocalQuickFix[] quickFixes;
            boolean isAfterEndOfLine;
            String message;
            int endOffset;
            int startOffset;
            HighlightSeverity severity = annotation.getSeverity();
            ProblemDescriptor descriptor2 = ProblemDescriptorUtil.convertToDescriptor(file2, severity, startOffset = annotation.getStartOffset(), endOffset = annotation.getEndOffset(), message = annotation.getMessage(), isAfterEndOfLine = annotation.isAfterEndOfLine(), quickFixes = ProblemDescriptorUtil.toLocalQuickFixes(annotation.getQuickFixes(), quickFixMappingCache));
            if (descriptor2 == null) continue;
            problems.add(descriptor2);
        }
        ProblemDescriptor[] problemDescriptorArray = problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
        if (problemDescriptorArray == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(27);
        }
        return problemDescriptorArray;
    }

    private static ProblemDescriptor convertToDescriptor(@NotNull PsiFile file2, @NotNull HighlightSeverity severity, int startOffset, int endOffset, @NotNull @InspectionMessage String message, boolean isAfterEndOfLine, LocalQuickFix @NotNull [] quickFixes) {
        PsiElement startElement;
        PsiElement endElement;
        if (file2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(28);
        }
        if (severity == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(29);
        }
        if (message == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(30);
        }
        if (quickFixes == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(31);
        }
        if (severity == HighlightSeverity.INFORMATION || startOffset == endOffset && !isAfterEndOfLine) {
            return null;
        }
        if (startOffset == endOffset) {
            startElement = endElement = file2.findElementAt(endOffset - 1);
        } else {
            startElement = file2.findElementAt(startOffset);
            endElement = file2.findElementAt(endOffset - 1);
        }
        if (startElement == null || endElement == null) {
            return null;
        }
        TextRange rangeInElement = ProblemDescriptorUtil.getRangeInElement(startElement, startOffset, endElement, endOffset);
        ProblemHighlightType highlightType = HighlightInfo.convertSeverityToProblemHighlight(severity);
        return new ProblemDescriptorBase(startElement, endElement, message, quickFixes, highlightType, isAfterEndOfLine, rangeInElement, true, false);
    }

    @Nullable
    private static TextRange getRangeInElement(@NotNull PsiElement startElement, int startOffset, PsiElement endElement, int endOffset) {
        if (startElement == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(32);
        }
        if (startElement != endElement) {
            return null;
        }
        TextRange elementTextRange = startElement.getTextRange();
        if (elementTextRange.getStartOffset() == startOffset && elementTextRange.getEndOffset() == endOffset) {
            return null;
        }
        return new TextRange(startOffset - elementTextRange.getStartOffset(), endOffset - elementTextRange.getStartOffset());
    }

    private static LocalQuickFix @NotNull [] toLocalQuickFixes(@Nullable List<? extends Annotation.QuickFixInfo> fixInfos, @NotNull Map<IntentionAction, LocalQuickFix> quickFixMappingCache) {
        if (quickFixMappingCache == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(33);
        }
        if (fixInfos == null || fixInfos.isEmpty()) {
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                ProblemDescriptorUtil.$$$reportNull$$$0(34);
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        LocalQuickFix[] result2 = new LocalQuickFix[fixInfos.size()];
        int i2 = 0;
        for (Annotation.QuickFixInfo quickFixInfo : fixInfos) {
            LocalQuickFix fix2;
            IntentionAction intentionAction = quickFixInfo.quickFix;
            if (intentionAction instanceof LocalQuickFix) {
                LocalQuickFix fix22 = (LocalQuickFix)((Object)intentionAction);
            } else {
                LocalQuickFix lqf = quickFixMappingCache.get(intentionAction);
                if (lqf == null) {
                    lqf = new ExternalAnnotatorInspectionVisitor.LocalQuickFixBackedByIntentionAction(intentionAction);
                    quickFixMappingCache.put(intentionAction, lqf);
                }
                fix2 = lqf;
            }
            result2[i2++] = fix2;
        }
        if (result2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(35);
        }
        return result2;
    }

    public static ProblemDescriptor toProblemDescriptor(@NotNull PsiFile file2, @NotNull HighlightInfo info2) {
        if (file2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(36);
        }
        if (info2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(37);
        }
        ArrayList quickFixes = new ArrayList();
        info2.findRegisteredQuickFix((descriptor2, range) -> {
            LocalQuickFix fix2;
            IntentionAction intention = descriptor2.getAction();
            LocalQuickFix localQuickFix = intention instanceof LocalQuickFix ? (LocalQuickFix)((Object)intention) : (fix2 = intention instanceof LocalQuickFixAsIntentionAdapter ? ((LocalQuickFixAsIntentionAdapter)intention).getFix() : null);
            if (fix2 != null) {
                quickFixes.add(fix2);
            }
            return null;
        });
        return ProblemDescriptorUtil.convertToDescriptor(file2, info2.getSeverity(), info2.getStartOffset(), info2.getEndOffset(), info2.getDescription(), info2.isAfterEndOfLine(), quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 9, 11, 13, 15, 23, 26, 27, 34, 35 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 23: 
            case 26: 
            case 27: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ProblemDescriptorUtil";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptor";
                break;
            }
            case 18: 
            case 21: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severityRegistrar";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightType";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 25: 
            case 28: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixes";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixMappingCache";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ProblemDescriptorUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "sanitizeIllegalXmlChars";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "extractHighlightedText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "renderDescriptionMessage";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "removeLocReference";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeTags";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeXmlCode";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightInfoType";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToProblemDescriptors";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "toLocalQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractHighlightedText";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "sanitizeIllegalXmlChars";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 23: 
            case 26: 
            case 27: 
            case 34: 
            case 35: {
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "renderDescriptionMessage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "renderDescriptor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeLocReference";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "unescapeTags";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "unescapeXmlCode";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "highlightTypeFromDescriptor";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightInfoType";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "convertToProblemDescriptors";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "convertToDescriptor";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getRangeInElement";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "toLocalQuickFixes";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "toProblemDescriptor";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 4, 9, 11, 13, 15, 23, 26, 27, 34, 35 -> new IllegalStateException(string2);
        };
    }

    public static interface ProblemPresentation {
        @NotNull
        @InspectionMessage
        public String getDescription();

        @NotNull
        @NlsContexts.Tooltip
        public String getTooltip();
    }

    static @interface FlagConstant {
    }
}

