/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.fileTypes.impl.FileTypeSelectable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReassignedToPlainTextInspection
extends LocalInspectionTool {
    @Override
    @NonNls
    @NotNull
    public String getShortName() {
        return "ReassignedToPlainText";
    }

    @Override
    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file2 == null) {
            ReassignedToPlainTextInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            ReassignedToPlainTextInspection.$$$reportNull$$$0(1);
        }
        if (InjectedLanguageManager.getInstance(file2.getProject()).isInjectedFragment(file2)) {
            return null;
        }
        if (!file2.isPhysical()) {
            return null;
        }
        FileViewProvider viewProvider = file2.getViewProvider();
        if (viewProvider.getBaseLanguage() != file2.getLanguage()) {
            return null;
        }
        VirtualFile virtualFile2 = file2.getVirtualFile();
        if (virtualFile2 == null) {
            return null;
        }
        FileType fileType = virtualFile2.getFileType();
        if (fileType != PlainTextFileType.INSTANCE) {
            return null;
        }
        if (PlainTextFileType.INSTANCE.getDefaultExtension().equals(virtualFile2.getExtension())) {
            return null;
        }
        FileType assigned = FileTypeManager.getInstance().getFileTypeByFileName(virtualFile2.getNameSequence());
        if (assigned != PlainTextFileType.INSTANCE) {
            return null;
        }
        LocalQuickFix removeFix = new LocalQuickFix(){

            @Override
            @Nls
            @NotNull
            public String getFamilyName() {
                String string2 = InspectionsBundle.message("reassigned.to.plain.text.inspection.fix.remove.name", new Object[0]);
                if (string2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string2;
            }

            @Override
            public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
                if (project2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (descriptor2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                ((FileTypeManagerImpl)FileTypeManager.getInstance()).removePlainTextAssociationsForFile((CharSequence)descriptor2.getPsiElement().getContainingFile().getName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/ReassignedToPlainTextInspection$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/ReassignedToPlainTextInspection$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string2);
                    case 1, 2 -> new IllegalArgumentException(string2);
                };
            }
        };
        LocalQuickFix editFix = new LocalQuickFix(){

            @Override
            @Nls
            @NotNull
            public String getFamilyName() {
                String string2 = InspectionsBundle.message("reassigned.to.plain.text.inspection.fix.edit.name", new Object[0]);
                if (string2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string2;
            }

            @Override
            public boolean startInWriteAction() {
                return false;
            }

            @Override
            public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
                if (project2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (descriptor2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                ReassignedToPlainTextInspection.editFileType(project2, PlainTextFileType.INSTANCE);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/ReassignedToPlainTextInspection$2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/ReassignedToPlainTextInspection$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string2);
                    case 1, 2 -> new IllegalArgumentException(string2);
                };
            }
        };
        ProblemDescriptor descriptor2 = manager.createProblemDescriptor((PsiElement)file2, InspectionsBundle.message("reassigned.to.plain.text.inspection.message", new Object[0]), new LocalQuickFix[]{removeFix, editFix}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, true, false);
        return new ProblemDescriptor[]{descriptor2};
    }

    private static void editFileType(@Nullable Project project2, @NotNull FileType fileType) {
        if (fileType == null) {
            ReassignedToPlainTextInspection.$$$reportNull$$$0(2);
        }
        ShowSettingsUtil.getInstance().showSettingsDialog(project2, configurable2 -> configurable2 instanceof SearchableConfigurable && ((SearchableConfigurable)configurable2).getId().equals("preferences.fileTypes"), configurable2 -> {
            if (configurable2 instanceof ConfigurableWrapper) {
                configurable2 = (Configurable)((ConfigurableWrapper)configurable2).getConfigurable();
            }
            FileTypeSelectable fileTypeSelectable = (FileTypeSelectable)configurable2;
            fileTypeSelectable.selectFileType(fileType);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/ReassignedToPlainTextInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "editFileType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

