/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModelKt;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.options.OptCheckbox;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ObjectUtils;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetInspectionOptionFix
extends IntentionAndQuickFixAction
implements LowPriorityAction,
Iconable {
    private final String myShortName;
    private final String myProperty;
    @IntentionName
    private final String myMessage;
    private final boolean myValue;
    @Nullable
    private final Function<? super InspectionProfileEntry, ? extends InspectionProfileEntry> myExtractor;

    public SetInspectionOptionFix(LocalInspectionTool inspection, @NonNls String property, @IntentionName String message, boolean value) {
        this(inspection.getShortName(), property, message, value, null);
    }

    private SetInspectionOptionFix(@NotNull String shortName, @NonNls String property, @IntentionName String message, boolean value, @Nullable Function<? super InspectionProfileEntry, ? extends InspectionProfileEntry> extractor) {
        if (shortName == null) {
            SetInspectionOptionFix.$$$reportNull$$$0(0);
        }
        this.myShortName = shortName;
        this.myProperty = property;
        this.myMessage = message;
        this.myValue = value;
        this.myExtractor = extractor;
    }

    @NotNull
    public static SetInspectionOptionFix createFix(@NotNull String shortName, @NonNls String property, @IntentionName String message, boolean value, @NotNull Function<? super InspectionProfileEntry, ? extends InspectionProfileEntry> extractor) {
        if (shortName == null) {
            SetInspectionOptionFix.$$$reportNull$$$0(1);
        }
        if (extractor == null) {
            SetInspectionOptionFix.$$$reportNull$$$0(2);
        }
        return new SetInspectionOptionFix(shortName, property, message, value, extractor);
    }

    @Override
    @NotNull
    public String getName() {
        String string2 = this.myMessage;
        if (string2 == null) {
            SetInspectionOptionFix.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string2 = AnalysisBundle.message("set.inspection.option.fix", new Object[0]);
        if (string2 == null) {
            SetInspectionOptionFix.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public boolean availableInBatchMode() {
        return false;
    }

    @Override
    public void applyFix(final @NotNull Project project2, PsiFile file2, @Nullable Editor editor2) {
        if (project2 == null) {
            SetInspectionOptionFix.$$$reportNull$$$0(5);
        }
        final VirtualFile vFile = file2.getVirtualFile();
        this.setOption(project2, vFile, this.myValue);
        UndoManager.getInstance(project2).undoableActionPerformed(new BasicUndoableAction(new VirtualFile[]{vFile}){

            @Override
            public void undo() {
                SetInspectionOptionFix.this.setOption(project2, vFile, !SetInspectionOptionFix.this.myValue);
            }

            @Override
            public void redo() {
                SetInspectionOptionFix.this.setOption(project2, vFile, SetInspectionOptionFix.this.myValue);
            }
        });
    }

    @Override
    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        InspectionToolWrapper<?, ?> tool;
        if (project2 == null) {
            SetInspectionOptionFix.$$$reportNull$$$0(6);
        }
        if (editor2 == null) {
            SetInspectionOptionFix.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            SetInspectionOptionFix.$$$reportNull$$$0(8);
        }
        if ((tool = InspectionProfileManager.getInstance(project2).getCurrentProfile().getInspectionTool(this.myShortName, file2)) == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                SetInspectionOptionFix.$$$reportNull$$$0(9);
            }
            return intentionPreviewInfo;
        }
        Object inspection = this.myExtractor == null ? tool.getTool() : this.myExtractor.apply((InspectionProfileEntry)tool.getTool());
        OptPane pane = ((InspectionProfileEntry)inspection).getOptionsPane();
        OptCheckbox control = ObjectUtils.tryCast(pane.findControl(this.myProperty), OptCheckbox.class);
        if (control == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                SetInspectionOptionFix.$$$reportNull$$$0(10);
            }
            return intentionPreviewInfo;
        }
        HtmlChunk label2 = HtmlChunk.text(control.label().label());
        HtmlChunk.Element checkbox = HtmlChunk.tag("input").attr("type", "checkbox").attr("readonly", "true");
        if (this.myValue) {
            checkbox = checkbox.attr("checked", "true");
        }
        HtmlChunk.Element info2 = HtmlChunk.tag("table").child(HtmlChunk.tag("tr").children(HtmlChunk.tag("td").child(checkbox), HtmlChunk.tag("td").child(label2)));
        return new IntentionPreviewInfo.Html(new HtmlBuilder().append(this.myValue ? AnalysisBundle.message("set.inspection.option.description.check", new Object[0]) : AnalysisBundle.message("set.inspection.option.description.uncheck", new Object[0])).br().br().append(info2).toFragment());
    }

    private void setOption(@NotNull Project project2, @NotNull VirtualFile vFile, boolean value) {
        PsiFile file2;
        if (project2 == null) {
            SetInspectionOptionFix.$$$reportNull$$$0(11);
        }
        if (vFile == null) {
            SetInspectionOptionFix.$$$reportNull$$$0(12);
        }
        if ((file2 = PsiManager.getInstance(project2).findFile(vFile)) == null) {
            return;
        }
        InspectionProfileModifiableModelKt.modifyAndCommitProjectProfile(project2, model2 -> {
            InspectionToolWrapper<?, ?> tool = model2.getInspectionTool(this.myShortName, file2);
            if (tool == null) {
                return;
            }
            Object inspection = tool.getTool();
            if (this.myExtractor != null) {
                inspection = this.myExtractor.apply((InspectionProfileEntry)inspection);
            }
            ((InspectionProfileEntry)inspection).getOptionController().setOption(this.myProperty, value);
        });
    }

    @Override
    public Icon getIcon(int flags) {
        return AllIcons.Actions.Cancel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractor";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/SetInspectionOptionFix";
                break;
            }
            case 5: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/SetInspectionOptionFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createFix";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setOption";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 4, 9, 10 -> new IllegalStateException(string2);
        };
    }
}

