/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.ide.todo.TodoIndexPatternProvider;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.psi.search.searches.IndexPatternSearch;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TodoCommentInspection
extends LocalInspectionTool {
    public boolean onlyWarnOnEmpty = true;

    @Override
    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane(OptPane.checkbox("onlyWarnOnEmpty", LangBundle.message("todo.comment.only.warn.on.empty.option", new Object[0]), new OptRegularComponent[0]));
        if (optPane == null) {
            TodoCommentInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @Override
    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        List<TextRange> ranges2;
        if (file2 == null) {
            TodoCommentInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            TodoCommentInspection.$$$reportNull$$$0(2);
        }
        if ((ranges2 = this.getTodoRanges(file2)).isEmpty()) {
            return null;
        }
        SmartList<ProblemDescriptor> result2 = new SmartList<ProblemDescriptor>();
        int lastEndOffset = -1;
        for (TextRange todoRange : ranges2) {
            PsiElement element;
            int todoStart = todoRange.getStartOffset();
            int todoEnd = todoRange.getEndOffset();
            if (todoStart < lastEndOffset) continue;
            for (element = file2.findElementAt(todoStart); element != null && element.getTextRange().getEndOffset() < todoEnd; element = element.getParent()) {
            }
            if (element == null) continue;
            int elementStart = element.getTextRange().getStartOffset();
            TextRange range = new TextRange(todoStart - elementStart, todoEnd - elementStart);
            String message = this.onlyWarnOnEmpty ? LangBundle.message("todo.comment.without.details.problem.descriptor", new Object[0]) : LangBundle.message("todo.comment.problem.descriptor", new Object[0]);
            result2.add(manager.createProblemDescriptor(element, range, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[0]));
            lastEndOffset = todoEnd;
        }
        return result2.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private List<TextRange> getTodoRanges(@NotNull PsiFile file2) {
        if (file2 == null) {
            TodoCommentInspection.$$$reportNull$$$0(3);
        }
        SmartList excludedWords = new SmartList();
        StringBuilder fileText = new StringBuilder();
        TodoIndexPatternProvider todoIndexPatternProvider = TodoIndexPatternProvider.getInstance();
        Collection occurrences = IndexPatternSearch.search((PsiFile)file2, (IndexPatternProvider)todoIndexPatternProvider, (boolean)TodoConfiguration.getInstance().isMultiLine()).findAll();
        return occurrences.stream().map(occurrence -> {
            TextRange mainRange = occurrence.getTextRange();
            List additionalRanges = occurrence.getAdditionalTextRanges();
            return additionalRanges.isEmpty() ? mainRange : new TextRange(mainRange.getStartOffset(), ((TextRange)additionalRanges.get(additionalRanges.size() - 1)).getEndOffset());
        }).filter(range -> {
            if (!this.onlyWarnOnEmpty) {
                return true;
            }
            if (excludedWords.isEmpty()) {
                for (IndexPattern pattern : todoIndexPatternProvider.getIndexPatterns()) {
                    excludedWords.addAll(pattern.getWordsToFindFirst());
                }
            }
            if (fileText.isEmpty()) {
                fileText.append(file2.getText());
            }
            CharSequence text2 = range.subSequence(fileText);
            block1: for (String word2 : StringUtil.getWordsIn(text2.toString())) {
                for (String excludedWord : excludedWords) {
                    if (!word2.equalsIgnoreCase(excludedWord)) continue;
                    continue block1;
                }
                return false;
            }
            return true;
        }).sorted(Comparator.comparingInt(TextRange::getStartOffset)).collect(Collectors.toList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/TodoCommentInspection";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/TodoCommentInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTodoRanges";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3 -> new IllegalArgumentException(string2);
        };
    }
}

