/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.InspectionEngine;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.actions.AbstractPerformFixesTask;
import com.intellij.codeInspection.actions.CleanupInspectionUtil;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CleanupInspectionIntention
implements IntentionAction,
HighPriorityAction {
    @NotNull
    private final InspectionToolWrapper<?, ?> myToolWrapper;
    private final FileModifier myQuickfix;
    @Nullable
    private final PsiFile myFile;
    private final String myText;

    public CleanupInspectionIntention(@NotNull InspectionToolWrapper<?, ?> toolWrapper, @NotNull FileModifier quickFix, @Nullable PsiFile file2, String text2) {
        if (toolWrapper == null) {
            CleanupInspectionIntention.$$$reportNull$$$0(0);
        }
        if (quickFix == null) {
            CleanupInspectionIntention.$$$reportNull$$$0(1);
        }
        this.myToolWrapper = toolWrapper;
        this.myQuickfix = quickFix;
        this.myFile = file2;
        this.myText = text2;
    }

    @Override
    @NotNull
    public String getText() {
        String string2 = InspectionsBundle.message("fix.all.inspection.problems.in.file", this.myToolWrapper.getDisplayName());
        if (string2 == null) {
            CleanupInspectionIntention.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string2 = this.getText();
        if (string2 == null) {
            CleanupInspectionIntention.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @Override
    public void invoke(@NotNull Project project2, Editor editor2, PsiFile file2) throws IncorrectOperationException {
        List descriptions;
        if (project2 == null) {
            CleanupInspectionIntention.$$$reportNull$$$0(4);
        }
        assert (!ApplicationManager.getApplication().isWriteAccessAllowed()) : "do not run under write action";
        PsiFile targetFile = this.myFile == null ? file2 : this.myFile;
        try {
            descriptions = (List)ReadAction.nonBlocking(() -> ProgressManager.getInstance().runProcess(() -> {
                InspectionManager inspectionManager = InspectionManager.getInstance(project2);
                return InspectionEngine.runInspectionOnFile(targetFile, this.myToolWrapper, inspectionManager.createNewGlobalContext());
            }, (ProgressIndicator)new DaemonProgressIndicator())).submit(AppExecutorUtil.getAppExecutorService()).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        if (descriptions.isEmpty() || !FileModificationService.getInstance().preparePsiElementForWrite(targetFile)) {
            return;
        }
        AbstractPerformFixesTask fixesTask = CleanupInspectionUtil.getInstance().applyFixes(project2, LangBundle.message("apply.fixes", new Object[0]), descriptions, this.myQuickfix.getClass(), this.myQuickfix.startInWriteAction());
        if (!fixesTask.isApplicableFixFound()) {
            HintManager.getInstance().showErrorHint(editor2, LangBundle.message("hint.text.unfortunately.currently.available.for.batch.mode", this.myText));
        }
    }

    @Override
    public boolean isAvailable(@NotNull Project project2, Editor editor2, PsiFile file2) {
        if (project2 == null) {
            CleanupInspectionIntention.$$$reportNull$$$0(5);
        }
        return !(this.myQuickfix.getClass() == EmptyIntentionAction.class || !this.myQuickfix.startInWriteAction() && !(this.myQuickfix instanceof BatchQuickFix) || editor2 == null || this.myToolWrapper instanceof LocalInspectionToolWrapper && ((LocalInspectionToolWrapper)this.myToolWrapper).isUnfair());
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFix";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/actions/CleanupInspectionIntention";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/actions/CleanupInspectionIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3 -> new IllegalStateException(string2);
        };
    }
}

