/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.BaseAnalysisAction;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.application.options.schemes.SchemesCombo;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.actions.CodeInspectionAdditionalUi;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.InjectableLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.profile.codeInspection.ui.ErrorsConfigurable;
import com.intellij.profile.codeInspection.ui.header.InspectionProfileSchemesModel;
import com.intellij.profile.codeInspection.ui.header.InspectionToolsConfigurable;
import com.intellij.util.containers.ContainerUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CodeInspectionAction
extends BaseAnalysisAction {
    private static final Logger LOG = Logger.getInstance(CodeInspectionAction.class);
    private static final String LAST_SELECTED_PROFILE_PROP = "run.code.analysis.last.selected.profile";
    private int myRunId;
    private GlobalInspectionContextImpl myGlobalInspectionContext;
    protected InspectionProfileImpl myExternalProfile;

    public CodeInspectionAction() {
        super(InspectionsBundle.messagePointer("inspection.action.title", new Object[0]), InspectionsBundle.messagePointer("inspection.action.noun", new Object[0]));
    }

    public CodeInspectionAction(@NlsContexts.DialogTitle String title, @Nls String analysisNoon) {
        super(title, analysisNoon);
    }

    @Override
    protected void analyze(@NotNull Project project2, @NotNull AnalysisScope scope) {
        if (project2 == null) {
            CodeInspectionAction.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            CodeInspectionAction.$$$reportNull$$$0(1);
        }
        try {
            this.runInspections(project2, scope);
        }
        finally {
            this.myGlobalInspectionContext = null;
            this.myExternalProfile = null;
        }
    }

    protected void runInspections(@NotNull Project project2, @NotNull AnalysisScope scope) {
        if (project2 == null) {
            CodeInspectionAction.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            CodeInspectionAction.$$$reportNull$$$0(3);
        }
        int runId = ++this.myRunId;
        scope.setSearchInLibraries(false);
        FileDocumentManager.getInstance().saveAllDocuments();
        InspectionProfileImpl externalProfile = this.myExternalProfile;
        GlobalInspectionContextImpl inspectionContext = this.getGlobalInspectionContext(project2);
        inspectionContext.setRerunAction(() -> DumbService.getInstance(project2).smartInvokeLater(() -> {
            if (runId != this.myRunId) {
                return;
            }
            if (project2.isDisposed()) {
                return;
            }
            if (!scope.isValid()) {
                return;
            }
            this.myExternalProfile = externalProfile;
            this.myGlobalInspectionContext = inspectionContext;
            FileDocumentManager.getInstance().saveAllDocuments();
            this.analyze(project2, scope);
        }));
        inspectionContext.setExternalProfile(externalProfile);
        inspectionContext.setCurrentScope(scope);
        inspectionContext.doInspections(scope);
    }

    private GlobalInspectionContextImpl getGlobalInspectionContext(Project project2) {
        if (this.myGlobalInspectionContext == null) {
            this.myGlobalInspectionContext = ((InspectionManagerEx)InspectionManager.getInstance(project2)).createNewGlobalContext();
        }
        return this.myGlobalInspectionContext;
    }

    @Override
    @NonNls
    protected String getHelpTopic() {
        return "reference.dialogs.inspection.scope";
    }

    @Override
    protected void canceled() {
        super.canceled();
        this.myGlobalInspectionContext = null;
    }

    @Override
    protected JComponent getAdditionalActionSettings(@NotNull Project project2, @NotNull BaseAnalysisActionDialog dialog) {
        if (project2 == null) {
            CodeInspectionAction.$$$reportNull$$$0(4);
        }
        if (dialog == null) {
            CodeInspectionAction.$$$reportNull$$$0(5);
        }
        dialog.setShowInspectInjectedCode(true);
        CodeInspectionAdditionalUi ui = new CodeInspectionAdditionalUi();
        InspectionManagerEx manager = (InspectionManagerEx)InspectionManager.getInstance(project2);
        SchemesCombo<InspectionProfileImpl> profiles = ui.getBrowseProfilesCombo();
        InspectionProfileManager profileManager = InspectionProfileManager.getInstance();
        ProjectInspectionProfileManager projectProfileManager = ProjectInspectionProfileManager.getInstance(project2);
        ui.getLink().addActionListener(__ -> {
            ExternalProfilesComboboxAwareInspectionToolsConfigurable errorConfigurable = this.createConfigurable(projectProfileManager, profiles);
            MySingleConfigurableEditor editor2 = new MySingleConfigurableEditor(project2, errorConfigurable, manager);
            if (editor2.showAndGet()) {
                this.reloadProfiles(profiles, profileManager, projectProfileManager, project2);
                if (errorConfigurable.mySelectedName != null) {
                    InspectionProfileImpl profile = (errorConfigurable.mySelectedIsProjectProfile ? projectProfileManager : profileManager).getProfile(errorConfigurable.mySelectedName);
                    profiles.selectScheme((Scheme)profile);
                }
            } else {
                InspectionProfile profile = (InspectionProfile)((Object)profiles.getSelectedScheme());
                boolean canExecute = profile != null && profile.isExecutable(project2);
                dialog.setOKActionEnabled(canExecute);
            }
        });
        profiles.addActionListener(__ -> {
            this.myExternalProfile = (InspectionProfileImpl)profiles.getSelectedScheme();
            boolean canExecute = this.myExternalProfile != null && this.myExternalProfile.isExecutable(project2);
            dialog.setOKActionEnabled(canExecute);
            if (canExecute) {
                PropertiesComponent.getInstance(project2).setValue(LAST_SELECTED_PROFILE_PROP, (this.myExternalProfile.isProjectLevel() ? (char)'p' : (char)'a') + this.myExternalProfile.getName());
                manager.setProfile(this.myExternalProfile.getName());
            }
        });
        this.reloadProfiles(profiles, profileManager, projectProfileManager, project2);
        if (this.hasEnabledInspectionsOnInjectableCode(project2)) {
            dialog.setAnalyzeInjectedCode(false);
        }
        return ui.getPanel();
    }

    private boolean hasEnabledInspectionsOnInjectableCode(Project project2) {
        if (this.myExternalProfile != null) {
            return ContainerUtil.exists(this.myExternalProfile.getAllEnabledInspectionTools(project2), tool -> Language.findLanguageByID(tool.getTool().getLanguage()) instanceof InjectableLanguage);
        }
        return false;
    }

    protected ExternalProfilesComboboxAwareInspectionToolsConfigurable createConfigurable(ProjectInspectionProfileManager projectProfileManager, SchemesCombo<InspectionProfileImpl> profilesCombo) {
        return new ExternalProfilesComboboxAwareInspectionToolsConfigurable(projectProfileManager, profilesCombo);
    }

    private void reloadProfiles(@NotNull SchemesCombo<InspectionProfileImpl> profilesCombo, InspectionProfileManager appProfileManager, InspectionProjectProfileManager projectProfileManager, Project project2) {
        if (profilesCombo == null) {
            CodeInspectionAction.$$$reportNull$$$0(6);
        }
        profilesCombo.resetSchemes(InspectionProfileSchemesModel.getSortedProfiles(appProfileManager, projectProfileManager));
        InspectionProfileImpl selectedProfile = this.getProfileToUse(project2, appProfileManager, projectProfileManager);
        profilesCombo.selectScheme((Scheme)selectedProfile);
    }

    @NotNull
    private InspectionProfileImpl getProfileToUse(@NotNull Project project2, @NotNull InspectionProfileManager appProfileManager, @NotNull InspectionProjectProfileManager projectProfileManager) {
        String lastSelectedProfile;
        if (project2 == null) {
            CodeInspectionAction.$$$reportNull$$$0(7);
        }
        if (appProfileManager == null) {
            CodeInspectionAction.$$$reportNull$$$0(8);
        }
        if (projectProfileManager == null) {
            CodeInspectionAction.$$$reportNull$$$0(9);
        }
        if ((lastSelectedProfile = PropertiesComponent.getInstance(project2).getValue(LAST_SELECTED_PROFILE_PROP)) != null) {
            char type = lastSelectedProfile.charAt(0);
            String lastSelectedProfileName = lastSelectedProfile.substring(1);
            if (type == 'a') {
                InspectionProfileImpl profile = appProfileManager.getProfile(lastSelectedProfileName, false);
                if (profile != null) {
                    InspectionProfileImpl inspectionProfileImpl = profile;
                    if (inspectionProfileImpl == null) {
                        CodeInspectionAction.$$$reportNull$$$0(10);
                    }
                    return inspectionProfileImpl;
                }
            } else {
                LOG.assertTrue(type == 'p', "Unexpected last selected profile: '" + lastSelectedProfile + "'");
                InspectionProfileImpl profile = projectProfileManager.getProfile(lastSelectedProfileName, false);
                if (profile != null && profile.isProjectLevel()) {
                    InspectionProfileImpl inspectionProfileImpl = profile;
                    if (inspectionProfileImpl == null) {
                        CodeInspectionAction.$$$reportNull$$$0(11);
                    }
                    return inspectionProfileImpl;
                }
            }
        }
        InspectionProfileImpl inspectionProfileImpl = this.getGlobalInspectionContext(project2).getCurrentProfile();
        if (inspectionProfileImpl == null) {
            CodeInspectionAction.$$$reportNull$$$0(12);
        }
        return inspectionProfileImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialog";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilesCombo";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appProfileManager";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectProfileManager";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/actions/CodeInspectionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/actions/CodeInspectionAction";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfileToUse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "analyze";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runInspections";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalActionSettings";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "reloadProfiles";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getProfileToUse";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 10, 11, 12 -> new IllegalStateException(string2);
        };
    }

    protected static class ExternalProfilesComboboxAwareInspectionToolsConfigurable
    extends InspectionToolsConfigurable {
        private final SchemesCombo<InspectionProfileImpl> myProfilesCombo;
        private String mySelectedName;
        private boolean mySelectedIsProjectProfile;

        public ExternalProfilesComboboxAwareInspectionToolsConfigurable(@NotNull ProjectInspectionProfileManager projectProfileManager, SchemesCombo<InspectionProfileImpl> profilesCombo) {
            if (projectProfileManager == null) {
                ExternalProfilesComboboxAwareInspectionToolsConfigurable.$$$reportNull$$$0(0);
            }
            super(projectProfileManager);
            this.myProfilesCombo = profilesCombo;
        }

        @Override
        protected InspectionProfileImpl getCurrentProfile() {
            return (InspectionProfileImpl)this.myProfilesCombo.getSelectedScheme();
        }

        @Override
        protected void applyRootProfile(@NotNull String name, boolean isProjectLevel) {
            if (name == null) {
                ExternalProfilesComboboxAwareInspectionToolsConfigurable.$$$reportNull$$$0(1);
            }
            this.mySelectedName = name;
            this.mySelectedIsProjectProfile = isProjectLevel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectProfileManager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/actions/CodeInspectionAction$ExternalProfilesComboboxAwareInspectionToolsConfigurable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyRootProfile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MySingleConfigurableEditor
    extends SingleConfigurableEditor {
        private final InspectionManagerEx myManager;

        MySingleConfigurableEditor(Project project2, ErrorsConfigurable configurable2, InspectionManagerEx manager) {
            super(project2, (Configurable)configurable2, MySingleConfigurableEditor.createDimensionKey((Configurable)configurable2));
            this.myManager = manager;
        }

        protected void doOKAction() {
            Object o = ((ErrorsConfigurable)this.getConfigurable()).getSelectedObject();
            if (o instanceof InspectionProfile) {
                this.myManager.setProfile(((InspectionProfile)o).getName());
            }
            super.doOKAction();
        }
    }
}

