/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.codeInspection.actions.InspectionElement;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.text.Matcher;
import com.intellij.util.text.MatcherHolder;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class InspectionListCellRenderer
extends DefaultListCellRenderer {
    private final SimpleTextAttributes mySelected = new SimpleTextAttributes(UIUtil.getListSelectionBackground(true), NamedColorUtil.getListSelectionForeground(true), (Color)JBColor.RED, 0);
    private final SimpleTextAttributes myPlain = new SimpleTextAttributes(UIUtil.getListBackground(), UIUtil.getListForeground(), (Color)JBColor.RED, 0);
    private final SimpleTextAttributes myHighlighted = new SimpleTextAttributes(UIUtil.getListBackground(), UIUtil.getListForeground(), null, 64);

    @Override
    public Component getListCellRendererComponent(JList list2, Object value, int index2, boolean sel, boolean focus) {
        SimpleColoredComponent group2;
        InspectionToolWrapper toolWrapper;
        BorderLayout layout = new BorderLayout();
        layout.setHgap(5);
        JPanel panel2 = new JPanel(layout);
        panel2.setOpaque(true);
        Color bg = sel ? UIUtil.getListSelectionBackground(true) : UIUtil.getListBackground();
        Color fg = sel ? NamedColorUtil.getListSelectionForeground(true) : UIUtil.getListForeground();
        panel2.setBackground(bg);
        panel2.setForeground(fg);
        if (value instanceof InspectionElement) {
            boolean matchHighlighting;
            toolWrapper = ((InspectionElement)value).getToolWrapper();
            String inspectionName = "  " + toolWrapper.getDisplayName();
            String groupName = StringUtil.join(toolWrapper.getGroupPath(), " | ");
            String matchingText = inspectionName + "|" + groupName;
            Matcher matcher = MatcherHolder.getAssociatedMatcher(list2);
            FList fragments = matcher == null ? null : ((MinusculeMatcher)matcher).matchingFragments(matchingText);
            ArrayList<TextRange> adjustedFragments = new ArrayList<TextRange>();
            if (fragments != null) {
                adjustedFragments.addAll(fragments);
            }
            int splitPoint = InspectionListCellRenderer.adjustRanges(adjustedFragments, inspectionName.length() + 1);
            SimpleColoredComponent c2 = new SimpleColoredComponent();
            boolean bl = matchHighlighting = Registry.is("ide.highlight.match.in.selected.only") && !sel;
            if (matchHighlighting) {
                c2.append(inspectionName, this.myPlain);
            } else {
                List ranges2 = adjustedFragments.subList(0, splitPoint);
                SpeedSearchUtil.appendColoredFragments((SimpleColoredComponent)c2, (String)inspectionName, ranges2, (SimpleTextAttributes)(sel ? this.mySelected : this.myPlain), (SimpleTextAttributes)this.myHighlighted);
            }
            panel2.add((Component)c2, "West");
            group2 = new SimpleColoredComponent();
            if (matchHighlighting) {
                group2.append(groupName, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            } else {
                SimpleTextAttributes attributes = sel ? this.mySelected : SimpleTextAttributes.GRAYED_ATTRIBUTES;
                List ranges3 = adjustedFragments.subList(splitPoint, adjustedFragments.size());
                SpeedSearchUtil.appendColoredFragments((SimpleColoredComponent)group2, (String)groupName, ranges3, (SimpleTextAttributes)attributes, (SimpleTextAttributes)this.myHighlighted);
            }
        } else {
            return super.getListCellRendererComponent((JList<?>)list2, value, index2, sel, focus);
        }
        JPanel right = new JPanel(new BorderLayout());
        right.setBackground(bg);
        right.setForeground(fg);
        right.add((Component)group2, "Center");
        JLabel icon2 = new JLabel(InspectionListCellRenderer.getIcon(toolWrapper));
        icon2.setBackground(bg);
        icon2.setForeground(fg);
        right.add((Component)icon2, "East");
        panel2.add((Component)right, "East");
        return panel2;
    }

    private static int adjustRanges(List<TextRange> ranges2, int offset2) {
        int result2 = 0;
        for (int i2 = 0; i2 < ranges2.size(); ++i2) {
            TextRange range = ranges2.get(i2);
            int startOffset = range.getStartOffset();
            if (startOffset < offset2) {
                result2 = i2 + 1;
                continue;
            }
            ranges2.set(i2, new TextRange(startOffset - offset2, range.getEndOffset() - offset2));
        }
        return result2;
    }

    @NotNull
    private static Icon getIcon(@NotNull InspectionToolWrapper tool) {
        LanguageFileType fileType;
        if (tool == null) {
            InspectionListCellRenderer.$$$reportNull$$$0(0);
        }
        Icon icon2 = null;
        Language language = Language.findLanguageByID(tool.getLanguage());
        if (language != null && (fileType = language.getAssociatedFileType()) != null) {
            icon2 = fileType.getIcon();
        }
        if (icon2 == null) {
            icon2 = UnknownFileType.INSTANCE.getIcon();
        }
        assert (icon2 != null);
        Icon icon3 = icon2;
        if (icon3 == null) {
            InspectionListCellRenderer.$$$reportNull$$$0(1);
        }
        return icon3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/actions/InspectionListCellRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/actions/InspectionListCellRenderer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }
}

