/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.CommonBundle;
import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.analysis.dialog.ModelScopeItem;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.actions.FileFilterPanel;
import com.intellij.codeInspection.actions.GotoInspectionModel;
import com.intellij.codeInspection.actions.InspectionElement;
import com.intellij.codeInspection.actions.RunInspectionIntention;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ui.InspectionOptionPaneRenderer;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.util.gotoByName.ChooseByNameFilter;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.lang.InjectableLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ui.InspectionUiUtilKt;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.TitledSeparator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunInspectionAction
extends GotoActionBase
implements DataProvider {
    private static final Logger LOGGER = Logger.getInstance(RunInspectionAction.class);
    private final String myPredefinedText;

    public RunInspectionAction() {
        this(null);
    }

    public RunInspectionAction(String predefinedText) {
        this.myPredefinedText = predefinedText;
        this.getTemplatePresentation().setText(IdeBundle.messagePointer((String)"goto.inspection.action.text", (Object[])new Object[0]));
    }

    @Override
    protected void gotoActionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            RunInspectionAction.$$$reportNull$$$0(0);
        }
        if ((project2 = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        PsiDocumentManager.getInstance(project2).commitAllDocuments();
        final PsiElement psiElement = (PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT);
        final PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        final VirtualFile[] virtualFiles = ObjectUtils.notNull((VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY), VirtualFile.EMPTY_ARRAY);
        GotoInspectionModel model2 = new GotoInspectionModel(project2);
        this.showNavigationPopup(e, model2, new GotoActionBase.GotoActionCallback<Object>(){

            @Override
            protected ChooseByNameFilter<Object> createFilter(@NotNull ChooseByNamePopup popup2) {
                if (popup2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                popup2.setSearchInAnyPlace(true);
                return super.createFilter(popup2);
            }

            @Override
            public void elementChosen(ChooseByNamePopup popup2, Object element) {
                ApplicationManager.getApplication().invokeLater(() -> RunInspectionAction.runInspection(project2, ((InspectionElement)element).getToolWrapper().getShortName(), virtualFiles, psiElement, psiFile));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/codeInspection/actions/RunInspectionAction$1", "createFilter"));
            }
        }, false);
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            RunInspectionAction.$$$reportNull$$$0(1);
        }
        return PlatformDataKeys.PREDEFINED_TEXT.is(dataId) ? this.myPredefinedText : null;
    }

    public static void runInspection(@NotNull Project project2, @NotNull String shortName, @Nullable VirtualFile virtualFile2, @Nullable PsiElement psiElement, @Nullable PsiFile psiFile) {
        VirtualFile[] virtualFileArray;
        if (project2 == null) {
            RunInspectionAction.$$$reportNull$$$0(2);
        }
        if (shortName == null) {
            RunInspectionAction.$$$reportNull$$$0(3);
        }
        if (virtualFile2 == null) {
            virtualFileArray = VirtualFile.EMPTY_ARRAY;
        } else {
            VirtualFile[] virtualFileArray2 = new VirtualFile[1];
            virtualFileArray = virtualFileArray2;
            virtualFileArray2[0] = virtualFile2;
        }
        RunInspectionAction.runInspection(project2, shortName, virtualFileArray, psiElement, psiFile);
    }

    public static void runInspection(final @NotNull Project project2, @NotNull String shortName, @NotNull @NotNull VirtualFile @NotNull [] virtualFiles, @Nullable PsiElement psiElement, @Nullable PsiFile psiFile) {
        if (project2 == null) {
            RunInspectionAction.$$$reportNull$$$0(4);
        }
        if (shortName == null) {
            RunInspectionAction.$$$reportNull$$$0(5);
        }
        if (virtualFiles == null) {
            RunInspectionAction.$$$reportNull$$$0(6);
        }
        PsiElement element = psiFile == null ? psiElement : psiFile;
        InspectionProfileImpl currentProfile = InspectionProjectProfileManager.getInstance(project2).getCurrentProfile();
        final InspectionToolWrapper toolWrapper = element != null ? currentProfile.getInspectionTool(shortName, element) : currentProfile.getInspectionTool(shortName, project2);
        LOGGER.assertTrue(toolWrapper != null, "Missed inspection: " + shortName);
        final InspectionManagerEx managerEx = (InspectionManagerEx)InspectionManager.getInstance(project2);
        Module module2 = RunInspectionAction.findModuleForFiles(project2, virtualFiles);
        AnalysisScope analysisScope = null;
        if (psiFile != null) {
            analysisScope = new AnalysisScope(psiFile);
        } else {
            PsiDirectory psiDirectory;
            if (virtualFiles.length == 1 && virtualFiles[0].isDirectory() && (psiDirectory = PsiManager.getInstance(project2).findDirectory(virtualFiles[0])) != null) {
                analysisScope = new AnalysisScope(psiDirectory);
            }
            if (analysisScope == null && virtualFiles.length != 0) {
                analysisScope = new AnalysisScope(project2, ContainerUtil.newHashSet(virtualFiles));
            }
            if (analysisScope == null) {
                analysisScope = new AnalysisScope(project2);
            }
        }
        AnalysisUIOptions options2 = AnalysisUIOptions.getInstance(project2);
        final FileFilterPanel fileFilterPanel = new FileFilterPanel();
        fileFilterPanel.init(options2);
        final AnalysisScope initialAnalysisScope = analysisScope;
        List<ModelScopeItem> items2 = BaseAnalysisActionDialog.standardItems(project2, analysisScope, module2, psiElement);
        BaseAnalysisActionDialog dialog = new BaseAnalysisActionDialog(IdeBundle.message((String)"goto.inspection.action.dialog.title", (Object[])new Object[]{toolWrapper.getDisplayName()}), CodeInsightBundle.message("analysis.scope.title", InspectionsBundle.message("inspection.action.noun", new Object[0])), project2, items2, options2, true){
            private InspectionToolWrapper<?, ?> myUpdatedSettingsToolWrapper;

            @Override
            @NotNull
            protected JComponent getAdditionalActionSettings(@NotNull Project project22) {
                if (project22 == null) {
                    2.$$$reportNull$$$0(0);
                }
                JPanel panel2 = new JPanel(new GridBagLayout());
                boolean hasOptionsPanel = InspectionOptionPaneRenderer.hasSettings(toolWrapper.getTool());
                GridBag constraints = new GridBag().setDefaultWeightX(1.0).setDefaultWeightY(hasOptionsPanel ? 0.0 : 1.0).setDefaultFill(2);
                panel2.add((Component)fileFilterPanel.getPanel(), constraints.nextLine());
                if (hasOptionsPanel) {
                    this.myUpdatedSettingsToolWrapper = RunInspectionAction.copyToolWithSettings(toolWrapper);
                    JComponent optionsPanel = InspectionOptionPaneRenderer.createOptionsPanel(this.myUpdatedSettingsToolWrapper.getTool(), this.myDisposable, project22);
                    LOGGER.assertTrue(optionsPanel != null);
                    TitledSeparator separator = new TitledSeparator(IdeBundle.message((String)"goto.inspection.action.choose.inherit.settings.from", (Object[])new Object[0]));
                    separator.setBorder((Border)JBUI.Borders.empty());
                    panel2.add((Component)separator, constraints.nextLine().insetTop(20));
                    optionsPanel.setBorder(InspectionUiUtilKt.getBordersForOptions(optionsPanel));
                    JComponent scrollPane = InspectionUiUtilKt.addScrollPaneIfNecessary(optionsPanel);
                    Dimension preferredSize = scrollPane.getPreferredSize();
                    scrollPane.setPreferredSize(new Dimension(preferredSize.width, Math.min(preferredSize.height, 400)));
                    panel2.add((Component)scrollPane, constraints.nextLine());
                }
                JPanel jPanel = panel2;
                if (jPanel == null) {
                    2.$$$reportNull$$$0(1);
                }
                return jPanel;
            }

            @Override
            @NotNull
            public AnalysisScope getScope(@NotNull AnalysisScope defaultScope) {
                if (defaultScope == null) {
                    2.$$$reportNull$$$0(2);
                }
                AnalysisScope scope = super.getScope(defaultScope);
                GlobalSearchScope filterScope = fileFilterPanel.getSearchScope();
                if (filterScope == null) {
                    AnalysisScope analysisScope = scope;
                    if (analysisScope == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    return analysisScope;
                }
                scope.setFilter(filterScope);
                AnalysisScope analysisScope = scope;
                if (analysisScope == null) {
                    2.$$$reportNull$$$0(4);
                }
                return analysisScope;
            }

            private AnalysisScope getScope() {
                return this.getScope(initialAnalysisScope);
            }

            private InspectionToolWrapper<?, ?> getToolWrapper() {
                return this.myUpdatedSettingsToolWrapper == null ? toolWrapper : this.myUpdatedSettingsToolWrapper;
            }

            protected Action @NotNull [] createActions() {
                ArrayList<Action> actions = new ArrayList<Action>();
                boolean hasFixAll = toolWrapper.getTool() instanceof CleanupLocalInspectionTool;
                actions.add(new AbstractAction(hasFixAll ? CodeInsightBundle.message("action.analyze.verb", new Object[0]) : CommonBundle.getOkButtonText()){
                    {
                        super(arg0);
                        this.putValue("DefaultAction", Boolean.TRUE);
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AnalysisScope scope = this.getScope();
                        InspectionToolWrapper<?, ?> wrapper2 = this.getToolWrapper();
                        DumbService.getInstance(project2).smartInvokeLater(() -> RunInspectionIntention.rerunInspection(wrapper2, managerEx, scope, null));
                        this.close(0);
                    }
                });
                if (hasFixAll) {
                    actions.add(new AbstractAction(IdeBundle.message((String)"goto.inspection.action.fix.all", (Object[])new Object[0])){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            InspectionToolWrapper<?, ?> wrapper2 = this.getToolWrapper();
                            InspectionProfileImpl cleanupToolProfile = RunInspectionIntention.createProfile(wrapper2, managerEx, null);
                            managerEx.createNewGlobalContext().codeCleanup(this.getScope(), cleanupToolProfile, "Cleanup by " + wrapper2.getDisplayName(), null, false);
                            this.close(0);
                        }
                    });
                }
                actions.add(this.getCancelAction());
                if (SystemInfo.isMac) {
                    Collections.reverse(actions);
                }
                Action[] actionArray = actions.toArray(new Action[0]);
                if (actionArray == null) {
                    2.$$$reportNull$$$0(5);
                }
                return actionArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 3, 4, 5 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/actions/RunInspectionAction$2";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "defaultScope";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/actions/RunInspectionAction$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAdditionalActionSettings";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getScope";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createActions";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getAdditionalActionSettings";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getScope";
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string2);
                    case 1, 3, 4, 5 -> new IllegalStateException(string2);
                };
            }
        };
        dialog.setShowInspectInjectedCode(!(Language.findLanguageByID(toolWrapper.getLanguage()) instanceof InjectableLanguage));
        dialog.showAndGet();
    }

    @Nullable
    private static Module findModuleForFiles(@NotNull Project project2, VirtualFile @NotNull [] files2) {
        if (project2 == null) {
            RunInspectionAction.$$$reportNull$$$0(7);
        }
        if (files2 == null) {
            RunInspectionAction.$$$reportNull$$$0(8);
        }
        Set<Module> modules2 = ContainerUtil.map2Set(files2, f -> ModuleUtilCore.findModuleForFile(f, project2));
        return ContainerUtil.getFirstItem(modules2);
    }

    private static InspectionToolWrapper<?, ?> copyToolWithSettings(@NotNull InspectionToolWrapper tool) {
        if (tool == null) {
            RunInspectionAction.$$$reportNull$$$0(9);
        }
        Element options2 = new Element("copy");
        ((InspectionProfileEntry)tool.getTool()).writeSettings(options2);
        InspectionToolWrapper copiedTool = tool.createCopy();
        ((InspectionProfileEntry)copiedTool.getTool()).readSettings(options2);
        return copiedTool;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFiles";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/actions/RunInspectionAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "gotoActionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "runInspection";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "findModuleForFiles";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "copyToolWithSettings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

