/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.lang.ir;

import com.intellij.codeInspection.dataFlow.lang.ir.ControlFlow;
import com.intellij.codeInspection.dataFlow.lang.ir.ControlTransferInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.Instruction;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;

public abstract class BaseVariableAnalyzer {
    protected final Instruction[] myInstructions;
    protected final MultiMap<Instruction, Instruction> myForwardMap;
    protected final MultiMap<Instruction, Instruction> myBackwardMap;
    protected final DfaValueFactory myFactory;

    public BaseVariableAnalyzer(ControlFlow flow2) {
        this.myFactory = flow2.getFactory();
        this.myInstructions = flow2.getInstructions();
        this.myForwardMap = this.calcForwardMap();
        this.myBackwardMap = this.calcBackwardMap();
    }

    private List<Instruction> getSuccessors(Instruction ins) {
        return IntStreamEx.of((int[])ins.getSuccessorIndexes()).elements((Object[])this.myInstructions).toList();
    }

    private MultiMap<Instruction, Instruction> calcBackwardMap() {
        MultiMap<Instruction, Instruction> result2 = MultiMap.create();
        for (Instruction instruction : this.myInstructions) {
            for (Instruction next2 : this.myForwardMap.get(instruction)) {
                result2.putValue(next2, instruction);
            }
        }
        return result2;
    }

    private MultiMap<Instruction, Instruction> calcForwardMap() {
        MultiMap<Instruction, Instruction> result2 = MultiMap.create();
        for (Instruction instruction : this.myInstructions) {
            if (!this.isInterestingInstruction(instruction)) continue;
            block1: for (Instruction next2 : this.getSuccessors(instruction)) {
                while (true) {
                    if (this.isInterestingInstruction(next2)) {
                        result2.putValue(instruction, next2);
                        continue block1;
                    }
                    if (next2.getIndex() + 1 >= this.myInstructions.length) continue block1;
                    next2 = this.myInstructions[next2.getIndex() + 1];
                }
            }
        }
        return result2;
    }

    protected abstract boolean isInterestingInstruction(Instruction var1);

    protected boolean runDfa(boolean forward, BiFunction<? super Instruction, ? super BitSet, ? extends BitSet> handleState) {
        List entryPoints = forward ? List.of(this.myInstructions[0]) : (List)((StreamEx)StreamEx.of((Object[])this.myInstructions).select(ControlTransferInstruction.class).filter(cti -> cti.getTransfer().getTarget().getPossibleTargets().length == 0)).collect(Collectors.toList());
        ArrayDeque<InstructionState> queue2 = new ArrayDeque<InstructionState>(10);
        for (Instruction i2 : entryPoints) {
            queue2.addLast(new InstructionState(i2, new BitSet()));
        }
        int limit2 = this.myForwardMap.size() * 100;
        HashMap<BitSet, IntSet> processed2 = new HashMap<BitSet, IntSet>();
        int steps = 0;
        while (!queue2.isEmpty()) {
            if (steps > limit2) {
                return false;
            }
            if (steps % 1024 == 0) {
                ProgressManager.checkCanceled();
            }
            InstructionState state = (InstructionState)queue2.removeFirst();
            Instruction instruction = (Instruction)state.first;
            Collection<Instruction> nextInstructions = forward ? this.myForwardMap.get(instruction) : this.myBackwardMap.get(instruction);
            BitSet nextVars = handleState.apply(instruction, (BitSet)state.second);
            for (Instruction next2 : nextInstructions) {
                int index2;
                IntSet instructionSet = processed2.computeIfAbsent(nextVars, k -> new IntOpenHashSet());
                if (instructionSet.contains(index2 = next2.getIndex() + 1)) continue;
                instructionSet.add(index2);
                queue2.addLast(new InstructionState(next2, nextVars));
                ++steps;
            }
        }
        return true;
    }

    private static class InstructionState
    extends Pair<Instruction, BitSet> {
        InstructionState(Instruction first2, BitSet second2) {
            super(first2, second2);
        }
    }
}

