/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.memory;

import com.intellij.codeInspection.dataFlow.lang.ir.ControlFlow;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.memory.DistinctPairSet;
import com.intellij.codeInspection.dataFlow.memory.EqClass;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeBinOp;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeType;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfEphemeralType;
import com.intellij.codeInspection.dataFlow.types.DfIntegralType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.DerivedVariableDescriptor;
import com.intellij.codeInspection.dataFlow.value.DfaBinOpValue;
import com.intellij.codeInspection.dataFlow.value.DfaCondition;
import com.intellij.codeInspection.dataFlow.value.DfaControlTransferValue;
import com.intellij.codeInspection.dataFlow.value.DfaRelation;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.DfaWrappedValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.Stack;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaMemoryStateImpl
implements DfaMemoryState {
    private static final Logger LOG = Logger.getInstance(DfaMemoryStateImpl.class);
    @NotNull
    private final DfaValueFactory myFactory;
    private final List<EqClass> myEqClasses;
    protected final Int2IntMap myIdToEqClassesIndices;
    protected final Stack<DfaValue> myStack;
    private DistinctPairSet myDistinctClasses;
    private final LinkedHashMap<DfaVariableValue, DfType> myVariableTypes;
    private boolean myEphemeral;
    private LinkedHashSet<EqClass> myCachedNonTrivialEqClasses;
    private Integer myCachedHash;

    public DfaMemoryStateImpl(@NotNull DfaValueFactory factory2) {
        if (factory2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(0);
        }
        this.myFactory = factory2;
        this.myEqClasses = new ArrayList<EqClass>();
        this.myVariableTypes = new LinkedHashMap();
        this.myDistinctClasses = new DistinctPairSet(this);
        this.myStack = new Stack();
        this.myIdToEqClassesIndices = new Int2IntOpenHashMap();
    }

    protected DfaMemoryStateImpl(@NotNull DfaMemoryStateImpl toCopy) {
        if (toCopy == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(1);
        }
        this.myFactory = toCopy.myFactory;
        this.myEphemeral = toCopy.myEphemeral;
        this.myStack = new Stack<DfaValue>((Collection<DfaValue>)toCopy.myStack);
        this.myDistinctClasses = new DistinctPairSet(this, toCopy.myDistinctClasses);
        this.myEqClasses = new ArrayList<EqClass>(toCopy.myEqClasses);
        this.myIdToEqClassesIndices = new Int2IntOpenHashMap(toCopy.myIdToEqClassesIndices);
        this.myVariableTypes = new LinkedHashMap<DfaVariableValue, DfType>(toCopy.myVariableTypes);
        this.myCachedNonTrivialEqClasses = toCopy.myCachedNonTrivialEqClasses;
        this.myCachedHash = toCopy.myCachedHash;
    }

    @NotNull
    public DfaValueFactory getFactory() {
        DfaValueFactory dfaValueFactory = this.myFactory;
        if (dfaValueFactory == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(2);
        }
        return dfaValueFactory;
    }

    @Override
    @NotNull
    public DfaMemoryStateImpl createCopy() {
        return new DfaMemoryStateImpl(this);
    }

    @Override
    @NotNull
    public DfaMemoryStateImpl createClosureState() {
        DfaMemoryStateImpl copy2 = this.createCopy();
        copy2.flushFields(new QualifierStatusMap(null, true));
        copy2.emptyStack();
        for (DfaValue value : this.getFactory().getValues().toArray(DfaValue.EMPTY_ARRAY)) {
            DfaVariableValue var;
            DfType type;
            DfType newType;
            if (!(value instanceof DfaVariableValue) || (newType = (type = copy2.getDfType(var = (DfaVariableValue)value)).correctForClosure()) == type) continue;
            copy2.recordVariableType(var, newType);
        }
        DfaMemoryStateImpl dfaMemoryStateImpl = copy2;
        if (dfaMemoryStateImpl == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(3);
        }
        return dfaMemoryStateImpl;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DfaMemoryStateImpl)) {
            return false;
        }
        DfaMemoryStateImpl that = (DfaMemoryStateImpl)obj;
        if (this.myCachedHash != null && that.myCachedHash != null && !this.myCachedHash.equals(that.myCachedHash)) {
            return false;
        }
        return this.myEphemeral == that.myEphemeral && this.myStack.equals(that.myStack) && this.getNonTrivialEqClasses().equals(that.getNonTrivialEqClasses()) && this.getDistinctClassPairs().equals(that.getDistinctClassPairs()) && this.myVariableTypes.equals(that.myVariableTypes);
    }

    protected DistinctPairSet getDistinctClassPairs() {
        return this.myDistinctClasses;
    }

    protected LinkedHashSet<EqClass> getNonTrivialEqClasses() {
        if (this.myCachedNonTrivialEqClasses != null) {
            return this.myCachedNonTrivialEqClasses;
        }
        LinkedHashSet<EqClass> result2 = new LinkedHashSet<EqClass>();
        for (EqClass eqClass : this.myEqClasses) {
            if (eqClass == null || eqClass.size() <= 1) continue;
            result2.add(eqClass);
        }
        this.myCachedNonTrivialEqClasses = result2;
        return this.myCachedNonTrivialEqClasses;
    }

    public int hashCode() {
        if (this.myCachedHash != null) {
            return this.myCachedHash;
        }
        int hash = ((this.getNonTrivialEqClasses().hashCode() * 31 + this.getDistinctClassPairs().hashCode()) * 31 + this.myStack.hashCode()) * 31 + this.myVariableTypes.hashCode();
        this.myCachedHash = hash;
        return this.myCachedHash;
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        result2.append('<');
        if (this.myEphemeral) {
            result2.append("ephemeral, ");
        }
        for (EqClass set2 : this.getNonTrivialEqClasses()) {
            result2.append(set2);
        }
        if (!this.myDistinctClasses.isEmpty()) {
            result2.append("\n  distincts: ");
            String distincts = ((StreamEx)StreamEx.of((Collection)this.getDistinctClassPairs()).map(DistinctPairSet.DistinctPair::toString).sorted()).joining((CharSequence)" ");
            result2.append(distincts);
        }
        if (!this.myStack.isEmpty()) {
            result2.append("\n  stack: ").append(StringUtil.join(this.myStack, ","));
        }
        if (!this.myVariableTypes.isEmpty()) {
            result2.append("\n  vars: ");
            this.myVariableTypes.forEach((key, value) -> result2.append("[").append(key).append("->").append(value).append("] "));
        }
        result2.append('>');
        return result2.toString();
    }

    @Override
    @NotNull
    public DfaValue pop() {
        this.myCachedHash = null;
        DfaValue dfaValue = this.myStack.pop();
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(4);
        }
        return dfaValue;
    }

    @Override
    @NotNull
    public DfaValue peek() {
        DfaValue dfaValue = this.myStack.peek();
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(5);
        }
        return dfaValue;
    }

    @Override
    @Nullable
    public DfaValue getStackValue(int offset2) {
        int index2 = this.myStack.size() - 1 - offset2;
        return index2 < 0 ? null : (DfaValue)this.myStack.get(index2);
    }

    @Override
    public int getStackSize() {
        return this.myStack.size();
    }

    @Override
    public void push(@NotNull DfaValue value) {
        if (value == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(6);
        }
        assert (value.getFactory() == this.myFactory) : value;
        this.myCachedHash = null;
        this.myStack.push(value);
    }

    @Override
    public void emptyStack() {
        while (!this.myStack.isEmpty() && !(this.myStack.peek() instanceof DfaControlTransferValue)) {
            this.myCachedHash = null;
            this.myStack.pop();
        }
    }

    @Override
    public void setVarValue(DfaVariableValue var, DfaValue value) {
        assert (value.getFactory() == this.myFactory);
        assert (var.getFactory() == this.myFactory);
        if (var == value) {
            return;
        }
        value = this.handleStackValueOnVariableFlush(value, var, null);
        this.flushVariable(var, var.getDfType().isMergeable(var.getInherentType()));
        this.flushQualifiedMethods(var);
        DfType dfType = this.filterDfTypeOnAssignment(var, this.getDfType(value)).meet(var.getDfType());
        if (dfType == DfType.BOTTOM) {
            return;
        }
        if (!(!(value instanceof DfaVariableValue) || ControlFlow.isTempVariable(var) || ControlFlow.isTempVariable((DfaVariableValue)value) || var.getQualifier() != null && ControlFlow.isTempVariable(var.getQualifier()))) {
            this.checkEphemeral(var, value);
        }
        this.recordVariableType(var, dfType);
        this.applyBinOpRelations(value, RelationType.EQ, var);
        this.applyRelation(var, value, false);
        if (value instanceof DfaWrappedValue) {
            DfaWrappedValue wrappedValue = (DfaWrappedValue)value;
            DfaValue dfaValue = wrappedValue.getSpecialField().createValue(this.getFactory(), var);
            if (dfaValue instanceof DfaVariableValue) {
                DfaVariableValue derivedVar = (DfaVariableValue)dfaValue;
                this.setVarValue(derivedVar, wrappedValue.getWrappedValue());
            }
        } else if (!(value instanceof DfaVariableValue)) {
            for (Map.Entry<DerivedVariableDescriptor, DfType> entry : value.getDfType().getDerivedValues().entrySet()) {
                DerivedVariableDescriptor desc = entry.getKey();
                DfaValue dfaValue = desc.createValue(this.getFactory(), var);
                if (!(dfaValue instanceof DfaVariableValue)) continue;
                DfaVariableValue derivedVar = (DfaVariableValue)dfaValue;
                this.setVarValue(derivedVar, this.getFactory().fromDfType(entry.getValue().meet(desc.getDefaultValue())));
            }
        }
    }

    protected DfType filterDfTypeOnAssignment(DfaVariableValue var, @NotNull DfType dfType) {
        if (dfType == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(7);
        }
        return dfType;
    }

    private DfaValue handleStackValueOnVariableFlush(DfaValue value, DfaVariableValue flushed, DfaVariableValue replacement) {
        if (value.dependsOn(flushed)) {
            DfType dfType = this.getDfType(value);
            if (value instanceof DfaVariableValue) {
                DfaVariableValue target2;
                DfaVariableValue var = (DfaVariableValue)value;
                if (replacement != null && (target2 = DfaMemoryStateImpl.replaceQualifier(var, flushed, replacement)) != value) {
                    return target2;
                }
            }
            return this.myFactory.fromDfType(dfType);
        }
        return value;
    }

    private int getOrCreateEqClassIndex(@NotNull DfaVariableValue dfaValue) {
        int i2;
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(8);
        }
        if ((i2 = this.getEqClassIndex(dfaValue)) != -1) {
            return i2;
        }
        dfaValue = this.canonicalize(dfaValue);
        EqClass eqClass = new EqClass(this.myFactory);
        eqClass.add(dfaValue.getID());
        int resultIndex = this.storeClass(eqClass);
        this.checkInvariants();
        return resultIndex;
    }

    private int storeClass(EqClass eqClass) {
        int resultIndex;
        int freeIndex = this.myEqClasses.indexOf(null);
        int n = resultIndex = freeIndex >= 0 ? freeIndex : this.myEqClasses.size();
        if (freeIndex >= 0) {
            this.myEqClasses.set(freeIndex, eqClass);
        } else {
            this.myEqClasses.add(eqClass);
        }
        eqClass.forValues(id -> this.myIdToEqClassesIndices.put(id, resultIndex));
        return resultIndex;
    }

    @Override
    @Nullable
    public DfaMemoryState tryJoinExactly(@NotNull DfaMemoryState other) {
        DfType thatType;
        RelationType relation;
        int secondIndex;
        int firstIndex;
        DfaMemoryStateImpl that;
        StateMerger merger;
        if (other == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(9);
        }
        if (!(merger = new StateMerger(this, that = (DfaMemoryStateImpl)other)).update(that.myEphemeral || !this.myEphemeral, this.myEphemeral || !that.myEphemeral)) {
            return null;
        }
        if (this.myStack.size() != that.myStack.size()) {
            return null;
        }
        int i2 = 0;
        while (i2 < this.myStack.size()) {
            DfaValue thisValue = (DfaValue)this.myStack.get(i2);
            DfaValue thatValue = (DfaValue)that.myStack.get(i2);
            int n = i2++;
            if (merger.update(DfaMemoryStateImpl.isSuperValue(thisValue, thatValue), DfaMemoryStateImpl.isSuperValue(thatValue, thisValue), () -> {
                DfType type;
                if (thisValue instanceof DfaTypeValue && thatValue instanceof DfaTypeValue && (type = thisValue.getDfType().tryJoinExactly(thatValue.getDfType())) != null) {
                    return new MergePatch(false, ms -> ms.myStack.set(finalI, this.myFactory.fromDfType(type)));
                }
                return null;
            })) continue;
            return null;
        }
        int[] thisToThat = this.getClassesMap(that);
        if (!merger.update(thisToThat != null, true)) {
            return null;
        }
        int[] thatToThis = that.getClassesMap(this);
        if (!merger.update(true, thatToThis != null)) {
            return null;
        }
        if (thisToThat != null) {
            for (DistinctPairSet.DistinctPair distinctPair : this.myDistinctClasses) {
                if (!merger.updateEquivalence(distinctPair, firstIndex = thisToThat[distinctPair.getFirstIndex()], secondIndex = thisToThat[distinctPair.getSecondIndex()], false)) {
                    return null;
                }
                relation = that.myDistinctClasses.getRelation(firstIndex, secondIndex);
                if (merger.updateOrdering(distinctPair, relation, false)) continue;
                return null;
            }
        }
        if (thatToThis != null) {
            for (DistinctPairSet.DistinctPair distinctPair : that.myDistinctClasses) {
                if (!merger.updateEquivalence(distinctPair, firstIndex = thatToThis[distinctPair.getFirstIndex()], secondIndex = thatToThis[distinctPair.getSecondIndex()], true)) {
                    return null;
                }
                relation = this.myDistinctClasses.getRelation(firstIndex, secondIndex);
                if (merger.updateOrdering(distinctPair, relation, true)) continue;
                return null;
            }
        }
        for (Map.Entry entry : this.myVariableTypes.entrySet()) {
            DfType thisType;
            DfaVariableValue value = (DfaVariableValue)entry.getKey();
            if (merger.updateVariable(value, thisType = (DfType)entry.getValue(), thatType = that.getDfType(value))) continue;
            return null;
        }
        for (Map.Entry entry : that.myVariableTypes.entrySet()) {
            DfType thisType;
            DfaVariableValue value = (DfaVariableValue)entry.getKey();
            if (this.myVariableTypes.containsKey(value) || merger.updateVariable(value, thisType = this.getDfType(value), thatType = (DfType)entry.getValue())) continue;
            return null;
        }
        return merger.merge(this, that);
    }

    @Override
    public boolean isSuperStateOf(@NotNull DfaMemoryState other) {
        DfType thatType;
        if (other == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(10);
        }
        if (!(other instanceof DfaMemoryStateImpl)) {
            return false;
        }
        DfaMemoryStateImpl that = (DfaMemoryStateImpl)other;
        if (this.myEphemeral && !that.myEphemeral) {
            return false;
        }
        if (this.myStack.size() != that.myStack.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.myStack.size(); ++i2) {
            if (DfaMemoryStateImpl.isSuperValue((DfaValue)this.myStack.get(i2), (DfaValue)that.myStack.get(i2))) continue;
            return false;
        }
        int[] thisToThat = this.getClassesMap(that);
        if (thisToThat == null) {
            return false;
        }
        for (DistinctPairSet.DistinctPair distinctPair : this.myDistinctClasses) {
            int firstIndex = thisToThat[distinctPair.getFirstIndex()];
            int secondIndex = thisToThat[distinctPair.getSecondIndex()];
            if (firstIndex == -1 || secondIndex == -1 || firstIndex == secondIndex) {
                return false;
            }
            RelationType relation = that.myDistinctClasses.getRelation(firstIndex, secondIndex);
            if (relation != null && (!distinctPair.isOrdered() || relation == RelationType.LT)) continue;
            return false;
        }
        for (Map.Entry entry : this.myVariableTypes.entrySet()) {
            DfaVariableValue value = (DfaVariableValue)entry.getKey();
            DfType thisType = (DfType)entry.getValue();
            if (thisType.isMergeable(thatType = that.getDfType(value))) continue;
            return false;
        }
        for (Map.Entry entry : that.myVariableTypes.entrySet()) {
            DfType thisType;
            DfaVariableValue value = (DfaVariableValue)entry.getKey();
            if (this.myVariableTypes.containsKey(value) || (thisType = this.getDfType(value)).isMergeable(thatType = (DfType)entry.getValue())) continue;
            return false;
        }
        return true;
    }

    private int @Nullable [] getClassesMap(DfaMemoryStateImpl that) {
        List<EqClass> thisClasses = this.myEqClasses;
        List<EqClass> thatClasses = that.myEqClasses;
        int thisSize = thisClasses.size();
        int thatSize = thatClasses.size();
        int[] thisToThat = new int[thisSize];
        for (int thisIdx = 0; thisIdx < thisSize; ++thisIdx) {
            EqClass thisClass = thisClasses.get(thisIdx);
            thisToThat[thisIdx] = -1;
            if (thisClass == null) continue;
            boolean found2 = false;
            for (int thatIdx = 0; thatIdx < thatSize; ++thatIdx) {
                EqClass thatClass = thatClasses.get(thatIdx);
                if (thatClass == null || !thatClass.containsAll(thisClass)) continue;
                thisToThat[thisIdx] = thatIdx;
                found2 = true;
                break;
            }
            if (found2 || thisClass.size() <= 1) continue;
            return null;
        }
        return thisToThat;
    }

    private static boolean isSuperValue(DfaValue superValue, DfaValue subValue) {
        if (DfaTypeValue.isUnknown(superValue) || superValue == subValue) {
            return true;
        }
        if (superValue instanceof DfaTypeValue && subValue instanceof DfaTypeValue) {
            return superValue.getDfType().isMergeable(subValue.getDfType());
        }
        return false;
    }

    public List<EqClass> getEqClasses() {
        return this.myEqClasses;
    }

    @Nullable
    private EqClass getEqClass(DfaValue value) {
        int index2 = this.getEqClassIndex(value);
        return index2 == -1 ? null : this.myEqClasses.get(index2);
    }

    public int getEqClassIndex(@NotNull DfaValue dfaValue) {
        int classIndex;
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(11);
        }
        if ((classIndex = this.myIdToEqClassesIndices.getOrDefault(dfaValue.getID(), -1)) == -1) {
            dfaValue = this.canonicalize(dfaValue);
            classIndex = this.myIdToEqClassesIndices.getOrDefault(dfaValue.getID(), -1);
        }
        if (classIndex == -1) {
            return -1;
        }
        EqClass aClass = this.myEqClasses.get(classIndex);
        assert (aClass.contains(dfaValue.getID()));
        return classIndex;
    }

    DfaVariableValue getCanonicalVariable(DfaValue val) {
        EqClass eqClass = this.getEqClass(val);
        return eqClass == null ? null : eqClass.getCanonicalVariable();
    }

    private boolean uniteClasses(DfaVariableValue val1, DfaVariableValue val2) {
        int c2Index;
        DfaVariableValue var1 = this.getCanonicalVariable(val1);
        DfaVariableValue var2 = this.getCanonicalVariable(val2);
        int c1Index = this.getOrCreateEqClassIndex(val1);
        if (c1Index == (c2Index = this.getOrCreateEqClassIndex(val2))) {
            return true;
        }
        if (!this.myDistinctClasses.unite(c1Index, c2Index)) {
            return false;
        }
        EqClass c1 = this.myEqClasses.get(c1Index);
        EqClass c2 = this.myEqClasses.get(c2Index);
        EqClass newClass = new EqClass(c1);
        this.myEqClasses.set(c1Index, newClass);
        for (int i2 = 0; i2 < c2.size(); ++i2) {
            int c3 = c2.get(i2);
            newClass.add(c3);
            this.myIdToEqClassesIndices.put(c3, c1Index);
        }
        this.myEqClasses.set(c2Index, null);
        this.checkInvariants();
        if (var1 == null || var2 == null || var1 == var2) {
            return true;
        }
        int compare = EqClass.CANONICAL_VARIABLE_COMPARATOR.compare(var1, var2);
        return compare < 0 ? this.convertQualifiers(var2, var1) : this.convertQualifiers(var1, var2);
    }

    private static DfaVariableValue replaceQualifier(DfaVariableValue variable, DfaVariableValue from, DfaVariableValue to) {
        DfaVariableValue qualifier = variable.getQualifier();
        if (qualifier != null) {
            return variable.withQualifier(DfaMemoryStateImpl.replaceQualifier(qualifier == from ? to : qualifier, from, to));
        }
        return variable;
    }

    private boolean convertQualifiers(DfaVariableValue from, DfaVariableValue to) {
        assert (from != to);
        if (from.getDependentVariables().isEmpty()) {
            return true;
        }
        ArrayList<DfaVariableValue> vars = new ArrayList<DfaVariableValue>(this.myVariableTypes.keySet());
        for (DfaVariableValue var : vars) {
            DfType fromType;
            DfaVariableValue target2 = DfaMemoryStateImpl.replaceQualifier(var, from, to);
            if (target2 == var || (fromType = (DfType)this.myVariableTypes.remove(var)) == null) continue;
            DfType toType = this.myVariableTypes.get(target2);
            if (toType == null) {
                toType = fromType;
            } else if ((toType = fromType.meet(toType)) == DfType.BOTTOM) {
                return false;
            }
            this.recordVariableType(target2, toType);
        }
        for (Object valueId : (Object)this.myIdToEqClassesIndices.keySet().toIntArray()) {
            DfaValue value = this.myFactory.getValue((int)valueId);
            DfaVariableValue var = ObjectUtils.tryCast(value, DfaVariableValue.class);
            if (var == null || var.getQualifier() != from) continue;
            DfaVariableValue target3 = var.withQualifier(to);
            if (!this.uniteClasses(var, target3)) {
                return false;
            }
            this.removeEquivalence(var);
        }
        return true;
    }

    private void checkInvariants() {
        if (!LOG.isDebugEnabled() && !ApplicationManager.getApplication().isEAP()) {
            return;
        }
        for (Int2IntMap.Entry entry : this.myIdToEqClassesIndices.int2IntEntrySet()) {
            EqClass eqClass = this.myEqClasses.get(entry.getIntValue());
            if (eqClass != null && eqClass.contains(entry.getIntKey())) continue;
            LOG.error("Invariant violated: null-class for id=" + this.myFactory.getValue(entry.getIntKey()));
        }
        Int2ObjectOpenHashMap<BitSet> graph2 = new Int2ObjectOpenHashMap<BitSet>();
        for (DistinctPairSet.DistinctPair pair : this.myDistinctClasses) {
            if (pair.isOrdered()) {
                BitSet set2 = (BitSet)graph2.get(pair.getFirstIndex());
                if (set2 == null) {
                    set2 = new BitSet();
                    graph2.put(pair.getFirstIndex(), set2);
                }
                set2.set(pair.getSecondIndex());
            }
            pair.check();
        }
        BitSet bitSet = new BitSet();
        BitSet stack = new BitSet();
        IntIterator intIterator = graph2.keySet().iterator();
        while (intIterator.hasNext()) {
            int v = (Integer)intIterator.next();
            if (!DfaMemoryStateImpl.isCycle(v, graph2, bitSet, stack)) continue;
            throw new IllegalStateException("Cycle in distinct pairs involving " + this.myEqClasses.get(v));
        }
    }

    private static boolean isCycle(int v, Int2ObjectMap<BitSet> graph2, BitSet visited, BitSet stack) {
        if (!visited.get(v)) {
            visited.set(v);
            stack.set(v);
            BitSet set2 = (BitSet)graph2.get(v);
            if (set2 != null && set2.stream().anyMatch(i2 -> !visited.get(i2) && DfaMemoryStateImpl.isCycle(i2, graph2, visited, stack) || stack.get(i2))) {
                return true;
            }
        }
        stack.clear(v);
        return false;
    }

    @Override
    public void markEphemeral() {
        this.myEphemeral = true;
    }

    @Override
    public boolean isEphemeral() {
        return this.myEphemeral;
    }

    @Override
    public boolean isEmptyStack() {
        return this.myStack.isEmpty();
    }

    @Override
    public void setDfType(@NotNull DfaValue value, @NotNull DfType dfType) {
        if (value == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(12);
        }
        if (dfType == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(13);
        }
        if (value instanceof DfaVariableValue) {
            this.recordVariableType((DfaVariableValue)value, dfType);
        }
    }

    @Override
    public void updateDfType(@NotNull DfaValue value, @NotNull @NotNull UnaryOperator<@NotNull DfType> updater2) {
        if (value == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(14);
        }
        if (updater2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(15);
        }
        if (!(value instanceof DfaVariableValue)) {
            return;
        }
        DfaVariableValue var = (DfaVariableValue)value;
        EqClass values2 = this.getEqClass(var);
        Iterable<DfaVariableValue> vars = values2 == null ? List.of(var) : values2;
        for (DfaVariableValue eqVar : vars) {
            DfType newType;
            DfType type = this.getRecordedType(eqVar);
            if (type == null) {
                type = eqVar.getInherentType();
            }
            if ((newType = (DfType)updater2.apply(type)).equals(type)) continue;
            this.recordVariableType(eqVar, newType);
        }
    }

    @Override
    public boolean meetDfType(@NotNull DfaValue value, @NotNull DfType dfType) {
        if (value == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(16);
        }
        if (dfType == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(17);
        }
        if (dfType == DfType.TOP) {
            return true;
        }
        if (dfType == DfType.BOTTOM) {
            return false;
        }
        if (value instanceof DfaBinOpValue) {
            return this.propagateRangeBack(ObjectUtils.tryCast(dfType, DfIntegralType.class), (DfaBinOpValue)value);
        }
        if (value instanceof DfaVariableValue) {
            DfaVariableValue var = (DfaVariableValue)value;
            DfType type = this.getDfType(var);
            DfType result2 = type.meet(dfType);
            if (result2.equals(type)) {
                return true;
            }
            if (result2 == DfType.BOTTOM) {
                return false;
            }
            return this.meetVariableType(var, type, result2);
        }
        return value.getDfType().meet(dfType) != DfType.BOTTOM;
    }

    protected boolean meetVariableType(@NotNull DfaVariableValue var, @NotNull DfType originalType, @NotNull DfType newType) {
        if (var == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(18);
        }
        if (originalType == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(19);
        }
        if (newType == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(20);
        }
        this.recordVariableType(var, newType);
        for (Map.Entry<DerivedVariableDescriptor, DfType> entry : newType.getDerivedValues().entrySet()) {
            if (this.meetDfType(entry.getKey().createValue(this.getFactory(), var), entry.getValue())) continue;
            return false;
        }
        if (!this.updateDependentVariables(var, newType)) {
            return false;
        }
        if (!this.correctRelatedValues(var, newType)) {
            return false;
        }
        return !(newType instanceof DfConstantType) || this.propagateConstant(var, (DfConstantType)newType);
    }

    private boolean propagateRangeBack(@Nullable DfIntegralType appliedRange, @NotNull DfaBinOpValue binOp) {
        if (binOp == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(21);
        }
        if (appliedRange == null) {
            return true;
        }
        DfaVariableValue left = binOp.getLeft();
        DfaValue right = binOp.getRight();
        DfIntegralType leftDfType = ObjectUtils.tryCast(this.getDfType(left), DfIntegralType.class);
        DfIntegralType rightDfType = ObjectUtils.tryCast(this.getDfType(right), DfIntegralType.class);
        if (leftDfType == null || rightDfType == null) {
            return true;
        }
        DfType result2 = this.getBinOpRange(binOp);
        DfType targetRange = result2.meet(appliedRange);
        if (targetRange == DfType.BOTTOM) {
            return false;
        }
        DfType leftConstraint = binOp.getDfType();
        DfType rightConstraint = binOp.getDfType();
        switch (binOp.getOperation()) {
            case PLUS: {
                leftConstraint = appliedRange.eval(rightDfType, LongRangeBinOp.MINUS);
                rightConstraint = appliedRange.eval(leftDfType, LongRangeBinOp.MINUS);
                break;
            }
            case MINUS: {
                leftConstraint = rightDfType.eval(appliedRange, LongRangeBinOp.PLUS);
                rightConstraint = leftDfType.eval(appliedRange, LongRangeBinOp.MINUS);
                break;
            }
            case MOD: {
                Long value = rightDfType.getRange().getConstantValue();
                if (value == null) break;
                leftConstraint = leftDfType.meetRange(LongRangeSet.fromRemainder(value, DfaMemoryStateImpl.extractRange(targetRange)));
            }
        }
        return this.meetDfType(left, leftDfType.meet(leftConstraint)) && this.meetDfType(right, rightDfType.meet(rightConstraint));
    }

    @Override
    public boolean applyContractCondition(@NotNull DfaCondition condition) {
        DfaRelation relation;
        if (condition == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(22);
        }
        if (condition instanceof DfaRelation && (relation = (DfaRelation)condition).isEquality()) {
            this.checkEphemeral(relation.getLeftOperand(), relation.getRightOperand());
            this.checkEphemeral(relation.getRightOperand(), relation.getLeftOperand());
        }
        return this.applyCondition(condition);
    }

    @Override
    public boolean areEqual(@NotNull DfaValue value1, @NotNull DfaValue value2) {
        if (value1 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(23);
        }
        if (value2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(24);
        }
        if (value1 instanceof DfaBinOpValue) {
            DfaBinOpValue binOp1 = (DfaBinOpValue)value1;
            if (value2 instanceof DfaBinOpValue) {
                DfaBinOpValue binOp2 = (DfaBinOpValue)value2;
                return binOp1.getOperation() == binOp2.getOperation() && this.areEqual(binOp1.getLeft(), binOp2.getLeft()) && this.areEqual(binOp1.getRight(), binOp2.getRight());
            }
        }
        DfType dfType1 = this.getDfType(value1);
        DfType dfType2 = this.getDfType(value2);
        if (dfType1 instanceof DfConstantType && dfType2 instanceof DfConstantType && dfType1.equals(dfType2)) {
            return true;
        }
        if (!(value1 instanceof DfaVariableValue)) {
            return false;
        }
        if (!(value2 instanceof DfaVariableValue)) {
            return false;
        }
        if (value1 == value2) {
            return true;
        }
        int index1 = this.getEqClassIndex(value1);
        int index2 = this.getEqClassIndex(value2);
        return index1 != -1 && index1 == index2;
    }

    @Override
    @Nullable
    public RelationType getRelation(@NotNull DfaValue left, @NotNull DfaValue right) {
        if (left == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(25);
        }
        if (right == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(26);
        }
        int leftClass = this.getEqClassIndex(left);
        int rightClass = this.getEqClassIndex(right);
        if (leftClass == -1 || rightClass == -1) {
            return null;
        }
        if (leftClass == rightClass) {
            return RelationType.EQ;
        }
        return this.myDistinctClasses.getRelation(leftClass, rightClass);
    }

    @Override
    public boolean applyCondition(@NotNull DfaCondition dfaCond) {
        if (dfaCond == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(27);
        }
        if (!(dfaCond instanceof DfaRelation)) {
            return dfaCond != DfaCondition.getFalse();
        }
        return this.applyRelationCondition((DfaRelation)dfaCond);
    }

    private boolean applyRelationCondition(@NotNull DfaRelation dfaRelation) {
        if (dfaRelation == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(28);
        }
        DfaValue dfaLeft = dfaRelation.getLeftOperand();
        DfaValue dfaRight = dfaRelation.getRightOperand();
        RelationType relationType = dfaRelation.getRelation();
        if (DfaTypeValue.isUnknown(dfaLeft) || DfaTypeValue.isUnknown(dfaRight)) {
            return true;
        }
        if (dfaLeft instanceof DfaTypeValue && dfaRight instanceof DfaTypeValue) {
            return true;
        }
        if (relationType == RelationType.EQ && dfaLeft instanceof DfaVariableValue && dfaRight instanceof DfaVariableValue) {
            this.checkEphemeral(dfaLeft, dfaRight);
            this.checkEphemeral(dfaRight, dfaLeft);
        }
        DfType leftType = this.getDfType(dfaLeft);
        DfType rightType = this.getDfType(dfaRight);
        if (leftType == DfType.FAIL || rightType == DfType.FAIL) {
            return leftType == rightType == (relationType == RelationType.EQ);
        }
        if (!this.meetDfType(dfaLeft, leftType.meetRelation(relationType, rightType))) {
            return false;
        }
        if (relationType.getFlipped() != null && !this.meetDfType(dfaRight, rightType.meetRelation(relationType.getFlipped(), leftType))) {
            return false;
        }
        if (!this.applyBinOpRelations(dfaLeft, relationType, dfaRight)) {
            return false;
        }
        return this.applyEquivalenceRelation(relationType, dfaLeft, dfaRight);
    }

    @NotNull
    private static LongRangeSet extractRange(@NotNull DfType type) {
        if (type == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(29);
        }
        LongRangeSet longRangeSet = type instanceof DfIntegralType ? ((DfIntegralType)type).getRange() : LongRangeSet.all();
        if (longRangeSet == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(30);
        }
        return longRangeSet;
    }

    private boolean applyBinOpRelations(DfaValue left, RelationType type, DfaValue right) {
        if (type != RelationType.LT && type != RelationType.GT && type != RelationType.NE && type != RelationType.EQ) {
            return true;
        }
        if (!(left instanceof DfaBinOpValue)) {
            if (right instanceof DfaBinOpValue) {
                return this.applyBinOpRelations(right, type.getFlipped(), left);
            }
            return true;
        }
        DfaBinOpValue binOp = (DfaBinOpValue)left;
        LongRangeBinOp op = binOp.getOperation();
        if (op != LongRangeBinOp.PLUS && op != LongRangeBinOp.MINUS) {
            return true;
        }
        DfaVariableValue leftLeft = binOp.getLeft();
        DfaValue leftRight = binOp.getRight();
        LongRangeSet leftRange = DfaMemoryStateImpl.extractRange(this.getDfType(leftLeft));
        LongRangeSet rightRange = DfaMemoryStateImpl.extractRange(this.getDfType(leftRight));
        LongRangeType lrType = binOp.getDfType().getLongRangeType();
        LongRangeSet rightNegated = rightRange.negate(lrType);
        LongRangeSet rightCorrected = op == LongRangeBinOp.MINUS ? rightNegated : rightRange;
        LongRangeSet resultRange = DfaMemoryStateImpl.extractRange(this.getDfType(right));
        RelationType correctedRelation = DfaMemoryStateImpl.correctRelation(type, leftRange, rightCorrected, resultRange, lrType);
        if (op == LongRangeBinOp.MINUS) {
            RelationType correctedLt;
            RelationType correctedGt;
            long min = resultRange.min();
            long max = resultRange.max();
            if (min == 0L && max == 0L ? !this.applyCondition(leftLeft.cond(correctedRelation, leftRight)) : (min == 0L && type == RelationType.GT || min >= 1L && RelationType.GE.isSubRelation(type) ? !this.applyCondition(leftLeft.cond(correctedGt = DfaMemoryStateImpl.correctRelation(RelationType.GT, leftRange, rightCorrected, resultRange, lrType), leftRight)) : (max == 0L && type == RelationType.LT || max <= -1L && RelationType.LE.isSubRelation(type)) && !this.applyCondition(leftLeft.cond(correctedLt = DfaMemoryStateImpl.correctRelation(RelationType.LT, leftRange, rightCorrected, resultRange, lrType), leftRight)))) {
                return false;
            }
            if (RelationType.EQ.equals((Object)type) && !resultRange.contains(0L) && !this.applyRelation(leftLeft, leftRight, true)) {
                return false;
            }
        }
        if (op == LongRangeBinOp.PLUS && RelationType.EQ == type && !resultRange.intersects(lrType.fullRange().mul(LongRangeSet.point(2L), lrType)) && !this.applyRelation(leftLeft, leftRight, true)) {
            return false;
        }
        if (right instanceof DfaVariableValue) {
            if (this.areEqual(leftLeft, right)) {
                RelationType finalRelation;
                RelationType relationType = finalRelation = op == LongRangeBinOp.MINUS ? Objects.requireNonNull(correctedRelation.getFlipped()) : correctedRelation;
                if (!this.applyCondition(leftRight.cond(finalRelation, binOp.getDfType().meetRange(LongRangeSet.point(0L))))) {
                    return false;
                }
            }
            if (op == LongRangeBinOp.PLUS && this.areEqual(leftRight, right) && !this.applyCondition(leftLeft.cond(correctedRelation, binOp.getDfType().meetRange(LongRangeSet.point(0L))))) {
                return false;
            }
            if (!this.applyRelationOnAddition(type, leftLeft, leftRange, rightCorrected, right, lrType)) {
                return false;
            }
            if (op == LongRangeBinOp.PLUS && leftRight instanceof DfaVariableValue && !this.applyRelationOnAddition(type, (DfaVariableValue)leftRight, rightRange, leftRange, right, lrType)) {
                return false;
            }
        }
        return true;
    }

    private boolean applyRelationOnAddition(@NotNull RelationType type, @NotNull DfaVariableValue left, @NotNull LongRangeSet leftRange, @NotNull LongRangeSet rightRange, @NotNull DfaValue sum, @NotNull LongRangeType lrType) {
        if (type == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(31);
        }
        if (left == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(32);
        }
        if (leftRange == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(33);
        }
        if (rightRange == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(34);
        }
        if (sum == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(35);
        }
        if (lrType == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(36);
        }
        if (!leftRange.additionMayOverflow(rightRange, lrType)) {
            if (rightRange.max() < 0L && RelationType.GE.isSubRelation(type) && !this.applyLessThanRelation(sum, left)) {
                return false;
            }
            if (rightRange.min() > 0L && RelationType.LE.isSubRelation(type) && !this.applyLessThanRelation(left, sum)) {
                return false;
            }
        }
        return RelationType.EQ != type || rightRange.contains(0L) || this.applyRelation(left, sum, true);
    }

    private static RelationType correctRelation(RelationType relation, LongRangeSet summand1, LongRangeSet summand2, LongRangeSet resultRange, LongRangeType lrType) {
        if (relation != RelationType.LT && relation != RelationType.GT) {
            return relation;
        }
        boolean overflowPossible = true;
        if (lrType.bytes() < 8) {
            LongRangeSet overflowRange = DfaMemoryStateImpl.getSumOverflowValues(summand1, summand2, lrType);
            overflowPossible = !overflowRange.isEmpty() && (resultRange == null || resultRange.fromRelation(relation).intersects(overflowRange));
        }
        return overflowPossible ? RelationType.NE : relation;
    }

    @NotNull
    private static LongRangeSet getSumOverflowValues(LongRangeSet left, LongRangeSet right, LongRangeType lrType) {
        if (left.isEmpty() || right.isEmpty()) {
            LongRangeSet longRangeSet = LongRangeSet.empty();
            if (longRangeSet == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(37);
            }
            return longRangeSet;
        }
        long sumMin = left.min() + right.min();
        long sumMax = left.max() + right.max();
        LongRangeSet result2 = LongRangeSet.empty();
        if (sumMin < lrType.min()) {
            result2 = result2.join(LongRangeSet.range(lrType.cast(sumMin), lrType.max()));
        }
        if (sumMax > lrType.max()) {
            result2 = result2.join(LongRangeSet.range(lrType.min(), lrType.cast(sumMax)));
        }
        LongRangeSet longRangeSet = result2;
        if (longRangeSet == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(38);
        }
        return longRangeSet;
    }

    private boolean applyEquivalenceRelation(RelationType type, DfaValue dfaLeft, DfaValue dfaRight) {
        boolean isNegated;
        RelationType currentRelation = this.getRelation(dfaLeft, dfaRight);
        if (currentRelation != null && (type = type.meet(currentRelation)) == null) {
            return false;
        }
        boolean bl = isNegated = type == RelationType.NE || type == RelationType.GT || type == RelationType.LT;
        if (!isNegated && type != RelationType.EQ) {
            return true;
        }
        if (type == RelationType.EQ && !this.applyDerivedVariablesEquivalence(dfaLeft, dfaRight)) {
            return false;
        }
        if (!(!(dfaLeft instanceof DfaVariableValue) || !(dfaRight instanceof DfaVariableValue) || isNegated || this.updateQualifierOnEquality((DfaVariableValue)dfaLeft, dfaRight) && this.updateQualifierOnEquality((DfaVariableValue)dfaRight, dfaLeft))) {
            return false;
        }
        if (dfaLeft == dfaRight && dfaLeft instanceof DfaVariableValue) {
            return !isNegated || this.isUnstableValue(dfaLeft) || ((DfaVariableValue)dfaLeft).containsCalls();
        }
        if (dfaLeft instanceof DfaVariableValue && dfaRight instanceof DfaVariableValue && (type == RelationType.LT ? !this.applyLessThanRelation(dfaLeft, dfaRight) : (type == RelationType.GT ? !this.applyLessThanRelation(dfaRight, dfaLeft) : !this.applyRelation(dfaLeft, dfaRight, isNegated)))) {
            return false;
        }
        if (isNegated) {
            return this.applyDerivedInequality(dfaLeft, dfaRight);
        }
        return true;
    }

    protected void checkEphemeral(DfaValue left, DfaValue right) {
    }

    private boolean updateQualifierOnEquality(DfaVariableValue target2, DfaValue value) {
        DfType constraint = target2.getDescriptor().getQualifierConstraintFromValue(this, value);
        DfaVariableValue qualifier = target2.getQualifier();
        return qualifier == null || this.meetDfType(qualifier, constraint);
    }

    private boolean propagateConstant(DfaVariableValue value, DfConstantType<?> constant) {
        DfType dfType = constant.tryNegate();
        if (dfType == null) {
            return true;
        }
        EqClass eqClass = this.getEqClass(value);
        if (eqClass == null) {
            return true;
        }
        for (DistinctPairSet.DistinctPair pair : this.getDistinctClassPairs().toArray(new DistinctPairSet.DistinctPair[0])) {
            EqClass other;
            EqClass eqClass2 = pair.getFirst() == eqClass ? pair.getSecond() : (other = pair.getSecond() == eqClass ? pair.getFirst() : null);
            if (other == null) continue;
            for (DfaVariableValue var : other.asList()) {
                if (this.meetDfType(var, dfType)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean correctRelatedValues(@NotNull DfaValue value, @NotNull DfType type) {
        EqClass eqClass;
        if (value == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(39);
        }
        if (type == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(40);
        }
        if ((eqClass = this.getEqClass(value)) == null) {
            return true;
        }
        if (type.fromRelation(RelationType.GT) == DfType.TOP && type.fromRelation(RelationType.LT) == DfType.TOP) {
            return true;
        }
        DistinctPairSet distinctPairs = this.myDistinctClasses;
        this.myDistinctClasses = new DistinctPairSet(this);
        try {
            for (DistinctPairSet.DistinctPair pair : distinctPairs) {
                DfaVariableValue var;
                if (!pair.isOrdered()) continue;
                if (pair.getFirst() == eqClass) {
                    var = Objects.requireNonNull(pair.getSecond().getCanonicalVariable());
                    if (this.meetDfType(var, this.getDfType(var).meetRelation(RelationType.GT, type))) continue;
                    boolean bl = false;
                    return bl;
                }
                if (pair.getSecond() != eqClass || this.meetDfType(var = Objects.requireNonNull(pair.getFirst().getCanonicalVariable()), this.getDfType(var).meetRelation(RelationType.LT, type))) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.myDistinctClasses = distinctPairs;
        }
        return true;
    }

    private boolean applyDerivedVariablesEquivalence(@NotNull DfaValue left, @NotNull DfaValue right) {
        if (left == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(41);
        }
        if (right == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(42);
        }
        return StreamEx.of((Object[])new DfaValue[]{left, right}).flatCollection(val -> val.getDfType().getDerivedVariables()).allMatch(field -> {
            DfaValue leftValue = field.createValue(this.myFactory, left);
            DfaValue rightValue = field.createValue(this.myFactory, right);
            DfType result2 = this.getDfType(leftValue).meet(this.getDfType(rightValue));
            if (!result2.hasNonStandardEquivalence() && !this.applyRelation(leftValue, rightValue, false)) {
                return false;
            }
            return this.meetDfType(leftValue, result2) && this.meetDfType(rightValue, result2);
        });
    }

    private boolean applyDerivedInequality(@NotNull DfaValue dfaLeft, DfaValue dfaRight) {
        if (dfaLeft == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(43);
        }
        if (this.getDfType(dfaLeft).meet(this.getDfType(dfaRight)) == DfType.BOTTOM) {
            return true;
        }
        ArrayList<DerivedVariableDescriptor> variables = new ArrayList<DerivedVariableDescriptor>(dfaLeft.getDfType().getDerivedVariables());
        variables.retainAll(dfaRight.getDfType().getDerivedVariables());
        return ((StreamEx)StreamEx.of(variables).filter(dv -> dv.equalityImpliesQualifierEquality())).allMatch(dv -> {
            DfaValue derivedLeft = dv.createValue(this.myFactory, dfaLeft);
            DfaValue derivedRight = dv.createValue(this.myFactory, dfaRight);
            DfType leftType = this.getDfType(derivedLeft);
            DfType rightType = this.getDfType(derivedRight);
            if (leftType instanceof DfConstantType && leftType.equals(rightType)) {
                return false;
            }
            return derivedLeft.getDfType().hasNonStandardEquivalence() || derivedRight.getDfType().hasNonStandardEquivalence() || this.applyRelation(derivedLeft, derivedRight, true);
        });
    }

    private boolean applyRelation(@NotNull DfaValue dfaLeft, @NotNull DfaValue dfaRight, boolean isNegated) {
        int c2Index;
        if (dfaLeft == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(44);
        }
        if (dfaRight == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(45);
        }
        if (!(dfaLeft instanceof DfaVariableValue) || !(dfaRight instanceof DfaVariableValue)) {
            return true;
        }
        if (!isNegated && (this.isUnstableValue(dfaLeft) || this.isUnstableValue(dfaRight))) {
            return true;
        }
        int c1Index = this.getOrCreateEqClassIndex((DfaVariableValue)dfaLeft);
        if (c1Index == (c2Index = this.getOrCreateEqClassIndex((DfaVariableValue)dfaRight))) {
            return !isNegated;
        }
        if (!isNegated) {
            if (!this.uniteClasses((DfaVariableValue)dfaLeft, (DfaVariableValue)dfaRight)) {
                return false;
            }
        } else {
            this.myDistinctClasses.addUnordered(c1Index, c2Index);
        }
        this.myCachedNonTrivialEqClasses = null;
        this.myCachedHash = null;
        return true;
    }

    private boolean applyLessThanRelation(@NotNull DfaValue dfaLeft, @NotNull DfaValue dfaRight) {
        int c2Index;
        if (dfaLeft == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(46);
        }
        if (dfaRight == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(47);
        }
        if (!(dfaLeft instanceof DfaVariableValue) || !(dfaRight instanceof DfaVariableValue)) {
            return true;
        }
        int c1Index = this.getOrCreateEqClassIndex((DfaVariableValue)dfaLeft);
        if (c1Index == (c2Index = this.getOrCreateEqClassIndex((DfaVariableValue)dfaRight))) {
            return false;
        }
        this.myCachedHash = null;
        return this.myDistinctClasses.addOrdered(c1Index, c2Index);
    }

    private boolean isUnstableValue(DfaValue value) {
        if (!(value instanceof DfaVariableValue)) {
            return false;
        }
        DfaVariableValue var = (DfaVariableValue)value;
        return !var.alwaysEqualsToItself(this.getDfType(var));
    }

    @NotNull
    public DfType getBinOpRange(DfaBinOpValue binOp) {
        DfIntegralType leftType = ObjectUtils.tryCast(this.getDfType(binOp.getLeft()), DfIntegralType.class);
        DfIntegralType rightType = ObjectUtils.tryCast(this.getDfType(binOp.getRight()), DfIntegralType.class);
        if (leftType == null || rightType == null) {
            DfIntegralType dfIntegralType = binOp.getDfType();
            if (dfIntegralType == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(48);
            }
            return dfIntegralType;
        }
        LongRangeSet left = leftType.getRange();
        LongRangeSet right = rightType.getRange();
        LongRangeBinOp op = binOp.getOperation();
        DfIntegralType result2 = ObjectUtils.tryCast(leftType.eval(rightType, op), DfIntegralType.class);
        if (result2 == null) {
            result2 = binOp.getDfType();
        }
        if (op == LongRangeBinOp.MINUS) {
            RelationType rel = this.getRelation(binOp.getLeft(), binOp.getRight());
            if (rel == RelationType.NE) {
                DfType dfType = result2.meetRange(LongRangeSet.all().without(0L));
                if (dfType == null) {
                    DfaMemoryStateImpl.$$$reportNull$$$0(49);
                }
                return dfType;
            }
            if (!left.subtractionMayOverflow(right, result2.getLongRangeType())) {
                if (rel == RelationType.GT) {
                    DfType dfType = result2.meetRange(LongRangeSet.range(1L, Long.MAX_VALUE));
                    if (dfType == null) {
                        DfaMemoryStateImpl.$$$reportNull$$$0(50);
                    }
                    return dfType;
                }
                if (rel == RelationType.LT) {
                    DfType dfType = result2.meetRange(LongRangeSet.range(Long.MIN_VALUE, -1L));
                    if (dfType == null) {
                        DfaMemoryStateImpl.$$$reportNull$$$0(51);
                    }
                    return dfType;
                }
            }
        }
        if (op == LongRangeBinOp.PLUS && this.areEqual(binOp.getLeft(), binOp.getRight())) {
            DfType dfType = leftType.eval(binOp.getDfType().meetRange(LongRangeSet.point(2L)), LongRangeBinOp.MUL);
            if (dfType == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(52);
            }
            return dfType;
        }
        DfIntegralType dfIntegralType = result2;
        if (dfIntegralType == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(53);
        }
        return dfIntegralType;
    }

    @Override
    @NotNull
    public DfType getDfTypeIncludingDerived(@NotNull DfaValue value) {
        if (value == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(54);
        }
        DfType newType = this.getDfType(value);
        if (value instanceof DfaVariableValue) {
            DfaVariableValue var = (DfaVariableValue)value;
            if (!(var = this.canonicalizeQualifier(var)).getDependentVariables().isEmpty()) {
                for (Map.Entry<DfaVariableValue, DfType> entry : this.myVariableTypes.entrySet()) {
                    VariableDescriptor variableDescriptor;
                    DfaVariableValue recordedVar = entry.getKey();
                    if (recordedVar.getQualifier() != var || !((variableDescriptor = recordedVar.getDescriptor()) instanceof DerivedVariableDescriptor)) continue;
                    DerivedVariableDescriptor desc = (DerivedVariableDescriptor)variableDescriptor;
                    newType = newType.meet(desc.asDfType(entry.getValue()));
                }
            }
        }
        DfType dfType = newType;
        if (dfType == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(55);
        }
        return dfType;
    }

    @Override
    @NotNull
    public DfType getDfType(@NotNull DfaValue value) {
        if (value == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(56);
        }
        if (value instanceof DfaBinOpValue) {
            DfaBinOpValue binOpValue = (DfaBinOpValue)value;
            DfType dfType = this.getBinOpRange(binOpValue);
            if (dfType == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(57);
            }
            return dfType;
        }
        if (value instanceof DfaVariableValue) {
            DfaVariableValue variableValue = (DfaVariableValue)value;
            DfType type = this.getRecordedType(variableValue);
            DfType dfType = type != null ? type : variableValue.getInherentType();
            if (dfType == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(58);
            }
            return dfType;
        }
        if (value instanceof DfaWrappedValue) {
            DfaWrappedValue wrappedValue = (DfaWrappedValue)value;
            DfType wrappedValueType = this.getDfType(wrappedValue.getWrappedValue());
            DfType dfType = wrappedValue.getSpecialField().asDfType(value.getDfType(), wrappedValueType);
            if (dfType == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(59);
            }
            return dfType;
        }
        DfType dfType = value.getDfType();
        if (dfType == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(60);
        }
        return dfType;
    }

    public void recordVariableType(@NotNull DfaVariableValue dfaVar, @NotNull DfType type) {
        if (dfaVar == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(61);
        }
        if (type == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(62);
        }
        dfaVar = this.canonicalize(dfaVar);
        if ((type = type.getBasicType()).equals(dfaVar.getInherentType())) {
            this.myVariableTypes.remove(dfaVar);
        } else {
            this.myVariableTypes.put(dfaVar, type);
        }
        if (type instanceof DfEphemeralType) {
            this.markEphemeral();
        }
        this.myCachedHash = null;
    }

    private boolean updateDependentVariables(DfaVariableValue dfaVar, DfType type) {
        if (!this.updateQualifierOnEquality(dfaVar, dfaVar)) {
            return false;
        }
        EqClass eqClass = this.getEqClass(dfaVar);
        if (eqClass != null) {
            type = type.fromRelation(RelationType.EQ);
            for (DfaVariableValue value : eqClass.asList()) {
                if (value == dfaVar) continue;
                this.recordVariableType(value, type);
                if (this.updateQualifierOnEquality(value, value)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    protected DfaValue canonicalize(@NotNull DfaValue value) {
        if (value == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(63);
        }
        if (value instanceof DfaVariableValue) {
            return this.canonicalize((DfaVariableValue)value);
        }
        if (value instanceof DfaWrappedValue) {
            DfaWrappedValue boxedValue = (DfaWrappedValue)value;
            DfaVariableValue canonicalized = this.canonicalize(boxedValue.getWrappedValue());
            if (canonicalized == boxedValue.getWrappedValue()) {
                DfaWrappedValue dfaWrappedValue = boxedValue;
                if (dfaWrappedValue == null) {
                    DfaMemoryStateImpl.$$$reportNull$$$0(64);
                }
                return dfaWrappedValue;
            }
            DfaValue dfaValue = this.myFactory.getWrapperFactory().createWrapper(boxedValue.getDfType(), boxedValue.getSpecialField(), canonicalized);
            if (dfaValue == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(65);
            }
            return dfaValue;
        }
        DfaValue dfaValue = value;
        if (dfaValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(66);
        }
        return dfaValue;
    }

    @NotNull
    private DfaVariableValue canonicalize(DfaVariableValue var) {
        DfaVariableValue qualifier = var.getQualifier();
        if (qualifier != null) {
            DfaVariableValue dfaVariableValue = var.withQualifier(this.canonicalizeQualifier(qualifier));
            if (dfaVariableValue == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(67);
            }
            return dfaVariableValue;
        }
        DfaVariableValue dfaVariableValue = var;
        if (dfaVariableValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(68);
        }
        return dfaVariableValue;
    }

    @NotNull
    private DfaVariableValue canonicalizeQualifier(@NotNull DfaVariableValue qualifier) {
        int index2;
        if (qualifier == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(69);
        }
        if ((index2 = this.myIdToEqClassesIndices.getOrDefault(qualifier.getID(), -1)) == -1 && (index2 = this.myIdToEqClassesIndices.getOrDefault((qualifier = this.canonicalize(qualifier)).getID(), -1)) == -1) {
            DfaVariableValue dfaVariableValue = qualifier;
            if (dfaVariableValue == null) {
                DfaMemoryStateImpl.$$$reportNull$$$0(70);
            }
            return dfaVariableValue;
        }
        DfaVariableValue dfaVariableValue = Objects.requireNonNull(this.myEqClasses.get(index2).getCanonicalVariable());
        if (dfaVariableValue == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(71);
        }
        return dfaVariableValue;
    }

    private DfType getRecordedType(DfaVariableValue var) {
        DfType type = this.myVariableTypes.get(var);
        if (type != null) {
            return type;
        }
        DfaVariableValue canonicalized = this.canonicalize(var);
        return canonicalized == var ? null : this.myVariableTypes.get(canonicalized);
    }

    public void forRecordedVariableTypes(BiConsumer<? super DfaVariableValue, ? super DfType> consumer2) {
        this.myVariableTypes.forEach(consumer2);
    }

    @Override
    public void flushFieldsQualifiedBy(@NotNull Set<DfaValue> qualifiers) {
        if (qualifiers == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(72);
        }
        this.flushFields(new QualifierStatusMap(qualifiers, false));
    }

    @Override
    public void flushFields() {
        this.flushFields(new QualifierStatusMap(null, false));
    }

    public void flushFields(@NotNull QualifierStatusMap qualifierStatusMap) {
        if (qualifierStatusMap == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(73);
        }
        LinkedHashSet<DfaVariableValue> vars = new LinkedHashSet<DfaVariableValue>();
        for (DfaVariableValue value : this.myVariableTypes.keySet()) {
            if (!qualifierStatusMap.shouldFlush(value)) continue;
            vars.add(value);
        }
        for (EqClass aClass : this.myEqClasses) {
            if (aClass == null) continue;
            for (DfaVariableValue value : aClass) {
                if (!qualifierStatusMap.shouldFlush(value)) continue;
                vars.add(value);
            }
        }
        for (DfaVariableValue value : vars) {
            this.doFlush(value, true);
        }
        this.myStack.replaceAll(val -> {
            DfType type = this.getDfType((DfaValue)val);
            for (Map.Entry<DerivedVariableDescriptor, DfType> entry : type.getDerivedValues().entrySet()) {
                DerivedVariableDescriptor descriptor2 = entry.getKey();
                DfType derivedType = entry.getValue();
                if (derivedType == DfType.TOP || descriptor2.isStable() || !qualifierStatusMap.shouldFlush((DfaValue)val, descriptor2.isCall())) continue;
                return this.myFactory.fromDfType(type.getBasicType());
            }
            if (val instanceof DfaVariableValue && qualifierStatusMap.shouldFlush((DfaVariableValue)val)) {
                return this.myFactory.fromDfType(type);
            }
            return val;
        });
    }

    @Override
    public void flushVariable(@NotNull DfaVariableValue variable) {
        if (variable == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(74);
        }
        this.flushVariable(variable, true);
    }

    @Override
    public void flushVariables(@NotNull @NotNull Predicate<? super @NotNull DfaVariableValue> filter2) {
        if (filter2 == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(75);
        }
        HashSet<? super DfaVariableValue> vars = new HashSet<DfaVariableValue>();
        for (EqClass aClass : this.myEqClasses) {
            if (aClass == null) continue;
            for (DfaVariableValue value : aClass) {
                vars.add(value);
            }
        }
        vars.addAll(this.myVariableTypes.keySet());
        vars.removeIf(filter2.negate());
        vars.forEach(this::flushVariable);
    }

    @Override
    public void flushVariable(@NotNull DfaVariableValue variable, boolean canonicalize) {
        if (variable == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(76);
        }
        DfaVariableValue canonical = canonicalize ? this.canonicalize(variable) : variable;
        EqClass eqClass = canonical.getDependentVariables().isEmpty() ? null : this.getEqClass(canonical);
        DfaVariableValue newCanonical = eqClass == null ? null : (DfaVariableValue)StreamEx.of(eqClass.iterator()).without((Object)canonical).min(EqClass.CANONICAL_VARIABLE_COMPARATOR).filter(candidate -> !candidate.dependsOn(canonical)).orElse(null);
        this.myStack.replaceAll(value -> this.handleStackValueOnVariableFlush((DfaValue)value, canonical, newCanonical));
        this.doFlush(canonical, false);
        this.flushDependencies(canonical);
        this.myCachedHash = null;
    }

    void flushDependencies(@NotNull DfaVariableValue variable) {
        if (variable == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(77);
        }
        for (DfaVariableValue dependent : variable.getDependentVariables().toArray(new DfaVariableValue[0])) {
            this.doFlush(dependent, false);
        }
    }

    private void flushQualifiedMethods(@NotNull DfaVariableValue variable) {
        if (variable == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(78);
        }
        if (variable.isFlushableByCalls()) {
            List toFlush = ((StreamEx)StreamEx.of(this.myEqClasses).flatMap(cls -> cls == null ? null : StreamEx.of(cls.iterator())).append(this.myVariableTypes.keySet()).filter(DfaVariableValue::containsCalls)).toList();
            toFlush.forEach(val -> this.doFlush((DfaVariableValue)val, true));
        }
    }

    protected void doFlush(@NotNull DfaVariableValue var, boolean markFlushed) {
        DfType correctedType;
        DfType inherentType;
        if (var == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(79);
        }
        DfType typeBefore = this.getDfType(var);
        this.removeEquivalence(var);
        this.myVariableTypes.remove(var);
        if (markFlushed && !(inherentType = var.getInherentType()).equals(correctedType = inherentType.correctTypeOnFlush(typeBefore))) {
            this.recordVariableType(var, correctedType);
        }
        this.myCachedHash = null;
    }

    void removeEquivalence(DfaVariableValue var) {
        int varID = var.getID();
        int varClassIndex = this.myIdToEqClassesIndices.getOrDefault(varID, -1);
        if (varClassIndex == -1 && (varClassIndex = this.myIdToEqClassesIndices.getOrDefault(varID = (var = this.canonicalize(var)).getID(), -1)) == -1) {
            return;
        }
        EqClass varClass = this.myEqClasses.get(varClassIndex);
        varClass = new EqClass(varClass);
        DfaVariableValue previousCanonical = varClass.getCanonicalVariable();
        this.myEqClasses.set(varClassIndex, varClass);
        varClass.removeValue(varID);
        this.myIdToEqClassesIndices.remove(varID);
        this.checkInvariants();
        if (varClass.isEmpty()) {
            this.myEqClasses.set(varClassIndex, null);
            Iterator<DistinctPairSet.DistinctPair> iterator2 = this.myDistinctClasses.iterator();
            while (iterator2.hasNext()) {
                DistinctPairSet.DistinctPair pair = iterator2.next();
                if (pair.getOtherClass(varClassIndex) == null) continue;
                iterator2.remove();
            }
        } else {
            DfaVariableValue newCanonical = varClass.getCanonicalVariable();
            if (newCanonical != null && previousCanonical != null && previousCanonical != newCanonical && (ControlFlow.isTempVariable(previousCanonical) && !newCanonical.dependsOn(previousCanonical) || newCanonical.getDepth() <= previousCanonical.getDepth())) {
                boolean successfullyConverted = this.convertQualifiers(previousCanonical, newCanonical);
                assert (successfullyConverted);
            }
        }
        this.myCachedNonTrivialEqClasses = null;
        this.myCachedHash = null;
    }

    @Override
    public Object getMergeabilityKey() {
        return StreamEx.of(this.myStack).mapLastOrElse(val -> val instanceof DfaControlTransferValue || val == this.myFactory.getSentinel() ? val : null, Function.identity()).append((Object)this.isEphemeral()).toImmutableList();
    }

    @Override
    public void merge(@NotNull DfaMemoryState that) {
        if (that == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(80);
        }
        DfaMemoryStateImpl other = (DfaMemoryStateImpl)that;
        assert (other.isEphemeral() == this.isEphemeral());
        assert (other.myStack.size() == this.myStack.size());
        ProgressManager.checkCanceled();
        this.retainEquivalences(other);
        this.mergeDistinctPairs(other);
        this.mergeVariableTypes(other);
        this.mergeStacks(other);
        this.myCachedHash = null;
        this.myCachedNonTrivialEqClasses = null;
        this.afterMerge(other);
    }

    @Override
    public void afterMerge(@NotNull DfaMemoryState other) {
        if (other == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(81);
        }
    }

    private void mergeStacks(DfaMemoryStateImpl other) {
        List values2 = StreamEx.zip(this.myStack, other.myStack, DfaValue::unite).toList();
        this.myStack.clear();
        values2.forEach(this.myStack::push);
    }

    private void mergeDistinctPairs(DfaMemoryStateImpl other) {
        ArrayList<DistinctPairSet.DistinctPair> pairs = new ArrayList<DistinctPairSet.DistinctPair>(this.myDistinctClasses);
        for (DistinctPairSet.DistinctPair pair : pairs) {
            EqClass first2 = pair.getFirst();
            EqClass second2 = pair.getSecond();
            RelationType relation = other.getRelation(this.myFactory.getValue(first2.get(0)), this.myFactory.getValue(second2.get(0)));
            if (relation == null || relation == RelationType.EQ) {
                this.myDistinctClasses.remove(pair);
                continue;
            }
            if (!pair.isOrdered() || relation == RelationType.LT) continue;
            this.myDistinctClasses.dropOrder(pair);
        }
    }

    private void mergeVariableTypes(DfaMemoryStateImpl other) {
        Set vars = (Set)StreamEx.of((Object[])new LinkedHashMap[]{this.myVariableTypes, other.myVariableTypes}).toFlatCollection(Map::keySet, HashSet::new);
        for (DfaVariableValue var : vars) {
            DfType otherType;
            DfType type = this.getDfType(var);
            DfType result2 = !type.equals(otherType = other.getDfType(var)) ? type.join(otherType).correctTypeOnFlush(type).correctTypeOnFlush(otherType) : type;
            this.recordVariableType(var, result2);
        }
    }

    private void retainEquivalences(DfaMemoryStateImpl other) {
        boolean needRestart = true;
        block0: while (needRestart) {
            ProgressManager.checkCanceled();
            needRestart = false;
            for (EqClass eqClass : new ArrayList<EqClass>(this.myEqClasses)) {
                if (eqClass == null || !this.retainEquivalences(eqClass, other)) continue;
                needRestart = true;
                continue block0;
            }
        }
    }

    private boolean retainEquivalences(EqClass eqClass, DfaMemoryStateImpl other) {
        if (eqClass.size() <= 1) {
            return false;
        }
        List<EqClass> groups2 = this.splitEqClass(eqClass, other);
        if (groups2.size() == 1) {
            return false;
        }
        IntArrayList addedClasses = new IntArrayList();
        int origIndex = this.myIdToEqClassesIndices.get(eqClass.get(0));
        for (EqClass group2 : groups2) {
            addedClasses.add(this.storeClass(group2));
        }
        int[] addedClassesArray = addedClasses.toIntArray();
        this.myDistinctClasses.splitClass(origIndex, addedClassesArray);
        this.myEqClasses.set(origIndex, null);
        DfaVariableValue from = eqClass.getCanonicalVariable();
        boolean otherClassChanged = false;
        if (from != null && !from.getDependentVariables().isEmpty()) {
            ArrayList<DfaVariableValue> vars = new ArrayList<DfaVariableValue>(this.myVariableTypes.keySet());
            for (int classIndex : addedClassesArray) {
                DfaVariableValue to = this.myEqClasses.get(classIndex).getCanonicalVariable();
                if (to == null || to == from || to.getDepth() > from.getDepth()) continue;
                for (DfaVariableValue var : vars) {
                    DfaVariableValue target2 = DfaMemoryStateImpl.replaceQualifier(var, from, to);
                    if (target2 == var) continue;
                    this.recordVariableType(target2, this.getDfType(var));
                }
                for (Object valueId : (Object)this.myIdToEqClassesIndices.keySet().toIntArray()) {
                    DfaValue value = this.myFactory.getValue((int)valueId);
                    DfaVariableValue var = ObjectUtils.tryCast(value, DfaVariableValue.class);
                    if (var == null || var.getQualifier() != from) continue;
                    DfaVariableValue target3 = var.withQualifier(to);
                    boolean united = this.uniteClasses(var, target3);
                    assert (united);
                    otherClassChanged = true;
                }
            }
        }
        this.checkInvariants();
        return otherClassChanged;
    }

    @NotNull
    private List<EqClass> splitEqClass(EqClass eqClass, DfaMemoryStateImpl other) {
        Int2ObjectOpenHashMap<EqClass> groupsInClasses = new Int2ObjectOpenHashMap<EqClass>();
        ArrayList<EqClass> groups2 = new ArrayList<EqClass>();
        for (DfaVariableValue value : eqClass.asList()) {
            EqClass list2;
            int otherClass = other.getEqClassIndex(value);
            if (otherClass == -1) {
                list2 = new EqClass(this.myFactory);
                groups2.add(list2);
            } else {
                list2 = (EqClass)groupsInClasses.get(otherClass);
                if (list2 == null) {
                    list2 = new EqClass(this.myFactory);
                    groupsInClasses.put(otherClass, list2);
                }
            }
            list2.add(value.getID());
        }
        groups2.addAll(groupsInClasses.values());
        ArrayList<EqClass> arrayList = groups2;
        if (arrayList == null) {
            DfaMemoryStateImpl.$$$reportNull$$$0(82);
        }
        return arrayList;
    }

    @Override
    public void widen() {
        this.myVariableTypes.replaceAll((var, type) -> type.widen());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 30, 37, 38, 48, 49, 50, 51, 52, 53, 55, 57, 58, 59, 60, 64, 65, 66, 67, 68, 70, 71, 82 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toCopy";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 30: 
            case 37: 
            case 38: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 71: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/memory/DfaMemoryStateImpl";
                break;
            }
            case 6: 
            case 12: 
            case 14: 
            case 16: 
            case 39: 
            case 54: 
            case 56: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfType";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaValue";
                break;
            }
            case 9: 
            case 10: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 18: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newType";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binOp";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value1";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value2";
                break;
            }
            case 25: 
            case 32: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 26: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaCond";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaRelation";
                break;
            }
            case 29: 
            case 31: 
            case 40: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftRange";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightRange";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sum";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lrType";
                break;
            }
            case 43: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaLeft";
                break;
            }
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaRight";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaVar";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiers";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierStatusMap";
                break;
            }
            case 74: 
            case 76: 
            case 77: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "that";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/memory/DfaMemoryStateImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createClosureState";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "pop";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "peek";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "extractRange";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getSumOverflowValues";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinOpRange";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getDfTypeIncludingDerived";
                break;
            }
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getDfType";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "canonicalize";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "canonicalizeQualifier";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "splitEqClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 30: 
            case 37: 
            case 38: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 71: 
            case 82: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "push";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "filterDfTypeOnAssignment";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateEqClassIndex";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "tryJoinExactly";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isSuperStateOf";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getEqClassIndex";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setDfType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateDfType";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "meetDfType";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "meetVariableType";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "propagateRangeBack";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "applyContractCondition";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "areEqual";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getRelation";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "applyCondition";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "applyRelationCondition";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "extractRange";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "applyRelationOnAddition";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "correctRelatedValues";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "applyDerivedVariablesEquivalence";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "applyDerivedInequality";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "applyRelation";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "applyLessThanRelation";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getDfTypeIncludingDerived";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getDfType";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "recordVariableType";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "canonicalize";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "canonicalizeQualifier";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "flushFieldsQualifiedBy";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "flushFields";
                break;
            }
            case 74: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "flushVariable";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "flushVariables";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "flushDependencies";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "flushQualifiedMethods";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "doFlush";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "afterMerge";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 4, 5, 30, 37, 38, 48, 49, 50, 51, 52, 53, 55, 57, 58, 59, 60, 64, 65, 66, 67, 68, 70, 71, 82 -> new IllegalStateException(string2);
        };
    }

    private final class QualifierStatusMap {
        private final Int2ObjectMap<QualifierStatus> myMap = new Int2ObjectOpenHashMap<QualifierStatus>();
        @Nullable
        private final Set<DfaValue> myQualifiersToFlush;
        private final boolean myClosure;

        private QualifierStatusMap(Set<DfaValue> qualifiersToFlush, boolean closure) {
            this.myQualifiersToFlush = qualifiersToFlush;
            this.myClosure = closure;
        }

        boolean shouldFlush(DfaVariableValue value) {
            return (this.myClosure ? value.canBeCapturedInClosure() : value.isFlushableByCalls()) && this.shouldFlush(value.getQualifier(), value.containsCalls());
        }

        boolean shouldFlush(@Nullable DfaValue qualifier, boolean hasCall) {
            if (qualifier == null) {
                return true;
            }
            QualifierStatus status = (QualifierStatus)((Object)this.myMap.get(qualifier.getID()));
            if (status == null) {
                status = this.calculate(qualifier);
                if (status != QualifierStatus.SHOULD_FLUSH_ALWAYS && qualifier instanceof DfaVariableValue) {
                    DfaVariableValue qualifierQualifier;
                    DfaVariableValue qualifierVar = (DfaVariableValue)qualifier;
                    if ((this.myClosure ? qualifierVar.canBeCapturedInClosure() : qualifierVar.isFlushableByCalls()) && this.shouldFlush(qualifierQualifier = qualifierVar.getQualifier(), qualifierVar.containsCalls())) {
                        status = QualifierStatus.SHOULD_FLUSH_ALWAYS;
                    }
                }
                this.myMap.put(qualifier.getID(), status);
            }
            return status == QualifierStatus.SHOULD_FLUSH_ALWAYS || hasCall && status == QualifierStatus.SHOULD_FLUSH_CALLS;
        }

        @NotNull
        private QualifierStatus calculate(@NotNull DfaValue qualifier) {
            DfType dfType;
            if (qualifier == null) {
                QualifierStatusMap.$$$reportNull$$$0(0);
            }
            if ((dfType = DfaMemoryStateImpl.this.getDfType(qualifier)).isImmutableQualifier()) {
                QualifierStatus qualifierStatus = QualifierStatus.SHOULD_NOT_FLUSH;
                if (qualifierStatus == null) {
                    QualifierStatusMap.$$$reportNull$$$0(1);
                }
                return qualifierStatus;
            }
            if (dfType.isLocal()) {
                QualifierStatus qualifierStatus = this.myQualifiersToFlush != null && this.myQualifiersToFlush.contains(qualifier) ? QualifierStatus.SHOULD_FLUSH_ALWAYS : QualifierStatus.SHOULD_NOT_FLUSH;
                if (qualifierStatus == null) {
                    QualifierStatusMap.$$$reportNull$$$0(2);
                }
                return qualifierStatus;
            }
            if (this.myQualifiersToFlush == null) {
                QualifierStatus qualifierStatus = QualifierStatus.SHOULD_FLUSH_ALWAYS;
                if (qualifierStatus == null) {
                    QualifierStatusMap.$$$reportNull$$$0(3);
                }
                return qualifierStatus;
            }
            boolean flushCalls = false;
            for (DfaValue qualifierToFlush : this.myQualifiersToFlush) {
                RelationType relation = DfaMemoryStateImpl.this.getRelation(qualifier, qualifierToFlush);
                if (relation == RelationType.EQ) {
                    QualifierStatus qualifierStatus = QualifierStatus.SHOULD_FLUSH_ALWAYS;
                    if (qualifierStatus == null) {
                        QualifierStatusMap.$$$reportNull$$$0(4);
                    }
                    return qualifierStatus;
                }
                DfType typeToFlush = DfaMemoryStateImpl.this.getDfType(qualifierToFlush);
                if (typeToFlush.isLocal()) continue;
                flushCalls = true;
                if (relation != null || !dfType.mayAlias(typeToFlush)) continue;
                QualifierStatus qualifierStatus = QualifierStatus.SHOULD_FLUSH_ALWAYS;
                if (qualifierStatus == null) {
                    QualifierStatusMap.$$$reportNull$$$0(5);
                }
                return qualifierStatus;
            }
            QualifierStatus qualifierStatus = flushCalls ? QualifierStatus.SHOULD_FLUSH_CALLS : QualifierStatus.SHOULD_NOT_FLUSH;
            if (qualifierStatus == null) {
                QualifierStatusMap.$$$reportNull$$$0(6);
            }
            return qualifierStatus;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/memory/DfaMemoryStateImpl$QualifierStatusMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/memory/DfaMemoryStateImpl$QualifierStatusMap";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "calculate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "calculate";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1, 2, 3, 4, 5, 6 -> new IllegalStateException(string2);
            };
        }
    }

    private static class StateMerger {
        private final DfaMemoryStateImpl myLeftState;
        private final DfaMemoryStateImpl myRightState;
        private boolean myMaybeThisSuper = true;
        private boolean myMaybeThatSuper = true;
        @Nullable
        private MergePatch mySingleDiff = null;

        private StateMerger(DfaMemoryStateImpl left, DfaMemoryStateImpl right) {
            this.myLeftState = left;
            this.myRightState = right;
        }

        boolean update(boolean thisSuper, boolean thatSuper, Supplier<MergePatch> singleDiff) {
            if (thisSuper && thatSuper) {
                return true;
            }
            MergePatch diff = null;
            if (this.myMaybeThatSuper && this.myMaybeThisSuper) {
                assert (this.mySingleDiff == null);
                diff = singleDiff.get();
            } else if (this.mySingleDiff != null) {
                diff = this.tryMergeDiffs(singleDiff);
            }
            this.myMaybeThisSuper &= thisSuper;
            this.myMaybeThatSuper &= thatSuper;
            if (!this.myMaybeThisSuper && !this.myMaybeThatSuper && diff == null) {
                return false;
            }
            this.mySingleDiff = diff;
            return true;
        }

        @Nullable
        private MergePatch tryMergeDiffs(Supplier<MergePatch> singleDiff) {
            if (!(this.mySingleDiff instanceof DropOrderingMergePatch)) {
                return null;
            }
            MergePatch diff = singleDiff.get();
            if (diff instanceof DropOrderingMergePatch && diff.myApplyToRight != this.mySingleDiff.myApplyToRight) {
                DistinctPairSet.DistinctPair oldPair = ((DropOrderingMergePatch)this.mySingleDiff).myPair;
                DistinctPairSet.DistinctPair newPair = ((DropOrderingMergePatch)diff).myPair;
                if (oldPair.getFirst().equals(newPair.getSecond()) && newPair.getFirst().equals(oldPair.getSecond())) {
                    return this.mySingleDiff;
                }
            }
            if (diff instanceof UpdateVariableMergePatch) {
                DfaVariableValue otherVar;
                boolean left;
                UpdateVariableMergePatch updateVar = (UpdateVariableMergePatch)diff;
                DfaVariableValue var = updateVar.myValue;
                DistinctPairSet.DistinctPair pair = ((DropOrderingMergePatch)this.mySingleDiff).myPair;
                if (pair.getFirst().contains(var.getID())) {
                    left = true;
                    otherVar = pair.getSecond().getCanonicalVariable();
                } else if (pair.getSecond().contains(var.getID())) {
                    left = false;
                    otherVar = pair.getFirst().getCanonicalVariable();
                } else {
                    return null;
                }
                if (otherVar == null) {
                    return null;
                }
                if (this.mySingleDiff.myApplyToRight) {
                    left = !left;
                }
                if (updateVar.myType.meetRelation(left ? RelationType.LT : RelationType.GT, this.myLeftState.getDfType(otherVar)).equals(this.myLeftState.getDfType(var)) && updateVar.myType.meetRelation(left ? RelationType.GT : RelationType.LT, this.myRightState.getDfType(otherVar)).equals(this.myRightState.getDfType(var))) {
                    return new DropOrderingMergePatch(this.mySingleDiff.myApplyToRight, pair, this.mySingleDiff.myPatcher.andThen(diff.myPatcher));
                }
            }
            return null;
        }

        boolean update(boolean thisSuper, boolean thatSuper) {
            return this.update(thisSuper, thatSuper, () -> null);
        }

        boolean updateVariable(DfaVariableValue value, DfType thisType, DfType thatType) {
            return this.update(thisType.isMergeable(thatType), thatType.isMergeable(thisType), () -> {
                DfType type = thisType.tryJoinExactly(thatType);
                if (type != null) {
                    return new UpdateVariableMergePatch(value, type);
                }
                return null;
            });
        }

        boolean updateEquivalence(DistinctPairSet.DistinctPair pair, int firstIndex, int secondIndex, boolean rightDistinct) {
            if (firstIndex != -1 && secondIndex != -1 && firstIndex != secondIndex) {
                return true;
            }
            return this.update(rightDistinct, !rightDistinct, () -> {
                DfaVariableValue canonicalVariable;
                if (firstIndex == secondIndex && !pair.isOrdered() && (canonicalVariable = pair.getFirst().getCanonicalVariable()) != null) {
                    return new MergePatch(!rightDistinct, ms -> ms.removeEquivalence(canonicalVariable));
                }
                return null;
            });
        }

        boolean updateOrdering(DistinctPairSet.DistinctPair pair, RelationType relation, boolean rightDistinct) {
            if (!(relation == null || pair.isOrdered() && relation != RelationType.LT)) {
                return true;
            }
            return this.update(rightDistinct, !rightDistinct, () -> {
                if (pair.isOrdered() && relation == RelationType.GT) {
                    return new DropOrderingMergePatch(rightDistinct, pair);
                }
                return null;
            });
        }

        DfaMemoryStateImpl merge(DfaMemoryStateImpl left, DfaMemoryStateImpl right) {
            if (this.myMaybeThisSuper) {
                return left;
            }
            if (this.myMaybeThatSuper) {
                return right;
            }
            assert (this.mySingleDiff != null);
            return this.mySingleDiff.apply(left, right);
        }
    }

    private static class MergePatch {
        final boolean myApplyToRight;
        final Consumer<DfaMemoryStateImpl> myPatcher;

        private MergePatch(boolean right, Consumer<DfaMemoryStateImpl> patcher) {
            this.myApplyToRight = right;
            this.myPatcher = patcher;
        }

        DfaMemoryStateImpl apply(DfaMemoryStateImpl left, DfaMemoryStateImpl right) {
            DfaMemoryStateImpl result2 = (this.myApplyToRight ? right : left).createCopy();
            this.myPatcher.accept(result2);
            result2.afterMerge(this.myApplyToRight ? left : right);
            return result2;
        }
    }

    static enum QualifierStatus {
        SHOULD_FLUSH_ALWAYS,
        SHOULD_FLUSH_CALLS,
        SHOULD_NOT_FLUSH;

    }

    private static class DropOrderingMergePatch
    extends MergePatch {
        private final DistinctPairSet.DistinctPair myPair;

        private DropOrderingMergePatch(boolean right, DistinctPairSet.DistinctPair pair) {
            this(right, pair, ms -> ms.myDistinctClasses.dropOrder(pair));
        }

        private DropOrderingMergePatch(boolean right, DistinctPairSet.DistinctPair pair, Consumer<DfaMemoryStateImpl> diff) {
            super(right, diff);
            this.myPair = pair;
        }
    }

    private static class UpdateVariableMergePatch
    extends MergePatch {
        private final DfaVariableValue myValue;
        private final DfType myType;

        private UpdateVariableMergePatch(DfaVariableValue value, DfType type) {
            super(false, (DfaMemoryStateImpl s) -> s.recordVariableType(value, type));
            this.myValue = value;
            this.myType = type;
        }
    }
}

