/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.memory;

import com.intellij.codeInspection.dataFlow.memory.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.memory.EqClass;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DistinctPairSet
extends AbstractSet<DistinctPair> {
    private final DfaMemoryStateImpl myState;
    private final LongOpenHashSet myData;

    public DistinctPairSet(DfaMemoryStateImpl state) {
        this.myState = state;
        this.myData = new LongOpenHashSet();
    }

    public DistinctPairSet(DfaMemoryStateImpl state, DistinctPairSet other) {
        this.myData = new LongOpenHashSet(other.myData);
        this.myState = state;
    }

    public boolean addOrdered(int firstIndex, int secondIndex) {
        LongOpenHashSet toAdd = new LongOpenHashSet();
        LongOpenHashSet toRemove2 = new LongOpenHashSet();
        toAdd.add(DistinctPairSet.createPair(firstIndex, secondIndex, true));
        toRemove2.add(DistinctPairSet.createPair(firstIndex, secondIndex, false));
        for (DistinctPair pair : this) {
            if (!pair.isOrdered()) continue;
            if (pair.myFirst == secondIndex) {
                if (pair.mySecond == firstIndex || this.myData.contains(DistinctPairSet.createPair(pair.mySecond, firstIndex, true))) {
                    return false;
                }
                toAdd.add(DistinctPairSet.createPair(firstIndex, pair.mySecond, true));
                toRemove2.add(DistinctPairSet.createPair(firstIndex, pair.mySecond, false));
                continue;
            }
            if (pair.mySecond != firstIndex) continue;
            if (this.myData.contains(DistinctPairSet.createPair(secondIndex, pair.myFirst, true))) {
                return false;
            }
            toAdd.add(DistinctPairSet.createPair(pair.myFirst, secondIndex, true));
            toRemove2.add(DistinctPairSet.createPair(pair.myFirst, secondIndex, false));
        }
        this.myData.removeAll(toRemove2);
        this.myData.addAll(toAdd);
        return true;
    }

    public void addUnordered(int firstIndex, int secondIndex) {
        if (!this.myData.contains(DistinctPairSet.createPair(firstIndex, secondIndex, true)) && !this.myData.contains(DistinctPairSet.createPair(secondIndex, firstIndex, true))) {
            this.myData.add(DistinctPairSet.createPair(firstIndex, secondIndex, false));
        }
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof DistinctPair) {
            DistinctPair dp = (DistinctPair)o;
            return this.myData.remove(DistinctPairSet.createPair(dp.myFirst, dp.mySecond, dp.myOrdered));
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof DistinctPair)) {
            return false;
        }
        DistinctPair dp = (DistinctPair)o;
        EqClass first2 = dp.getFirst();
        EqClass second2 = dp.getSecond();
        if (first2.isEmpty() || second2.isEmpty()) {
            return false;
        }
        int firstVal = first2.get(0);
        int secondVal = second2.get(0);
        int firstIndex = this.myState.getEqClassIndex(this.myState.getFactory().getValue(firstVal));
        if (firstIndex == -1) {
            return false;
        }
        int secondIndex = this.myState.getEqClassIndex(this.myState.getFactory().getValue(secondVal));
        if (secondIndex == -1) {
            return false;
        }
        long pair = DistinctPairSet.createPair(firstIndex, secondIndex, dp.isOrdered());
        return this.myData.contains(pair) && this.decode(pair).equals(dp);
    }

    @Override
    public Iterator<DistinctPair> iterator() {
        return new Iterator<DistinctPair>(){
            final LongIterator iterator;
            {
                this.iterator = DistinctPairSet.this.myData.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public DistinctPair next() {
                return DistinctPairSet.this.decode(this.iterator.nextLong());
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        };
    }

    @Override
    public int size() {
        return this.myData.size();
    }

    public boolean unite(int c1Index, int c2Index) {
        long[] distincts;
        LongArrayList c2Pairs = new LongArrayList();
        for (long distinct2 : distincts = this.myData.toLongArray()) {
            int pc1 = DistinctPairSet.low(distinct2);
            int pc2 = DistinctPairSet.high(distinct2);
            boolean addedToC1 = false;
            if (pc1 == c1Index || pc2 == c1Index) {
                addedToC1 = true;
                if (distinct2 < 0L && (pc1 == c1Index && this.myData.contains(DistinctPairSet.createPair(pc2, c2Index, true)) || pc2 == c1Index && this.myData.contains(DistinctPairSet.createPair(c2Index, pc1, true)))) {
                    return false;
                }
            }
            if (pc1 != c2Index && pc2 != c2Index) continue;
            if (addedToC1) {
                return false;
            }
            c2Pairs.add(distinct2);
        }
        for (int i2 = 0; i2 < c2Pairs.size(); ++i2) {
            long c2 = c2Pairs.getLong(i2);
            this.myData.remove(c2);
            if (c2 >= 0L) {
                this.myData.add(DistinctPairSet.createPair(c1Index, DistinctPairSet.low(c2) == c2Index ? DistinctPairSet.high(c2) : DistinctPairSet.low(c2), false));
                continue;
            }
            if (DistinctPairSet.low(c2) == c2Index) {
                this.myData.add(DistinctPairSet.createPair(c1Index, DistinctPairSet.high(c2), true));
                continue;
            }
            this.myData.add(DistinctPairSet.createPair(DistinctPairSet.low(c2), c1Index, true));
        }
        return true;
    }

    public void splitClass(int index2, int[] splitIndices) {
        LongArrayList toAdd = new LongArrayList();
        LongIterator iterator2 = this.myData.iterator();
        while (iterator2.hasNext()) {
            DistinctPair pair = this.decode(iterator2.nextLong());
            if (pair.myFirst == index2) {
                for (int splitIndex : splitIndices) {
                    toAdd.add(DistinctPairSet.createPair(splitIndex, pair.mySecond, pair.isOrdered()));
                }
                iterator2.remove();
                continue;
            }
            if (pair.mySecond != index2) continue;
            for (int splitIndex : splitIndices) {
                toAdd.add(DistinctPairSet.createPair(pair.myFirst, splitIndex, pair.isOrdered()));
            }
            iterator2.remove();
        }
        this.myData.addAll(toAdd);
    }

    public boolean areDistinctUnordered(int c1Index, int c2Index) {
        return this.myData.contains(DistinctPairSet.createPair(c1Index, c2Index, false));
    }

    @Nullable
    public RelationType getRelation(int c1Index, int c2Index) {
        if (this.areDistinctUnordered(c1Index, c2Index)) {
            return RelationType.NE;
        }
        if (this.myData.contains(DistinctPairSet.createPair(c1Index, c2Index, true))) {
            return RelationType.LT;
        }
        if (this.myData.contains(DistinctPairSet.createPair(c2Index, c1Index, true))) {
            return RelationType.GT;
        }
        return null;
    }

    private DistinctPair decode(long encoded) {
        boolean ordered = encoded < 0L;
        encoded = Math.abs(encoded);
        return new DistinctPair(DistinctPairSet.low(encoded), DistinctPairSet.high(encoded), ordered, this.myState.getEqClasses());
    }

    public void dropOrder(DistinctPair pair) {
        if (this.remove(pair)) {
            this.addUnordered(pair.myFirst, pair.mySecond);
        }
    }

    private static long createPair(int low, int high, boolean ordered) {
        if (ordered) {
            return -(((long)high << 32) + (long)low);
        }
        return low < high ? ((long)low << 32) + (long)high : ((long)high << 32) + (long)low;
    }

    private static int low(long l) {
        return (int)Math.abs(l);
    }

    private static int high(long l) {
        return (int)((Math.abs(l) & 0xFFFFFFFF00000000L) >> 32);
    }

    public static final class DistinctPair {
        private final int myFirst;
        private final int mySecond;
        private final boolean myOrdered;
        private final List<EqClass> myList;

        private DistinctPair(int first2, int second2, boolean ordered, List<EqClass> list2) {
            this.myFirst = first2;
            this.mySecond = second2;
            this.myOrdered = ordered;
            this.myList = list2;
        }

        @NotNull
        public EqClass getFirst() {
            EqClass eqClass = this.myList.get(this.myFirst);
            if (eqClass == null) {
                DistinctPair.$$$reportNull$$$0(0);
            }
            return eqClass;
        }

        public int getFirstIndex() {
            return this.myFirst;
        }

        @NotNull
        public EqClass getSecond() {
            EqClass eqClass = this.myList.get(this.mySecond);
            if (eqClass == null) {
                DistinctPair.$$$reportNull$$$0(1);
            }
            return eqClass;
        }

        public int getSecondIndex() {
            return this.mySecond;
        }

        public void check() {
            if (this.myList.get(this.myFirst) == null) {
                throw new IllegalStateException(this + ": EqClass " + this.myFirst + " is missing");
            }
            if (this.myList.get(this.mySecond) == null) {
                throw new IllegalStateException(this + ": EqClass " + this.mySecond + " is missing");
            }
        }

        public boolean isOrdered() {
            return this.myOrdered;
        }

        @Nullable
        public EqClass getOtherClass(int eqClassIndex) {
            if (this.myFirst == eqClassIndex) {
                return this.getSecond();
            }
            if (this.mySecond == eqClassIndex) {
                return this.getFirst();
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof DistinctPair)) {
                return false;
            }
            DistinctPair that = (DistinctPair)obj;
            if (that.myOrdered != this.myOrdered) {
                return false;
            }
            return that.getFirst().equals(this.getFirst()) && that.getSecond().equals(this.getSecond()) || !this.myOrdered && that.getSecond().equals(this.getFirst()) && that.getFirst().equals(this.getSecond());
        }

        public int hashCode() {
            return this.getFirst().hashCode() * (this.myOrdered ? 31 : 1) + this.getSecond().hashCode();
        }

        public String toString() {
            return "{" + this.myList.get(this.myFirst) + (this.myOrdered ? "<" : "!=") + this.myList.get(this.mySecond) + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInspection/dataFlow/memory/DistinctPairSet$DistinctPair";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFirst";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSecond";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

