/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.memory;

import com.intellij.codeInspection.dataFlow.memory.SortedIntSet;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EqClass
extends SortedIntSet
implements Iterable<DfaVariableValue> {
    private final DfaValueFactory myFactory;
    public static final Comparator<DfaVariableValue> CANONICAL_VARIABLE_COMPARATOR = Comparator.nullsFirst((v1, v2) -> {
        int result2 = CANONICAL_VARIABLE_COMPARATOR.compare(v1.getQualifier(), v2.getQualifier());
        if (result2 != 0) {
            return result2;
        }
        return Integer.compare(v1.getID(), v2.getID());
    });

    public EqClass(DfaValueFactory factory2) {
        this.myFactory = factory2;
    }

    public EqClass(@NotNull EqClass toCopy) {
        if (toCopy == null) {
            EqClass.$$$reportNull$$$0(0);
        }
        super(toCopy.toNativeArray());
        this.myFactory = toCopy.myFactory;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        for (int i2 = 0; i2 < this.size(); ++i2) {
            if (i2 > 0) {
                buf.append(", ");
            }
            int value = this.get(i2);
            DfaValue dfaValue = this.myFactory.getValue(value);
            buf.append(dfaValue);
        }
        buf.append(")");
        return buf.toString();
    }

    public DfaVariableValue getVariable(int index2) {
        return (DfaVariableValue)this.myFactory.getValue(this.get(index2));
    }

    public List<DfaVariableValue> asList() {
        ArrayList<DfaVariableValue> vars = new ArrayList<DfaVariableValue>(this.size());
        this.forValues(id -> vars.add((DfaVariableValue)this.myFactory.getValue(id)));
        return vars;
    }

    @Nullable
    public DfaVariableValue getCanonicalVariable() {
        if (this.size() == 1) {
            return this.getVariable(0);
        }
        return StreamEx.of(this.iterator()).min(CANONICAL_VARIABLE_COMPARATOR).orElse(null);
    }

    @Override
    @NotNull
    public Iterator<DfaVariableValue> iterator() {
        return new Iterator<DfaVariableValue>(){
            int pos;

            @Override
            public boolean hasNext() {
                return this.pos < EqClass.this.size();
            }

            @Override
            public DfaVariableValue next() {
                if (this.pos >= EqClass.this.size()) {
                    throw new NoSuchElementException();
                }
                return (DfaVariableValue)EqClass.this.myFactory.getValue(EqClass.this.get(this.pos++));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toCopy", "com/intellij/codeInspection/dataFlow/memory/EqClass", "<init>"));
    }
}

