/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.rangeSet;

import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class LongRangeUtil {
    LongRangeUtil() {
    }

    static int gcd(int x, int y) {
        while (x != 0) {
            int z = x;
            x = y % z;
            y = z;
        }
        return y;
    }

    static long clearBit(long value, int bitNumber) {
        return value & (1L << bitNumber ^ 0xFFFFFFFFFFFFFFFFL);
    }

    static long setBit(long value, int bitNumber) {
        return value | 1L << bitNumber;
    }

    static boolean isSet(long value, int bitNumber) {
        return (value & 1L << bitNumber) != 0L;
    }

    static long extractBits(long value, int offset2, int count2) {
        long shifted = value >>> offset2;
        return count2 == 64 ? shifted : shifted & (1L << count2) - 1L;
    }

    static int remainder(long dividend, int divisor) {
        return (int)((dividend %= (long)divisor) < 0L ? dividend + (long)divisor : dividend);
    }

    static long rotateRemainders(long bits, int mod, int amount) {
        return LongRangeUtil.extractBits(bits, amount, 64) | LongRangeUtil.extractBits(bits, 0, amount) << mod - amount;
    }

    static class BitString {
        static final BitString UNSURE = new BitString(0L, 0L);
        final long myBits;
        final long myMask;

        BitString(long bits, long mask) {
            this.myBits = bits & mask;
            this.myMask = mask;
        }

        @NotNull
        BitString unite(BitString other) {
            long diff = this.myBits ^ other.myBits;
            return new BitString(this.myBits, this.myMask & other.myMask & (diff ^ 0xFFFFFFFFFFFFFFFFL));
        }

        @Nullable
        BitString intersect(BitString other) {
            long intersectMask = this.myMask & other.myMask;
            if ((this.myBits & intersectMask) != (other.myBits & intersectMask)) {
                return null;
            }
            return new BitString(this.myBits | other.myBits, this.myMask | other.myMask);
        }

        @NotNull
        ThreeState get(int bit) {
            ThreeState threeState = LongRangeUtil.isSet(this.myMask, bit) ? ThreeState.fromBoolean(LongRangeUtil.isSet(this.myBits, bit)) : ThreeState.UNSURE;
            if (threeState == null) {
                BitString.$$$reportNull$$$0(0);
            }
            return threeState;
        }

        @NotNull
        BitString and(BitString other) {
            long andBits = this.myBits & other.myBits;
            long andMask = this.myMask ^ this.myBits | other.myMask ^ other.myBits | andBits;
            return new BitString(andBits, andMask);
        }

        @NotNull
        BitString or(BitString other) {
            long orBits = this.myBits | other.myBits;
            long orMask = (this.myMask ^ this.myBits) & (other.myMask ^ other.myBits) | orBits;
            return new BitString(orBits, orMask);
        }

        @NotNull
        BitString xor(BitString other) {
            long xorBits = this.myBits ^ other.myBits;
            long xorMask = this.myMask & other.myMask;
            return new BitString(xorBits, xorMask);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("[");
            for (int i2 = 63; i2 >= 0; --i2) {
                sb.append((char)(LongRangeUtil.isSet(this.myMask, i2) ? (LongRangeUtil.isSet(this.myBits, i2) ? 49 : 48) : 63));
                if (i2 == 0 || i2 % 8 != 0) continue;
                sb.append(".");
            }
            sb.append("]");
            return sb.toString();
        }

        @NotNull
        static BitString fromRange(long from, long to) {
            if (from == to) {
                return new BitString(from, -1L);
            }
            long bits = 0L;
            long mask = -1L;
            while (true) {
                int toBit;
                int fromBit;
                if ((fromBit = 63 - Long.numberOfLeadingZeros(from)) != (toBit = 63 - Long.numberOfLeadingZeros(to))) {
                    for (int i2 = 0; i2 <= Math.max(fromBit, toBit); ++i2) {
                        mask = LongRangeUtil.clearBit(mask, i2);
                    }
                    break;
                }
                if (fromBit == 0) break;
                bits = LongRangeUtil.setBit(bits, fromBit);
                from = LongRangeUtil.clearBit(from, fromBit);
                to = LongRangeUtil.clearBit(to, fromBit);
            }
            return new BitString(bits, mask);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/rangeSet/LongRangeUtil$BitString", "get"));
        }
    }
}

