/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum RelationType {
    LE("<="),
    LT("<"),
    GE(">="),
    GT(">"),
    EQ("=="),
    NE("!="),
    IS("is"),
    IS_NOT("isn't");

    private final String myName;

    private RelationType(String name) {
        this.myName = name;
    }

    @Nullable
    public RelationType meet(@NotNull RelationType other) {
        if (other == null) {
            RelationType.$$$reportNull$$$0(0);
        }
        if (this.isSubRelation(other)) {
            return other;
        }
        if (other.isSubRelation(this)) {
            return this;
        }
        if (this == NE && other == LE || this == LE && other == NE) {
            return LT;
        }
        if (this == NE && other == GE || this == GE && other == NE) {
            return GT;
        }
        if (this == LE && other == GE || this == GE && other == LE) {
            return EQ;
        }
        return null;
    }

    public boolean isSubRelation(RelationType other) {
        if (other == this) {
            return true;
        }
        return switch (this) {
            case LE -> {
                if (other == LT || other == EQ) {
                    yield true;
                }
                yield false;
            }
            case GE -> {
                if (other == GT || other == EQ) {
                    yield true;
                }
                yield false;
            }
            case NE -> {
                if (other == LT || other == GT) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @NotNull
    public RelationType getNegated() {
        RelationType relationType = switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case LE -> GT;
            case LT -> GE;
            case GE -> LT;
            case GT -> LE;
            case EQ -> NE;
            case NE -> EQ;
            case IS -> IS_NOT;
            case IS_NOT -> IS;
        };
        if (relationType == null) {
            RelationType.$$$reportNull$$$0(1);
        }
        return relationType;
    }

    @Nullable
    public RelationType getFlipped() {
        return switch (this) {
            case LE -> GE;
            case LT -> GT;
            case GE -> LE;
            case GT -> LT;
            case NE, EQ -> this;
            default -> null;
        };
    }

    public boolean isInequality() {
        return this == LE || this == GE || this == LT || this == GT || this == NE;
    }

    public String toString() {
        return this.myName;
    }

    public static RelationType equivalence(boolean equal) {
        return equal ? EQ : NE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/value/RelationType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/value/RelationType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNegated";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "meet";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }
}

