/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.InspectionProfileConvertor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeveritiesProvider;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.ApplicationInspectionProfileManager;
import com.intellij.codeInspection.ex.ApplicationInspectionProfileManagerBase;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeWithMe.ClientId;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.serviceContainer.NonInjectable;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="InspectionProfileManager", storages={@Storage(value="editor.xml")}, additionalExportDirectory="inspection")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0017\u0018\u0000 \u001c2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001\u001cB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0019\u001a\u00020\rH\u0016J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0003H\u0016R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/intellij/codeInspection/ex/ApplicationInspectionProfileManager;", "Lcom/intellij/codeInspection/ex/ApplicationInspectionProfileManagerBase;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "()V", "schemeManagerFactory", "Lcom/intellij/openapi/options/SchemeManagerFactory;", "(Lcom/intellij/openapi/options/SchemeManagerFactory;)V", "converter", "Lcom/intellij/codeInsight/daemon/InspectionProfileConvertor;", "getConverter", "()Lcom/intellij/codeInsight/daemon/InspectionProfileConvertor;", "rootProfileName", "", "getRootProfileName", "()Ljava/lang/String;", "fireProfileChanged", "", "profile", "Lcom/intellij/codeInspection/ex/InspectionProfileImpl;", "forceInitProfilesInTestUntil", "disposable", "Lcom/intellij/openapi/Disposable;", "getState", "loadProfile", "path", "loadState", "state", "Companion", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nApplicationInspectionProfileManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApplicationInspectionProfileManager.kt\ncom/intellij/codeInspection/ex/ApplicationInspectionProfileManager\n+ 2 ProjectUtil.kt\ncom/intellij/openapi/project/ProjectUtil\n*L\n1#1,121:1\n319#2,8:122\n*S KotlinDebug\n*F\n+ 1 ApplicationInspectionProfileManager.kt\ncom/intellij/codeInspection/ex/ApplicationInspectionProfileManager\n*L\n93#1:122,8\n*E\n"})
public class ApplicationInspectionProfileManager
extends ApplicationInspectionProfileManagerBase
implements PersistentStateComponent<Element> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NonInjectable
    @TestOnly
    public ApplicationInspectionProfileManager(@NotNull SchemeManagerFactory schemeManagerFactory) {
        Intrinsics.checkNotNullParameter((Object)schemeManagerFactory, (String)"schemeManagerFactory");
        super(schemeManagerFactory);
        ApplicationInspectionProfileManager.Companion.registerProvidedSeverities();
    }

    @NotNull
    public InspectionProfileConvertor getConverter() {
        return new InspectionProfileConvertor(this);
    }

    @NotNull
    public final String getRootProfileName() {
        String string2 = this.getSchemeManager().getCurrentSchemeName();
        if (string2 == null) {
            string2 = "Default";
        }
        return string2;
    }

    public ApplicationInspectionProfileManager() {
        this(SchemeManagerFactory.Companion.getInstance());
    }

    @TestOnly
    public final void forceInitProfilesInTestUntil(@NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.setLOAD_PROFILES(true);
        this.getProfilesAreInitialized();
        Disposer.register(disposable, () -> ApplicationInspectionProfileManager.forceInitProfilesInTestUntil$lambda$0(this));
    }

    @Override
    @Nullable
    public Element getState() {
        Element state = new Element("state");
        this.getSeverityRegistrar().writeExternal(state);
        return state;
    }

    @Override
    public void loadState(@NotNull Element state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.getSeverityRegistrar().readExternal(state);
    }

    @Override
    public void fireProfileChanged(@NotNull InspectionProfileImpl profile) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        boolean $i$f$processOpenedProjects = false;
        Project[] projectArray = ProjectManager.getInstanceIfCreated();
        if (projectArray != null && (projectArray = projectArray.getOpenProjects()) != null) {
            for (Project project$iv : projectArray) {
                if (project$iv.isDisposed() || !project$iv.isInitialized()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)project$iv, (String)"project");
                Project project2 = project$iv;
                boolean bl = false;
                ProjectInspectionProfileManager.Companion.getInstance(project2).fireProfileChanged(profile);
            }
        }
    }

    @Override
    @Nullable
    public InspectionProfileImpl loadProfile(@NotNull String path2) throws IOException, JDOMException {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        try {
            return super.loadProfile(path2);
        }
        catch (IOException e) {
            throw e;
        }
        catch (JDOMException e) {
            throw e;
        }
        catch (Exception ignored) {
            Path file2 = Paths.get(path2, new String[0]);
            ApplicationManager.getApplication().invokeLater(() -> ApplicationInspectionProfileManager.loadProfile$lambda$2(file2), ModalityState.NON_MODAL);
            return this.getProfile(path2, false);
        }
    }

    private static final void forceInitProfilesInTestUntil$lambda$0(ApplicationInspectionProfileManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.setLOAD_PROFILES(false);
    }

    private static final void loadProfile$lambda$2(Path $file) {
        Object[] objectArray = new Object[]{0, $file};
        Messages.showErrorDialog((String)InspectionsBundle.message("inspection.error.loading.message", objectArray), (String)InspectionsBundle.message("inspection.errors.occurred.dialog.title", new Object[0]));
    }

    @JvmStatic
    @NotNull
    public static final ApplicationInspectionProfileManager getInstanceImpl() {
        return Companion.getInstanceImpl();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lcom/intellij/codeInspection/ex/ApplicationInspectionProfileManager$Companion;", "", "()V", "getInstanceImpl", "Lcom/intellij/codeInspection/ex/ApplicationInspectionProfileManager;", "registerProvidedSeverities", "", "intellij.platform.lang.impl"})
    @SourceDebugExtension(value={"SMAP\nApplicationInspectionProfileManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApplicationInspectionProfileManager.kt\ncom/intellij/codeInspection/ex/ApplicationInspectionProfileManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,121:1\n39#2,3:122\n*S KotlinDebug\n*F\n+ 1 ApplicationInspectionProfileManager.kt\ncom/intellij/codeInspection/ex/ApplicationInspectionProfileManager$Companion\n*L\n46#1:122,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ApplicationInspectionProfileManager getInstanceImpl() {
            boolean $i$f$service = false;
            Class<InspectionProfileManager> serviceClass$iv = InspectionProfileManager.class;
            InspectionProfileManager inspectionProfileManager = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (inspectionProfileManager == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (ApplicationInspectionProfileManager)inspectionProfileManager;
        }

        private final void registerProvidedSeverities() {
            HashMap<String, HighlightInfoType> map2 = new HashMap<String, HighlightInfoType>();
            SeveritiesProvider.EP_NAME.forEachExtensionSafe(arg_0 -> Companion.registerProvidedSeverities$lambda$0((Function1)new Function1<SeveritiesProvider, Unit>(map2){
                final /* synthetic */ HashMap<String, HighlightInfoType> $map;
                {
                    this.$map = $map;
                    super(1);
                }

                public final void invoke(SeveritiesProvider provider2) {
                    for (HighlightInfoType t : provider2.getSeveritiesHighlightInfoTypes()) {
                        HighlightSeverity highlightSeverity;
                        Intrinsics.checkNotNullExpressionValue((Object)t.getSeverity(null), (String)"t.getSeverity(null)");
                        Icon icon2 = t instanceof HighlightInfoType.Iconable ? IconLoader.createLazy(() -> registerProvidedSeverities.1.invoke$lambda$0(t)) : null;
                        this.$map.put(highlightSeverity.getName(), t);
                        HighlightDisplayLevel.registerSeverity(highlightSeverity, t.getAttributesKey(), icon2);
                    }
                }

                private static final Icon invoke$lambda$0(HighlightInfoType $t) {
                    Intrinsics.checkNotNull((Object)$t, (String)"null cannot be cast to non-null type com.intellij.codeInsight.daemon.impl.HighlightInfoType.Iconable");
                    return ((HighlightInfoType.Iconable)((Object)$t)).getIcon();
                }
            }, arg_0));
            if (!((Map)map2).isEmpty()) {
                SeverityRegistrar.registerStandard((Map<String, ? extends HighlightInfoType>)map2);
            }
        }

        private static final void registerProvidedSeverities$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

