/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionToolResultExporter;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.ex.GlobalInspectionContextUtil;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.TripleFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BatchModeDescriptorsUtil {
    private static final TripleFunction<LocalInspectionTool, PsiElement, GlobalInspectionContext, RefElement> CONVERT = (tool, element, context2) -> {
        PsiLanguageInjectionHost injectionHost = InjectedLanguageManager.getInstance(context2.getProject()).getInjectionHost((PsiElement)element);
        if (injectionHost != null) {
            element = injectionHost;
        }
        PsiNamedElement problemElement = BatchModeDescriptorsUtil.getContainerElement(element, tool, context2);
        RefElement refElement = context2.getRefManager().getReference(problemElement);
        if (refElement == null && problemElement != null) {
            refElement = GlobalInspectionContextUtil.retrieveRefElement(element, context2);
        }
        return refElement;
    };

    static void addProblemDescriptors(@NotNull Collection<? extends ProblemDescriptor> descriptors, boolean filterSuppressed, @NotNull GlobalInspectionContext context2, @Nullable LocalInspectionTool tool, @NotNull InspectionToolResultExporter dpi, @NotNull TripleFunction<? super LocalInspectionTool, ? super PsiElement, ? super GlobalInspectionContext, ? extends RefElement> getProblemElementFunction) {
        RefElement refElement;
        if (descriptors == null) {
            BatchModeDescriptorsUtil.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            BatchModeDescriptorsUtil.$$$reportNull$$$0(1);
        }
        if (dpi == null) {
            BatchModeDescriptorsUtil.$$$reportNull$$$0(2);
        }
        if (getProblemElementFunction == null) {
            BatchModeDescriptorsUtil.$$$reportNull$$$0(3);
        }
        if (descriptors.isEmpty()) {
            return;
        }
        HashMap<RefElement, List> problems = new HashMap<RefElement, List>();
        RefManagerImpl refManager = (RefManagerImpl)context2.getRefManager();
        for (ProblemDescriptor problemDescriptor : descriptors) {
            String alternativeId;
            String id;
            PsiElement element = problemDescriptor.getPsiElement();
            if (element == null || filterSuppressed && (refManager.isDeclarationsFound() && (context2.isSuppressed(element, id = tool.getID()) || (alternativeId = tool.getAlternativeID()) != null && !alternativeId.equals(id) && context2.isSuppressed(element, alternativeId)) || SuppressionUtil.inspectionResultSuppressed(element, tool))) continue;
            refElement = getProblemElementFunction.fun(tool, element, context2);
            List elementProblems = problems.computeIfAbsent(refElement, __ -> new ArrayList());
            elementProblems.add(problemDescriptor);
        }
        for (Map.Entry entry : problems.entrySet()) {
            List problemDescriptors = (List)entry.getValue();
            refElement = (RefElement)entry.getKey();
            CommonProblemDescriptor[] descriptions = problemDescriptors.toArray(CommonProblemDescriptor.EMPTY_ARRAY);
            dpi.addProblemElement((RefEntity)refElement, filterSuppressed, descriptions);
        }
    }

    public static void addProblemDescriptors(@NotNull Collection<? extends ProblemDescriptor> descriptors, @NotNull InspectionToolResultExporter dpi, boolean filterSuppressed, @NotNull GlobalInspectionContext inspectionContext, @NotNull LocalInspectionTool tool) {
        if (descriptors == null) {
            BatchModeDescriptorsUtil.$$$reportNull$$$0(4);
        }
        if (dpi == null) {
            BatchModeDescriptorsUtil.$$$reportNull$$$0(5);
        }
        if (inspectionContext == null) {
            BatchModeDescriptorsUtil.$$$reportNull$$$0(6);
        }
        if (tool == null) {
            BatchModeDescriptorsUtil.$$$reportNull$$$0(7);
        }
        BatchModeDescriptorsUtil.addProblemDescriptors(descriptors, filterSuppressed, inspectionContext, tool, dpi, CONVERT);
    }

    public static PsiNamedElement getContainerElement(@Nullable PsiElement element, @NotNull LocalInspectionTool tool, @NotNull GlobalInspectionContext context2) {
        if (tool == null) {
            BatchModeDescriptorsUtil.$$$reportNull$$$0(8);
        }
        if (context2 == null) {
            BatchModeDescriptorsUtil.$$$reportNull$$$0(9);
        }
        if (element == null) {
            return null;
        }
        PsiNamedElement containerFromTool = tool.getProblemElement(element);
        if (containerFromTool != null && !(containerFromTool instanceof PsiFile)) {
            return containerFromTool;
        }
        PsiNamedElement container = context2.getRefManager().getContainerElement(element);
        return container != null ? container : containerFromTool;
    }

    public static CommonProblemDescriptor @NotNull [] flattenDescriptors(@NotNull List<CommonProblemDescriptor[]> descriptors) {
        if (descriptors == null) {
            BatchModeDescriptorsUtil.$$$reportNull$$$0(10);
        }
        CommonProblemDescriptor[] commonProblemDescriptorArray = (CommonProblemDescriptor[])descriptors.stream().flatMap(ds -> Arrays.stream(ds)).toArray(CommonProblemDescriptor.ARRAY_FACTORY::create);
        if (commonProblemDescriptorArray == null) {
            BatchModeDescriptorsUtil.$$$reportNull$$$0(11);
        }
        return commonProblemDescriptorArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dpi";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getProblemElementFunction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionContext";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/BatchModeDescriptorsUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/BatchModeDescriptorsUtil";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addProblemDescriptors";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getContainerElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "flattenDescriptors";
                break;
            }
            case 11: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 11 -> new IllegalStateException(string2);
        };
    }
}

