/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModelKt;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisableInspectionToolAction
extends IntentionAndQuickFixAction
implements Iconable {
    private final String myToolId;

    public DisableInspectionToolAction(LocalInspectionTool tool) {
        this.myToolId = tool.getShortName();
    }

    public DisableInspectionToolAction(HighlightDisplayKey key) {
        this.myToolId = key.toString();
    }

    @Override
    @NotNull
    public String getName() {
        String string2 = DisableInspectionToolAction.getNameText();
        if (string2 == null) {
            DisableInspectionToolAction.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string2 = DisableInspectionToolAction.getNameText();
        if (string2 == null) {
            DisableInspectionToolAction.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @Override
    public boolean isAvailable(@NotNull Project project2, Editor editor2, PsiFile file2) {
        InspectionProjectProfileManager profileManager;
        InspectionProfileImpl inspectionProfile;
        InspectionToolWrapper toolWrapper;
        if (project2 == null) {
            DisableInspectionToolAction.$$$reportNull$$$0(2);
        }
        return (toolWrapper = (inspectionProfile = (profileManager = InspectionProjectProfileManager.getInstance(project2)).getCurrentProfile()).getInspectionTool(this.myToolId, project2)) == null || !toolWrapper.getDefaultLevel().isNonSwitchable();
    }

    @Override
    public void applyFix(@NotNull Project project2, PsiFile file2, @Nullable Editor editor2) {
        if (project2 == null) {
            DisableInspectionToolAction.$$$reportNull$$$0(3);
        }
        InspectionProfileModifiableModelKt.modifyAndCommitProjectProfile(project2, it -> it.disableTool(this.myToolId, file2));
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public Icon getIcon(int flags) {
        return AllIcons.Actions.Cancel;
    }

    @IntentionName
    public static String getNameText() {
        return InspectionsBundle.message("disable.inspection.action.name", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/DisableInspectionToolAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/DisableInspectionToolAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 2, 3 -> new IllegalArgumentException(string2);
        };
    }
}

