/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.lang.InspectionExtensionsFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditInspectionToolsSettingsInSuppressedPlaceIntention
implements IntentionAction {
    private String myId;
    private String myDisplayName;

    @Override
    @NotNull
    public String getFamilyName() {
        String string2 = InspectionsBundle.message("edit.options.of.reporter.inspection.family", new Object[0]);
        if (string2 == null) {
            EditInspectionToolsSettingsInSuppressedPlaceIntention.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getText() {
        String string2 = InspectionsBundle.message("edit.inspection.options", this.myDisplayName);
        if (string2 == null) {
            EditInspectionToolsSettingsInSuppressedPlaceIntention.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @Nullable
    private static String getSuppressedId(Editor editor2, PsiFile file2) {
        int offset2 = editor2.getCaretModel().getOffset();
        for (PsiElement element = file2.findElementAt(offset2); element != null && !(element instanceof PsiFile); element = element.getParent()) {
            for (InspectionExtensionsFactory factory2 : InspectionExtensionsFactory.EP_NAME.getExtensionList()) {
                String suppressedIds = factory2.getSuppressedInspectionIdsIn(element);
                if (suppressedIds == null) continue;
                for (String id : StringUtil.split(suppressedIds, ",")) {
                    if (!EditInspectionToolsSettingsInSuppressedPlaceIntention.isCaretOnSuppressedId(file2, offset2, id)) continue;
                    return id;
                }
            }
        }
        return null;
    }

    private static boolean isCaretOnSuppressedId(PsiFile file2, int caretOffset, String suppressedId) {
        int end;
        int start;
        CharSequence fileText = file2.getViewProvider().getContents();
        return StringUtil.indexOf(fileText.subSequence(start = Math.max(0, caretOffset - suppressedId.length()), end = Math.min(caretOffset + suppressedId.length(), fileText.length())), suppressedId) >= 0;
    }

    @Override
    public boolean isAvailable(@NotNull Project project2, Editor editor2, PsiFile file2) {
        if (project2 == null) {
            EditInspectionToolsSettingsInSuppressedPlaceIntention.$$$reportNull$$$0(2);
        }
        this.myId = EditInspectionToolsSettingsInSuppressedPlaceIntention.getSuppressedId(editor2, file2);
        if (this.myId != null) {
            InspectionToolWrapper toolWrapper = this.getTool(project2, file2);
            if (toolWrapper == null) {
                return false;
            }
            this.myDisplayName = toolWrapper.getDisplayName();
        }
        return this.myId != null;
    }

    @Nullable
    private InspectionToolWrapper getTool(Project project2, PsiFile file2) {
        InspectionProjectProfileManager projectProfileManager = InspectionProjectProfileManager.getInstance(project2);
        InspectionProfileImpl inspectionProfile = projectProfileManager.getCurrentProfile();
        return inspectionProfile.getToolById(this.myId, file2);
    }

    @Override
    public void invoke(@NotNull Project project2, Editor editor2, PsiFile file2) throws IncorrectOperationException {
        InspectionToolWrapper toolWrapper;
        if (project2 == null) {
            EditInspectionToolsSettingsInSuppressedPlaceIntention.$$$reportNull$$$0(3);
        }
        if ((toolWrapper = this.getTool(project2, file2)) == null) {
            return;
        }
        InspectionProjectProfileManager projectProfileManager = InspectionProjectProfileManager.getInstance(project2);
        InspectionProfileImpl inspectionProfile = projectProfileManager.getCurrentProfile();
        EditInspectionToolsSettingsAction.editToolSettings(project2, inspectionProfile, toolWrapper.getShortName());
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        if (project2 == null) {
            EditInspectionToolsSettingsInSuppressedPlaceIntention.$$$reportNull$$$0(4);
        }
        if (editor2 == null) {
            EditInspectionToolsSettingsInSuppressedPlaceIntention.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            EditInspectionToolsSettingsInSuppressedPlaceIntention.$$$reportNull$$$0(6);
        }
        return new IntentionPreviewInfo.Html(InspectionsBundle.message("edit.inspection.options.preview", this.myDisplayName));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/EditInspectionToolsSettingsInSuppressedPlaceIntention";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/EditInspectionToolsSettingsInSuppressedPlaceIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 2, 3, 4, 5, 6 -> new IllegalArgumentException(string2);
        };
    }
}

