/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.HTMLComposer;
import com.intellij.codeInspection.lang.HTMLComposerExtension;
import com.intellij.codeInspection.lang.InspectionExtensionsFactory;
import com.intellij.codeInspection.reference.RefDirectory;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefProject;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.lang.Language;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HTMLComposerImpl
extends HTMLComposer {
    private final int[] myListStack;
    private int myListStackTop = -1;
    private final Map<Key, HTMLComposerExtension> myExtensions = new HashMap<Key, HTMLComposerExtension>();
    private final Map<Language, HTMLComposerExtension> myLanguageExtensions = new HashMap<Language, HTMLComposerExtension>();
    @NonNls
    protected static final String BR = "<br>";
    @NonNls
    public static final String NBSP = "&nbsp;";
    @NonNls
    public static final String CODE_CLOSING = "</code>";
    @NonNls
    public static final String CODE_OPENING = "<code>";
    @NonNls
    public static final String B_OPENING = "<b>";
    @NonNls
    public static final String B_CLOSING = "</b>";
    @NonNls
    protected static final String CLOSE_TAG = "\">";
    @NonNls
    public static final String A_HREF_OPENING = "<a HREF=\"";
    @NonNls
    public static final String A_CLOSING = "</a>";

    protected HTMLComposerImpl() {
        this.myListStack = new int[5];
        for (InspectionExtensionsFactory factory2 : InspectionExtensionsFactory.EP_NAME.getExtensionList()) {
            HTMLComposerExtension extension2 = factory2.createHTMLComposerExtension(this);
            if (extension2 == null) continue;
            this.myExtensions.put(extension2.getID(), extension2);
            extension2.getLanguages().forEach(l -> this.myLanguageExtensions.put((Language)l, extension2));
        }
    }

    public abstract void compose(@NotNull StringBuilder var1, RefEntity var2);

    public void compose(@NotNull StringBuilder buf, RefEntity refElement, CommonProblemDescriptor descriptor2) {
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(0);
        }
    }

    protected void genPageHeader(@NotNull StringBuilder buf, RefEntity refEntity) {
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(1);
        }
        if (refEntity instanceof RefElement) {
            RefElement refElement = (RefElement)refEntity;
            HTMLComposerImpl.appendHeading(buf, AnalysisBundle.message("inspection.export.results.capitalized.location", new Object[0]));
            buf.append("<div class=\"location\">");
            this.appendShortName(buf, refElement);
            buf.append(BR);
            buf.append("in ");
            this.appendLocation(buf, refElement);
            buf.append("</div>");
            buf.append(BR).append(BR);
        }
    }

    private void appendLocation(@NotNull StringBuilder buf, RefElement refElement) {
        HTMLComposerExtension extension2;
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(2);
        }
        if ((extension2 = this.getLanguageExtension(refElement)) != null) {
            extension2.appendLocation(refElement, buf);
        }
        if (refElement instanceof RefFile) {
            buf.append(AnalysisBundle.message("inspection.export.results.file", new Object[0]));
            buf.append(NBSP);
            this.appendElementReference(buf, refElement, false);
        } else if (refElement instanceof RefDirectory) {
            buf.append(AnalysisBundle.message("inspection.export.results.directory", new Object[0]));
            buf.append(NBSP);
            this.appendElementReference(buf, refElement, false);
        }
    }

    @Nullable
    private HTMLComposerExtension getLanguageExtension(RefElement refElement) {
        PsiElement element = refElement.getPsiElement();
        return element != null ? this.myLanguageExtensions.get(element.getLanguage()) : null;
    }

    private void appendShortName(final @NotNull StringBuilder buf, RefElement refElement) {
        HTMLComposerExtension extension2;
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(3);
        }
        if ((extension2 = this.getLanguageExtension(refElement)) != null) {
            extension2.appendShortName(refElement, buf);
        } else {
            refElement.accept(new RefVisitor(){

                @Override
                public void visitFile(@NotNull RefFile file2) {
                    PsiFile psiFile;
                    if (file2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((psiFile = file2.getPsiElement()) != null) {
                        buf.append(HTMLComposerImpl.B_OPENING);
                        buf.append(psiFile.getName());
                        buf.append(HTMLComposerImpl.B_CLOSING);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/ex/HTMLComposerImpl$1", "visitFile"));
                }
            });
        }
    }

    public void appendQualifiedName(@NotNull StringBuilder buf, RefEntity refEntity) {
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(4);
        }
        if (refEntity == null) {
            return;
        }
        StringBuilder qName = new StringBuilder();
        while (!(refEntity instanceof RefProject)) {
            HTMLComposerExtension extension2;
            if (qName.length() > 0) {
                qName.insert(0, ".");
            }
            String name = null;
            if (refEntity instanceof RefElement && (extension2 = this.getLanguageExtension((RefElement)refEntity)) != null) {
                name = extension2.getQualifiedName(refEntity);
            }
            if (name == null) {
                name = refEntity.getName();
            }
            qName.insert(0, name);
            if (Comparing.strEqual(refEntity.getName(), refEntity.getQualifiedName())) {
                buf.append((CharSequence)qName);
                return;
            }
            refEntity = refEntity.getOwner();
        }
        buf.append((CharSequence)qName);
    }

    @Override
    public void appendElementReference(@NotNull StringBuilder buf, RefElement refElement) {
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(5);
        }
        this.appendElementReference(buf, refElement, true);
    }

    @Override
    public void appendElementReference(@NotNull StringBuilder buf, RefElement refElement, String linkText, @NonNls String frameName) {
        String url;
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(6);
        }
        if ((url = ((RefElementImpl)refElement).getURL()) != null) {
            this.appendElementReference(buf, url, linkText, frameName);
        }
    }

    @Override
    public void appendElementReference(@NotNull StringBuilder buf, String url, String linkText, @NonNls String frameName) {
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(7);
        }
        buf.append(A_HREF_OPENING);
        buf.append(url);
        if (frameName != null) {
            @NonNls String target2 = "\" target=\"";
            buf.append("\" target=\"");
            buf.append(frameName);
        }
        buf.append(CLOSE_TAG);
        buf.append(linkText);
        buf.append(A_CLOSING);
    }

    protected void appendQuickFix(@NotNull StringBuilder buf, String text2) {
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(8);
        }
        buf.append(text2);
    }

    @Override
    public void appendElementReference(@NotNull StringBuilder buf, RefElement refElement, boolean isPackageIncluded) {
        HTMLComposerExtension extension2;
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(9);
        }
        if ((extension2 = this.getLanguageExtension(refElement)) != null) {
            extension2.appendReferencePresentation(refElement, buf, isPackageIncluded);
        } else if (refElement instanceof RefFile || refElement instanceof RefDirectory) {
            VirtualFile file2;
            buf.append(A_HREF_OPENING);
            buf.append(((RefElementImpl)refElement).getURL());
            buf.append(CLOSE_TAG);
            String refElementName = refElement.getName();
            PsiElement element = refElement.getPsiElement();
            if (element != null && (file2 = PsiUtilCore.getVirtualFile(element)) != null) {
                refElementName = ProjectUtilCore.displayUrlRelativeToProject(file2, file2.getPresentableUrl(), element.getProject(), true, false);
            }
            buf.append(refElementName);
            buf.append(A_CLOSING);
        }
    }

    @Override
    public String composeNumereables(int n, String statement2, String singleEnding, String multipleEnding) {
        StringBuilder buf = new StringBuilder();
        buf.append(n);
        buf.append(' ');
        buf.append(statement2);
        if (n % 10 == 1 && n % 100 != 11) {
            buf.append(singleEnding);
        } else {
            buf.append(multipleEnding);
        }
        return buf.toString();
    }

    @Override
    public void appendElementInReferences(@NotNull StringBuilder buf, RefElement refElement) {
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(10);
        }
        if (refElement.getInReferences().size() > 0) {
            HTMLComposerImpl.appendHeading(buf, AnalysisBundle.message("inspection.export.results.used.from", new Object[0]));
            this.startList(buf);
            for (RefElement refCaller : refElement.getInReferences()) {
                this.appendListItem(buf, refCaller);
            }
            this.doneList(buf);
        }
    }

    @Override
    public void appendElementOutReferences(@NotNull StringBuilder buf, RefElement refElement) {
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(11);
        }
        if (refElement.getOutReferences().size() > 0) {
            HTMLComposerImpl.appendHeading(buf, AnalysisBundle.message("inspection.export.results.uses", new Object[0]));
            this.startList(buf);
            for (RefElement refCallee : refElement.getOutReferences()) {
                this.appendListItem(buf, refCallee);
            }
            this.doneList(buf);
        }
    }

    @Override
    public void appendListItem(@NotNull StringBuilder buf, RefElement refElement) {
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(12);
        }
        this.startListItem(buf);
        this.appendElementReference(buf, refElement, true);
        this.appendAdditionalListItemInfo(buf, refElement);
        HTMLComposerImpl.doneListItem(buf);
    }

    protected void appendAdditionalListItemInfo(@NotNull StringBuilder buf, RefElement refElement) {
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(13);
        }
    }

    protected void appendResolution(@NotNull StringBuilder buf, RefEntity where, String[] quickFixes) {
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(14);
        }
        if (where instanceof RefElement && !where.isValid()) {
            return;
        }
        if (quickFixes != null) {
            boolean listStarted = false;
            for (String text2 : quickFixes) {
                if (text2 == null) continue;
                if (!listStarted) {
                    HTMLComposerImpl.appendHeading(buf, AnalysisBundle.message("inspection.problem.resolution", new Object[0]));
                    this.startList(buf);
                    listStarted = true;
                }
                this.startListItem(buf);
                this.appendQuickFix(buf, text2);
                HTMLComposerImpl.doneListItem(buf);
            }
            if (listStarted) {
                this.doneList(buf);
            }
        }
    }

    @Override
    public void startList(@NotNull StringBuilder buf) {
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(15);
        }
        if (this.myListStackTop == -1) {
            buf.append("<div class=\"problem-description\">");
        }
        buf.append("<ul>");
        ++this.myListStackTop;
        this.myListStack[this.myListStackTop] = 0;
    }

    @Override
    public void doneList(@NotNull StringBuilder buf) {
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(16);
        }
        buf.append("</ul>");
        if (this.myListStack[this.myListStackTop] != 0) {
            buf.append("<table cellpadding=\"0\" border=\"0\" cellspacing=\"0\"><tr><td>&nbsp;</td></tr></table>");
        }
        if (this.myListStackTop == 0) {
            buf.append("</div>");
        }
        --this.myListStackTop;
    }

    @Override
    public void startListItem(@NotNull StringBuilder buf) {
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(17);
        }
        int n = this.myListStackTop;
        this.myListStack[n] = this.myListStack[n] + 1;
        buf.append("<li>");
    }

    public static void doneListItem(@NotNull StringBuilder buf) {
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(18);
        }
        buf.append("</li>");
    }

    @Override
    public void appendNoProblems(@NotNull StringBuilder buf) {
        if (buf == null) {
            HTMLComposerImpl.$$$reportNull$$$0(19);
        }
        buf.append("<p class=\"problem-description-group\">");
        buf.append(AnalysisBundle.message("inspection.export.results.no.problems.found", new Object[0]));
        buf.append("</p>");
    }

    @Override
    public <T> T getExtension(Key<T> key) {
        return (T)this.myExtensions.get(key);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "buf";
        objectArray2[1] = "com/intellij/codeInspection/ex/HTMLComposerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "compose";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "genPageHeader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "appendLocation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "appendShortName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "appendQualifiedName";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "appendElementReference";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "appendQuickFix";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "appendElementInReferences";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "appendElementOutReferences";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "appendListItem";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "appendAdditionalListItemInfo";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "appendResolution";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "startList";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "doneList";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "startListItem";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "doneListItem";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "appendNoProblems";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

