/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionElementsMerger {
    public static final ExtensionPointName<InspectionElementsMerger> EP_NAME = new ExtensionPointName("com.intellij.inspectionElementsMerger");
    private static final ConcurrentMap<String, InspectionElementsMerger> ourAdditionalMergers = new ConcurrentHashMap<String, InspectionElementsMerger>();

    @Nullable
    public static InspectionElementsMerger getMerger(@NotNull String shortName) {
        InspectionElementsMerger additionalMerger;
        if (shortName == null) {
            InspectionElementsMerger.$$$reportNull$$$0(0);
        }
        if ((additionalMerger = (InspectionElementsMerger)ourAdditionalMergers.get(shortName)) == null) {
            return EP_NAME.getByKey(shortName, InspectionElementsMerger.class, InspectionElementsMerger::getMergedToolName);
        }
        return additionalMerger;
    }

    static void addMerger(@NotNull String shortName, @NotNull InspectionElementsMerger merger) {
        if (shortName == null) {
            InspectionElementsMerger.$$$reportNull$$$0(1);
        }
        if (merger == null) {
            InspectionElementsMerger.$$$reportNull$$$0(2);
        }
        ourAdditionalMergers.put(shortName, merger);
    }

    @Contract(pure=true)
    @NotNull
    @NonNls
    public abstract String getMergedToolName();

    @Contract(pure=true)
    public abstract @NonNls String @NotNull [] getSourceToolNames();

    @Contract(pure=true)
    public @NonNls String @NotNull [] getSuppressIds() {
        if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
            InspectionElementsMerger.$$$reportNull$$$0(3);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    public static String getMergedToolName(@NotNull String id) {
        if (id == null) {
            InspectionElementsMerger.$$$reportNull$$$0(4);
        }
        for (InspectionElementsMerger merger : EP_NAME.getExtensionList()) {
            if (!ArrayUtil.contains(id, merger.getSourceToolNames()) && !ArrayUtil.contains(id, merger.getSuppressIds())) continue;
            return merger.getMergedToolName();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "merger";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/InspectionElementsMerger";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/InspectionElementsMerger";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMerger";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addMerger";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMergedToolName";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3 -> new IllegalStateException(string2);
        };
    }
}

