/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.analysis.problemsView.toolWindow.ProblemsView;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.InspectionManagerBase;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.ProblemDescriptorImpl;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.TabbedPaneContentUI;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class InspectionManagerEx
extends InspectionManagerBase {
    private final NotNullLazyValue<ContentManager> myContentManager;
    private final Set<GlobalInspectionContextImpl> myRunningContexts = new HashSet<GlobalInspectionContextImpl>();

    public InspectionManagerEx(Project project2) {
        super(project2);
        this.myContentManager = ApplicationManager.getApplication().isHeadlessEnvironment() ? NotNullLazyValue.createValue(() -> {
            ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project2);
            toolWindowManager.registerToolWindow("Problems View", true, ToolWindowAnchor.BOTTOM, (Disposable)project2);
            return ContentFactory.getInstance().createContentManager((ContentUI)new TabbedPaneContentUI(), true, project2);
        }) : NotNullLazyValue.createValue(() -> this.getProblemsViewContentManager(project2));
    }

    @NotNull
    protected ContentManager getProblemsViewContentManager(@NotNull Project project2) {
        if (project2 == null) {
            InspectionManagerEx.$$$reportNull$$$0(0);
        }
        ToolWindow toolWindow = Objects.requireNonNull(ProblemsView.getToolWindow(project2));
        ContentManager contentManager = toolWindow.getContentManager();
        ContentManagerWatcher.watchContentManager((ToolWindow)toolWindow, (ContentManager)contentManager);
        ContentManager contentManager2 = contentManager;
        if (contentManager2 == null) {
            InspectionManagerEx.$$$reportNull$$$0(1);
        }
        return contentManager2;
    }

    @NotNull
    public ProblemDescriptor createProblemDescriptor(@NotNull PsiElement psiElement, @NotNull @InspectionMessage String descriptionTemplate, @NotNull ProblemHighlightType highlightType, @Nullable HintAction hintAction, boolean onTheFly, LocalQuickFix ... fixes) {
        if (psiElement == null) {
            InspectionManagerEx.$$$reportNull$$$0(2);
        }
        if (descriptionTemplate == null) {
            InspectionManagerEx.$$$reportNull$$$0(3);
        }
        if (highlightType == null) {
            InspectionManagerEx.$$$reportNull$$$0(4);
        }
        return new ProblemDescriptorImpl(psiElement, psiElement, descriptionTemplate, fixes, highlightType, false, null, hintAction, onTheFly);
    }

    @Override
    @NotNull
    public GlobalInspectionContextImpl createNewGlobalContext(boolean reuse) {
        GlobalInspectionContextImpl globalInspectionContextImpl = this.createNewGlobalContext();
        if (globalInspectionContextImpl == null) {
            InspectionManagerEx.$$$reportNull$$$0(5);
        }
        return globalInspectionContextImpl;
    }

    @Override
    @NotNull
    public GlobalInspectionContextImpl createNewGlobalContext() {
        GlobalInspectionContextImpl inspectionContext = new GlobalInspectionContextImpl(this.getProject(), this.myContentManager);
        this.myRunningContexts.add(inspectionContext);
        GlobalInspectionContextImpl globalInspectionContextImpl = inspectionContext;
        if (globalInspectionContextImpl == null) {
            InspectionManagerEx.$$$reportNull$$$0(6);
        }
        return globalInspectionContextImpl;
    }

    void closeRunningContext(@NotNull GlobalInspectionContextImpl globalInspectionContext) {
        if (globalInspectionContext == null) {
            InspectionManagerEx.$$$reportNull$$$0(7);
        }
        this.myRunningContexts.remove(globalInspectionContext);
    }

    @NotNull
    public Set<GlobalInspectionContextImpl> getRunningContexts() {
        Set<GlobalInspectionContextImpl> set2 = this.myRunningContexts;
        if (set2 == null) {
            InspectionManagerEx.$$$reportNull$$$0(8);
        }
        return set2;
    }

    @TestOnly
    @NotNull
    public NotNullLazyValue<ContentManager> getContentManager() {
        NotNullLazyValue<ContentManager> notNullLazyValue = this.myContentManager;
        if (notNullLazyValue == null) {
            InspectionManagerEx.$$$reportNull$$$0(9);
        }
        return notNullLazyValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 6, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/InspectionManagerEx";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionTemplate";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalInspectionContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/InspectionManagerEx";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblemsViewContentManager";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewGlobalContext";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunningContexts";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProblemsViewContentManager";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createProblemDescriptor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "closeRunningContext";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 5, 6, 8, 9 -> new IllegalStateException(string2);
        };
    }
}

