/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.PerformFixesModalTask;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionResultsViewComparator;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ClickListener;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public abstract class QuickFixAction
extends AnAction
implements CustomComponentAction {
    private static final Logger LOG = Logger.getInstance(QuickFixAction.class);
    public static final QuickFixAction[] EMPTY = new QuickFixAction[0];
    protected final InspectionToolWrapper<?, ?> myToolWrapper;

    protected static InspectionResultsView getInvoker(@NotNull AnActionEvent e) {
        if (e == null) {
            QuickFixAction.$$$reportNull$$$0(0);
        }
        return (InspectionResultsView)e.getData(InspectionResultsView.DATA_KEY);
    }

    protected QuickFixAction(@NlsActions.ActionText String text2, @NotNull InspectionToolWrapper<?, ?> toolWrapper) {
        if (toolWrapper == null) {
            QuickFixAction.$$$reportNull$$$0(1);
        }
        this(text2, AllIcons.Actions.IntentionBulb, null, toolWrapper);
    }

    protected QuickFixAction(@NlsActions.ActionText String text2, Icon icon2, KeyStroke keyStroke, @NotNull InspectionToolWrapper<?, ?> toolWrapper) {
        if (toolWrapper == null) {
            QuickFixAction.$$$reportNull$$$0(2);
        }
        super(text2, null, icon2);
        this.myToolWrapper = toolWrapper;
        if (keyStroke != null) {
            this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(keyStroke), null);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        InspectionResultsView view;
        if (e == null) {
            QuickFixAction.$$$reportNull$$$0(3);
        }
        if ((view = QuickFixAction.getInvoker(e)) == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(false);
        Object[] selectedNodes = (Object[])e.getData(PlatformCoreDataKeys.SELECTED_ITEMS);
        if (selectedNodes == null) {
            return;
        }
        InspectionToolWrapper<?, ?> toolWrapper = InspectionTree.findWrapper(selectedNodes);
        if (toolWrapper == null || toolWrapper != this.myToolWrapper) {
            return;
        }
        if (!this.isProblemDescriptorsAcceptable() && InspectionTree.getSelectedRefElements(e).length > 0 || this.isProblemDescriptorsAcceptable() && view.getTree().getSelectedDescriptors(e).length > 0) {
            e.getPresentation().setEnabledAndVisible(true);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            QuickFixAction.$$$reportNull$$$0(4);
        }
        return actionUpdateThread;
    }

    protected boolean isProblemDescriptorsAcceptable() {
        return false;
    }

    @NlsActions.ActionText
    public String getText() {
        return this.getTemplatePresentation().getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            QuickFixAction.$$$reportNull$$$0(5);
        }
        InspectionResultsView view = QuickFixAction.getInvoker(e);
        InspectionTree tree = view.getTree();
        try {
            Ref descriptors = Ref.create();
            HashSet readOnlyFiles = new HashSet();
            TreePath[] paths2 = tree.getSelectionPaths();
            if (paths2 == null) {
                descriptors.set(List.of());
            } else if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ReadAction.run(() -> {
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                indicator.setText(InspectionsBundle.message("quick.fix.action.checking.problem.progress", new Object[0]));
                descriptors.set(tree.getSelectedDescriptorPacks(true, readOnlyFiles, false, paths2));
            }), InspectionsBundle.message("preparing.for.apply.fix", new Object[0]), true, e.getProject())) {
                return;
            }
            if (this.isProblemDescriptorsAcceptable() && !((List)descriptors.get()).isEmpty()) {
                this.doApplyFix(view.getProject(), (List)descriptors.get(), readOnlyFiles, tree.getContext());
            } else {
                this.doApplyFix(QuickFixAction.getSelectedElements(view), view);
            }
            view.getTree().removeSelectedProblems();
        }
        finally {
            view.setApplyingFix(false);
        }
    }

    protected void applyFix(@NotNull Project project2, @NotNull GlobalInspectionContextImpl context2, CommonProblemDescriptor @NotNull [] descriptors, @NotNull Set<? super PsiElement> ignoredElements) {
        if (project2 == null) {
            QuickFixAction.$$$reportNull$$$0(6);
        }
        if (context2 == null) {
            QuickFixAction.$$$reportNull$$$0(7);
        }
        if (ignoredElements == null) {
            QuickFixAction.$$$reportNull$$$0(8);
        }
        if (descriptors == null) {
            QuickFixAction.$$$reportNull$$$0(9);
        }
    }

    private void doApplyFix(@NotNull Project project2, @NotNull List<CommonProblemDescriptor[]> descriptors, @NotNull Set<? extends VirtualFile> readOnlyFiles, @NotNull GlobalInspectionContextImpl context2) {
        if (project2 == null) {
            QuickFixAction.$$$reportNull$$$0(10);
        }
        if (descriptors == null) {
            QuickFixAction.$$$reportNull$$$0(11);
        }
        if (readOnlyFiles == null) {
            QuickFixAction.$$$reportNull$$$0(12);
        }
        if (context2 == null) {
            QuickFixAction.$$$reportNull$$$0(13);
        }
        if (!FileModificationService.getInstance().prepareVirtualFilesForWrite(project2, readOnlyFiles)) {
            return;
        }
        HashSet resolvedElements = new HashSet();
        this.performFixesInBatch(project2, descriptors, context2, resolvedElements);
        QuickFixAction.refreshViews(project2, resolvedElements, this.myToolWrapper);
    }

    protected boolean startInWriteAction() {
        return false;
    }

    protected void performFixesInBatch(@NotNull Project project2, @NotNull List<CommonProblemDescriptor[]> descriptors, @NotNull GlobalInspectionContextImpl context2, Set<? super PsiElement> ignoredElements) {
        if (project2 == null) {
            QuickFixAction.$$$reportNull$$$0(14);
        }
        if (descriptors == null) {
            QuickFixAction.$$$reportNull$$$0(15);
        }
        if (context2 == null) {
            QuickFixAction.$$$reportNull$$$0(16);
        }
        String templatePresentationText = this.getTemplatePresentation().getText();
        assert (templatePresentationText != null);
        CommandProcessor.getInstance().executeCommand(project2, () -> {
            CommandProcessor.getInstance().markCurrentCommandAsGlobal(project2);
            boolean startInWriteAction = this.startInWriteAction();
            PerformFixesTask performFixesTask = new PerformFixesTask(project2, descriptors, ignoredElements, context2);
            if (startInWriteAction) {
                ((ApplicationImpl)ApplicationManager.getApplication()).runWriteActionWithCancellableProgressInDispatchThread(templatePresentationText, project2, null, performFixesTask::doRun);
            } else {
                SequentialModalProgressTask progressTask = new SequentialModalProgressTask(project2, templatePresentationText, true);
                progressTask.setMinIterationTime(200L);
                progressTask.setTask(performFixesTask);
                ProgressManager.getInstance().run(progressTask);
            }
        }, templatePresentationText, null);
    }

    private void doApplyFix(RefEntity @NotNull [] refElements, @NotNull InspectionResultsView view) {
        if (view == null) {
            QuickFixAction.$$$reportNull$$$0(17);
        }
        if (refElements == null) {
            QuickFixAction.$$$reportNull$$$0(18);
        }
        boolean[] refreshNeeded = new boolean[]{false};
        if (refElements.length > 0) {
            Project project2 = refElements[0].getRefManager().getProject();
            CommandProcessor.getInstance().executeCommand(project2, () -> {
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(project2);
                ApplicationManager.getApplication().runWriteAction(() -> {
                    refreshNeeded[0] = this.applyFix(refElements);
                });
            }, this.getTemplatePresentation().getText(), null);
        }
        if (refreshNeeded[0]) {
            QuickFixAction.refreshViews(view.getProject(), refElements, this.myToolWrapper);
        }
    }

    public static void removeElements(RefEntity @NotNull [] refElements, @NotNull Project project2, @NotNull InspectionToolWrapper<?, ?> toolWrapper) {
        if (project2 == null) {
            QuickFixAction.$$$reportNull$$$0(19);
        }
        if (toolWrapper == null) {
            QuickFixAction.$$$reportNull$$$0(20);
        }
        if (refElements == null) {
            QuickFixAction.$$$reportNull$$$0(21);
        }
        QuickFixAction.refreshViews(project2, refElements, toolWrapper);
        ArrayList deletedRefs = new ArrayList(1);
        for (RefEntity refElement : refElements) {
            if (!(refElement instanceof RefElement)) continue;
            refElement.getRefManager().removeRefElement((RefElement)refElement, deletedRefs);
        }
    }

    private static Set<VirtualFile> getReadOnlyFiles(RefEntity @NotNull [] refElements) {
        if (refElements == null) {
            QuickFixAction.$$$reportNull$$$0(22);
        }
        HashSet<VirtualFile> readOnlyFiles = new HashSet<VirtualFile>();
        for (RefEntity refElement : refElements) {
            PsiElement psiElement;
            PsiElement psiElement2 = psiElement = refElement instanceof RefElement ? ((RefElement)refElement).getPsiElement() : null;
            if (psiElement == null || psiElement.getContainingFile() == null) continue;
            readOnlyFiles.add(psiElement.getContainingFile().getVirtualFile());
        }
        return readOnlyFiles;
    }

    private static RefEntity @NotNull [] getSelectedElements(InspectionResultsView view) {
        if (view == null) {
            if (RefEntity.EMPTY_ELEMENTS_ARRAY == null) {
                QuickFixAction.$$$reportNull$$$0(23);
            }
            return RefEntity.EMPTY_ELEMENTS_ARRAY;
        }
        RefEntity[] selection = view.getTree().getSelectedElements();
        PsiDocumentManager.getInstance(view.getProject()).commitAllDocuments();
        Arrays.sort(selection, InspectionResultsViewComparator::compareEntities);
        if (selection == null) {
            QuickFixAction.$$$reportNull$$$0(24);
        }
        return selection;
    }

    private static void refreshViews(@NotNull Project project2, @NotNull Set<? extends PsiElement> resolvedElements, @NotNull InspectionToolWrapper<?, ?> toolWrapper) {
        if (project2 == null) {
            QuickFixAction.$$$reportNull$$$0(25);
        }
        if (resolvedElements == null) {
            QuickFixAction.$$$reportNull$$$0(26);
        }
        if (toolWrapper == null) {
            QuickFixAction.$$$reportNull$$$0(27);
        }
        InspectionManagerEx managerEx = (InspectionManagerEx)InspectionManager.getInstance(project2);
        Set<GlobalInspectionContextImpl> runningContexts = managerEx.getRunningContexts();
        for (GlobalInspectionContextImpl context2 : runningContexts) {
            for (PsiElement psiElement : resolvedElements) {
                context2.resolveElement((InspectionProfileEntry)toolWrapper.getTool(), psiElement);
            }
            context2.refreshViews();
        }
    }

    protected static void refreshViews(@NotNull Project project2, RefEntity @NotNull [] resolvedElements, @NotNull InspectionToolWrapper<?, ?> toolWrapper) {
        if (project2 == null) {
            QuickFixAction.$$$reportNull$$$0(28);
        }
        if (toolWrapper == null) {
            QuickFixAction.$$$reportNull$$$0(29);
        }
        if (resolvedElements == null) {
            QuickFixAction.$$$reportNull$$$0(30);
        }
        HashSet<PsiElement> ignoredElements = new HashSet<PsiElement>();
        for (RefEntity element : resolvedElements) {
            PsiElement psiElement;
            PsiElement psiElement2 = psiElement = element instanceof RefElement ? ((RefElement)element).getPsiElement() : null;
            if (psiElement == null || !psiElement.isValid()) continue;
            ignoredElements.add(psiElement);
        }
        QuickFixAction.refreshViews(project2, ignoredElements, toolWrapper);
    }

    protected boolean applyFix(RefEntity @NotNull [] refElements) {
        Set<VirtualFile> readOnlyFiles;
        if (refElements == null) {
            QuickFixAction.$$$reportNull$$$0(31);
        }
        if (!(readOnlyFiles = QuickFixAction.getReadOnlyFiles(refElements)).isEmpty()) {
            Project project2 = refElements[0].getRefManager().getProject();
            ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandler.getInstance(project2).ensureFilesWritable(readOnlyFiles);
            return !operationStatus.hasReadonlyFiles();
        }
        return true;
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation2, final @NotNull String place) {
        if (presentation2 == null) {
            QuickFixAction.$$$reportNull$$$0(32);
        }
        if (place == null) {
            QuickFixAction.$$$reportNull$$$0(33);
        }
        final JButton button2 = new JButton(presentation2.getText());
        Icon icon2 = presentation2.getIcon();
        if (icon2 == null) {
            icon2 = AllIcons.Actions.IntentionBulb;
        }
        button2.setEnabled(presentation2.isEnabled());
        button2.setIcon(IconLoader.getTransparentIcon(icon2, 0.75f));
        new ClickListener(){

            @Override
            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                QuickFixAction.this.actionPerformed(AnActionEvent.createFromAnAction((AnAction)QuickFixAction.this, (InputEvent)event, (String)place, (DataContext)ActionToolbar.getDataContextFor((Component)button2)));
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInspection/ex/QuickFixAction$1", "onClick"));
            }
        }.installOn(button2);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 2));
        panel2.setBorder(JBUI.Borders.empty(7, 0, 8, 0));
        panel2.add(button2);
        JPanel jPanel = panel2;
        if (jPanel == null) {
            QuickFixAction.$$$reportNull$$$0(34);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 23, 24, 34 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: 
            case 20: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 4: 
            case 23: 
            case 24: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/QuickFixAction";
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 19: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredElements";
                break;
            }
            case 9: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readOnlyFiles";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 18: 
            case 21: 
            case 22: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElements";
                break;
            }
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedElements";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/QuickFixAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElements";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInvoker";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 4: 
            case 23: 
            case 24: 
            case 34: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "doApplyFix";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "performFixesInBatch";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removeElements";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getReadOnlyFiles";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "refreshViews";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createCustomComponent";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 23, 24, 34 -> new IllegalStateException(string2);
        };
    }

    private class PerformFixesTask
    extends PerformFixesModalTask {
        @NotNull
        private final GlobalInspectionContextImpl myContext;
        @NotNull
        private final Set<? super PsiElement> myIgnoredElements;

        PerformFixesTask(@NotNull Project project2, @NotNull List<CommonProblemDescriptor[]> descriptors, @NotNull Set<? super PsiElement> ignoredElements, GlobalInspectionContextImpl context2) {
            if (project2 == null) {
                PerformFixesTask.$$$reportNull$$$0(0);
            }
            if (descriptors == null) {
                PerformFixesTask.$$$reportNull$$$0(1);
            }
            if (ignoredElements == null) {
                PerformFixesTask.$$$reportNull$$$0(2);
            }
            if (context2 == null) {
                PerformFixesTask.$$$reportNull$$$0(3);
            }
            super(project2, descriptors);
            this.myContext = context2;
            this.myIgnoredElements = ignoredElements;
        }

        @Override
        protected void applyFix(Project project2, CommonProblemDescriptor descriptor2) {
            if (descriptor2 instanceof ProblemDescriptor && ((ProblemDescriptor)descriptor2).getStartElement() == null && ((ProblemDescriptor)descriptor2).getEndElement() == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Invalidated psi for " + descriptor2);
                }
                return;
            }
            try {
                QuickFixAction.this.applyFix(this.myProject, this.myContext, new CommonProblemDescriptor[]{descriptor2}, this.myIgnoredElements);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptors";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "ignoredElements";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/ex/QuickFixAction$PerformFixesTask";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

