/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class QuickFixWrapper
implements IntentionAction,
PriorityAction {
    private static final Logger LOG = Logger.getInstance(QuickFixWrapper.class);
    private final ProblemDescriptor myDescriptor;
    private final LocalQuickFix myFix;

    @NotNull
    public static IntentionAction wrap(@NotNull ProblemDescriptor descriptor2, int fixNumber) {
        if (descriptor2 == null) {
            QuickFixWrapper.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(fixNumber >= 0, fixNumber);
        QuickFix[] fixes = descriptor2.getFixes();
        LOG.assertTrue(fixes != null && fixes.length > fixNumber);
        QuickFix fix2 = fixes[fixNumber];
        return fix2 instanceof IntentionAction ? (IntentionAction)((Object)fix2) : new QuickFixWrapper(descriptor2, (LocalQuickFix)fix2);
    }

    private QuickFixWrapper(@NotNull ProblemDescriptor descriptor2, @NotNull LocalQuickFix fix2) {
        if (descriptor2 == null) {
            QuickFixWrapper.$$$reportNull$$$0(1);
        }
        if (fix2 == null) {
            QuickFixWrapper.$$$reportNull$$$0(2);
        }
        this.myDescriptor = descriptor2;
        this.myFix = fix2;
    }

    @Override
    @NotNull
    public String getText() {
        String string2 = this.getFamilyName();
        if (string2 == null) {
            QuickFixWrapper.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string2 = this.getFix().getName();
        if (string2 == null) {
            QuickFixWrapper.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @Override
    public boolean isAvailable(@NotNull Project project2, Editor editor2, PsiFile file2) {
        PsiElement psiElement;
        if (project2 == null) {
            QuickFixWrapper.$$$reportNull$$$0(5);
        }
        if ((psiElement = this.myDescriptor.getPsiElement()) == null || !psiElement.isValid()) {
            return false;
        }
        PsiFile containingFile = psiElement.getContainingFile();
        return containingFile == file2 || containingFile == null || containingFile.getViewProvider().getVirtualFile().equals(file2.getViewProvider().getVirtualFile());
    }

    @Override
    public void invoke(@NotNull Project project2, Editor editor2, PsiFile file2) throws IncorrectOperationException {
        PsiElement element;
        if (project2 == null) {
            QuickFixWrapper.$$$reportNull$$$0(6);
        }
        PsiFile fileForUndo = (element = this.myDescriptor.getPsiElement()) == null ? null : element.getContainingFile();
        LocalQuickFix fix2 = this.getFix();
        fix2.applyFix(project2, this.myDescriptor);
        DaemonCodeAnalyzer.getInstance(project2).restart();
        if (fileForUndo != null && !fileForUndo.equals(file2)) {
            UndoUtil.markPsiFileForUndo(fileForUndo);
        }
    }

    @Override
    public boolean startInWriteAction() {
        return this.getFix().startInWriteAction();
    }

    @Override
    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file2) {
        if (file2 == null) {
            QuickFixWrapper.$$$reportNull$$$0(7);
        }
        return this.getFix().getElementToMakeWritable(file2);
    }

    @NotNull
    public LocalQuickFix getFix() {
        LocalQuickFix localQuickFix = this.myFix;
        if (localQuickFix == null) {
            QuickFixWrapper.$$$reportNull$$$0(8);
        }
        return localQuickFix;
    }

    @Override
    @NotNull
    public PriorityAction.Priority getPriority() {
        PriorityAction.Priority priority = this.myFix instanceof PriorityAction ? ((PriorityAction)((Object)this.myFix)).getPriority() : PriorityAction.Priority.NORMAL;
        if (priority == null) {
            QuickFixWrapper.$$$reportNull$$$0(9);
        }
        return priority;
    }

    @TestOnly
    public ProblemHighlightType getHighlightType() {
        return this.myDescriptor.getHighlightType();
    }

    @Nullable
    public PsiFile getFile() {
        PsiElement element = this.myDescriptor.getPsiElement();
        return element != null ? element.getContainingFile() : null;
    }

    public String toString() {
        return this.getText();
    }

    @Override
    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        ProblemDescriptor descriptorForPreview;
        if (project2 == null) {
            QuickFixWrapper.$$$reportNull$$$0(10);
        }
        if (editor2 == null) {
            QuickFixWrapper.$$$reportNull$$$0(11);
        }
        if (file2 == null) {
            QuickFixWrapper.$$$reportNull$$$0(12);
        }
        PsiFile psiFile = this.getFile();
        PsiFile originalFile = file2.getOriginalFile();
        if (originalFile != psiFile && originalFile.isPhysical()) {
            IntentionPreviewInfo intentionPreviewInfo = this.myFix.generatePreview(project2, this.myDescriptor);
            if (intentionPreviewInfo == null) {
                QuickFixWrapper.$$$reportNull$$$0(13);
            }
            return intentionPreviewInfo;
        }
        try {
            descriptorForPreview = this.myDescriptor.getDescriptorForPreview(file2);
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create preview descriptor for quickfix " + this.myFix.getFamilyName() + " (" + this.myFix.getClass() + ")", e);
        }
        IntentionPreviewInfo intentionPreviewInfo = this.myFix.generatePreview(project2, descriptorForPreview);
        if (intentionPreviewInfo == null) {
            QuickFixWrapper.$$$reportNull$$$0(14);
        }
        return intentionPreviewInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 8, 9, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/QuickFixWrapper";
                break;
            }
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/QuickFixWrapper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFix";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPriority";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 13: 
            case 14: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 4, 8, 9, 13, 14 -> new IllegalStateException(string2);
        };
    }
}

