/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.lang.Language;
import com.intellij.lang.MetaLanguage;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class ToolLanguageUtil {
    private ToolLanguageUtil() {
    }

    @NotNull
    public static @Unmodifiable Set<String> getAllMatchingLanguages(@NotNull String languageId, boolean applyToDialects) {
        Set<String> result2;
        Language language;
        if (languageId == null) {
            ToolLanguageUtil.$$$reportNull$$$0(0);
        }
        if ((language = Language.findLanguageByID(languageId)) == null) {
            Set<String> set2 = Set.of(languageId);
            if (set2 == null) {
                ToolLanguageUtil.$$$reportNull$$$0(1);
            }
            return set2;
        }
        if (language instanceof MetaLanguage) {
            Collection<Language> matchingLanguages = ((MetaLanguage)language).getMatchingLanguages();
            result2 = new HashSet<String>();
            for (Language matchingLanguage : matchingLanguages) {
                result2.addAll(ToolLanguageUtil.getLanguageWithDialects(matchingLanguage, applyToDialects));
            }
        } else {
            result2 = ToolLanguageUtil.getLanguageWithDialects(language, applyToDialects);
        }
        Set<String> set3 = Set.copyOf(result2);
        if (set3 == null) {
            ToolLanguageUtil.$$$reportNull$$$0(2);
        }
        return set3;
    }

    @NotNull
    private static Set<String> getLanguageWithDialects(@NotNull Language language, boolean applyToDialects) {
        if (language == null) {
            ToolLanguageUtil.$$$reportNull$$$0(3);
        }
        List<Language> dialects = language.getDialects();
        if (!applyToDialects || dialects.isEmpty()) {
            Set<String> set2 = Set.of(language.getID());
            if (set2 == null) {
                ToolLanguageUtil.$$$reportNull$$$0(4);
            }
            return set2;
        }
        HashSet<String> result2 = new HashSet<String>(1 + dialects.size());
        result2.add(language.getID());
        ToolLanguageUtil.addDialects(language, result2);
        HashSet<String> hashSet = result2;
        if (hashSet == null) {
            ToolLanguageUtil.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    private static void addDialects(@NotNull Language language, @NotNull Set<? super String> result2) {
        if (language == null) {
            ToolLanguageUtil.$$$reportNull$$$0(6);
        }
        if (result2 == null) {
            ToolLanguageUtil.$$$reportNull$$$0(7);
        }
        for (Language dialect : language.getDialects()) {
            if (!result2.add(dialect.getID())) continue;
            ToolLanguageUtil.addDialects(dialect, result2);
        }
    }

    private static boolean existsDialectOneOf(@NotNull Set<String> elementDialectIds, @NotNull Language language, boolean applyToDialects) {
        if (elementDialectIds == null) {
            ToolLanguageUtil.$$$reportNull$$$0(8);
        }
        if (language == null) {
            ToolLanguageUtil.$$$reportNull$$$0(9);
        }
        if (elementDialectIds.contains(language.getID())) {
            return true;
        }
        if (applyToDialects) {
            for (Language dialect : language.getDialects()) {
                if (!ToolLanguageUtil.existsDialectOneOf(elementDialectIds, dialect, applyToDialects)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isToolLanguageOneOf(@NotNull Set<String> elementDialectIds, @NotNull String languageId, boolean applyToDialects) {
        if (elementDialectIds == null) {
            ToolLanguageUtil.$$$reportNull$$$0(10);
        }
        if (languageId == null) {
            ToolLanguageUtil.$$$reportNull$$$0(11);
        }
        if (elementDialectIds.contains(languageId)) {
            return true;
        }
        Language language = Language.findLanguageByID(languageId);
        if (language == null) {
            return false;
        }
        if (language instanceof MetaLanguage) {
            return !ContainerUtil.process(Language.getRegisteredLanguages(), registeredLanguage -> !((MetaLanguage)language).matchesLanguage((Language)registeredLanguage) || !ToolLanguageUtil.existsDialectOneOf(elementDialectIds, registeredLanguage, applyToDialects));
        }
        return ToolLanguageUtil.existsDialectOneOf(elementDialectIds, language, applyToDialects);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageId";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/ToolLanguageUtil";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementDialectIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/ToolLanguageUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMatchingLanguages";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageWithDialects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllMatchingLanguages";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageWithDialects";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addDialects";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "existsDialectOneOf";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isToolLanguageOneOf";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 4, 5 -> new IllegalStateException(string2);
        };
    }
}

