/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.incorrectFormatting;

import com.intellij.codeInspection.incorrectFormatting.FormattingChanges;
import com.intellij.codeInspection.incorrectFormatting.NonWhitespaceChangeException;
import com.intellij.formatting.service.CoreFormattingService;
import com.intellij.formatting.service.FormattingService;
import com.intellij.formatting.service.FormattingServiceUtil;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategy;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategyFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"detectFormattingChanges", "Lcom/intellij/codeInspection/incorrectFormatting/FormattingChanges;", "file", "Lcom/intellij/psi/PsiFile;", "diffWhitespace", "", "Lcom/intellij/codeInspection/incorrectFormatting/FormattingChanges$WhitespaceMismatch;", "pre", "", "post", "whiteSpaceFormattingStrategy", "Lcom/intellij/psi/formatter/WhiteSpaceFormattingStrategy;", "intellij.platform.lang.impl"})
@SourceDebugExtension(value={"SMAP\nFormattingChanges.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FormattingChanges.kt\ncom/intellij/codeInspection/incorrectFormatting/FormattingChangesKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,129:1\n10#2:130\n*S KotlinDebug\n*F\n+ 1 FormattingChanges.kt\ncom/intellij/codeInspection/incorrectFormatting/FormattingChangesKt\n*L\n59#1:130\n*E\n"})
public final class FormattingChangesKt {
    @Nullable
    public static final FormattingChanges detectFormattingChanges(@NotNull PsiFile file2) {
        List<FormattingChanges.WhitespaceMismatch> list2;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!LanguageFormatting.INSTANCE.isAutoFormatAllowed((PsiElement)file2)) {
            return null;
        }
        Document document = PsiDocumentManager.getInstance(file2.getProject()).getDocument(file2);
        if (document == null) {
            return null;
        }
        Document fileDoc = document;
        Language language = file2.getViewProvider().getBaseLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"file.viewProvider.baseLanguage");
        Language baseLanguage = language;
        PsiFile psiFile = PsiFileFactory.getInstance(file2.getProject()).createFileFromText(file2.getName(), file2.getLanguage(), fileDoc.getText(), false, true, false, null);
        if (psiFile == null) {
            return null;
        }
        PsiFile psiCopy = psiFile;
        psiCopy.putUserData(PsiFileFactory.ORIGINAL_FILE, file2);
        Document document2 = psiCopy.getViewProvider().getDocument();
        Intrinsics.checkNotNull((Object)document2);
        Document copyDoc = document2;
        FormattingService formattingService = FormattingServiceUtil.findService((PsiFile)file2, (boolean)true, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)formattingService, (String)"findService(file, true, true)");
        FormattingService formattingService2 = formattingService;
        if (!(formattingService2 instanceof CoreFormattingService)) {
            return null;
        }
        FormattingService formattingService3 = FormattingServiceUtil.findService((PsiFile)psiCopy, (boolean)true, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)formattingService3, (String)"findService(psiCopy, true, true)");
        FormattingService copyService = formattingService3;
        if (!Intrinsics.areEqual((Object)formattingService2, (Object)copyService)) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(FormattingChanges.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
            logger.warn(Reflection.getOrCreateKotlinClass(formattingService2.getClass()) + " cannot format an in-memory copy.");
            return null;
        }
        CodeStyleManager.getInstance(psiCopy.getProject()).reformat(psiCopy, true);
        String string2 = fileDoc.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fileDoc.text");
        String preFormat = string2;
        String string3 = copyDoc.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"copyDoc.text");
        String postFormat = string3;
        try {
            CharSequence charSequence = preFormat;
            CharSequence charSequence2 = postFormat;
            WhiteSpaceFormattingStrategy whiteSpaceFormattingStrategy = WhiteSpaceFormattingStrategyFactory.getStrategy((Language)baseLanguage);
            Intrinsics.checkNotNullExpressionValue((Object)whiteSpaceFormattingStrategy, (String)"getStrategy(baseLanguage)");
            list2 = FormattingChangesKt.diffWhitespace(charSequence, charSequence2, whiteSpaceFormattingStrategy);
        }
        catch (NonWhitespaceChangeException e) {
            String string4 = "Non-whitespace change: pre-format=%#04x, post-format=%#04x, lang=%s, filetype=%s";
            Object[] objectArray = new Object[]{(int)e.getPre(), (int)e.getPost(), file2.getLanguage().getID(), file2.getFileType().getName()};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(this, *args)");
            throw new IllegalArgumentException(string5);
        }
        List<FormattingChanges.WhitespaceMismatch> changes = list2;
        return new FormattingChanges(preFormat, postFormat, changes);
    }

    private static final List<FormattingChanges.WhitespaceMismatch> diffWhitespace(CharSequence pre, CharSequence post, WhiteSpaceFormattingStrategy whiteSpaceFormattingStrategy) {
        List mismatches = new ArrayList();
        int i2 = 0;
        int j = 0;
        while (i2 < pre.length() && j < post.length()) {
            int iWsEnd = whiteSpaceFormattingStrategy.check(pre, i2, pre.length());
            int jWsEnd = whiteSpaceFormattingStrategy.check(post, j, post.length());
            if (iWsEnd > i2 || jWsEnd > j) {
                int iWsStart = i2;
                int jWsStart = j;
                int iWsLen = iWsEnd - iWsStart;
                int jWsLen = jWsEnd - jWsStart;
                boolean changeDetected = false;
                if (iWsLen == jWsLen) {
                    while (i2 < iWsEnd) {
                        if (pre.charAt(i2) != post.charAt(j)) {
                            changeDetected = true;
                        }
                        ++i2;
                        ++j;
                    }
                }
                if (changeDetected || iWsLen != jWsLen) {
                    ((Collection)mismatches).add(new FormattingChanges.WhitespaceMismatch(new TextRange(iWsStart, iWsEnd), new TextRange(jWsStart, jWsEnd)));
                }
                i2 = iWsEnd;
                j = jWsEnd;
                continue;
            }
            if (pre.charAt(i2) != post.charAt(j)) {
                throw new NonWhitespaceChangeException(pre.charAt(i2), post.charAt(j));
            }
            ++i2;
            ++j;
        }
        return mismatches;
    }
}

